/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.BigDecimalMapping;
import org.datanucleus.store.mapped.mapping.BigIntegerMapping;
import org.datanucleus.store.mapped.mapping.BooleanMapping;
import org.datanucleus.store.mapped.mapping.ByteMapping;
import org.datanucleus.store.mapped.mapping.CharacterMapping;
import org.datanucleus.store.mapped.mapping.DateMapping;
import org.datanucleus.store.mapped.mapping.DoubleMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedMapping;
import org.datanucleus.store.mapped.mapping.FloatMapping;
import org.datanucleus.store.mapped.mapping.IntegerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.LongMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.ShortMapping;
import org.datanucleus.store.mapped.mapping.SqlDateMapping;
import org.datanucleus.store.mapped.mapping.SqlTimeMapping;
import org.datanucleus.store.mapped.mapping.SqlTimestampMapping;
import org.datanucleus.store.mapped.mapping.StringMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.ByteLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.ColumnExpression;
import org.datanucleus.store.rdbms.sql.expression.FloatingPointLiteral;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.ObjectLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalLiteral;

public class ObjectExpression
extends SQLExpression {
    public ObjectExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        super(stmt, table, mapping);
    }

    public SQLExpression cast(Class castType) {
        return null;
    }

    public BooleanExpression eq(SQLExpression expr) {
        BooleanExpression bExpr = null;
        if (this.isParameter || expr.isParameter) {
            if (this.subExprs.size() > 1) {
                int i;
                if (expr.subExprs == null) {
                    expr.subExprs = new SQLExpression.ColumnExpressionList();
                    for (i = 0; i < this.subExprs.size(); ++i) {
                        expr.subExprs.addExpression(new ColumnExpression(this.stmt, null));
                    }
                }
                for (i = 0; i < this.subExprs.size(); ++i) {
                    ColumnExpression sourceExpr = this.subExprs.getExpression(i);
                    ColumnExpression targetExpr = ((ObjectExpression)expr).subExprs.getExpression(i);
                    bExpr = bExpr == null ? ((SQLExpression)sourceExpr).eq(targetExpr) : bExpr.and(((SQLExpression)sourceExpr).eq(targetExpr));
                }
            } else {
                bExpr = new BooleanExpression(this, Expression.OP_EQ, expr);
            }
        } else if (expr instanceof NullLiteral) {
            for (int i = 0; i < this.subExprs.size(); ++i) {
                ColumnExpression sourceExpr = this.subExprs.getExpression(i);
                bExpr = bExpr == null ? expr.eq(sourceExpr) : bExpr.and(expr.eq(sourceExpr));
            }
        } else if (this.literalIsValidForSimpleComparison(expr)) {
            bExpr = this.subExprs.size() > 1 ? super.eq(expr) : new BooleanExpression(this, Expression.OP_EQ, expr);
        } else if (expr instanceof ObjectLiteral) {
            bExpr = expr.eq(this);
        } else if (expr instanceof ObjectExpression) {
            for (int i = 0; i < this.subExprs.size(); ++i) {
                ColumnExpression sourceExpr = this.subExprs.getExpression(i);
                ColumnExpression targetExpr = ((ObjectExpression)expr).subExprs.getExpression(i);
                bExpr = bExpr == null ? ((SQLExpression)sourceExpr).eq(targetExpr) : bExpr.and(((SQLExpression)sourceExpr).eq(targetExpr));
            }
        } else {
            bExpr = super.eq(expr);
        }
        return bExpr;
    }

    public BooleanExpression ne(SQLExpression expr) {
        BooleanExpression bExpr = null;
        if (this.isParameter || expr.isParameter) {
            if (this.subExprs.size() > 1) {
                int i;
                if (expr.subExprs == null) {
                    expr.subExprs = new SQLExpression.ColumnExpressionList();
                    for (i = 0; i < this.subExprs.size(); ++i) {
                        expr.subExprs.addExpression(new ColumnExpression(this.stmt, null));
                    }
                }
                for (i = 0; i < this.subExprs.size(); ++i) {
                    ColumnExpression sourceExpr = this.subExprs.getExpression(i);
                    ColumnExpression targetExpr = ((ObjectExpression)expr).subExprs.getExpression(i);
                    bExpr = bExpr == null ? sourceExpr.ne(targetExpr) : bExpr.and(sourceExpr.ne(targetExpr));
                }
            } else {
                bExpr = new BooleanExpression(this, Expression.OP_NOTEQ, expr);
            }
        } else if (expr instanceof NullLiteral) {
            for (int i = 0; i < this.subExprs.size(); ++i) {
                ColumnExpression sourceExpr = this.subExprs.getExpression(i);
                bExpr = bExpr == null ? expr.eq(sourceExpr) : bExpr.and(expr.eq(sourceExpr));
            }
            bExpr = new BooleanExpression(Expression.OP_NOT, bExpr.encloseInParentheses());
        } else if (this.literalIsValidForSimpleComparison(expr)) {
            bExpr = this.subExprs.size() > 1 ? super.ne(expr) : new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        } else if (expr instanceof ObjectLiteral) {
            bExpr = expr.ne(this);
        } else if (expr instanceof ObjectExpression) {
            for (int i = 0; i < this.subExprs.size(); ++i) {
                ColumnExpression sourceExpr = this.subExprs.getExpression(i);
                ColumnExpression targetExpr = ((ObjectExpression)expr).subExprs.getExpression(i);
                bExpr = bExpr == null ? ((SQLExpression)sourceExpr).eq(targetExpr) : bExpr.and(((SQLExpression)sourceExpr).eq(targetExpr));
            }
            bExpr = new BooleanExpression(Expression.OP_NOT, bExpr.encloseInParentheses());
        } else {
            bExpr = super.ne(expr);
        }
        return bExpr;
    }

    private boolean literalIsValidForSimpleComparison(SQLExpression expr) {
        return expr instanceof BooleanLiteral && this.mapping instanceof BooleanMapping || expr instanceof ByteLiteral && this.mapping instanceof ByteMapping || expr instanceof CharacterLiteral && this.mapping instanceof CharacterMapping || expr instanceof FloatingPointLiteral && (this.mapping instanceof FloatMapping || this.mapping instanceof DoubleMapping || this.mapping instanceof BigDecimalMapping) || expr instanceof IntegerLiteral && (this.mapping instanceof IntegerMapping || this.mapping instanceof LongMapping || this.mapping instanceof BigIntegerMapping) || this.mapping instanceof ShortMapping || expr instanceof TemporalLiteral && (this.mapping instanceof DateMapping || this.mapping instanceof SqlDateMapping || this.mapping instanceof SqlTimeMapping || this.mapping instanceof SqlTimestampMapping) || expr instanceof StringLiteral && (this.mapping instanceof StringMapping || this.mapping instanceof CharacterMapping);
    }

    public BooleanExpression in(SQLExpression expr) {
        return new BooleanExpression(this, Expression.OP_IN, expr);
    }

    public BooleanExpression is(Class type) {
        RDBMSManager storeMgr = this.stmt.getRDBMSManager();
        SQLExpressionFactory exprFactory = this.stmt.getSQLExpressionFactory();
        ClassLoaderResolver clr = storeMgr.getOMFContext().getClassLoaderResolver(null);
        if (this.mapping instanceof EmbeddedMapping) {
            JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
            return exprFactory.newLiteral(this.stmt, m, false).eq(exprFactory.newLiteral(this.stmt, m, true));
        }
        if (this.mapping instanceof PersistenceCapableMapping || this.mapping instanceof ReferenceMapping) {
            JavaTypeMapping discMapping = this.getSQLTable().getTable().getDiscriminatorMapping(true);
            if (discMapping != null) {
                DiscriminatorMetaData dismd = discMapping.getDatastoreContainer().getDiscriminatorMetaData();
                SQLTable discSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(this.stmt, this.getSQLTable(), discMapping);
                BooleanExpression discExpr = SQLStatementHelper.getExpressionForDiscriminatorForClass(this.stmt, type.getName(), dismd, discMapping, discSqlTbl);
                for (String subclassName : storeMgr.getSubClassesForClass(type.getName(), true, clr)) {
                    BooleanExpression discExprSub = SQLStatementHelper.getExpressionForDiscriminatorForClass(this.stmt, subclassName, dismd, discMapping, discSqlTbl);
                    discExpr.ior(discExprSub);
                }
                return discExpr;
            }
            throw new NucleusException("Dont currently support " + this + " instanceof " + type.getName());
        }
        throw new NucleusException("Dont currently support " + this + " instanceof " + type.getName());
    }
}

