/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;

public class CharacterLiteral
extends CharacterExpression
implements SQLLiteral {
    private final String value;
    Object rawValue;

    public CharacterLiteral(SQLStatement stmt, JavaTypeMapping mapping) {
        super(stmt, null, mapping);
        this.isParameter = true;
        this.value = null;
        this.st.appendParameter(mapping, this.value);
    }

    public CharacterLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
        super(stmt, null, mapping);
        if (value instanceof Character) {
            this.value = ((Character)value).toString();
            this.st.append('\'').append(this.value).append('\'');
        } else if (value instanceof String) {
            this.value = (String)value;
            this.st.append('\'').append(this.value).append('\'');
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        this.st.append('\'').append(this.value).append('\'');
    }

    public BooleanExpression eq(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.stmt, this.mapping, this.value.equals(((CharacterLiteral)expr).value));
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.stmt, this.mapping, !this.value.equals(((CharacterLiteral)expr).value));
        }
        return super.ne(expr);
    }

    public BooleanExpression lt(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.stmt, this.mapping, this.value.compareTo(((CharacterLiteral)expr).value) < 0);
        }
        return super.lt(expr);
    }

    public BooleanExpression le(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.stmt, this.mapping, this.value.compareTo(((CharacterLiteral)expr).value) <= 0);
        }
        return super.le(expr);
    }

    public BooleanExpression gt(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.stmt, this.mapping, this.value.compareTo(((CharacterLiteral)expr).value) > 0);
        }
        return super.gt(expr);
    }

    public BooleanExpression ge(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.stmt, this.mapping, this.value.compareTo(((CharacterLiteral)expr).value) >= 0);
        }
        return super.ge(expr);
    }

    public SQLExpression add(SQLExpression expr) {
        if (expr instanceof CharacterLiteral) {
            int v = this.value.charAt(0) + ((CharacterLiteral)expr).value.charAt(0);
            return new IntegerLiteral(this.stmt, this.mapping, new Integer(v));
        }
        if (expr instanceof IntegerLiteral) {
            int v = this.value.charAt(0) + ((Number)((IntegerLiteral)expr).getValue()).intValue();
            return new IntegerLiteral(this.stmt, this.mapping, new Integer(v));
        }
        return super.add(expr);
    }

    public SQLExpression sub(SQLExpression expr) {
        if (expr instanceof CharacterLiteral) {
            int v = this.value.charAt(0) - ((CharacterLiteral)expr).value.charAt(0);
            return new IntegerLiteral(this.stmt, this.mapping, new Integer(v));
        }
        if (expr instanceof IntegerLiteral) {
            int v = this.value.charAt(0) - ((Number)((IntegerLiteral)expr).getValue()).intValue();
            return new IntegerLiteral(this.stmt, this.mapping, new Integer(v));
        }
        return super.add(expr);
    }

    public SQLExpression mod(SQLExpression expr) {
        if (expr instanceof CharacterLiteral) {
            int v = this.value.charAt(0) % ((CharacterLiteral)expr).value.charAt(0);
            return new IntegerLiteral(this.stmt, this.mapping, new Integer(v));
        }
        if (expr instanceof IntegerLiteral) {
            int v = this.value.charAt(0) % ((Number)((IntegerLiteral)expr).getValue()).intValue();
            return new IntegerLiteral(this.stmt, this.mapping, new Integer(v));
        }
        return super.mod(expr);
    }

    public SQLExpression neg() {
        char v = -this.value.charAt(0);
        return new IntegerLiteral(this.stmt, this.mapping, new Integer(v));
    }

    public SQLExpression com() {
        int v = ~this.value.charAt(0);
        return new IntegerLiteral(this.stmt, this.mapping, new Integer(v));
    }

    public SQLExpression invoke(String methodName, List args) {
        if (methodName.equals("toUpperCase")) {
            return new CharacterLiteral(this.stmt, this.mapping, this.value.toUpperCase());
        }
        if (methodName.equals("toLowerCase")) {
            return new CharacterLiteral(this.stmt, this.mapping, this.value.toLowerCase());
        }
        return super.invoke(methodName, args);
    }

    public Object getValue() {
        if (this.value == null) {
            return null;
        }
        return new Character(this.value.charAt(0));
    }

    public void setRawValue(Object val) {
        this.rawValue = val;
    }

    public Object getRawValue() {
        return this.rawValue;
    }
}

