/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ObjectManager;
import org.datanucleus.store.mapped.expression.ExpressionHelper;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;

public class SQLText {
    private String sql;
    private List<Parameter> parameters = null;
    private boolean encloseInParentheses = false;
    private String postpend;
    private List appended = new ArrayList();

    public SQLText() {
    }

    public SQLText(String initialStatementText) {
        this();
        this.append(initialStatementText);
    }

    public void clearStatement() {
        this.sql = null;
        this.appended.clear();
    }

    public void encloseInParentheses() {
        this.sql = null;
        this.encloseInParentheses = true;
    }

    public SQLText postpend(String s) {
        this.sql = null;
        this.postpend = s;
        return this;
    }

    public SQLText append(char c) {
        this.sql = null;
        this.appended.add(new Character(c));
        return this;
    }

    public SQLText append(String s) {
        this.sql = null;
        this.appended.add(s);
        return this;
    }

    public SQLText append(SQLStatement stmt) {
        this.sql = null;
        this.appended.add(stmt);
        return this;
    }

    public SQLText append(SQLText st, int mode) {
        this.sql = null;
        this.appended.add(st.toSQL(mode));
        if (st.parameters != null) {
            if (this.parameters == null) {
                this.parameters = new ArrayList<Parameter>();
            }
            this.parameters.addAll(st.parameters);
        }
        return this;
    }

    public SQLText append(SQLExpression expr) {
        this.sql = null;
        this.appended.add(expr);
        return this;
    }

    public SQLText appendParameter(JavaTypeMapping mapping, Object value) {
        this.sql = null;
        this.appended.add(new Parameter(mapping, value));
        return this;
    }

    public void applyParametersToStatement(ObjectManager om, PreparedStatement ps) {
        if (this.parameters != null) {
            int num = 1;
            for (Parameter param : this.parameters) {
                JavaTypeMapping mapping = param.mapping;
                if (mapping == null) continue;
                Object value = param.value;
                mapping.setObject(om, (Object)ps, ExpressionHelper.getParametersIndex((int)num, (JavaTypeMapping)mapping), value);
                if (mapping.getNumberOfDatastoreFields() > 0) {
                    num += mapping.getNumberOfDatastoreFields();
                    continue;
                }
                ++num;
            }
        }
    }

    public String toSQL(int mode) {
        if (this.sql != null) {
            return this.sql;
        }
        StringBuffer sql = new StringBuffer();
        if (this.encloseInParentheses) {
            sql.append("(");
        }
        for (int i = 0; i < this.appended.size(); ++i) {
            SQLText st;
            Object item = this.appended.get(i);
            if (item instanceof SQLExpression) {
                SQLExpression expr = (SQLExpression)item;
                st = expr.toSQLText(mode);
                sql.append(st.toSQL(mode));
                if (st.parameters == null) continue;
                if (this.parameters == null) {
                    this.parameters = new ArrayList<Parameter>();
                }
                this.parameters.addAll(st.parameters);
                continue;
            }
            if (item instanceof Parameter) {
                Parameter param = (Parameter)item;
                sql.append('?');
                if (this.parameters == null) {
                    this.parameters = new ArrayList<Parameter>();
                }
                this.parameters.add(param);
                continue;
            }
            if (item instanceof SQLStatement) {
                SQLStatement stmt = (SQLStatement)item;
                st = stmt.getSelectStatement();
                sql.append(st.toSQL(mode));
                if (st.parameters == null) continue;
                if (this.parameters == null) {
                    this.parameters = new ArrayList<Parameter>();
                }
                this.parameters.addAll(st.parameters);
                continue;
            }
            if (item instanceof SQLText) {
                SQLText st2 = (SQLText)item;
                sql.append(st2.toSQL(mode));
                if (st2.parameters == null) continue;
                if (this.parameters == null) {
                    this.parameters = new ArrayList<Parameter>();
                }
                this.parameters.addAll(st2.parameters);
                continue;
            }
            sql.append(item);
        }
        if (this.encloseInParentheses) {
            sql.append(")");
        }
        sql.append(this.postpend == null ? "" : this.postpend);
        this.sql = sql.toString();
        return this.sql;
    }

    public String toString() {
        return this.toSQL(0);
    }

    private class Parameter {
        final JavaTypeMapping mapping;
        final Object value;

        public Parameter(JavaTypeMapping mapping, Object value) {
            this.mapping = mapping;
            this.value = value;
        }
    }
}

