/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.MapEntrySetStore;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.SQLWarnings;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.scostore.MapStore;

class RDBMSMapEntrySetStore
extends MapEntrySetStore {
    private String iteratorStmt;
    private String sizeStmt;

    public RDBMSMapEntrySetStore(MapTable mapTable, MapStore mapStore, ClassLoaderResolver clr, RDBMSManager storeMgr) {
        super((DatastoreContainerObject)mapTable, mapTable.getOwnerMapping(), mapTable.getOwnerMemberMetaData(), mapTable.getKeyMapping(), mapTable.getValueMapping(), mapStore, clr, (MappedStoreManager)storeMgr);
    }

    RDBMSMapEntrySetStore(DatastoreContainerObject valueTable, JavaTypeMapping ownerMapping, JavaTypeMapping keyMapping, JavaTypeMapping valueMapping, MapStore mapStore, RDBMSManager storeMgr) {
        super(valueTable, ownerMapping, keyMapping, valueMapping, mapStore);
    }

    RDBMSManager getStoreMgr() {
        return (RDBMSManager)this.storeMgr;
    }

    private String getSizeStmt() {
        if (this.sizeStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("SELECT COUNT(*) FROM ");
            stmt.append(this.setTable.toString());
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.keyMapping != null) {
                for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" IS NOT NULL");
                }
            }
            this.sizeStmt = stmt.toString();
        }
        return this.sizeStmt;
    }

    private String getIteratorStmt(JavaTypeMapping keyMapping, JavaTypeMapping valueMapping, DatastoreContainerObject setTable, JavaTypeMapping ownerMapping) {
        if (this.iteratorStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("SELECT ");
            if (keyMapping != null) {
                for (i = 0; i < keyMapping.getNumberOfDatastoreFields(); ++i) {
                    if (i > 0) {
                        stmt.append(",");
                    }
                    stmt.append(keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                }
            }
            if (valueMapping != null) {
                for (i = 0; i < valueMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                }
            }
            stmt.append(" FROM ");
            stmt.append(setTable.toString());
            stmt.append(" WHERE ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (keyMapping != null) {
                for (i = 0; i < keyMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" IS NOT NULL");
                }
            }
            this.iteratorStmt = stmt.toString();
        }
        return this.iteratorStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(StateManager sm) {
        int numRows;
        String stmt = this.getSizeStmt();
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.getStoreMgr().getConnection(om);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, om, ps, jdbcPosition, (BaseContainerStore)this);
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, stmt, ps);
                    try {
                        if (!rs.next()) {
                            throw new NucleusDataStoreException("Size request returned no result row: " + stmt);
                        }
                        numRows = rs.getInt(1);
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException("Size request failed: " + stmt, (Throwable)e);
        }
        return numRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator(StateManager sm) {
        MapEntrySetStore.SetIterator iter;
        String stmt;
        if (this.keyMapping != null && this.valueMapping != null) {
            stmt = this.getIteratorStmt(this.keyMapping, this.valueMapping, this.setTable, this.ownerMapping);
        } else {
            QueryExpression expr = this.dba.newQueryStatement(this.setTable, null, this.clr);
            ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(expr, expr.getMainTableExpression());
            ScalarExpression ownerVal = this.ownerMapping.newLiteral(expr, sm.getObject());
            expr.andCondition(ownerExpr.eq(ownerVal), true);
            this.newResultObjectFactory(sm, expr, false, true);
            stmt = expr.toStatementText(false).toString();
        }
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.getStoreMgr().getConnection(om);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    if (this.keyMapping != null && this.valueMapping != null) {
                        int jdbcPosition = 1;
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, om, ps, jdbcPosition, (BaseContainerStore)this);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, stmt, ps);
                    try {
                        AbstractMemberMetaData ownerMemberMetaData = null;
                        if (this.setTable instanceof JoinTable) {
                            ownerMemberMetaData = ((JoinTable)this.setTable).getOwnerMemberMetaData();
                        }
                        iter = new MapEntrySetStore.SetIterator(sm, this, ownerMemberMetaData, rs){

                            protected boolean next(Object rs) throws MappedDatastoreException {
                                try {
                                    return ((ResultSet)rs).next();
                                }
                                catch (SQLException e) {
                                    throw new MappedDatastoreException("SQLException", (Throwable)e);
                                }
                            }
                        };
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException("Iteration request failed: " + stmt, (Throwable)e);
        }
        catch (MappedDatastoreException e) {
            throw new NucleusDataStoreException("Iteration request failed: " + stmt, (Throwable)e);
        }
        return iter;
    }
}

