/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query2;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ManagedConnectionResourceListener;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.query.evaluator.JDOQLEvaluator;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.StatementMappingForClass;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.StatementParameterMapping;
import org.datanucleus.store.mapped.StatementResultMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.store.rdbms.query.ForwardQueryResult;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.query.ResultClassROF;
import org.datanucleus.store.rdbms.query.ScrollableQueryResult;
import org.datanucleus.store.rdbms.query2.QueryToSQLMapper;
import org.datanucleus.store.rdbms.sql.AbstractStatementGenerator;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDOQLQuery2
extends AbstractJDOQLQuery {
    String sqlStmt = null;
    StatementMappingForClass resultsDefinitionForClass = null;
    StatementResultMapping resultsDefinition = null;
    StatementParameterMapping parameterDefinition = new StatementParameterMapping();

    public JDOQLQuery2(ObjectManager om) {
        this(om, (JDOQLQuery2)null);
    }

    public JDOQLQuery2(ObjectManager om, JDOQLQuery2 q) {
        super(om, (AbstractJDOQLQuery)q);
    }

    public JDOQLQuery2(ObjectManager om, String query) {
        super(om, query);
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.sqlStmt = null;
        this.resultsDefinition = null;
        this.resultsDefinitionForClass = null;
        this.parameterDefinition = null;
    }

    protected void compileInternal(boolean forExecute, Map parameterValues) {
        if (this.compilation != null) {
            return;
        }
        super.compileInternal(forExecute, parameterValues);
        boolean inMemory = this.evaluateInMemory();
        RDBMSManager storeMgr = (RDBMSManager)this.getStoreManager();
        ClassLoaderResolver clr = this.om.getClassLoaderResolver();
        DatastoreClass candidateTable = storeMgr.getDatastoreClass(this.candidateClass.getName(), clr);
        AbstractClassMetaData acmd = this.getObjectManager().getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
        if (this.candidateCollection == null && this.candidateExtent == null) {
            this.resultsDefinitionForClass = new StatementMappingForClass(null);
            if (inMemory) {
                this.setStatementToRetrieveCandidates(parameterValues, candidateTable, acmd);
            } else {
                this.setStatementForQuery(parameterValues, candidateTable, acmd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        if (this.candidateCollection != null && this.candidateCollection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Object results = null;
        boolean inMemory = this.evaluateInMemory();
        ManagedConnection mconn = this.om.getStoreManager().getConnection(this.om);
        try {
            long startTime;
            block22: {
                ArrayList candidates;
                startTime = System.currentTimeMillis();
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JDOQL", (Object)this.getSingleStringQuery(), null));
                }
                RDBMSManager storeMgr = (RDBMSManager)this.getStoreManager();
                ClassLoaderResolver clr = this.om.getClassLoaderResolver();
                DatastoreClass candidateTable = storeMgr.getDatastoreClass(this.candidateClass.getName(), clr);
                AbstractClassMetaData acmd = this.getObjectManager().getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
                if (this.candidateCollection != null) {
                    candidates = new ArrayList(this.candidateCollection);
                    JDOQLEvaluator resultMapper = new JDOQLEvaluator((Query)this, candidates, this.compilation, clr);
                    results = resultMapper.execute(inMemory, inMemory, inMemory, inMemory, inMemory);
                } else if (this.candidateExtent != null) {
                    candidates = new ArrayList();
                    Iterator iter = this.candidateExtent.iterator();
                    while (iter.hasNext()) {
                        candidates.add(iter.next());
                    }
                    JDOQLEvaluator resultMapper = new JDOQLEvaluator((Query)this, candidates, this.compilation, clr);
                    results = resultMapper.execute(inMemory, inMemory, inMemory, inMemory, inMemory);
                } else {
                    try {
                        SQLController sqlControl = storeMgr.getSQLController();
                        PreparedStatement ps = RDBMSQueryUtils.getPreparedStatementForQuery(mconn, this.sqlStmt, (Query)this);
                        try {
                            RDBMSQueryUtils.prepareStatementForExecution(ps, (Query)this);
                            this.applyParametersToStatement(parameters, ps);
                            if (this.type != 0) break block22;
                            ResultSet rs = sqlControl.executeStatementQuery(mconn, this.sqlStmt, ps);
                            AbstractRDBMSQueryResult qr = null;
                            try {
                                if (inMemory) {
                                    ResultObjectFactory rof = storeMgr.newResultObjectFactory(candidateTable, acmd, this.resultsDefinitionForClass, RDBMSQueryUtils.useUpdateLockForQuery((Query)this), false, this.getFetchPlan(), this.candidateClass);
                                    ArrayList<Object> candidates2 = new ArrayList<Object>();
                                    while (rs.next()) {
                                        candidates2.add(rof.getObject(this.om, (Object)rs));
                                    }
                                    JDOQLEvaluator resultMapper = new JDOQLEvaluator((Query)this, candidates2, this.compilation, clr);
                                    results = resultMapper.execute(true, true, true, true, true);
                                } else {
                                    ResultClassROF rof = null;
                                    rof = !inMemory && this.result != null ? new ResultClassROF(this.resultClass, this.resultsDefinition) : storeMgr.newResultObjectFactory(candidateTable, acmd, this.resultsDefinitionForClass, RDBMSQueryUtils.useUpdateLockForQuery((Query)this), false, this.getFetchPlan(), this.candidateClass);
                                    String resultSetType = RDBMSQueryUtils.getResultSetTypeForQuery((Query)this);
                                    qr = resultSetType.equals("scroll-insensitive") || resultSetType.equals("scroll-sensitive") ? new ScrollableQueryResult((Query)this, rof, rs, this.getResultDistinct() ? null : this.candidateCollection) : new ForwardQueryResult((Query)this, rof, rs, this.getResultDistinct() ? null : this.candidateCollection);
                                    final ScrollableQueryResult qr1 = qr;
                                    final ManagedConnection mconn1 = mconn;
                                    ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener(){

                                        public void managedConnectionPreClose() {
                                        }

                                        public void managedConnectionPostClose() {
                                        }

                                        public void managedConnectionFlushed() {
                                            qr1.disconnect();
                                        }

                                        public void resourcePostClose() {
                                            mconn1.removeListener((ManagedConnectionResourceListener)this);
                                        }
                                    };
                                    mconn.addListener(listener);
                                    ((AbstractRDBMSQueryResult)qr).addConnectionListener(listener);
                                    results = qr;
                                }
                            }
                            finally {
                                if (qr == null) {
                                    rs.close();
                                }
                            }
                        }
                        catch (SQLException sqle) {
                            throw new NucleusException("Exception thrown in query", (Throwable)sqle);
                        }
                    }
                    catch (SQLException sqle) {
                        throw new NucleusException("Exception thrown in query", (Throwable)sqle);
                    }
                }
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)"JDOQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            Collection collection = results;
            return collection;
        }
        finally {
            mconn.release();
        }
    }

    private void setStatementForQuery(Map parameters, DatastoreClass candidateTable, AbstractClassMetaData candidateCmd) {
        if (this.result != null) {
            this.resultsDefinition = new StatementResultMapping();
        } else {
            this.resultsDefinitionForClass = new StatementMappingForClass(null);
        }
        RDBMSManager storeMgr = (RDBMSManager)this.getStoreManager();
        if (this.candidateCollection == null) {
            AbstractStatementGenerator stmtGen = null;
            if (candidateTable.getDiscriminatorMapping(false) != null) {
                stmtGen = new DiscriminatorStatementGenerator(storeMgr, this.candidateClass, this.subclasses, null, "this");
            } else {
                stmtGen = new UnionStatementGenerator(storeMgr, this.candidateClass, this.subclasses, null, "this");
                if (this.result == null) {
                    stmtGen.setOption("selectNucleusType");
                    this.resultsDefinitionForClass.setNucleusTypeColumnName("NUCLEUS_TYPE");
                }
            }
            SQLStatement stmt = stmtGen.getStatement();
            QueryToSQLMapper sqlMapper = new QueryToSQLMapper(stmt, this.compilation, parameters, this.resultsDefinitionForClass, this.resultsDefinition, candidateCmd, this.getFetchPlan(), this.parameterDefinition);
            sqlMapper.compile();
            boolean useUpdateLock = RDBMSQueryUtils.useUpdateLockForQuery((Query)this);
            stmt.addExtension("lock-for-update", new Boolean(useUpdateLock));
            if (this.type == 0) {
                this.sqlStmt = stmt.getSelectStatement().toString();
            } else {
                if (this.type == 1) {
                    throw new NucleusException("DataNucleus doesnt currently support bulk update statements");
                }
                if (this.type == 2) {
                    throw new NucleusException("DataNucleus doesnt currently support bulk delete statements");
                }
            }
        }
    }

    private void setStatementToRetrieveCandidates(Map parameters, DatastoreClass candidateTable, AbstractClassMetaData candidateCmd) {
        this.resultsDefinitionForClass = new StatementMappingForClass(null);
        RDBMSManager storeMgr = (RDBMSManager)this.getStoreManager();
        if (this.candidateCollection == null) {
            AbstractStatementGenerator stmtGen = null;
            if (candidateTable.getDiscriminatorMapping(false) != null) {
                stmtGen = new DiscriminatorStatementGenerator(storeMgr, this.candidateClass, this.subclasses, null, "this");
            } else {
                stmtGen = new UnionStatementGenerator(storeMgr, this.candidateClass, this.subclasses, null, "this");
                stmtGen.setOption("selectNucleusType");
                this.resultsDefinitionForClass.setNucleusTypeColumnName("NUCLEUS_TYPE");
            }
            SQLStatement stmt = stmtGen.getStatement();
            SQLStatementHelper.selectFetchPlanOfCandidateInStatement(stmt, this.resultsDefinitionForClass, this.getFetchPlan(), candidateCmd, 1);
            if (this.type == 0) {
                this.sqlStmt = stmt.getSelectStatement().toString();
            } else {
                if (this.type == 1) {
                    throw new NucleusException("DataNucleus doesnt currently support bulk update statements");
                }
                if (this.type == 2) {
                    throw new NucleusException("DataNucleus doesnt currently support bulk delete statements");
                }
            }
        }
    }

    protected void applyParametersToStatement(Map parameterValuesByName, PreparedStatement ps) throws SQLException {
        if (this.parameterDefinition == null || this.parameterDefinition.isEmpty()) {
            return;
        }
        for (Map.Entry entry : parameterValuesByName.entrySet()) {
            String paramName = (String)entry.getKey();
            Object paramValue = entry.getValue();
            StatementMappingIndex paramIdx = this.parameterDefinition.getMappingForParameter(paramName);
            if (paramIdx == null) continue;
            int[] positions = paramIdx.getParameterPositions();
            JavaTypeMapping mapping = paramIdx.getMapping();
            if (mapping.getJavaType() == Boolean.class) {
                mapping.setBoolean(this.om, (Object)ps, positions, ((Boolean)paramValue).booleanValue());
                continue;
            }
            if (mapping.getJavaType() == Byte.class) {
                mapping.setByte(this.om, (Object)ps, positions, ((Byte)paramValue).byteValue());
                continue;
            }
            if (mapping.getJavaType() == Character.class) {
                mapping.setChar(this.om, (Object)ps, positions, ((Character)paramValue).charValue());
                continue;
            }
            if (mapping.getJavaType() == Double.class) {
                mapping.setDouble(this.om, (Object)ps, positions, ((Double)paramValue).doubleValue());
                continue;
            }
            if (mapping.getJavaType() == Float.class) {
                mapping.setFloat(this.om, (Object)ps, positions, ((Float)paramValue).floatValue());
                continue;
            }
            if (mapping.getJavaType() == Integer.class) {
                mapping.setInt(this.om, (Object)ps, positions, ((Integer)paramValue).intValue());
                continue;
            }
            if (mapping.getJavaType() == Long.class) {
                mapping.setLong(this.om, (Object)ps, positions, ((Long)paramValue).longValue());
                continue;
            }
            if (mapping.getJavaType() == Short.class) {
                mapping.setShort(this.om, (Object)ps, positions, ((Short)paramValue).shortValue());
                continue;
            }
            if (mapping.getJavaType() == String.class) {
                mapping.setString(this.om, (Object)ps, positions, (String)paramValue);
                continue;
            }
            mapping.setObject(this.om, (Object)ps, positions, paramValue);
        }
    }

    public Set<String> getSupportedExtensions() {
        Set supported = super.getSupportedExtensions();
        supported.add("datanucleus.rdbms.query.resultSetType");
        supported.add("datanucleus.rdbms.query.resultSetConcurrency");
        supported.add("datanucleus.rdbms.query.useUpdateLock");
        return supported;
    }
}

