/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class SQLWarnings {
    private static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());

    public static void log(SQLWarning warning) {
        while (warning != null) {
            NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("052700", (Object)warning));
            warning = warning.getNextWarning();
        }
    }

    public static void log(Connection conn) {
        try {
            SQLWarnings.log(conn.getWarnings());
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("052701", (Object)conn), (Throwable)e);
        }
    }

    public static void log(Statement stmt) {
        try {
            SQLWarnings.log(stmt.getWarnings());
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("052702", (Object)stmt), (Throwable)e);
        }
    }

    public static void log(ResultSet rs) {
        try {
            SQLWarnings.log(rs.getWarnings());
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("052703", (Object)rs), (Throwable)e);
        }
    }
}

