/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.ExtensionPoint;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.SecondaryDatastoreClass;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.rdbms.sql.operation.SQLOperation;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class SQLExpressionFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    RDBMSManager storeMgr;
    ClassLoaderResolver clr;
    Map<String, String> expressionByMapping = new HashMap<String, String>();
    Map<String, String> literalByMapping = new HashMap<String, String>();
    Map<String, String> methodByDatastoreMethodName = new HashMap<String, String>();
    Map<String, String> operationByDatastoreOperationName = new HashMap<String, String>();

    public SQLExpressionFactory(RDBMSManager storeMgr) {
        String datastoreName;
        int e;
        ConfigurationElement[] elms;
        int i;
        this.storeMgr = storeMgr;
        this.clr = storeMgr.getOMFContext().getClassLoaderResolver(null);
        ExtensionPoint exPoint = storeMgr.getOMFContext().getPluginManager().getExtensionPoint("org.datanucleus.store.rdbms.sql_expression");
        for (i = 0; i < exPoint.getExtensions().length; ++i) {
            elms = exPoint.getExtensions()[i].getConfigurationElements();
            for (e = 0; e < elms.length; ++e) {
                String mappingName = elms[e].getAttribute("mapping-class").trim();
                String expressionName = elms[e].getAttribute("expression-class").trim();
                String literalName = elms[e].getAttribute("literal-class").trim();
                this.expressionByMapping.put(mappingName, expressionName);
                this.literalByMapping.put(mappingName, literalName);
            }
        }
        exPoint = storeMgr.getOMFContext().getPluginManager().getExtensionPoint("org.datanucleus.store.rdbms.sql_method");
        for (i = 0; i < exPoint.getExtensions().length; ++i) {
            elms = exPoint.getExtensions()[i].getConfigurationElements();
            for (e = 0; e < elms.length; ++e) {
                datastoreName = elms[e].getAttribute("datastore");
                String className = elms[e].getAttribute("class");
                String methodName = elms[e].getAttribute("method").trim();
                String sqlMethodName = elms[e].getAttribute("evaluator").trim();
                String key = this.getSQLMethodKey(datastoreName, className, methodName);
                this.methodByDatastoreMethodName.put(key, sqlMethodName);
            }
        }
        exPoint = storeMgr.getOMFContext().getPluginManager().getExtensionPoint("org.datanucleus.store.rdbms.sql_operation");
        for (i = 0; i < exPoint.getExtensions().length; ++i) {
            elms = exPoint.getExtensions()[i].getConfigurationElements();
            for (e = 0; e < elms.length; ++e) {
                datastoreName = elms[e].getAttribute("datastore");
                String name = elms[e].getAttribute("name").trim();
                String sqlOperationName = elms[e].getAttribute("evaluator").trim();
                String key = this.getSQLOperationKey(datastoreName, name);
                this.operationByDatastoreOperationName.put(key, sqlOperationName);
            }
        }
    }

    public SQLExpression newExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        DatastoreClass tbl;
        String expressionClassName = this.expressionByMapping.get(mapping.getClass().getName());
        if (expressionClassName == null) {
            throw new NucleusException(LOCALISER.msg("060004", (Object)mapping.getClass().getName()));
        }
        SQLTable expressionTable = table;
        if (table.getTable() instanceof DatastoreClass && !(tbl = (DatastoreClass)table.getTable()).managesMapping(mapping) && mapping.getDatastoreContainer() != null) {
            DatastoreContainerObject tableOfMapping = mapping.getDatastoreContainer();
            boolean innerJoin = true;
            if (tableOfMapping instanceof SecondaryDatastoreClass) {
                JoinMetaData joinmd = ((SecondaryDatastoreClass)tableOfMapping).getJoinMetaData();
                if (joinmd != null && joinmd.isOuter()) {
                    innerJoin = false;
                }
            } else if (!tbl.isSuperDatastoreClass((DatastoreClass)tableOfMapping)) {
                throw new NucleusException("Attempt to create expression for " + mapping + " in SQLTable " + table + " yet this mapping is for " + tableOfMapping + " which is not a supertable of the required table!");
            }
            expressionTable = stmt.getTable(tableOfMapping);
            if (expressionTable == null) {
                NucleusLogger.JDO.debug((Object)(">> newExpression needs join from " + table + " to " + tableOfMapping + " jointype=" + (innerJoin ? "INNER" : "OUTER")));
                expressionTable = innerJoin ? stmt.innerJoin(table, table.getTable().getIDMapping(), tableOfMapping, null, tableOfMapping.getIDMapping(), null) : stmt.leftOuterJoin(table, table.getTable().getIDMapping(), tableOfMapping, null, tableOfMapping.getIDMapping(), null);
            }
        }
        try {
            Class exprCls = this.clr.classForName(expressionClassName);
            SQLExpression expr = (SQLExpression)ClassUtils.newInstance((Class)exprCls, (Class[])new Class[]{SQLStatement.class, SQLTable.class, JavaTypeMapping.class}, (Object[])new Object[]{stmt, expressionTable, mapping});
            return expr;
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusException(LOCALISER.msg("060005", (Object)expressionClassName));
        }
    }

    public SQLExpression newLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
        String literalClassName = this.literalByMapping.get(mapping.getClass().getName());
        if (literalClassName == null) {
            throw new NucleusException(LOCALISER.msg("060006", (Object)mapping.getClass().getName()));
        }
        try {
            Class exprCls = this.clr.classForName(literalClassName);
            SQLExpression expr = (SQLExpression)ClassUtils.newInstance((Class)exprCls, (Class[])new Class[]{SQLStatement.class, JavaTypeMapping.class, Object.class}, (Object[])new Object[]{stmt, mapping, value});
            return expr;
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusException(LOCALISER.msg("060007", (Object)literalClassName));
        }
    }

    public SQLExpression invokeMethod(String className, String methodName, SQLExpression expr, List args) {
        String datastoreId = this.storeMgr.getDatastoreAdapter().getVendorID();
        String key = this.getSQLMethodKey(datastoreId, className, methodName);
        String sqlMethodClassName = this.methodByDatastoreMethodName.get(key);
        if (sqlMethodClassName == null && (sqlMethodClassName = this.methodByDatastoreMethodName.get(key = this.getSQLMethodKey(null, className, methodName))) == null) {
            if (className == null) {
                throw new NucleusException(LOCALISER.msg("060008", (Object)methodName, (Object)className));
            }
            throw new NucleusException(LOCALISER.msg("060009", (Object)methodName));
        }
        try {
            SQLMethod method = (SQLMethod)this.clr.classForName(sqlMethodClassName).newInstance();
            return method.getExpression(expr, args);
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusException(LOCALISER.msg("060010", (Object)sqlMethodClassName));
        }
        catch (InstantiationException e) {
            throw new NucleusException(LOCALISER.msg("060011", (Object)sqlMethodClassName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusException(LOCALISER.msg("060011", (Object)sqlMethodClassName), (Throwable)e);
        }
    }

    public SQLExpression invokeOperation(String name, SQLExpression expr, SQLExpression expr2) {
        String datastoreId = this.storeMgr.getDatastoreAdapter().getVendorID();
        String key = this.getSQLOperationKey(datastoreId, name);
        String sqlOperationClassName = this.operationByDatastoreOperationName.get(key);
        if (sqlOperationClassName == null && (sqlOperationClassName = this.operationByDatastoreOperationName.get(key = this.getSQLOperationKey(null, name))) == null) {
            throw new NucleusException(LOCALISER.msg("060012", (Object)name));
        }
        try {
            NucleusLogger.JDO.info((Object)(">> Invoke " + name + " returns " + sqlOperationClassName));
            SQLOperation operation = (SQLOperation)this.clr.classForName(sqlOperationClassName).newInstance();
            return operation.getExpression(expr, expr2);
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusException(LOCALISER.msg("060013", (Object)sqlOperationClassName));
        }
        catch (InstantiationException e) {
            throw new NucleusException(LOCALISER.msg("060014", (Object)sqlOperationClassName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusException(LOCALISER.msg("060014", (Object)sqlOperationClassName), (Throwable)e);
        }
    }

    private String getSQLMethodKey(String datastoreName, String className, String methodName) {
        return (datastoreName != null ? datastoreName.trim() : "ALL") + "#" + (className != null ? className.trim() + "." : "") + methodName;
    }

    private String getSQLOperationKey(String datastoreName, String name) {
        return (datastoreName != null ? datastoreName.trim() : "ALL") + "#" + name;
    }
}

