/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.BigDecimalMapping;
import org.datanucleus.store.mapped.mapping.BigIntegerMapping;
import org.datanucleus.store.mapped.mapping.BooleanMapping;
import org.datanucleus.store.mapped.mapping.ByteMapping;
import org.datanucleus.store.mapped.mapping.CharacterMapping;
import org.datanucleus.store.mapped.mapping.DateMapping;
import org.datanucleus.store.mapped.mapping.DoubleMapping;
import org.datanucleus.store.mapped.mapping.FloatMapping;
import org.datanucleus.store.mapped.mapping.IntegerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.LongMapping;
import org.datanucleus.store.mapped.mapping.ShortMapping;
import org.datanucleus.store.mapped.mapping.SqlDateMapping;
import org.datanucleus.store.mapped.mapping.SqlTimeMapping;
import org.datanucleus.store.mapped.mapping.SqlTimestampMapping;
import org.datanucleus.store.mapped.mapping.StringMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.ByteLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.ColumnExpression;
import org.datanucleus.store.rdbms.sql.expression.FloatingPointLiteral;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.ObjectLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalLiteral;
import org.datanucleus.store.rdbms.table.Column;

public class ObjectExpression
extends SQLExpression {
    private List<SQLExpression> expressions = new ArrayList<SQLExpression>();

    public ObjectExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        super(stmt, table, mapping);
        for (int i = 0; i < mapping.getNumberOfDatastoreFields(); ++i) {
            ColumnExpression colExpr = new ColumnExpression(stmt, table, (Column)mapping.getDataStoreMapping(i).getDatastoreField());
            this.expressions.add(colExpr);
        }
    }

    public SQLExpression cast(Class castType) {
        return null;
    }

    public BooleanExpression eq(SQLExpression expr) {
        BooleanExpression bExpr = null;
        if (expr instanceof NullLiteral) {
            for (int i = 0; i < this.expressions.size(); ++i) {
                SQLExpression sourceExpr = this.expressions.get(i);
                bExpr = bExpr == null ? expr.eq(sourceExpr) : bExpr.and(expr.eq(sourceExpr));
            }
        } else if (this.literalIsValidForSimpleComparison(expr)) {
            bExpr = this.expressions.size() > 1 ? super.eq(expr) : new BooleanExpression(this, Expression.OP_EQ, expr);
        } else if (expr instanceof ObjectLiteral) {
            bExpr = expr.eq(this);
        } else if (expr instanceof ObjectExpression) {
            for (int i = 0; i < this.expressions.size(); ++i) {
                SQLExpression sourceExpr = this.expressions.get(i);
                SQLExpression targetExpr = ((ObjectExpression)expr).expressions.get(i);
                bExpr = bExpr == null ? sourceExpr.eq(targetExpr) : bExpr.and(sourceExpr.eq(targetExpr));
            }
        } else {
            bExpr = super.eq(expr);
        }
        return bExpr;
    }

    public BooleanExpression ne(SQLExpression expr) {
        BooleanExpression bExpr = null;
        if (expr instanceof NullLiteral) {
            for (int i = 0; i < this.expressions.size(); ++i) {
                SQLExpression sourceExpr = this.expressions.get(i);
                bExpr = bExpr == null ? expr.eq(sourceExpr) : bExpr.and(expr.eq(sourceExpr));
            }
            bExpr = new BooleanExpression(Expression.OP_NOT, bExpr.encloseInParentheses());
        } else if (this.literalIsValidForSimpleComparison(expr)) {
            bExpr = this.expressions.size() > 1 ? super.ne(expr) : new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        } else if (expr instanceof ObjectLiteral) {
            bExpr = expr.ne(this);
        } else if (expr instanceof ObjectExpression) {
            for (int i = 0; i < this.expressions.size(); ++i) {
                SQLExpression sourceExpr = this.expressions.get(i);
                SQLExpression targetExpr = ((ObjectExpression)expr).expressions.get(i);
                bExpr = bExpr == null ? sourceExpr.eq(targetExpr) : bExpr.and(sourceExpr.eq(targetExpr));
            }
            bExpr = new BooleanExpression(Expression.OP_NOT, bExpr.encloseInParentheses());
        } else {
            bExpr = super.ne(expr);
        }
        return bExpr;
    }

    private boolean literalIsValidForSimpleComparison(SQLExpression expr) {
        return expr instanceof BooleanLiteral && this.mapping instanceof BooleanMapping || expr instanceof ByteLiteral && this.mapping instanceof ByteMapping || expr instanceof CharacterLiteral && this.mapping instanceof CharacterMapping || expr instanceof FloatingPointLiteral && (this.mapping instanceof FloatMapping || this.mapping instanceof DoubleMapping || this.mapping instanceof BigDecimalMapping) || expr instanceof IntegerLiteral && (this.mapping instanceof IntegerMapping || this.mapping instanceof LongMapping || this.mapping instanceof BigIntegerMapping) || this.mapping instanceof ShortMapping || expr instanceof TemporalLiteral && (this.mapping instanceof DateMapping || this.mapping instanceof SqlDateMapping || this.mapping instanceof SqlTimeMapping || this.mapping instanceof SqlTimestampMapping) || expr instanceof StringLiteral && (this.mapping instanceof StringMapping || this.mapping instanceof CharacterMapping);
    }

    public BooleanExpression in(SQLExpression expr) {
        return new BooleanExpression(this, Expression.OP_IN, expr);
    }

    public SQLExpression accessField(String subfieldName, boolean innerJoin) {
        return null;
    }

    public BooleanExpression instanceOf(SQLExpression expr) {
        return null;
    }
}

