/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.math.BigInteger;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;

public class IntegerLiteral
extends NumericExpression
implements SQLLiteral {
    private final Number value;
    Object rawValue;
    private SQLText stUsingParameter = new SQLText();

    public IntegerLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
        super(stmt, null, mapping);
        if (!(value instanceof Number)) {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        this.value = (Number)value;
        this.st.append(String.valueOf(value));
        this.stUsingParameter.appendParameter(mapping, value);
    }

    public BooleanExpression eq(SQLExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) == 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(expr, Expression.OP_EQ, literal);
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) != 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(expr, Expression.OP_NOTEQ, literal);
        }
        return super.ne(expr);
    }

    public BooleanExpression lt(SQLExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) < 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, Expression.OP_LT, expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression le(SQLExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) <= 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, Expression.OP_LTEQ, expr);
        }
        return super.le(expr);
    }

    public BooleanExpression gt(SQLExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) > 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, Expression.OP_GT, expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression ge(SQLExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) >= 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, Expression.OP_GTEQ, expr);
        }
        return super.ge(expr);
    }

    public SQLExpression add(SQLExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).add(new BigInteger(((IntegerLiteral)expr).value.toString())));
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).add(new BigInteger("" + v)));
        }
        return super.add(expr);
    }

    public SQLExpression sub(SQLExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).subtract(new BigInteger(((IntegerLiteral)expr).value.toString())));
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).subtract(new BigInteger("" + v)));
        }
        return super.sub(expr);
    }

    public SQLExpression mul(SQLExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).multiply(new BigInteger(((IntegerLiteral)expr).value.toString())));
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).multiply(new BigInteger("" + v)));
        }
        return super.mul(expr);
    }

    public SQLExpression div(SQLExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).divide(new BigInteger(((IntegerLiteral)expr).value.toString())));
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).divide(new BigInteger("" + v)));
        }
        return super.div(expr);
    }

    public SQLExpression mod(SQLExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).mod(new BigInteger(((IntegerLiteral)expr).value.toString())));
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).mod(new BigInteger("" + v)));
        }
        return super.mod(expr);
    }

    public SQLExpression neg() {
        return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).negate());
    }

    public SQLText toSQL(int mode) {
        if (mode == 0) {
            return this.stUsingParameter;
        }
        return super.toSQL(mode);
    }

    public Object getValue() {
        return this.value;
    }

    public void setRawValue(Object val) {
        this.rawValue = val;
    }

    public Object getRawValue() {
        return this.rawValue;
    }
}

