/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.lang.reflect.Field;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerHelper;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;

public class ExpressionUtils {
    public static NumericExpression getNumericExpression(SQLExpression expr) {
        RDBMSManager storeMgr = expr.getSQLStatement().getRDBMSManager();
        SQLExpressionFactory factory = storeMgr.getSQLExpressionFactory();
        DatabaseAdapter dba = expr.getSQLStatement().getDatabaseAdapter();
        if (expr instanceof CharacterLiteral) {
            char c = ((Character)((CharacterLiteral)expr).getValue()).charValue();
            BigInteger value = new BigInteger("" + c);
            return (NumericExpression)factory.newLiteral(expr.getSQLStatement(), storeMgr.getMappingManager().getMapping(value.getClass()), value);
        }
        if (expr instanceof SQLLiteral) {
            BigInteger value = new BigInteger((String)((SQLLiteral)((Object)expr)).getValue());
            return (NumericExpression)factory.newLiteral(expr.getSQLStatement(), storeMgr.getMappingManager().getMapping(value.getClass()), value);
        }
        ArrayList<SQLExpression> args = new ArrayList<SQLExpression>();
        args.add(expr);
        return new NumericExpression(dba.getNumericConversionFunction(), args);
    }

    public static Object getFieldValue(Object pc, AbstractMemberMetaData fmd) {
        ObjectManager om = ObjectManagerHelper.getObjectManager((Object)pc);
        if (om == null) {
            Object fieldValue;
            final Field field = ExpressionUtils.getDeclaredFieldPrivileged(pc.getClass(), fmd.getName());
            if (field == null) {
                throw new NucleusUserException("Cannot access field: " + fmd.getName() + " in type " + pc.getClass());
            }
            try {
                if (!field.isAccessible()) {
                    try {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                field.setAccessible(true);
                                return null;
                            }
                        });
                    }
                    catch (SecurityException ex) {
                        throw new NucleusException("Cannot access field: " + fmd.getName(), (Throwable)ex).setFatal();
                    }
                }
                fieldValue = field.get(pc);
            }
            catch (IllegalArgumentException e2) {
                throw new NucleusUserException("Cannot access field: " + fmd.getName(), (Throwable)e2);
            }
            catch (IllegalAccessException e2) {
                throw new NucleusUserException("Cannot access field: " + fmd.getName(), (Throwable)e2);
            }
            return fieldValue;
        }
        StateManager sm = om.findStateManager(pc);
        SingleValueFieldManager fm = new SingleValueFieldManager();
        if (!fmd.isPrimaryKey()) {
            om.getApiAdapter().isLoaded(sm, fmd.getAbsoluteFieldNumber());
        }
        sm.provideFields(new int[]{fmd.getAbsoluteFieldNumber()}, (FieldManager)fm);
        return fm.fetchObjectField(fmd.getAbsoluteFieldNumber());
    }

    private static Field getDeclaredFieldPrivileged(final Class cls, final String fieldName) {
        if (cls == null || fieldName == null) {
            return null;
        }
        return (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class seekingClass = cls;
                do {
                    try {
                        return seekingClass.getDeclaredField(fieldName);
                    }
                    catch (SecurityException ex) {
                        throw new NucleusException("CannotGetDeclaredField", (Throwable)ex).setFatal();
                    }
                    catch (NoSuchFieldException ex) {
                    }
                    catch (LinkageError ex) {
                        throw new NucleusException("ClassLoadingError", (Throwable)ex).setFatal();
                    }
                } while ((seekingClass = seekingClass.getSuperclass()) != null);
                return null;
            }
        });
    }

    public static SQLExpression getLiteralForOne(SQLStatement stmt) {
        RDBMSManager storeMgr = stmt.getRDBMSManager();
        JavaTypeMapping mapping = storeMgr.getMappingManager().getMapping(BigInteger.class);
        return storeMgr.getSQLExpressionFactory().newLiteral(stmt, mapping, BigInteger.ONE);
    }
}

