/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.mapped.scostore.AssociationStrategy;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.SQLWarnings;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.util.Localiser;

public class RDBMSAssociationStrategy
extends AssociationStrategy {
    private final RDBMSManager storeMgr;

    public RDBMSAssociationStrategy(Localiser localiser, ClassLoaderResolver clr, RDBMSManager storeMgr) {
        super(localiser, clr);
        this.storeMgr = storeMgr;
    }

    protected int populateOwnerInStatement(StateManager sm, ObjectManager om, Object ps, int jdbcPosition, BaseContainerStore bcs) {
        if (!this.storeMgr.insertValuesOnInsert(bcs.ownerMapping.getDataStoreMapping(0))) {
            return jdbcPosition;
        }
        if (bcs.ownerMemberMetaData != null) {
            bcs.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, bcs.ownerMapping), sm.getObject(), sm, bcs.ownerMemberMetaData.getAbsoluteFieldNumber());
        } else {
            bcs.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, bcs.ownerMapping), sm.getObject());
        }
        return jdbcPosition + bcs.ownerMapping.getNumberOfDatastoreFields();
    }

    protected int populateRelationDiscriminatorInStatement(ObjectManager om, PreparedStatement ps, int jdbcPosition, ElementContainerStore ecs) {
        ecs.relationDiscriminatorMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, ecs.relationDiscriminatorMapping), ecs.relationDiscriminatorValue);
        return jdbcPosition + ecs.relationDiscriminatorMapping.getNumberOfDatastoreFields();
    }

    protected String getAddStmt(ElementContainerStore ecs) {
        if (ecs.addStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("INSERT INTO ");
            stmt.append(ecs.containerTable.toString());
            stmt.append(" (");
            for (i = 0; i < ecs.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((Object)ecs.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            }
            for (i = 0; i < ecs.elementMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((Object)ecs.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            }
            if (ecs.orderMapping != null) {
                for (i = 0; i < ecs.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)ecs.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                }
            }
            if (ecs.relationDiscriminatorMapping != null) {
                for (i = 0; i < ecs.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)ecs.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                }
            }
            stmt.append(") VALUES (");
            for (i = 0; i < ecs.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((RDBMSMapping)ecs.ownerMapping.getDataStoreMapping(i)).getInsertionInputParameter());
            }
            for (i = 0; i < ecs.elementMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((RDBMSMapping)ecs.elementMapping.getDataStoreMapping(0)).getInsertionInputParameter());
            }
            if (ecs.orderMapping != null) {
                for (i = 0; i < ecs.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((RDBMSMapping)ecs.orderMapping.getDataStoreMapping(0)).getInsertionInputParameter());
                }
            }
            if (ecs.relationDiscriminatorMapping != null) {
                for (i = 0; i < ecs.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((RDBMSMapping)ecs.relationDiscriminatorMapping.getDataStoreMapping(0)).getInsertionInputParameter());
                }
            }
            stmt.append(") ");
            ecs.addStmt = stmt.toString();
        }
        return ecs.addStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeClear(StateManager ownerSM, ElementContainerStore ecs) {
        String clearStmt = this.getClearStmt(ecs);
        try {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, ecs);
                    if (ecs.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition, ecs);
                    }
                    sqlControl.executeStatementUpdate(mconn, clearStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.localiser.msg("056013", (Object)clearStmt), (Throwable)e);
        }
    }

    protected String getClearStmt(ElementContainerStore ecs) {
        if (ecs.clearStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("DELETE FROM ");
            stmt.append(ecs.containerTable.toString());
            stmt.append(" WHERE ");
            for (i = 0; i < ecs.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)ecs.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)ecs.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (ecs.relationDiscriminatorMapping != null) {
                for (i = 0; i < ecs.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)ecs.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)ecs.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            ecs.clearStmt = stmt.toString();
        }
        return ecs.clearStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize(StateManager ownerSM, ElementContainerStore ecs) {
        int numRows;
        String sizeStmt = this.getSizeStmt(ecs);
        try {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, sizeStmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, ecs);
                    if (ecs.elementInfo != null && ecs.elementInfo.length == 1) {
                        for (int i = 0; i < ecs.elementInfo.length; ++i) {
                            if (ecs.elementInfo[i].getDiscriminatorMapping() == null) continue;
                            jdbcPosition = this.populateElementDiscriminatorInStatement(om, ps, jdbcPosition, true, ecs.elementInfo[i]);
                        }
                    }
                    if (ecs.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition, ecs);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, sizeStmt, ps);
                    try {
                        if (!rs.next()) {
                            throw new NucleusDataStoreException(this.localiser.msg("056007", (Object)sizeStmt));
                        }
                        numRows = rs.getInt(1);
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.localiser.msg("056007", (Object)sizeStmt), (Throwable)e);
        }
        return numRows;
    }

    protected String getSizeStmt(ElementContainerStore ecs) {
        int i;
        int i2;
        if (ecs.sizeStmt != null && !ecs.usingDiscriminatorInSizeStmt) {
            return ecs.sizeStmt;
        }
        boolean allowNulls = false;
        if (ecs.ownerMemberMetaData != null && ecs.ownerMemberMetaData.hasExtension("allow-nulls") && ecs.ownerMemberMetaData.getValueForExtension("allow-nulls").equalsIgnoreCase("true")) {
            allowNulls = true;
        }
        StringBuffer stmt = new StringBuffer();
        String containerAlias = "THIS";
        String joinedElementAlias = "ELEM";
        stmt.append("SELECT COUNT(*) FROM ");
        stmt.append(ecs.containerTable.toString()).append(" ").append(containerAlias);
        boolean joinedDiscrim = false;
        if (ecs.elementInfo != null && ecs.elementInfo.length == 1 && ecs.elementInfo[0].getDatastoreClass() != ecs.containerTable && ecs.elementInfo[0].getDiscriminatorMapping() != null) {
            joinedDiscrim = true;
            JavaTypeMapping elemIdMapping = ecs.elementInfo[0].getDatastoreClass().getIDMapping();
            if (allowNulls) {
                stmt.append(" LEFT OUTER JOIN ");
            } else {
                stmt.append(" INNER JOIN ");
            }
            stmt.append(((Object)ecs.elementInfo[0].getDatastoreClass()).toString()).append(" ").append(joinedElementAlias).append(" ON ");
            for (i2 = 0; i2 < ecs.elementMapping.getNumberOfDatastoreFields(); ++i2) {
                if (i2 > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(containerAlias).append(".").append(ecs.elementMapping.getDataStoreMapping(i2).getDatastoreField().getIdentifier());
                stmt.append("=");
                stmt.append(joinedElementAlias).append(".").append(elemIdMapping.getDataStoreMapping(i2).getDatastoreField().getIdentifier());
            }
        }
        stmt.append(" WHERE ");
        for (i = 0; i < ecs.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(containerAlias).append(".").append(((Object)ecs.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append("=");
            stmt.append(((RDBMSMapping)ecs.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (ecs.orderMapping != null) {
            for (i = 0; i < ecs.orderMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(containerAlias).append(".").append(((Object)ecs.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(">=0");
            }
        }
        if (ecs.elementInfo != null && ecs.elementInfo.length == 1) {
            StringBuffer discrStmt = new StringBuffer();
            for (i2 = 0; i2 < ecs.elementInfo.length; ++i2) {
                if (ecs.elementInfo[i2].getDiscriminatorMapping() == null) continue;
                ecs.usingDiscriminatorInSizeStmt = true;
                if (discrStmt.length() > 0) {
                    discrStmt.append(" OR ");
                }
                JavaTypeMapping discrimMapping = ecs.elementInfo[i2].getDiscriminatorMapping();
                for (int j = 0; j < discrimMapping.getNumberOfDatastoreFields(); ++j) {
                    if (joinedDiscrim) {
                        discrStmt.append(joinedElementAlias);
                    } else {
                        discrStmt.append(containerAlias);
                    }
                    discrStmt.append(".");
                    discrStmt.append(((Object)discrimMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString());
                    discrStmt.append("=");
                    discrStmt.append(((RDBMSMapping)discrimMapping.getDataStoreMapping(j)).getUpdateInputParameter());
                }
                HashSet subclasses = this.storeMgr.getSubClassesForClass(ecs.elementInfo[i2].getClassName(), true, this.clr);
                if (subclasses == null || subclasses.size() <= 0) continue;
                for (int j = 0; j < subclasses.size(); ++j) {
                    for (int k = 0; k < discrimMapping.getNumberOfDatastoreFields(); ++k) {
                        discrStmt.append(" OR ");
                        if (joinedDiscrim) {
                            discrStmt.append(joinedElementAlias);
                        } else {
                            discrStmt.append(containerAlias);
                        }
                        discrStmt.append(".");
                        discrStmt.append(((Object)discrimMapping.getDataStoreMapping(k).getDatastoreField().getIdentifier()).toString());
                        discrStmt.append("=");
                        discrStmt.append(((RDBMSMapping)discrimMapping.getDataStoreMapping(k)).getUpdateInputParameter());
                    }
                }
            }
            if (discrStmt.length() > 0) {
                stmt.append(" AND (");
                stmt.append(discrStmt);
                if (allowNulls) {
                    stmt.append(" OR ");
                    stmt.append(((Object)ecs.elementInfo[0].getDiscriminatorMapping().getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" IS NULL");
                }
                stmt.append(")");
            }
        }
        if (ecs.relationDiscriminatorMapping != null) {
            for (int i3 = 0; i3 < ecs.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i3) {
                stmt.append(" AND ");
                stmt.append(containerAlias).append(".").append(((Object)ecs.relationDiscriminatorMapping.getDataStoreMapping(i3).getDatastoreField().getIdentifier()).toString());
                stmt.append("=");
                stmt.append(((RDBMSMapping)ecs.relationDiscriminatorMapping.getDataStoreMapping(i3)).getUpdateInputParameter());
            }
        }
        ecs.sizeStmt = stmt.toString();
        return ecs.sizeStmt;
    }

    protected int populateElementDiscriminatorInStatement(ObjectManager om, PreparedStatement ps, int jdbcPosition, boolean includeSubclasses, ElementContainerStore.ElementInfo info) {
        HashSet subclasses;
        DiscriminatorStrategy strategy = info.getDiscriminatorStrategy();
        JavaTypeMapping discrimMapping = info.getDiscriminatorMapping();
        if (strategy == DiscriminatorStrategy.CLASS_NAME) {
            discrimMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, discrimMapping), info.getClassName());
            jdbcPosition += discrimMapping.getNumberOfDatastoreFields();
        } else if (strategy == DiscriminatorStrategy.VALUE_MAP) {
            discrimMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, discrimMapping), info.getAbstractClassMetaData().getInheritanceMetaData().getDiscriminatorMetaData().getValue());
            jdbcPosition += discrimMapping.getNumberOfDatastoreFields();
        }
        if (includeSubclasses && (subclasses = this.storeMgr.getSubClassesForClass(info.getClassName(), true, this.clr)) != null && subclasses.size() > 0) {
            for (String subclass : subclasses) {
                if (strategy == DiscriminatorStrategy.CLASS_NAME) {
                    discrimMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, discrimMapping), subclass);
                    jdbcPosition += discrimMapping.getNumberOfDatastoreFields();
                    continue;
                }
                if (strategy != DiscriminatorStrategy.VALUE_MAP) continue;
                AbstractClassMetaData subclassCmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(subclass, this.clr);
                discrimMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, discrimMapping), subclassCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue());
                jdbcPosition += discrimMapping.getNumberOfDatastoreFields();
            }
        }
        return jdbcPosition;
    }

    protected SQLController getSQLController() {
        return this.storeMgr.getSQLController();
    }

    protected String getStatementTextForQuery(QueryExpression stmt, boolean useUpdateLock) {
        return this.storeMgr.getStatementTextForQuery(stmt, useUpdateLock);
    }

    protected PreparedStatement getStatementForQuery(QueryExpression qs, ObjectManager om, ManagedConnection conn, boolean updateLock, String resultSetType, String resultSetConcurrency) throws SQLException {
        return this.storeMgr.getStatementForQuery(qs, om, conn, updateLock, resultSetType, resultSetConcurrency);
    }
}

