/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.JDOQLEvaluator;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.util.NucleusLogger;

public class JDOQLQuery2
extends AbstractJDOQLQuery {
    public JDOQLQuery2(ObjectManager om) {
        this(om, (JDOQLQuery2)null);
    }

    public JDOQLQuery2(ObjectManager om, JDOQLQuery2 q) {
        super(om, (AbstractJDOQLQuery)q);
    }

    public JDOQLQuery2(ObjectManager om, String query) {
        super(om, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object performExecute(Map parameters) {
        ClassLoaderResolver clr = this.om.getClassLoaderResolver();
        if (this.candidateCollection != null && this.candidateCollection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        boolean inMemory = false;
        String queryInMemoryStr = (String)this.getExtension("datanucleus.query.evaluateInMemory");
        if (queryInMemoryStr != null && queryInMemoryStr.equalsIgnoreCase("true")) {
            inMemory = true;
        }
        ManagedConnection mconn = this.om.getStoreManager().getConnection(this.om);
        try {
            boolean orderingInMemory;
            boolean filterInMemory;
            ArrayList candidates;
            long startTime;
            block18: {
                block19: {
                    startTime = System.currentTimeMillis();
                    if (NucleusLogger.QUERY.isDebugEnabled()) {
                        NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JDOQL", (Object)this.getSingleStringQuery(), null));
                    }
                    candidates = null;
                    filterInMemory = false;
                    orderingInMemory = false;
                    if (this.candidateCollection != null) break block19;
                    if (inMemory) {
                        filterInMemory = true;
                        orderingInMemory = true;
                        break block18;
                    } else {
                        SQLStatement stmt = this.getNativeQueryForCompiledQuery(this.compilation, parameters);
                        boolean useUpdateLock = RDBMSQueryUtils.useUpdateLockForQuery((Query)this);
                        stmt.addExtension("lock-for-update", new Boolean(useUpdateLock));
                        SQLText sqlText = null;
                        if (this.type == 0) {
                            sqlText = stmt.getSelectStatement();
                        } else {
                            if (this.type == 1) {
                                throw new NucleusException("DataNucleus doesnt currently support bulk update statements");
                            }
                            if (this.type == 2) {
                                throw new NucleusException("DataNucleus doesnt currently support bulk delete statements");
                            }
                        }
                        NucleusLogger.QUERY.debug((Object)(">> statement=" + sqlText.toSQL(0)));
                        try {
                            SQLController sqlControl = ((RDBMSManager)this.getStoreManager()).getSQLController();
                            PreparedStatement ps = RDBMSQueryUtils.getPreparedStatementForQuery(mconn, sqlText.toSQL(0), (Query)this);
                            try {
                                RDBMSQueryUtils.prepareStatementForExecution(ps, (Query)this);
                                if (this.type == 0) {
                                    sqlControl.executeStatementQuery(mconn, sqlText.toString(), ps);
                                }
                                break block18;
                            }
                            catch (SQLException sqle) {
                                throw new NucleusException("Exception thrown in query", (Throwable)sqle);
                            }
                        }
                        catch (SQLException sqle) {
                            throw new NucleusException("Exception thrown in query", (Throwable)sqle);
                        }
                    }
                }
                candidates = new ArrayList(this.candidateCollection);
                filterInMemory = true;
                orderingInMemory = true;
            }
            JDOQLEvaluator resultMapper = new JDOQLEvaluator((Query)this, candidates, this.compilation, clr);
            Collection results = resultMapper.execute(filterInMemory, orderingInMemory, true, true, true);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)"JDOQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            Collection collection = results;
            return collection;
        }
        finally {
            mconn.release();
        }
    }

    private SQLStatement getNativeQueryForCompiledQuery(QueryCompilation compilation, Map parameters) {
        SQLStatement stmt = null;
        RDBMSManager storeMgr = (RDBMSManager)this.getStoreManager();
        ClassLoaderResolver clr = this.getObjectManager().getClassLoaderResolver();
        if (this.candidateCollection == null) {
            DatastoreClass candidateTable = storeMgr.getDatastoreClass(this.candidateClass.getName(), clr);
            stmt = new SQLStatement(storeMgr, candidateTable, null);
            if (this.result != null) {
                // empty if block
            }
        }
        return stmt;
    }
}

