/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.schema.H2TypeInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;

public class H2Adapter
extends DatabaseAdapter {
    private String schemaName;

    public H2Adapter(DatabaseMetaData metadata) {
        super(metadata);
        try {
            ResultSet rs = metadata.getSchemas();
            while (rs.next()) {
                if (!rs.getBoolean("IS_DEFAULT")) continue;
                this.schemaName = rs.getString("TABLE_SCHEM");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("CheckInEndCreateStatements");
        this.supportedOptions.add("UniqueInEndCreateStatements");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("TxIsolationReadRepeatableRead");
        this.supportedOptions.remove("TxIsolationNone");
    }

    public String getVendorID() {
        return "h2";
    }

    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new H2TypeInfo(rs);
    }

    public int getDatastoreIdentifierMaxLength(int identifierType) {
        if (identifierType == 0) {
            return 128;
        }
        if (identifierType == 1) {
            return 128;
        }
        if (identifierType == 4) {
            return 128;
        }
        if (identifierType == 2) {
            return 128;
        }
        if (identifierType == 3) {
            return 128;
        }
        if (identifierType == 5) {
            return 128;
        }
        if (identifierType == 6) {
            return 128;
        }
        return super.getDatastoreIdentifierMaxLength(identifierType);
    }

    public String getAddColumnStatement(DatastoreContainerObject table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD COLUMN " + col.getSQLDefinition();
    }

    public String getRangeByLimitSelectClause(long offset, long count) {
        if (offset >= 0L && count > 0L) {
            return " LIMIT " + offset + " " + count + " ";
        }
        if (offset <= 0L && count > 0L) {
            return " LIMIT 0 " + count + " ";
        }
        if (offset >= 0L && count < 0L) {
            return " LIMIT " + offset + "," + Long.MAX_VALUE;
        }
        return "";
    }

    public String getSchemaName(Connection conn) throws SQLException {
        return this.schemaName;
    }

    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public String getAutoIncrementStmt(Table table, String columnName) {
        return "CALL IDENTITY()";
    }

    public String getAutoIncrementKeyword() {
        return "IDENTITY";
    }

    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " VALUES(NULL)";
    }

    public boolean isValidPrimaryKeyType(int datatype) {
        return true;
    }

    public String getSequenceCreateStmt(String sequence_name, String min, String max, String start, String increment, String cache_size) {
        if (sequence_name == null) {
            throw new NucleusUserException(LOCALISER.msg("051028"));
        }
        StringBuffer stmt = new StringBuffer("CREATE SEQUENCE IF NOT EXISTS ");
        stmt.append(sequence_name);
        if (min != null && min.length() > 0) {
            stmt.append(" START WITH " + min);
        } else if (start != null && start.length() > 0) {
            stmt.append(" START WITH " + start);
        }
        if (max != null && max.length() > 0) {
            throw new NucleusUserException(LOCALISER.msg("051022"));
        }
        if (increment != null && increment.length() > 0) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (cache_size != null && cache_size.length() > 0) {
            stmt.append(" CACHE " + cache_size);
        }
        return stmt.toString();
    }

    public String getSequenceNextStmt(String sequence_name) {
        if (sequence_name == null) {
            throw new NucleusUserException(LOCALISER.msg("051028"));
        }
        StringBuffer stmt = new StringBuffer("CALL NEXT VALUE FOR ");
        stmt.append(sequence_name);
        return stmt.toString();
    }

    public NumericExpression modOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(operand1);
        args.add(operand2);
        return new NumericExpression("MOD", args);
    }
}

