/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.OMFContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.state.ActivityState;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreDataManager;
import org.datanucleus.store.exceptions.NoTableManagedException;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.FetchStatement;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreData;
import org.datanucleus.store.mapped.MappedTypeManager;
import org.datanucleus.store.mapped.StatementExpressionIndex;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingManager;
import org.datanucleus.store.mapped.scostore.AssociationStrategy;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public abstract class MappedStoreManager
extends AbstractStoreManager {
    protected DatastoreAdapter dba;
    protected IdentifierFactory identifierFactory;
    protected final boolean autoCreateTables;
    protected final boolean autoCreateColumns;
    protected final boolean autoCreateConstraints;
    protected final boolean autoCreateWarnOnError;
    protected final boolean validateTables;
    protected final boolean validateColumns;
    protected final boolean validateConstraints;
    protected Map<DatastoreIdentifier, DatastoreContainerObject> datastoreContainerByIdentifier = new HashMap<DatastoreIdentifier, DatastoreContainerObject>();
    protected MappedTypeManager mappedTypeMgr = null;
    protected MappingManager mappingManager;
    protected Map<StateManager, DatastoreClass> insertedDatastoreClassByStateManager = new HashMap<StateManager, DatastoreClass>();

    protected MappedStoreManager(String key, ClassLoaderResolver clr, OMFContext omfContext) {
        super(key, clr, omfContext);
        PersistenceConfiguration conf = omfContext.getPersistenceConfiguration();
        if (this.readOnlyDatastore || this.fixedDatastore) {
            this.autoCreateTables = false;
            this.autoCreateColumns = false;
            this.autoCreateConstraints = false;
        } else {
            boolean autoCreateSchema = conf.getBooleanProperty("datanucleus.autoCreateSchema");
            if (autoCreateSchema) {
                this.autoCreateTables = true;
                this.autoCreateColumns = true;
                this.autoCreateConstraints = true;
            } else {
                this.autoCreateColumns = conf.getBooleanProperty("datanucleus.autoCreateColumns");
                this.autoCreateTables = conf.getBooleanProperty("datanucleus.autoCreateTables");
                this.autoCreateConstraints = conf.getBooleanProperty("datanucleus.autoCreateConstraints");
            }
        }
        this.autoCreateWarnOnError = conf.getBooleanProperty("datanucleus.autoCreateWarnOnError");
        this.validateTables = conf.getBooleanProperty("datanucleus.validateTables");
        this.validateColumns = !this.validateTables ? false : conf.getBooleanProperty("datanucleus.validateColumns");
        this.validateConstraints = conf.getBooleanProperty("datanucleus.validateConstraints");
        this.mappedTypeMgr = new MappedTypeManager(omfContext);
    }

    public void close() {
        this.dba = null;
        super.close();
    }

    public boolean supportsValueStrategy(String strategy) {
        if (strategy.equalsIgnoreCase("IDENTITY") || super.supportsValueStrategy(strategy)) {
            if (strategy.equalsIgnoreCase("IDENTITY") && !this.dba.supportsOption("IdentityColumns")) {
                return false;
            }
            return !strategy.equalsIgnoreCase("SEQUENCE") || this.dba.supportsOption("Sequences");
        }
        return false;
    }

    public MappedTypeManager getMappedTypeManager() {
        return this.mappedTypeMgr;
    }

    public IdentifierFactory getIdentifierFactory() {
        return this.identifierFactory;
    }

    public DatastoreAdapter getDatastoreAdapter() {
        return this.dba;
    }

    public MappingManager getMappingManager() {
        if (this.mappingManager == null) {
            this.mappingManager = this.dba.getMappingManager(this);
        }
        return this.mappingManager;
    }

    public abstract FetchStatement getFetchStatement(DatastoreContainerObject var1);

    public abstract DatastoreContainerObject newJoinDatastoreContainerObject(AbstractMemberMetaData var1, ClassLoaderResolver var2);

    public synchronized StoreData[] getStoreDataForDatastoreContainerObject(DatastoreIdentifier tableIdentifier) {
        return this.storeDataMgr.getStoreDataForProperties("tableId", (Object)tableIdentifier, "table-owner", (Object)"true");
    }

    public synchronized DatastoreContainerObject getDatastoreContainerObject(AbstractMemberMetaData fmd) {
        StoreData sd = this.storeDataMgr.get(fmd);
        if (sd != null && sd instanceof MappedStoreData) {
            return ((MappedStoreData)sd).getDatastoreContainerObject();
        }
        return null;
    }

    public void addDatastoreContainer(DatastoreContainerObject table) {
        if (table != null && this.datastoreContainerByIdentifier.get(table.getIdentifier()) == null) {
            this.datastoreContainerByIdentifier.put(table.getIdentifier(), table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastoreClass getDatastoreClass(String className, ClassLoaderResolver clr) {
        DatastoreClass ct = null;
        if (className == null) {
            NucleusLogger.PERSISTENCE.error((Object)LOCALISER.msg("032015"));
            return null;
        }
        StoreData sd = this.storeDataMgr.get(className);
        if (sd != null && sd instanceof MappedStoreData && (ct = (DatastoreClass)((MappedStoreData)sd).getDatastoreContainerObject()) != null) {
            return ct;
        }
        boolean toBeAdded = false;
        if (clr != null) {
            Class cls = clr.classForName(className);
            ApiAdapter api = this.getApiAdapter();
            if (cls != null && !cls.isInterface() && api.isPersistable(cls)) {
                toBeAdded = true;
            }
        } else {
            toBeAdded = true;
        }
        boolean classKnown = false;
        if (toBeAdded) {
            this.addClass(className, clr);
            StoreDataManager storeDataManager = this.storeDataMgr;
            synchronized (storeDataManager) {
                sd = this.storeDataMgr.get(className);
                if (sd != null && sd instanceof MappedStoreData) {
                    classKnown = true;
                    ct = (DatastoreClass)((MappedStoreData)sd).getDatastoreContainerObject();
                }
            }
        }
        if (!classKnown && ct == null) {
            throw new NoTableManagedException(className);
        }
        return ct;
    }

    public synchronized DatastoreClass getDatastoreClass(DatastoreIdentifier name) {
        for (StoreData sd : this.storeDataMgr.getManagedStoreData()) {
            MappedStoreData tsd;
            if (!(sd instanceof MappedStoreData) || !(tsd = (MappedStoreData)sd).hasTable() || !tsd.getDatastoreIdentifier().equals(name)) continue;
            return (DatastoreClass)tsd.getDatastoreContainerObject();
        }
        return null;
    }

    public AbstractClassMetaData getClassWithPrimaryKeyForClass(AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        if (cmd == null) {
            return null;
        }
        if (cmd.getSuperAbstractClassMetaData() == null) {
            return cmd;
        }
        if (this.getDatastoreClass(cmd.getFullClassName(), clr) != null) {
            return cmd;
        }
        return this.getClassWithPrimaryKeyForClass(cmd.getSuperAbstractClassMetaData(), clr);
    }

    public AbstractClassMetaData[] getClassesManagingTableForClass(AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        if (cmd == null) {
            return null;
        }
        if (cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE || cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.NEW_TABLE) {
            return new AbstractClassMetaData[]{cmd};
        }
        if (cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
            int i;
            String[] subclasses = this.getMetaDataManager().getSubclassesForClass(cmd.getFullClassName(), true);
            if (subclasses != null) {
                for (int i2 = 0; i2 < subclasses.length; ++i2) {
                    if (this.storeDataMgr.managesClass(subclasses[i2])) continue;
                    this.addClass(subclasses[i2], clr);
                }
            }
            HashSet<AbstractClassMetaData> managingClasses = new HashSet<AbstractClassMetaData>();
            for (StoreData data : this.storeDataMgr.getManagedStoreData()) {
                AbstractClassMetaData[] superCmds;
                if (!data.isFCO() || ((AbstractClassMetaData)data.getMetaData()).getSuperAbstractClassMetaData() == null || !((AbstractClassMetaData)data.getMetaData()).getSuperAbstractClassMetaData().getFullClassName().equals(cmd.getFullClassName()) || (superCmds = this.getClassesManagingTableForClass((AbstractClassMetaData)data.getMetaData(), clr)) == null) continue;
                for (i = 0; i < superCmds.length; ++i) {
                    managingClasses.add(superCmds[i]);
                }
            }
            Iterator managingClassesIter = managingClasses.iterator();
            AbstractClassMetaData[] managingCmds = new AbstractClassMetaData[managingClasses.size()];
            i = 0;
            while (managingClassesIter.hasNext()) {
                managingCmds[i++] = (AbstractClassMetaData)managingClassesIter.next();
            }
            return managingCmds;
        }
        if (cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
            return this.getClassesManagingTableForClass(cmd.getSuperAbstractClassMetaData(), clr);
        }
        return null;
    }

    public boolean isObjectInserted(StateManager sm, int fieldNumber) {
        if (sm == null) {
            return false;
        }
        if (!sm.isInserting()) {
            return true;
        }
        DatastoreClass latestTable = this.insertedDatastoreClassByStateManager.get(sm);
        if (latestTable == null) {
            return false;
        }
        AbstractMemberMetaData fmd = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (fmd == null) {
            return false;
        }
        String className = fmd.getClassName();
        if (fmd.isPrimaryKey()) {
            className = sm.getObject().getClass().getName();
        }
        for (DatastoreClass datastoreCls = latestTable; datastoreCls != null; datastoreCls = datastoreCls.getSuperDatastoreClass()) {
            if (!datastoreCls.managesClass(className)) continue;
            return true;
        }
        return false;
    }

    public boolean isObjectInserted(StateManager sm, String className) {
        if (sm == null) {
            return false;
        }
        if (!sm.isInserting()) {
            return false;
        }
        DatastoreClass latestTable = this.insertedDatastoreClassByStateManager.get(sm);
        if (latestTable != null) {
            for (DatastoreClass datastoreCls = latestTable; datastoreCls != null; datastoreCls = datastoreCls.getSuperDatastoreClass()) {
                if (!datastoreCls.managesClass(className)) continue;
                return true;
            }
        }
        return false;
    }

    public void setObjectIsInsertedToLevel(StateManager sm, DatastoreClass table) {
        this.insertedDatastoreClassByStateManager.put(sm, table);
        if (table.managesClass(sm.getClassMetaData().getFullClassName())) {
            sm.changeActivityState(ActivityState.INSERTING_CALLBACKS);
            this.insertedDatastoreClassByStateManager.remove(sm);
        }
    }

    public abstract FieldManager getFieldManagerForResultProcessing(StateManager var1, Object var2, StatementExpressionIndex[] var3);

    public abstract FieldManager getFieldManagerForStatementGeneration(StateManager var1, Object var2, StatementExpressionIndex[] var3, boolean var4);

    public abstract Object getResultValueAtPosition(Object var1, JavaTypeMapping var2, int var3);

    public abstract boolean insertValuesOnInsert(DatastoreMapping var1);

    public abstract boolean allowsBatching();

    public abstract AssociationStrategy newAssociationStrategy(Localiser var1, ClassLoaderResolver var2);

    public abstract ResultObjectFactory newResultObjectFactory(DatastoreClass var1, int[] var2, AbstractClassMetaData var3, StatementExpressionIndex[] var4, int[] var5, int[] var6, boolean var7, boolean var8, boolean var9, FetchPlan var10, Class var11);
}

