/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.DuplicateDatastoreFieldException;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.CorrespondentColumnsMapper;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public final class ColumnCreator {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.mapped.Localisation", (ClassLoader)MappedStoreManager.class.getClassLoader());

    private ColumnCreator() {
    }

    public static DatastoreField createIndexColumn(JavaTypeMapping mapping, MappedStoreManager storeMgr, ClassLoaderResolver clr, DatastoreContainerObject table, ColumnMetaData colmd, boolean pk) {
        DatastoreIdentifier identifier = null;
        identifier = colmd != null && colmd.getName() != null ? storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(colmd.getName()) : storeMgr.getIdentifierFactory().newAdapterIndexFieldIdentifier();
        DatastoreField column = table.addDatastoreField(mapping.getType(), identifier, mapping, (MetaData)colmd);
        storeMgr.getMappingManager().createDatastoreMapping(mapping, column, mapping.getJavaType().getName());
        if (pk) {
            column.setAsPrimaryKey();
        }
        return column;
    }

    public static JavaTypeMapping createColumnsForJoinTables(Class javaType, AbstractMemberMetaData mmd, ColumnMetaData[] columnMetaData, MappedStoreManager storeMgr, DatastoreContainerObject table, boolean primaryKey, boolean nullable, int fieldRole, ClassLoaderResolver clr) {
        JavaTypeMapping mapping = storeMgr.getMappingManager().getMapping(javaType, false, false, mmd.getFullFieldName());
        ColumnCreator.createColumnsForField(javaType, mapping, table, storeMgr, mmd, primaryKey, nullable, false, false, fieldRole, columnMetaData, clr, false);
        return mapping;
    }

    public static JavaTypeMapping createColumnsForField(Class javaType, JavaTypeMapping mapping, DatastoreContainerObject table, MappedStoreManager storeMgr, AbstractMemberMetaData mmd, boolean isPrimaryKey, boolean isNullable, boolean serialised, boolean embedded, int fieldRole, ColumnMetaData[] columnMetaData, ClassLoaderResolver clr, boolean isReferenceField) {
        IdentifierFactory idFactory = storeMgr.getIdentifierFactory();
        if (mapping instanceof ReferenceMapping || mapping instanceof PersistenceCapableMapping) {
            DatastoreClass destinationTable;
            JavaTypeMapping container = mapping;
            if (mapping instanceof ReferenceMapping) {
                container = storeMgr.getMappingManager().getMapping(javaType, serialised, embedded, mmd != null ? mmd.getFullFieldName() : null);
                ((ReferenceMapping)mapping).addJavaTypeMapping(container);
            }
            if ((destinationTable = storeMgr.getDatastoreClass(javaType.getName(), clr)) == null) {
                AbstractClassMetaData ownerCmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(javaType, clr);
                AbstractClassMetaData[] ownerCmds = storeMgr.getClassesManagingTableForClass(ownerCmd, clr);
                if (ownerCmds == null || ownerCmds.length == 0) {
                    throw new NucleusUserException(LOCALISER.msg("057023", (Object)javaType.getName())).setFatal();
                }
                destinationTable = storeMgr.getDatastoreClass(ownerCmds[0].getFullClassName(), clr);
            }
            if (destinationTable != null) {
                JavaTypeMapping m = destinationTable.getIDMapping();
                ColumnMetaDataContainer columnContainer = null;
                if (columnMetaData != null && columnMetaData.length > 0) {
                    columnContainer = (ColumnMetaDataContainer)columnMetaData[0].getParent();
                }
                CorrespondentColumnsMapper correspondentColumnsMapping = new CorrespondentColumnsMapper(columnContainer, columnMetaData, m, true);
                for (int i = 0; i < m.getNumberOfDatastoreFields(); ++i) {
                    JavaTypeMapping refDatastoreMapping = storeMgr.getMappingManager().getMapping(m.getDataStoreMapping(i).getJavaTypeMapping().getJavaType());
                    ColumnMetaData colmd = correspondentColumnsMapping.getColumnMetaDataByIdentifier(m.getDataStoreMapping(i).getDatastoreField().getIdentifier());
                    try {
                        AbstractMemberMetaData[] relatedMmds;
                        DatastoreIdentifier identifier = null;
                        identifier = colmd.getName() == null ? (isReferenceField ? idFactory.newReferenceFieldIdentifier(mmd, storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(javaType, clr), m.getDataStoreMapping(i).getDatastoreField().getIdentifier(), storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(javaType), fieldRole) : idFactory.newJoinTableFieldIdentifier(mmd, (relatedMmds = mmd.getRelatedMemberMetaData(clr)) != null ? relatedMmds[0] : null, m.getDataStoreMapping(i).getDatastoreField().getIdentifier(), storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(javaType), fieldRole)) : idFactory.newDatastoreFieldIdentifier(colmd.getName());
                        DatastoreField column = table.addDatastoreField(javaType.getName(), identifier, refDatastoreMapping, (MetaData)colmd);
                        ((Column)m.getDataStoreMapping(i).getDatastoreField()).copyConfigurationTo(column);
                        if (isPrimaryKey) {
                            column.setAsPrimaryKey();
                        }
                        if (isNullable) {
                            column.setNullable();
                        }
                        storeMgr.getMappingManager().createDatastoreMapping(refDatastoreMapping, column, m.getDataStoreMapping(i).getJavaTypeMapping().getJavaTypeForDatastoreMapping(i));
                    }
                    catch (DuplicateDatastoreFieldException ex) {
                        throw new NucleusUserException("Cannot create column for field " + mmd.getFullFieldName() + " column metadata " + colmd, (Throwable)((Object)ex));
                    }
                    ((PersistenceCapableMapping)container).addJavaTypeMapping(refDatastoreMapping);
                }
            }
        } else {
            DatastoreField column = null;
            ColumnMetaData colmd = null;
            if (columnMetaData != null && columnMetaData.length > 0) {
                colmd = columnMetaData[0];
            }
            DatastoreIdentifier identifier = null;
            identifier = colmd != null && colmd.getName() != null ? idFactory.newDatastoreFieldIdentifier(colmd.getName()) : idFactory.newJoinTableFieldIdentifier(mmd, null, null, storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(javaType), fieldRole);
            column = table.addDatastoreField(javaType.getName(), identifier, mapping, (MetaData)colmd);
            storeMgr.getMappingManager().createDatastoreMapping(mapping, column, mapping.getJavaTypeForDatastoreMapping(0));
            if (isNullable) {
                column.setNullable();
            }
        }
        return mapping;
    }
}

