/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.util.StringTokenizer;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreFieldDefinitionException;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.exceptions.IncompatibleDataTypeException;
import org.datanucleus.store.rdbms.exceptions.WrongPrecisionException;
import org.datanucleus.store.rdbms.exceptions.WrongScaleException;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class Column
implements DatastoreField {
    private static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    private static final int PRIMARY_KEY_PART = 1;
    private static final int EXACT_PRECISION = 2;
    private static final int NULLABLE = 4;
    private static final int UNIQUE = 8;
    public static final int WRAPPER_FUNCTION_SELECT = 0;
    public static final int WRAPPER_FUNCTION_INSERT = 1;
    public static final int WRAPPER_FUNCTION_UPDATE = 2;
    protected DatastoreIdentifier identifier;
    protected ColumnMetaData columnMetaData;
    protected final DatastoreContainerObject table;
    protected DatastoreMapping datastoreMapping = null;
    protected final String storedJavaType;
    protected final MappedStoreManager storeMgr;
    protected SQLTypeInfo typeInfo;
    protected String constraints;
    protected int flags;
    protected Object defaultValue;
    protected boolean defaultable = false;
    protected boolean autoIncrement = false;
    protected String[] wrapperFunction;

    public Column(DatastoreContainerObject table, String javaType, DatastoreIdentifier identifier, ColumnMetaData colmd) {
        this.table = table;
        this.storedJavaType = javaType;
        this.storeMgr = table.getStoreManager();
        this.typeInfo = null;
        this.constraints = null;
        this.flags = 0;
        this.setIdentifier(identifier);
        this.columnMetaData = colmd == null ? new ColumnMetaData(null, (String)null) : colmd;
        if (this.columnMetaData.isAllowsNullSet() && this.columnMetaData.isAllowsNull()) {
            this.setNullable();
        }
        if (this.columnMetaData.getUnique()) {
            this.setUnique();
        }
        this.wrapperFunction = new String[3];
        this.wrapperFunction[0] = "?";
        this.wrapperFunction[1] = "?";
        this.wrapperFunction[2] = "?";
    }

    public boolean isUnlimitedLength() {
        if (this.columnMetaData.getJdbcType() != null && this.columnMetaData.getJdbcType().toLowerCase().indexOf("lob") > 0) {
            return true;
        }
        return this.columnMetaData.getSqlType() != null && this.columnMetaData.getSqlType().toLowerCase().indexOf("lob") > 0;
    }

    public DatastoreIdentifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(DatastoreIdentifier identifier) {
        this.identifier = identifier;
    }

    public DatastoreContainerObject getDatastoreContainerObject() {
        return this.table;
    }

    public DatastoreMapping getDatastoreMapping() {
        return this.datastoreMapping;
    }

    public void setDatastoreMapping(DatastoreMapping mapping) {
        this.datastoreMapping = mapping;
    }

    public JavaTypeMapping getMapping() {
        return this.datastoreMapping.getJavaTypeMapping();
    }

    public String getStoredJavaType() {
        return this.storedJavaType;
    }

    public final SQLTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public int getJdbcType() {
        return this.typeInfo.getDataType();
    }

    public MappedStoreManager getStoreManager() {
        return this.storeMgr;
    }

    private int getSQLPrecision() {
        int sqlPrecision = -1;
        if (this.isUnlimitedLength()) {
            int ulpv = ((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).getUnlimitedLengthPrecisionValue(this.typeInfo);
            if (ulpv > 0) {
                sqlPrecision = ulpv;
            }
        } else if (this.columnMetaData.getLength() != null) {
            sqlPrecision = this.columnMetaData.getLength();
        }
        if (this.typeInfo.getTypeName().toLowerCase().startsWith("bit")) {
            return sqlPrecision * 8;
        }
        return sqlPrecision;
    }

    public String getSQLDefinition() {
        StringBuffer def = new StringBuffer(((Object)this.identifier).toString());
        StringBuffer typeSpec = new StringBuffer(this.typeInfo.getTypeName());
        RDBMSAdapter adapter = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
        boolean specifyType = true;
        if (adapter.supportsOption("IdentityColumns") && this.autoIncrement && !adapter.supportsOption("AutoIncrementColumnTypeSpecification")) {
            specifyType = false;
        }
        if (specifyType) {
            if (this.typeInfo.getCreateParams() != null && this.typeInfo.getCreateParams().indexOf(40) >= 0 && this.typeInfo.getTypeName().indexOf(40) < 0) {
                StringTokenizer toks = new StringTokenizer(this.typeInfo.getCreateParams());
                while (toks.hasMoreTokens()) {
                    String tok = toks.nextToken();
                    if (tok.startsWith("[") && tok.endsWith("]")) continue;
                    typeSpec.append(" " + tok);
                }
            }
            StringBuffer precSpec = new StringBuffer();
            int sqlPrecision = this.getSQLPrecision();
            if (sqlPrecision > 0 && this.typeInfo.isAllowsPrecisionSpec()) {
                precSpec.append(sqlPrecision);
                if (this.columnMetaData.getScale() != null) {
                    precSpec.append("," + this.columnMetaData.getScale());
                }
            } else if (sqlPrecision > 0 && !this.typeInfo.isAllowsPrecisionSpec()) {
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER.msg("020183", (Object)this.toString()));
            }
            int lParenIdx = typeSpec.toString().indexOf(40);
            int rParenIdx = typeSpec.toString().indexOf(41, lParenIdx);
            if (lParenIdx > 0 && rParenIdx > 0) {
                if (precSpec.length() > 0) {
                    typeSpec.replace(lParenIdx + 1, rParenIdx, precSpec.toString());
                } else if (rParenIdx == lParenIdx + 1) {
                    throw new DatastoreFieldDefinitionException(LOCALISER.msg("020184", (Object)this.toString()));
                }
            } else if (precSpec.length() > 0) {
                typeSpec.append('(');
                typeSpec.append(precSpec.toString());
                typeSpec.append(')');
            }
            def.append(" " + typeSpec.toString());
        }
        if (adapter.supportsOption("ColumnOptions_DefaultBeforeNull") && adapter.supportsOption("ColumnOptions_DefaultKeyword") && this.columnMetaData.getDefaultValue() != null) {
            def.append(" ").append(this.getDefaultDefinition());
        }
        if (!adapter.supportsOption("IdentityColumns") || !this.autoIncrement || adapter.supportsOption("AutoIncrementNullSpecification")) {
            if (!this.isNullable()) {
                if (this.columnMetaData.getDefaultValue() == null || adapter.supportsOption("ColumnOptions_DefaultWithNotNull")) {
                    def.append(" NOT NULL");
                }
            } else if (this.typeInfo.getNullable() == 1 && adapter.supportsOption("ColumnOptions_NullsKeyword")) {
                def.append(" NULL");
            }
        }
        if (!adapter.supportsOption("ColumnOptions_DefaultBeforeNull") && adapter.supportsOption("ColumnOptions_DefaultKeyword") && this.columnMetaData.getDefaultValue() != null) {
            def.append(" ").append(this.getDefaultDefinition());
        }
        if (adapter.supportsOption("CheckInCreateStatements") && this.constraints != null) {
            def.append(" " + this.constraints.toString());
        }
        if (adapter.supportsOption("IdentityColumns") && this.autoIncrement) {
            def.append(" " + adapter.getAutoIncrementKeyword());
        }
        if (this.isUnique() && !adapter.supportsOption("UniqueInEndCreateStatements")) {
            def.append(" UNIQUE");
        }
        return def.toString();
    }

    private String getDefaultDefinition() {
        if (this.typeInfo.getTypeName().toUpperCase().indexOf("CHAR") >= 0 || this.typeInfo.getTypeName().toUpperCase().indexOf("LOB") >= 0) {
            return "DEFAULT '" + this.columnMetaData.getDefaultValue() + "'";
        }
        if (this.typeInfo.getTypeName().toUpperCase().indexOf("BIT") == 0 && (this.columnMetaData.getDefaultValue().equalsIgnoreCase("true") || this.columnMetaData.getDefaultValue().equalsIgnoreCase("false"))) {
            return "DEFAULT '" + this.columnMetaData.getDefaultValue() + "'";
        }
        return "DEFAULT " + this.columnMetaData.getDefaultValue();
    }

    public void initializeColumnInfoFromDatastore(RDBMSColumnInfo ci) {
        String column_default = ci.getColumnDef();
        if (this.getStoredJavaType() != null && this.getStoredJavaType().equals(ClassNameConstants.JAVA_LANG_STRING)) {
            if (column_default != null) {
                this.setDefaultValue(StringUtils.replaceAll((String)StringUtils.replaceAll((String)StringUtils.replaceAll((String)StringUtils.replaceAll((String)column_default, (String)"'", (String)""), (String)"\"", (String)""), (String)")", (String)""), (String)"(", (String)""));
            }
        } else if (column_default != null) {
            this.setDefaultValue(StringUtils.replaceAll((String)StringUtils.replaceAll((String)StringUtils.replaceAll((String)StringUtils.replaceAll((String)column_default, (String)"'", (String)""), (String)"\"", (String)""), (String)")", (String)""), (String)"(", (String)""));
        }
        try {
            this.autoIncrement = this.storeMgr.getDatastoreAdapter().isIdentityFieldDataType(ci.getColumnDef());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void validate(RDBMSColumnInfo ci) {
        if (!this.typeInfo.isCompatibleWith(ci)) {
            throw new IncompatibleDataTypeException(this, this.typeInfo.getDataType(), ci.getDataType());
        }
        if (ci.getDataType() == 1111) {
            return;
        }
        if (this.table instanceof TableImpl) {
            String actualIsNullable;
            if (this.typeInfo.isAllowsPrecisionSpec()) {
                int actualPrecision = ci.getColumnSize();
                int actualScale = ci.getDecimalDigits();
                int sqlPrecision = this.getSQLPrecision();
                if (sqlPrecision > 0 && actualPrecision > 0 && sqlPrecision != actualPrecision) {
                    if (this.columnMetaData != null && this.columnMetaData.getParent() != null && this.columnMetaData.getParent() instanceof AbstractMemberMetaData) {
                        throw new WrongPrecisionException(this.toString(), sqlPrecision, actualPrecision, ((AbstractMemberMetaData)this.columnMetaData.getParent()).getFullFieldName());
                    }
                    throw new WrongPrecisionException(this.toString(), sqlPrecision, actualPrecision);
                }
                if (this.columnMetaData.getScale() != null && actualScale >= 0 && this.columnMetaData.getScale() != actualScale) {
                    if (this.columnMetaData != null && this.columnMetaData.getParent() != null && this.columnMetaData.getParent() instanceof AbstractMemberMetaData) {
                        throw new WrongScaleException(this.toString(), this.columnMetaData.getScale(), actualScale, ((AbstractMemberMetaData)this.columnMetaData.getParent()).getFullFieldName());
                    }
                    throw new WrongScaleException(this.toString(), this.columnMetaData.getScale(), actualScale);
                }
            }
            if ((actualIsNullable = ci.getIsNullable()).length() > 0) {
                switch (Character.toUpperCase(actualIsNullable.charAt(0))) {
                    case 'Y': {
                        if (this.isNullable()) break;
                        NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("020025", (Object)this));
                        break;
                    }
                    case 'N': {
                        break;
                    }
                }
            }
            try {
                if (this.isAutoIncrement() != this.storeMgr.getDatastoreAdapter().isIdentityFieldDataType(ci.getColumnDef())) {
                    if (this.isAutoIncrement()) {
                        throw new NucleusException("Expected an auto increment column (" + this.getIdentifier() + ") in the database, but it is not").setFatal();
                    }
                    throw new NucleusException("According to the user metadata, the column (" + this.getIdentifier() + ") is not auto incremented, but the database says it is.").setFatal();
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    public final Column setTypeInfo(SQLTypeInfo typeInfo) {
        if (this.typeInfo == null) {
            this.typeInfo = typeInfo;
        }
        return this;
    }

    public final Column setConstraints(String constraints) {
        this.constraints = constraints;
        return this;
    }

    public final void setAsPrimaryKey() {
        this.flags |= 1;
        this.flags &= 0xFFFFFFFB;
    }

    public final DatastoreField setNullable() {
        this.flags |= 4;
        return this;
    }

    public final DatastoreField setDefaultable() {
        this.defaultable = true;
        return this;
    }

    public final Column setUnique() {
        this.flags |= 8;
        return this;
    }

    public final boolean isPrimaryKey() {
        return (this.flags & 1) != 0;
    }

    public final boolean isExactPrecision() {
        return (this.flags & 2) != 0;
    }

    public final boolean isNullable() {
        return (this.flags & 4) != 0;
    }

    public final boolean isDefaultable() {
        return this.defaultable;
    }

    public final boolean isUnique() {
        return (this.flags & 8) != 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Column)) {
            return false;
        }
        Column col = (Column)obj;
        return this.table.equals(col.table) && this.identifier.equals(col.identifier);
    }

    public int hashCode() {
        return this.table.hashCode() ^ this.identifier.hashCode();
    }

    public String toString() {
        return this.table.toString() + "." + this.identifier;
    }

    public String applySelectFunction(String replacementValue) {
        if (replacementValue == null) {
            return this.wrapperFunction[0];
        }
        if (this.wrapperFunction[0] != null) {
            return StringUtils.replaceAll((String)this.wrapperFunction[0], (String)"?", (String)replacementValue);
        }
        return replacementValue;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public final ColumnMetaData getColumnMetaData() {
        return this.columnMetaData;
    }

    public MetaData getMetaData() {
        return this.columnMetaData;
    }

    public AbstractMemberMetaData getFieldMetaData() {
        if (this.columnMetaData != null && this.columnMetaData.getParent() instanceof AbstractMemberMetaData) {
            return (AbstractMemberMetaData)this.columnMetaData.getParent();
        }
        return null;
    }

    public void setMetaData(MetaData md) {
        if (md == null) {
            return;
        }
        ColumnMetaData colmd = (ColumnMetaData)md;
        if (colmd.getJdbcType() != null) {
            this.columnMetaData.setJdbcType(colmd.getJdbcType());
        }
        if (colmd.getSqlType() != null) {
            this.columnMetaData.setSqlType(colmd.getSqlType());
        }
        if (colmd.getName() != null) {
            this.columnMetaData.setName(colmd.getName());
        }
        if (colmd.isAllowsNullSet()) {
            this.columnMetaData.setAllowsNull(new Boolean(colmd.isAllowsNull()));
        }
        if (colmd.getLength() != null) {
            this.columnMetaData.setLength(colmd.getLength());
        }
        if (colmd.getScale() != null) {
            this.columnMetaData.setScale(colmd.getScale());
        }
        if (colmd.isAllowsNullSet() && colmd.isAllowsNull()) {
            this.setNullable();
        }
        if (colmd.getUnique()) {
            this.setUnique();
        }
    }

    public String getConstraints() {
        return this.constraints;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean auto_increment) {
        this.autoIncrement = auto_increment;
    }

    public final void checkPrimitive() throws DatastoreFieldDefinitionException {
    }

    public final void checkInteger() throws DatastoreFieldDefinitionException {
    }

    public final void checkDecimal() throws DatastoreFieldDefinitionException {
    }

    public final void checkString() throws DatastoreFieldDefinitionException {
        if (this.columnMetaData.getJdbcType() == null) {
            this.columnMetaData.setJdbcType("VARCHAR");
        }
        if (this.columnMetaData.getLength() == null) {
            this.columnMetaData.setLength(this.storeMgr.getOMFContext().getPersistenceConfiguration().getIntProperty("datanucleus.rdbms.stringDefaultLength"));
        }
    }

    public void copyConfigurationTo(DatastoreField field) {
        Column col = (Column)field;
        col.typeInfo = this.typeInfo;
        col.flags |= this.flags;
        col.flags &= 0xFFFFFFFE;
        col.flags &= 0xFFFFFFF7;
        col.flags &= 0xFFFFFFFB;
        col.defaultValue = this.defaultValue;
        col.wrapperFunction = this.wrapperFunction;
        if (this.columnMetaData.getJdbcType() != null) {
            col.columnMetaData.setJdbcType(this.columnMetaData.getJdbcType());
        }
        if (this.columnMetaData.getSqlType() != null) {
            col.columnMetaData.setSqlType(this.columnMetaData.getSqlType());
        }
        if (this.columnMetaData.getLength() != null) {
            col.getColumnMetaData().setLength(this.columnMetaData.getLength());
        }
        if (this.columnMetaData.getScale() != null) {
            col.getColumnMetaData().setScale(this.getColumnMetaData().getScale());
        }
    }

    public void setWrapperFunction(String wrapperFunction, int wrapperMode) {
        if (wrapperFunction != null && wrapperMode == 0 && wrapperFunction.indexOf("?") < 0) {
            throw new NucleusUserException("Wrapping function must have one ? (question mark). e.g. SQRT(?)");
        }
        this.wrapperFunction[wrapperMode] = wrapperFunction;
    }

    public String getWrapperFunction(int wrapperMode) {
        return this.wrapperFunction[wrapperMode];
    }
}

