/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sqlidentifier;

import java.util.Map;
import java.util.WeakHashMap;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.exceptions.TooManyForeignKeysException;
import org.datanucleus.store.rdbms.exceptions.TooManyIndicesException;
import org.datanucleus.store.rdbms.sqlidentifier.CandidateKeyIdentifier;
import org.datanucleus.store.rdbms.sqlidentifier.ColumnIdentifier;
import org.datanucleus.store.rdbms.sqlidentifier.ForeignKeyIdentifier;
import org.datanucleus.store.rdbms.sqlidentifier.IndexIdentifier;
import org.datanucleus.store.rdbms.sqlidentifier.PrimaryKeyIdentifier;
import org.datanucleus.store.rdbms.sqlidentifier.RDBMSIdentifierFactory;
import org.datanucleus.store.rdbms.sqlidentifier.SQLIdentifier;
import org.datanucleus.store.rdbms.sqlidentifier.SequenceIdentifier;
import org.datanucleus.store.rdbms.sqlidentifier.TableIdentifier;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractRDBMSIdentifierFactory
implements RDBMSIdentifierFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    public static final int CASE_PRESERVE = 1;
    public static final int CASE_UPPER = 2;
    public static final int CASE_LOWER = 3;
    protected DatastoreAdapter dba;
    protected int identifierCase;
    protected String quoteString;
    private static final int HASH_LENGTH = 4;
    private static final int HASH_RANGE = AbstractRDBMSIdentifierFactory.calculateHashMax();
    protected Map<String, DatastoreIdentifier> tables = new WeakHashMap<String, DatastoreIdentifier>();
    protected Map<String, DatastoreIdentifier> columns = new WeakHashMap<String, DatastoreIdentifier>();
    protected Map<String, DatastoreIdentifier> foreignkeys = new WeakHashMap<String, DatastoreIdentifier>();
    protected Map<String, DatastoreIdentifier> indexes = new WeakHashMap<String, DatastoreIdentifier>();
    protected Map<String, DatastoreIdentifier> candidates = new WeakHashMap<String, DatastoreIdentifier>();
    protected Map<String, DatastoreIdentifier> primarykeys = new WeakHashMap<String, DatastoreIdentifier>();
    protected Map<String, DatastoreIdentifier> sequences = new WeakHashMap<String, DatastoreIdentifier>();
    protected Map<String, DatastoreIdentifier> references = new WeakHashMap<String, DatastoreIdentifier>();
    protected String wordSeparator = "_";
    protected RDBMSAdapter rdba = null;
    protected String defaultCatalogName = null;
    protected String defaultSchemaName = null;

    private static final int calculateHashMax() {
        int hm = 1;
        for (int i = 0; i < 4; ++i) {
            hm *= 36;
        }
        return hm;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractRDBMSIdentifierFactory(DatastoreAdapter dba, String requiredCase, String defaultCatalog, String defaultSchema) {
        this.dba = dba;
        this.quoteString = dba.getIdentifierQuoteString();
        int userIdentifierCase = 2;
        if (requiredCase.equalsIgnoreCase("UpperCase")) {
            userIdentifierCase = 2;
        } else if (requiredCase.equalsIgnoreCase("LowerCase")) {
            userIdentifierCase = 3;
        } else if (requiredCase.equalsIgnoreCase("PreserveCase")) {
            userIdentifierCase = 1;
        }
        if (userIdentifierCase == 2) {
            if (dba.supportsOption("UpperCaseIdentifiers")) {
                this.identifierCase = 0;
            } else if (dba.supportsOption("UpperCaseQuotedIdentifiers")) {
                this.identifierCase = 1;
            } else if (dba.supportsOption("MixedCaseIdentifiers") || dba.supportsOption("MixedCaseSensitiveIdentifiers")) {
                this.identifierCase = 0;
            } else if (dba.supportsOption("MixedCaseQuotedIdentifiers") || dba.supportsOption("MixedCaseQuotedSensitiveIdentifiers")) {
                this.identifierCase = 1;
            } else if (dba.supportsOption("LowerCaseIdentifiers")) {
                this.identifierCase = 2;
                NucleusLogger.PERSISTENCE.warn((Object)LOCALISER.msg("039001", (Object)"UPPERCASE", (Object)"LOWERCASE"));
            } else {
                if (!dba.supportsOption("LowerCaseQuotedIdentifiers")) throw new NucleusUserException(LOCALISER.msg("039002", (Object)"UPPERCASE")).setFatal();
                this.identifierCase = 3;
                NucleusLogger.PERSISTENCE.warn((Object)LOCALISER.msg("039001", (Object)"UPPERCASE", (Object)"LOWERCASEQUOTED"));
            }
        } else if (userIdentifierCase == 3) {
            if (dba.supportsOption("LowerCaseIdentifiers")) {
                this.identifierCase = 2;
            } else if (dba.supportsOption("LowerCaseQuotedIdentifiers")) {
                this.identifierCase = 3;
            } else if (dba.supportsOption("MixedCaseIdentifiers") || dba.supportsOption("MixedCaseSensitiveIdentifiers")) {
                this.identifierCase = 2;
            } else if (dba.supportsOption("MixedCaseQuotedIdentifiers") || dba.supportsOption("MixedCaseQuotedSensitiveIdentifiers")) {
                this.identifierCase = 3;
            } else if (dba.supportsOption("UpperCaseIdentifiers")) {
                this.identifierCase = 0;
                NucleusLogger.PERSISTENCE.warn((Object)LOCALISER.msg("039001", (Object)"LOWERCASE", (Object)"UPPERCASE"));
            } else {
                if (!dba.supportsOption("UpperCaseQuotedIdentifiers")) throw new NucleusUserException(LOCALISER.msg("039002", (Object)"LOWERCASE")).setFatal();
                this.identifierCase = 1;
                NucleusLogger.PERSISTENCE.warn((Object)LOCALISER.msg("039001", (Object)"LOWERCASE", (Object)"UPPERCASEQUOTED"));
            }
        } else {
            if (userIdentifierCase != 1) throw new NucleusUserException(LOCALISER.msg("039000", (long)userIdentifierCase)).setFatal();
            if (dba.supportsOption("MixedCaseIdentifiers") || dba.supportsOption("MixedCaseSensitiveIdentifiers")) {
                this.identifierCase = 4;
            } else if (dba.supportsOption("MixedCaseQuotedIdentifiers") || dba.supportsOption("MixedCaseQuotedSensitiveIdentifiers")) {
                this.identifierCase = 5;
            } else if (dba.supportsOption("LowerCaseIdentifiers")) {
                this.identifierCase = 2;
                NucleusLogger.PERSISTENCE.warn((Object)LOCALISER.msg("039001", (Object)"MIXEDCASE", (Object)"LOWERCASE"));
            } else if (dba.supportsOption("LowerCaseQuotedIdentifiers")) {
                this.identifierCase = 3;
                NucleusLogger.PERSISTENCE.warn((Object)LOCALISER.msg("039001", (Object)"MIXEDCASE", (Object)"LOWERCASEQUOTED"));
            } else if (dba.supportsOption("UpperCaseIdentifiers")) {
                this.identifierCase = 0;
                NucleusLogger.PERSISTENCE.warn((Object)LOCALISER.msg("039001", (Object)"MIXEDCASE", (Object)"UPPERCASE"));
            } else {
                if (!dba.supportsOption("UpperCaseQuotedIdentifiers")) throw new NucleusUserException(LOCALISER.msg("039002", (Object)"MIXEDCASE")).setFatal();
                this.identifierCase = 1;
                NucleusLogger.PERSISTENCE.warn((Object)LOCALISER.msg("039001", (Object)"MIXEDCASE", (Object)"UPPERCASEQUOTED"));
            }
        }
        this.rdba = (RDBMSAdapter)dba;
        if (defaultCatalog != null) {
            this.defaultCatalogName = this.getIdentifierInAdapterCase(defaultCatalog);
        }
        if (defaultSchema == null) return;
        this.defaultSchemaName = this.getIdentifierInAdapterCase(defaultSchema);
    }

    public DatastoreAdapter getDatastoreAdapter() {
        return this.dba;
    }

    public int getIdentifierCase() {
        return this.identifierCase;
    }

    public String getNameOfIdentifierCase() {
        if (this.identifierCase == 2) {
            return "lowercase";
        }
        if (this.identifierCase == 3) {
            return "\"lowercase\"";
        }
        if (this.identifierCase == 4) {
            return "\"MixedCase\"";
        }
        if (this.identifierCase == 5) {
            return "\"MixedCase\"";
        }
        if (this.identifierCase == 0) {
            return "UPPERCASE";
        }
        if (this.identifierCase == 1) {
            return "\"UPPERCASE\"";
        }
        return "UNKNOWN";
    }

    protected static String truncate(String identifier, int length) {
        if (length == 0) {
            return identifier;
        }
        if (identifier.length() > length) {
            String suffix;
            if (length < 4) {
                throw new IllegalArgumentException("The length argument (=" + length + ") is less than HASH_LENGTH(=" + 4 + ")!");
            }
            int tailIndex = length - 4;
            int tailHash = identifier.hashCode();
            if (tailHash < 0) {
                tailHash *= -1;
            }
            if ((suffix = Integer.toString(tailHash %= HASH_RANGE, 36)).length() > 4) {
                throw new IllegalStateException("Calculated hash \"" + suffix + "\" has more characters than defined by HASH_LENGTH (=" + 4 + ")! This should never happen!");
            }
            if (suffix.length() < 4) {
                StringBuilder sb = new StringBuilder(4);
                sb.append(suffix);
                while (sb.length() < 4) {
                    sb.insert(0, '0');
                }
                suffix = sb.toString();
            }
            return identifier.substring(0, tailIndex) + suffix;
        }
        return identifier;
    }

    public String getWordSeparator() {
        return this.wordSeparator;
    }

    public String getIdentifierInAdapterCase(String identifier) {
        if (identifier == null) {
            return null;
        }
        StringBuffer id = new StringBuffer();
        if (!(this.identifierCase != 3 && this.identifierCase != 5 && this.identifierCase != 1 || identifier.startsWith(this.quoteString))) {
            id.append(this.quoteString);
        }
        if (this.identifierCase == 2 || this.identifierCase == 3) {
            id.append(identifier.toLowerCase());
        } else if (this.identifierCase == 0 || this.identifierCase == 1) {
            id.append(identifier.toUpperCase());
        } else {
            id.append(identifier);
        }
        if (!(this.identifierCase != 3 && this.identifierCase != 5 && this.identifierCase != 1 || identifier.endsWith(this.quoteString))) {
            id.append(this.quoteString);
        }
        return id.toString();
    }

    public DatastoreIdentifier newIdentifier(int identifierType, String name) {
        DatastoreIdentifier identifier = null;
        String key = StringUtils.replaceAll((String)name, (String)this.quoteString, (String)"");
        if (identifierType == 0) {
            identifier = this.tables.get(key);
            if (identifier == null) {
                String sqlIdentifier = this.generateIdentifierNameForJavaName(key);
                sqlIdentifier = AbstractRDBMSIdentifierFactory.truncate(sqlIdentifier, this.getMaxLengthForIdentifierType(identifierType));
                identifier = new TableIdentifier(this, sqlIdentifier);
                this.setCatalogSchemaForTable((TableIdentifier)identifier);
                this.tables.put(key, identifier);
            }
        } else if (identifierType == 1) {
            identifier = this.columns.get(key);
            if (identifier == null) {
                String sqlIdentifier = this.generateIdentifierNameForJavaName(key);
                sqlIdentifier = AbstractRDBMSIdentifierFactory.truncate(sqlIdentifier, this.getMaxLengthForIdentifierType(identifierType));
                identifier = new ColumnIdentifier(this, sqlIdentifier);
                this.columns.put(key, identifier);
            }
        } else if (identifierType == 2) {
            identifier = this.foreignkeys.get(key);
            if (identifier == null) {
                String sqlIdentifier = this.generateIdentifierNameForJavaName(key);
                sqlIdentifier = AbstractRDBMSIdentifierFactory.truncate(sqlIdentifier, this.getMaxLengthForIdentifierType(identifierType));
                identifier = new ForeignKeyIdentifier(this, sqlIdentifier);
                this.foreignkeys.put(key, identifier);
            }
        } else if (identifierType == 3) {
            identifier = this.indexes.get(key);
            if (identifier == null) {
                String sqlIdentifier = this.generateIdentifierNameForJavaName(key);
                sqlIdentifier = AbstractRDBMSIdentifierFactory.truncate(sqlIdentifier, this.getMaxLengthForIdentifierType(identifierType));
                identifier = new IndexIdentifier(this, sqlIdentifier);
                this.indexes.put(key, identifier);
            }
        } else if (identifierType == 4) {
            identifier = this.candidates.get(key);
            if (identifier == null) {
                String sqlIdentifier = this.generateIdentifierNameForJavaName(key);
                sqlIdentifier = AbstractRDBMSIdentifierFactory.truncate(sqlIdentifier, this.getMaxLengthForIdentifierType(identifierType));
                identifier = new CandidateKeyIdentifier(this, sqlIdentifier);
                this.candidates.put(key, identifier);
            }
        } else if (identifierType == 5) {
            identifier = this.primarykeys.get(key);
            if (identifier == null) {
                String sqlIdentifier = this.generateIdentifierNameForJavaName(key);
                sqlIdentifier = AbstractRDBMSIdentifierFactory.truncate(sqlIdentifier, this.getMaxLengthForIdentifierType(identifierType));
                identifier = new PrimaryKeyIdentifier(this, sqlIdentifier);
                this.primarykeys.put(key, identifier);
            }
        } else if (identifierType == 6) {
            identifier = this.sequences.get(key);
            if (identifier == null) {
                String sqlIdentifier = this.generateIdentifierNameForJavaName(key);
                sqlIdentifier = AbstractRDBMSIdentifierFactory.truncate(sqlIdentifier, this.getMaxLengthForIdentifierType(identifierType));
                identifier = new SequenceIdentifier(this, sqlIdentifier);
                this.sequences.put(key, identifier);
            }
        } else {
            throw new NucleusException("identifier type " + identifierType + " not supported by this factory method").setFatal();
        }
        return identifier;
    }

    public DatastoreIdentifier newIdentifier(DatastoreIdentifier identifier, String suffix) {
        String newId = identifier.getIdentifier() + this.getWordSeparator() + suffix;
        if (identifier instanceof TableIdentifier) {
            newId = AbstractRDBMSIdentifierFactory.truncate(newId, this.getMaxLengthForIdentifierType(0));
            TableIdentifier tableIdentifier = new TableIdentifier(this, newId);
            this.setCatalogSchemaForTable(tableIdentifier);
            return tableIdentifier;
        }
        if (identifier instanceof ColumnIdentifier) {
            newId = AbstractRDBMSIdentifierFactory.truncate(newId, this.getMaxLengthForIdentifierType(1));
            return new ColumnIdentifier(this, newId);
        }
        if (identifier instanceof ForeignKeyIdentifier) {
            newId = AbstractRDBMSIdentifierFactory.truncate(newId, this.getMaxLengthForIdentifierType(2));
            return new ForeignKeyIdentifier(this, newId);
        }
        if (identifier instanceof IndexIdentifier) {
            newId = AbstractRDBMSIdentifierFactory.truncate(newId, this.getMaxLengthForIdentifierType(3));
            return new IndexIdentifier(this, newId);
        }
        if (identifier instanceof CandidateKeyIdentifier) {
            newId = AbstractRDBMSIdentifierFactory.truncate(newId, this.getMaxLengthForIdentifierType(4));
            return new CandidateKeyIdentifier(this, newId);
        }
        if (identifier instanceof PrimaryKeyIdentifier) {
            newId = AbstractRDBMSIdentifierFactory.truncate(newId, this.getMaxLengthForIdentifierType(5));
            return new PrimaryKeyIdentifier(this, newId);
        }
        if (identifier instanceof SequenceIdentifier) {
            newId = AbstractRDBMSIdentifierFactory.truncate(newId, this.getMaxLengthForIdentifierType(6));
            return new SequenceIdentifier(this, newId);
        }
        return null;
    }

    public DatastoreIdentifier newDatastoreContainerIdentifier(String identifierName) {
        String key = StringUtils.replaceAll((String)identifierName, (String)this.quoteString, (String)"");
        DatastoreIdentifier identifier = this.tables.get(key);
        if (identifier == null) {
            String baseID = AbstractRDBMSIdentifierFactory.truncate(key, this.getMaxLengthForIdentifierType(0));
            identifier = new TableIdentifier(this, baseID);
            this.setCatalogSchemaForTable((TableIdentifier)identifier);
            this.tables.put(key, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newDatastoreFieldIdentifier(String identifierName) {
        String key = StringUtils.replaceAll((String)identifierName, (String)this.quoteString, (String)"");
        DatastoreIdentifier identifier = this.columns.get(key);
        if (identifier == null) {
            String baseID = AbstractRDBMSIdentifierFactory.truncate(key, this.getMaxLengthForIdentifierType(1));
            identifier = new ColumnIdentifier(this, baseID);
            this.columns.put(key, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newDatastoreFieldIdentifier(String javaName, boolean embedded, int fieldRole) {
        DatastoreIdentifier identifier = null;
        String key = "[" + (javaName == null ? "" : javaName) + "][" + embedded + "][" + fieldRole;
        identifier = this.columns.get(key);
        if (identifier == null) {
            if (fieldRole == -1) {
                String baseID = AbstractRDBMSIdentifierFactory.truncate(javaName, this.getMaxLengthForIdentifierType(1));
                identifier = new ColumnIdentifier(this, baseID);
            } else {
                String suffix = this.getColumnIdentifierSuffix(fieldRole, embedded);
                String datastoreID = this.generateIdentifierNameForJavaName(javaName);
                String baseID = AbstractRDBMSIdentifierFactory.truncate(datastoreID, this.getMaxLengthForIdentifierType(1) - suffix.length());
                identifier = new ColumnIdentifier(this, baseID + suffix);
            }
            this.columns.put(key, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newSequenceIdentifier(String sequenceName) {
        String key = sequenceName;
        DatastoreIdentifier identifier = this.sequences.get(key);
        if (identifier == null) {
            String baseID = AbstractRDBMSIdentifierFactory.truncate(sequenceName, this.getMaxLengthForIdentifierType(6));
            identifier = new ColumnIdentifier(this, baseID);
            this.sequences.put(key, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newPrimaryKeyIdentifier(DatastoreContainerObject table) {
        DatastoreIdentifier identifier = null;
        String key = ((Object)table.getIdentifier()).toString();
        identifier = this.primarykeys.get(key);
        if (identifier == null) {
            String suffix = this.getWordSeparator() + "PK";
            int maxLength = this.getMaxLengthForIdentifierType(5);
            String baseID = AbstractRDBMSIdentifierFactory.truncate(((SQLIdentifier)table.getIdentifier()).getIdentifier(), maxLength - suffix.length());
            identifier = new PrimaryKeyIdentifier(this, baseID + suffix);
            this.primarykeys.put(key, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newCandidateKeyIdentifier(DatastoreContainerObject table, int seq) {
        DatastoreIdentifier identifier = null;
        String key = "[" + ((Object)table.getIdentifier()).toString() + "][" + seq + "]";
        identifier = this.candidates.get(key);
        if (identifier == null) {
            String suffix = this.getWordSeparator() + "U" + seq;
            int maxLength = this.getMaxLengthForIdentifierType(4);
            String baseID = AbstractRDBMSIdentifierFactory.truncate(((SQLIdentifier)table.getIdentifier()).getIdentifier(), maxLength - suffix.length());
            identifier = new CandidateKeyIdentifier(this, baseID + suffix);
            this.candidates.put(key, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newForeignKeyIdentifier(DatastoreContainerObject table, int seq) {
        DatastoreIdentifier identifier = null;
        String key = "[" + ((Object)table.getIdentifier()).toString() + "][" + seq + "]";
        identifier = this.foreignkeys.get(key);
        if (identifier == null) {
            String suffix = this.getWordSeparator() + "FK";
            if (seq < 10) {
                suffix = suffix + "" + (char)(48 + seq);
            } else if (seq < this.rdba.getMaxForeignKeys()) {
                suffix = suffix + Integer.toHexString(65 + seq);
            } else {
                throw new TooManyForeignKeysException(this.rdba, table.toString());
            }
            int maxLength = this.getMaxLengthForIdentifierType(2);
            String baseID = AbstractRDBMSIdentifierFactory.truncate(((SQLIdentifier)table.getIdentifier()).getIdentifier(), maxLength - suffix.length());
            identifier = new ForeignKeyIdentifier(this, baseID + suffix);
            this.foreignkeys.put(key, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newIndexIdentifier(DatastoreContainerObject table, boolean isUnique, int seq) {
        DatastoreIdentifier identifier = null;
        String key = "[" + ((Object)table.getIdentifier()).toString() + "][" + isUnique + "][" + seq + "]";
        identifier = this.indexes.get(key);
        if (identifier == null) {
            String suffix = this.getWordSeparator() + (isUnique ? "U" : "N");
            if (seq >= this.rdba.getMaxIndexes()) {
                throw new TooManyIndicesException(this.rdba, table.toString());
            }
            suffix = suffix + String.valueOf(48 + seq);
            int maxLength = this.getMaxLengthForIdentifierType(3);
            String baseID = AbstractRDBMSIdentifierFactory.truncate(((SQLIdentifier)table.getIdentifier()).getIdentifier(), maxLength - suffix.length());
            identifier = new IndexIdentifier(this, baseID + suffix);
            this.indexes.put(key, identifier);
        }
        return identifier;
    }

    protected abstract String getColumnIdentifierSuffix(int var1, boolean var2);

    protected abstract String generateIdentifierNameForJavaName(String var1);

    protected void setCatalogSchemaForTable(TableIdentifier identifier) {
        String catalogName = identifier.getCatalogName();
        String schemaName = identifier.getSchemaName();
        if (schemaName == null && catalogName == null) {
            if (this.rdba.supportsOption("CatalogInTableDefinition")) {
                identifier.setCatalogName(this.defaultCatalogName);
            }
            if (this.rdba.supportsOption("SchemaInTableDefinition")) {
                identifier.setSchemaName(this.defaultSchemaName);
            }
        }
    }

    protected String[] getIdentifierNamePartsFromName(String name) {
        if (name != null) {
            String[] names = new String[3];
            if (name.indexOf(46) < 0) {
                names[0] = null;
                names[1] = null;
                names[2] = name;
            } else {
                String[] specifiedNameParts = StringUtils.split((String)name, (String)".");
                int currentPartIndex = specifiedNameParts.length - 1;
                names[2] = specifiedNameParts[currentPartIndex--];
                if (this.rdba.supportsOption("SchemaInTableDefinition") && currentPartIndex >= 0) {
                    names[1] = specifiedNameParts[currentPartIndex--];
                }
                if (this.rdba.supportsOption("CatalogInTableDefinition") && currentPartIndex >= 0) {
                    names[0] = specifiedNameParts[currentPartIndex--];
                }
            }
            return names;
        }
        return null;
    }

    protected int getMaxLengthForIdentifierType(int identifierType) {
        if (identifierType == 0) {
            return this.rdba.getMaxTableNameLength();
        }
        if (identifierType == 1) {
            return this.rdba.getMaxColumnNameLength();
        }
        if (identifierType == 2) {
            return this.rdba.getMaxConstraintNameLength();
        }
        if (identifierType == 3) {
            return this.rdba.getMaxConstraintNameLength();
        }
        if (identifierType == 4) {
            return this.rdba.getMaxConstraintNameLength();
        }
        if (identifierType == 5) {
            return this.rdba.getMaxConstraintNameLength();
        }
        if (identifierType == 6) {
            return this.rdba.getMaxTableNameLength();
        }
        return -1;
    }
}

