/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;

public class CollectionLiteral
extends SQLExpression
implements SQLLiteral {
    private final Collection value;
    private final boolean isEmpty;
    private final boolean containsNull;
    private List scalarExpressions;

    public CollectionLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
        super(stmt, null, mapping);
        if (value instanceof Collection) {
            Collection collValue;
            this.value = collValue = (Collection)value;
            this.containsNull = collValue != null && collValue.contains(null);
            boolean bl = this.isEmpty = collValue == null || collValue.isEmpty() || collValue.size() == 1 && this.containsNull;
            if (!this.isEmpty) {
                RDBMSManager storeMgr = stmt.getRDBMSManager();
                DatastoreAdapter dba = storeMgr.getDatastoreAdapter();
                this.scalarExpressions = new ArrayList();
                this.st.append("(");
                boolean hadPrev = false;
                for (Object current : collValue) {
                    if (current == null) continue;
                    JavaTypeMapping m = dba.getMapping(current.getClass(), storeMgr, storeMgr.getOMFContext().getClassLoaderResolver(null));
                    SQLExpression expr = storeMgr.getSQLExpressionFactory().newLiteral(stmt, m, current);
                    this.st.append(hadPrev ? "," : "");
                    this.st.append(expr);
                    this.scalarExpressions.add(expr);
                    hadPrev = true;
                }
                this.st.append(")");
            }
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
    }

    public SQLExpression invoke(String methodName, List args) {
        if (methodName.equals("isEmpty") && args.size() == 0) {
            return new BooleanLiteral(this.stmt, this.mapping, this.isEmpty);
        }
        if (methodName.equals("size")) {
            DatastoreAdapter dba = this.stmt.getRDBMSManager().getDatastoreAdapter();
            JavaTypeMapping m = dba.getMapping(Integer.class, this.stmt.getRDBMSManager());
            return new IntegerLiteral(this.stmt, m, new Integer(this.value.size()));
        }
        if (methodName.equals("contains") && args.size() == 1) {
            if (this.isEmpty) {
                return new BooleanLiteral(this.stmt, this.mapping, Boolean.FALSE);
            }
            SQLExpression argExpr = (SQLExpression)args.get(0);
            SQLExpression bExpr = null;
            for (int i = 0; i < this.scalarExpressions.size(); ++i) {
                bExpr = bExpr == null ? ((SQLExpression)this.scalarExpressions.get(i)).eq(argExpr) : ((BooleanExpression)bExpr).ior(((SQLExpression)this.scalarExpressions.get(i)).eq(argExpr));
            }
            bExpr.encloseInParentheses();
            return bExpr;
        }
        return super.invoke(methodName, args);
    }

    public Object getValue() {
        return this.value;
    }

    public Object getRawValue() {
        return null;
    }

    public void setRawValue(Object val) {
    }
}

