/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ObjectManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;

public class SQLText {
    private StringBuffer sql;
    private List<Parameter> parameters = null;
    private boolean encloseInParentheses = false;
    private String postpend;
    private List appended = new ArrayList();

    public SQLText() {
    }

    public SQLText(String initialStatementText) {
        this();
        this.append(initialStatementText);
    }

    public void clearStatement() {
        this.sql = null;
        this.appended.clear();
    }

    public void encloseInParentheses() {
        this.sql = null;
        this.encloseInParentheses = true;
    }

    public SQLText postpend(String s) {
        this.sql = null;
        this.postpend = s;
        return this;
    }

    public SQLText append(char c) {
        this.sql = null;
        this.appended.add(new Character(c));
        return this;
    }

    public SQLText append(String s) {
        this.sql = null;
        this.appended.add(s);
        return this;
    }

    public SQLText append(SQLStatement stmt) {
        this.sql = null;
        this.appended.add(stmt);
        return this;
    }

    public SQLText append(SQLText st, int mode) {
        this.sql = null;
        this.appended.add(st.toSQL(mode));
        if (st.parameters != null) {
            if (this.parameters == null) {
                this.parameters = new ArrayList<Parameter>();
            }
            this.parameters.addAll(st.parameters);
        }
        return this;
    }

    public SQLText append(SQLExpression expr) {
        this.sql = null;
        this.appended.add(expr);
        return this;
    }

    public SQLText appendParameter(JavaTypeMapping mapping, Object value) {
        this.sql = null;
        this.appended.add(new Parameter(mapping, value));
        return this;
    }

    public void applyParametersToStatement(ObjectManager om, PreparedStatement ps) {
        if (this.parameters != null) {
            int num = 1;
            for (Parameter param : this.parameters) {
                JavaTypeMapping mapping = param.mapping;
                Object value = param.value;
                mapping.setObject(om, ps, Mappings.getParametersIndex(num, mapping), value);
                if (mapping.getNumberOfDatastoreFields() > 0) {
                    num += mapping.getNumberOfDatastoreFields();
                    continue;
                }
                ++num;
            }
        }
    }

    public String toSQL(int mode) {
        if (this.sql == null) {
            this.sql = new StringBuffer();
            if (this.encloseInParentheses) {
                this.sql.append("(");
            }
            for (int i = 0; i < this.appended.size(); ++i) {
                SQLText st;
                Object item = this.appended.get(i);
                if (item instanceof SQLExpression) {
                    SQLExpression expr = (SQLExpression)item;
                    st = expr.toSQL(mode);
                    this.sql.append(st.toSQL(mode));
                    if (st.parameters == null) continue;
                    if (this.parameters == null) {
                        this.parameters = new ArrayList<Parameter>();
                    }
                    this.parameters.addAll(st.parameters);
                    continue;
                }
                if (item instanceof Parameter) {
                    Parameter param = (Parameter)item;
                    this.sql.append('?');
                    if (this.parameters == null) {
                        this.parameters = new ArrayList<Parameter>();
                    }
                    this.parameters.add(param);
                    continue;
                }
                if (item instanceof SQLStatement) {
                    SQLStatement stmt = (SQLStatement)item;
                    st = stmt.getSelectStatement();
                    this.sql.append(st.toSQL(mode));
                    if (st.parameters == null) continue;
                    if (this.parameters == null) {
                        this.parameters = new ArrayList<Parameter>();
                    }
                    this.parameters.addAll(st.parameters);
                    continue;
                }
                if (item instanceof SQLText) {
                    SQLText st2 = (SQLText)item;
                    this.sql.append(st2.toSQL(mode));
                    if (st2.parameters == null) continue;
                    if (this.parameters == null) {
                        this.parameters = new ArrayList<Parameter>();
                    }
                    this.parameters.addAll(st2.parameters);
                    continue;
                }
                this.sql.append(item);
            }
            if (this.encloseInParentheses) {
                this.sql.append(")");
            }
            this.sql.append(this.postpend == null ? "" : this.postpend);
        }
        return this.sql.toString();
    }

    public String toString() {
        return this.toSQL(1);
    }

    private class Parameter {
        final JavaTypeMapping mapping;
        final Object value;

        public Parameter(JavaTypeMapping mapping, Object value) {
            this.mapping = mapping;
            this.value = value;
        }
    }
}

