/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;

public class SQLJoin {
    public static final int NON_ANSI_JOIN = 0;
    public static final int INNER_JOIN = 1;
    public static final int LEFT_OUTER_JOIN = 2;
    public static final int RIGHT_OUTER_JOIN = 3;
    public static final int CROSS_JOIN = 4;
    private final int type;
    private SQLTable table;
    private BooleanExpression condition;

    public SQLJoin(int type, SQLTable tbl, BooleanExpression condition) {
        if (type != 0 && type != 1 && type != 2 && type != 3 && type != 4) {
            throw new NucleusException("Unsupported join type specified : " + type);
        }
        if (tbl == null) {
            throw new NucleusException("Specification of join must supply the table reference");
        }
        this.type = type;
        this.table = tbl;
        this.condition = condition;
    }

    public int getType() {
        return this.type;
    }

    public SQLTable getTable() {
        return this.table;
    }

    public BooleanExpression getCondition() {
        return this.condition;
    }

    public String toFromClause(RDBMSAdapter dba, boolean lock) {
        if (this.type > 0) {
            StringBuffer result = new StringBuffer();
            if (this.type == 1) {
                result.append("INNER JOIN ");
            } else if (this.type == 2) {
                result.append("LEFT OUTER JOIN ");
            } else if (this.type == 3) {
                result.append("RIGHT OUTER JOIN ");
            } else if (this.type == 4) {
                result.append("CROSS JOIN ");
            }
            result.append(this.table);
            if (this.type == 1 || this.type == 2 || this.type == 3) {
                result.append(" ON ");
                if (this.condition != null) {
                    result.append(this.condition.toSQL(0).toSQL(0));
                }
            }
            if (lock && dba.supportsOption("LockOptionWithinJoinClause")) {
                result.append(" WITH ").append(dba.getSelectWithLockOption());
            }
            return result.toString();
        }
        return "" + this.table;
    }
}

