/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.CharacterExpression;
import org.datanucleus.store.mapped.expression.CharacterLiteral;
import org.datanucleus.store.mapped.expression.ConcatOperatorExpression;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.SqlTemporalExpression;
import org.datanucleus.store.mapped.expression.StringExpression;
import org.datanucleus.store.mapped.expression.StringLiteral;
import org.datanucleus.store.mapped.expression.SubstringExpression;
import org.datanucleus.store.mapped.expression.TableExprAsJoins;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingManager;
import org.datanucleus.store.rdbms.ConnectionProvider;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.RDBMSStoreHelper;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.mapping.RDBMSMappingManager;
import org.datanucleus.store.rdbms.query.QueryStatement;
import org.datanucleus.store.rdbms.schema.ForeignKeyInfo;
import org.datanucleus.store.rdbms.schema.JDBCTypeInfo;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.RDBMSTypesInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.store.rdbms.table.ViewImpl;
import org.datanucleus.store.schema.StoreSchemaData;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseAdapter
implements RDBMSAdapter {
    protected static final Localiser LOCALISER_BASE = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ObjectManagerFactoryImpl.class.getClassLoader());
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    protected final HashSet<String> reservedKeywords = new HashSet();
    protected String datastoreProductName;
    protected String datastoreProductVersion;
    protected int datastoreMajorVersion;
    protected int datastoreMinorVersion;
    protected int datastoreRevisionVersion = 0;
    protected String identifierQuoteString;
    protected MappingManager mappingManager;
    protected Collection<String> supportedOptions = new HashSet<String>();
    protected String driverName;
    protected String driverVersion;
    protected int driverMajorVersion;
    protected int driverMinorVersion;
    protected int maxTableNameLength;
    protected int maxConstraintNameLength;
    protected int maxIndexNameLength;
    protected int maxColumnNameLength;
    protected String catalogSeparator;

    protected DatabaseAdapter(DatabaseMetaData metadata) {
        this.reservedKeywords.addAll(this.parseKeywordList("ABSOLUTE,ACTION,ADD,ALL,ALLOCATE,ALTER,AND,ANY,ARE,AS,ASC,ASSERTION,AT,AUTHORIZATION,AVG,BEGIN,BETWEEN,BIT,BIT_LENGTH,BOTH,BY,CASCADE,CASCADED,CASE,CAST,CATALOG,CHAR,CHARACTER,CHAR_LENGTH,CHARACTER_LENGTH,CHECK,CLOSE,COALESCE,COLLATE,COLLATION,COLUMN,COMMIT,CONNECT,CONNECTION,CONSTRAINT,CONSTRAINTS,CONTINUE,CONVERT,CORRESPONDING,COUNT,CREATE,CROSS,CURRENT,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_USER,CURSOR,DATE,DAY,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFAULT,DEFERRABLE,DEFERRED,DELETE,DESC,DESCRIBE,DESCRIPTOR,DIAGNOSTICS,DISCONNECT,DISTINCT,DOMAIN,DOUBLE,DROP,ELSE,END,END-EXEC,ESCAPE,EXCEPT,EXCEPTION,EXEC,EXECUTE,EXISTS,EXTERNAL,EXTRACT,FALSE,FETCH,FIRST,FLOAT,FOR,FOREIGN,FOUND,FROM,FULL,GET,GLOBAL,GO,GOTO,GRANT,GROUP,HAVING,HOUR,IDENTITY,IMMEDIATE,IN,INDICATOR,INITIALLY,INNER,INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTERVAL,INTO,IS,ISOLATION,JOIN,KEY,LANGUAGE,LAST,LEADING,LEFT,LEVEL,LIKE,LOCAL,LOWER,MATCH,MAX,MIN,MINUTE,MODULE,MONTH,NAMES,NATIONAL,NATURAL,NCHAR,NEXT,NO,NOT,NULL,NULLIF,NUMERIC,OCTET_LENGTH,OF,ON,ONLY,OPEN,OPTION,OR,ORDER,OUTER,OUTPUT,OVERLAPS,PAD,PARTIAL,POSITION,PRECISION,PREPARE,PRESERVE,PRIMARY,PRIOR,PRIVILEGES,PROCEDURE,PUBLIC,READ,REAL,REFERENCES,RELATIVE,RESTRICT,REVOKE,RIGHT,ROLLBACK,ROWS,SCHEMA,SCROLL,SECOND,SECTION,SELECT,SESSION,SESSION_USER,SET,SIZE,SMALLINT,SOME,SPACE,SQL,SQLCODE,SQLERROR,SQLSTATE,SUBSTRING,SUM,SYSTEM_USER,TABLE,TEMPORARY,THEN,TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE,TO,TRAILING,TRANSACTION,TRANSLATE,TRANSLATION,TRIM,TRUE,UNION,UNIQUE,UNKNOWN,UPDATE,UPPER,USAGE,USER,USING,VALUE,VALUES,VARCHAR,VARYING,VIEW,WHEN,WHENEVER,WHERE,WITH,WORK,WRITE,YEAR,ZONE"));
        this.reservedKeywords.addAll(this.parseKeywordList("ABSOLUTE,ACTION,ADD,AFTER,ALL,ALLOCATE,ALTER,AND,ANY,ARE,ARRAY,AS,ASC,ASENSITIVE,ASSERTION,ASYMMETRIC,AT,ATOMIC,AUTHORIZATION,BEFORE,BEGIN,BETWEEN,BINARY,BIT,BLOB,BOOLEAN,BOTH,BREADTH,BY,CALL,CALLED,CASCADE,CASCADED,CASE,CAST,CATALOG,CHAR,CHARACTER,CHECK,CLOB,CLOSE,COLLATE,COLLATION,COLUMN,COMMIT,CONDITION,CONNECT,CONNECTION,CONSTRAINT,CONSTRAINTS,CONSTRUCTOR,CONTINUE,CORRESPONDING,CREATE,CROSS,CUBE,CURRENT,CURRENT_DATE,CURRENT_DEFAULT_TRANSFORM_GROUP,CURRENT_PATH,CURRENT_ROLE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_TRANSFORM_GROUP_FOR_TYPE,CURRENT_USER,CURSOR,CYCLE,DATA,DATE,DAY,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFAULT,DEFERRABLE,DEFERRED,DELETE,DEPTH,DEREF,DESC,DESCRIBE,DESCRIPTOR,DETERMINISTIC,DIAGNOSTICS,DISCONNECT,DISTINCT,DO,DOMAIN,DOUBLE,DROP,DYNAMIC,EACH,ELSE,ELSEIF,END,EQUALS,ESCAPE,EXCEPT,EXCEPTION,EXEC,EXECUTE,EXISTS,EXIT,EXTERNAL,FALSE,FETCH,FILTER,FIRST,FLOAT,FOR,FOREIGN,FOUND,FREE,FROM,FULL,FUNCTION,GENERAL,GET,GLOBAL,GO,GOTO,GRANT,GROUP,GROUPING,HANDLER,HAVING,HOLD,HOUR,IDENTITY,IF,IMMEDIATE,IN,INDICATOR,INITIALLY,INNER,INOUT,INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTERVAL,INTO,IS,ISOLATION,ITERATE,JOIN,KEY,LANGUAGE,LARGE,LAST,LATERAL,LEADING,LEAVE,LEFT,LEVEL,LIKE,LOCAL,LOCALTIME,LOCALTIMESTAMP,LOCATOR,LOOP,MAP,MATCH,METHOD,MINUTE,MODIFIES,MODULE,MONTH,NAMES,NATIONAL,NATURAL,NCHAR,NCLOB,NEW,NEXT,NO,NONE,NOT,NULL,NUMERIC,OBJECT,OF,OLD,ON,ONLY,OPEN,OPTION,OR,ORDER,ORDINALITY,OUT,OUTER,OUTPUT,OVER,OVERLAPS,PAD,PARAMETER,PARTIAL,PARTITION,PATH,PRECISION,PREPARE,PRESERVE,PRIMARY,PRIOR,PRIVILEGES,PROCEDURE,PUBLIC,RANGE,READ,READS,REAL,RECURSIVE,REF,REFERENCES,REFERENCING,RELATIVE,RELEASE,REPEAT,RESIGNAL,RESTRICT,RESULT,RETURN,RETURNS,REVOKE,RIGHT,ROLE,ROLLBACK,ROLLUP,ROUTINE,ROW,ROWS,SAVEPOINT,SCHEMA,SCOPE,SCROLL,SEARCH,SECOND,SECTION,SELECT,SENSITIVE,SESSION,SESSION_USER,SET,SETS,SIGNAL,SIMILAR,SIZE,SMALLINT,SOME,SPACE,SPECIFIC,SPECIFICTYPE,SQL,SQLEXCEPTION,SQLSTATE,SQLWARNING,START,STATE,STATIC,SYMMETRIC,SYSTEM,SYSTEM_USER,TABLE,TEMPORARY,THEN,TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE,TO,TRAILING,TRANSACTION,TRANSLATION,TREAT,TRIGGER,TRUE,UNDER,UNDO,UNION,UNIQUE,UNKNOWN,UNNEST,UNTIL,UPDATE,USAGE,USER,USING,VALUE,VALUES,VARCHAR,VARYING,VIEW,WHEN,WHENEVER,WHERE,WHILE,WINDOW,WITH,WITHIN,WITHOUT,WORK,WRITE,YEAR,ZONE"));
        this.reservedKeywords.addAll(this.parseKeywordList("ADD,ALL,ALLOCATE,ALTER,AND,ANY,ARE,ARRAY,AS,ASENSITIVE,ASYMMETRIC,AT,ATOMIC,AUTHORIZATION,BEGIN,BETWEEN,BIGINT,BINARY,BLOB,BOOLEAN,BOTH,BY,CALL,CALLED,CASCADED,CASE,CAST,CHAR,CHARACTER,CHECK,CLOB,CLOSE,COLLATE,COLUMN,COMMIT,CONDITION,CONNECT,CONSTRAINT,CONTINUE,CORRESPONDING,CREATE,CROSS,CUBE,CURRENT,CURRENT_DATE,CURRENT_DEFAULT_TRANSFORM_GROUP,CURRENT_PATH,CURRENT_ROLE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_TRANSFORM_GROUP_FOR_TYPE,CURRENT_USER,CURSOR,CYCLE,DATE,DAY,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFAULT,DELETE,DEREF,DESCRIBE,DETERMINISTIC,DISCONNECT,DISTINCT,DO,DOUBLE,DROP,DYNAMIC,EACH,ELEMENT,ELSE,ELSEIF,END,ESCAPE,EXCEPT,EXEC,EXECUTE,EXISTS,EXIT,EXTERNAL,FALSE,FETCH,FILTER,FLOAT,FOR,FOREIGN,FREE,FROM,FULL,FUNCTION,GET,GLOBAL,GRANT,GROUP,GROUPING,HANDLER,HAVING,HOLD,HOUR,IDENTITY,IF,IMMEDIATE,IN,INDICATOR,INNER,INOUT,INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTERVAL,INTO,IS,ITERATE,JOIN,LANGUAGE,LARGE,LATERAL,LEADING,LEAVE,LEFT,LIKE,LOCAL,LOCALTIME,LOCALTIMESTAMP,LOOP,MATCH,MEMBER,MERGE,METHOD,MINUTE,MODIFIES,MODULE,MONTH,MULTISET,NATIONAL,NATURAL,NCHAR,NCLOB,NEW,NO,NONE,NOT,NULL,NUMERIC,OF,OLD,ON,ONLY,OPEN,OR,ORDER,OUT,OUTER,OUTPUT,OVER,OVERLAPS,PARAMETER,PARTITION,PRECISION,PREPARE,PRIMARY,PROCEDURE,RANGE,READS,REAL,RECURSIVE,REF,REFERENCES,REFERENCING,RELEASE,REPEAT,RESIGNAL,RESULT,RETURN,RETURNS,REVOKE,RIGHT,ROLLBACK,ROLLUP,ROW,ROWS,SAVEPOINT,SCOPE,SCROLL,SEARCH,SECOND,SELECT,SENSITIVE,SESSION_USER,SET,SIGNAL,SIMILAR,SMALLINT,SOME,SPECIFIC,SPECIFICTYPE,SQL,SQLEXCEPTION,SQLSTATE,SQLWARNING,START,STATIC,SUBMULTISET,SYMMETRIC,SYSTEM,SYSTEM_USER,TABLE,TABLESAMPLE,THEN,TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE,TO,TRAILING,TRANSLATION,TREAT,TRIGGER,TRUE,UNDO,UNION,UNIQUE,UNKNOWN,UNNEST,UNTIL,UPDATE,USER,USING,VALUE,VALUES,VARCHAR,VARYING,WHEN,WHENEVER,WHERE,WHILE,WINDOW,WITH,WITHIN,WITHOUT,YEAR"));
        this.reservedKeywords.addAll(this.parseKeywordList("ADA,C,CATALOG_NAME,CHARACTER_SET_CATALOG,CHARACTER_SET_NAME,CHARACTER_SET_SCHEMA,CLASS_ORIGIN,COBOL,COLLATION_CATALOG,COLLATION_NAME,COLLATION_SCHEMA,COLUMN_NAME,COMMAND_FUNCTION,COMMITTED,CONDITION_NUMBER,CONNECTION_NAME,CONSTRAINT_CATALOG,CONSTRAINT_NAME,CONSTRAINT_SCHEMA,CURSOR_NAME,DATA,DATETIME_INTERVAL_CODE,DATETIME_INTERVAL_PRECISION,DYNAMIC_FUNCTION,FORTRAN,LENGTH,MESSAGE_LENGTH,MESSAGE_OCTET_LENGTH,MESSAGE_TEXT,MORE,MUMPS,NAME,NULLABLE,NUMBER,PASCAL,PLI,REPEATABLE,RETURNED_LENGTH,RETURNED_OCTET_LENGTH,RETURNED_SQLSTATE,ROW_COUNT,SCALE,SCHEMA_NAME,SERIALIZABLE,SERVER_NAME,SUBCLASS_ORIGIN,TABLE_NAME,TYPE,UNCOMMITTED,UNNAMED"));
        try {
            block41: {
                this.reservedKeywords.addAll(this.parseKeywordList(metadata.getSQLKeywords()));
                this.driverMinorVersion = metadata.getDriverMinorVersion();
                this.driverMajorVersion = metadata.getDriverMajorVersion();
                this.driverName = metadata.getDriverName();
                this.driverVersion = metadata.getDriverVersion();
                this.datastoreProductName = metadata.getDatabaseProductName();
                this.datastoreProductVersion = metadata.getDatabaseProductVersion();
                StringBuffer strippedProductVersion = new StringBuffer();
                char previousChar = ' ';
                for (int i = 0; i < this.datastoreProductVersion.length(); ++i) {
                    char c = this.datastoreProductVersion.charAt(i);
                    if (Character.isDigit(c) || c == '.') {
                        if (previousChar != ' ') {
                            if (strippedProductVersion.length() == 0) {
                                strippedProductVersion.append(previousChar);
                            }
                            strippedProductVersion.append(c);
                        }
                        previousChar = c;
                        continue;
                    }
                    previousChar = ' ';
                }
                try {
                    StringTokenizer parts;
                    Class<?> mdc = metadata.getClass();
                    this.datastoreMajorVersion = (Integer)mdc.getMethod("getDatabaseMajorVersion", new Class[0]).invoke((Object)metadata, new Object[0]);
                    this.datastoreMinorVersion = (Integer)mdc.getMethod("getDatabaseMinorVersion", new Class[0]).invoke((Object)metadata, new Object[0]);
                    boolean noDBVersion = false;
                    if (this.datastoreMajorVersion <= 0 && this.datastoreMinorVersion <= 0) {
                        noDBVersion = true;
                    }
                    if ((parts = new StringTokenizer(strippedProductVersion.toString(), ".")).hasMoreTokens()) {
                        if (noDBVersion) {
                            try {
                                this.datastoreMajorVersion = Integer.parseInt(parts.nextToken());
                            }
                            catch (Exception e) {
                                this.datastoreMajorVersion = -1;
                            }
                        } else {
                            parts.nextToken();
                        }
                    }
                    if (parts.hasMoreTokens()) {
                        if (noDBVersion) {
                            try {
                                this.datastoreMinorVersion = Integer.parseInt(parts.nextToken());
                            }
                            catch (Exception e) {
                                this.datastoreMajorVersion = -1;
                            }
                        } else {
                            parts.nextToken();
                        }
                    }
                    if (parts.hasMoreTokens()) {
                        try {
                            this.datastoreRevisionVersion = Integer.parseInt(parts.nextToken());
                        }
                        catch (Exception e) {
                            this.datastoreRevisionVersion = -1;
                        }
                    }
                }
                catch (Throwable t) {
                    StringTokenizer parts = new StringTokenizer(strippedProductVersion.toString(), ".");
                    if (parts.hasMoreTokens()) {
                        try {
                            this.datastoreMajorVersion = Integer.parseInt(parts.nextToken());
                        }
                        catch (Exception e) {
                            this.datastoreMajorVersion = -1;
                        }
                    }
                    if (parts.hasMoreTokens()) {
                        try {
                            this.datastoreMinorVersion = Integer.parseInt(parts.nextToken());
                        }
                        catch (Exception e) {
                            this.datastoreMajorVersion = -1;
                        }
                    }
                    if (!parts.hasMoreTokens()) break block41;
                    try {
                        this.datastoreRevisionVersion = Integer.parseInt(parts.nextToken());
                    }
                    catch (Exception e) {
                        this.datastoreRevisionVersion = -1;
                    }
                }
            }
            this.maxTableNameLength = metadata.getMaxTableNameLength();
            this.maxConstraintNameLength = metadata.getMaxTableNameLength();
            this.maxIndexNameLength = metadata.getMaxTableNameLength();
            this.maxColumnNameLength = metadata.getMaxColumnNameLength();
            if (metadata.supportsCatalogsInTableDefinitions()) {
                this.supportedOptions.add("CatalogInTableDefinition");
            }
            if (metadata.supportsSchemasInTableDefinitions()) {
                this.supportedOptions.add("SchemaInTableDefinition");
            }
            if (metadata.supportsBatchUpdates()) {
                this.supportedOptions.add("StatementBatching");
            }
            if (metadata.storesLowerCaseIdentifiers()) {
                this.supportedOptions.add("LowerCaseIdentifiers");
            }
            if (metadata.storesMixedCaseIdentifiers()) {
                this.supportedOptions.add("MixedCaseIdentifiers");
            }
            if (metadata.storesUpperCaseIdentifiers()) {
                this.supportedOptions.add("UpperCaseIdentifiers");
            }
            if (metadata.storesLowerCaseQuotedIdentifiers()) {
                this.supportedOptions.add("LowerCaseQuotedIdentifiers");
            }
            if (metadata.storesMixedCaseQuotedIdentifiers()) {
                this.supportedOptions.add("MixedCaseQuotedIdentifiers");
            }
            if (metadata.storesUpperCaseQuotedIdentifiers()) {
                this.supportedOptions.add("UpperCaseQuotedIdentifiers");
            }
            if (metadata.supportsMixedCaseIdentifiers()) {
                this.supportedOptions.add("MixedCaseSensitiveIdentifiers");
            }
            if (metadata.supportsMixedCaseQuotedIdentifiers()) {
                this.supportedOptions.add("MixedCaseQuotedSensitiveIdentifiers");
            }
            this.catalogSeparator = metadata.getCatalogSeparator();
            this.catalogSeparator = this.catalogSeparator == null || this.catalogSeparator.trim().length() < 1 ? "." : this.catalogSeparator;
            this.identifierQuoteString = metadata.getIdentifierQuoteString();
            this.identifierQuoteString = null == this.identifierQuoteString || this.identifierQuoteString.trim().length() < 1 ? "\"" : this.identifierQuoteString;
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("051004"), (Throwable)e);
        }
        this.supportedOptions.add("DateTimeStoresMillisecs");
        this.supportedOptions.add("EscapeExpressionInLikePredicate");
        this.supportedOptions.add("Union_Syntax");
        this.supportedOptions.add("Exists_Syntax");
        this.supportedOptions.add("AlterTableDropConstraint_Syntax");
        this.supportedOptions.add("DeferredConstraints");
        this.supportedOptions.add("DistinctWithSelectForUpdate");
        this.supportedOptions.add("PersistOfUnassignedChar");
        this.supportedOptions.add("CheckInCreateStatements");
        this.supportedOptions.add("GetGeneratedKeysStatement");
        this.supportedOptions.add("BooleanExpression");
        this.supportedOptions.add("NullsInCandidateKeys");
        this.supportedOptions.add("ColumnOptions_NullsKeyword");
        this.supportedOptions.add("ColumnOptions_DefaultKeyword");
        this.supportedOptions.add("ColumnOptions_DefaultWithNotNull");
        this.supportedOptions.add("ColumnOptions_DefaultBeforeNull");
        this.supportedOptions.add("ANSI_Join_Syntax");
        this.supportedOptions.add("AutoIncrementNullSpecification");
        this.supportedOptions.add("AutoIncrementColumnTypeSpecification");
        this.supportedOptions.add("IncludeOrderByColumnsInSelect");
        this.supportedOptions.add("AccessParentQueryInSubquery");
        this.supportedOptions.add("FkDeleteActionCascade");
        this.supportedOptions.add("FkDeleteActionRestrict");
        this.supportedOptions.add("FkDeleteActionDefault");
        this.supportedOptions.add("FkDeleteActionNull");
        this.supportedOptions.add("FkUpdateActionCascade");
        this.supportedOptions.add("FkUpdateActionRestrict");
        this.supportedOptions.add("FkUpdateActionDefault");
        this.supportedOptions.add("FkUpdateActionNull");
        this.supportedOptions.add("TxIsolationReadCommitted");
        this.supportedOptions.add("TxIsolationReadUncommitted");
        this.supportedOptions.add("TxIsolationReadRepeatableRead");
        this.supportedOptions.add("TxIsolationSerializable");
    }

    @Override
    public void initialiseDatastore(Object conn) {
    }

    @Override
    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        RDBMSManager storeMgr = (RDBMSManager)handler.getStoreManager();
        ClassLoaderResolver clr = storeMgr.getOMFContext().getClassLoaderResolver(null);
        PluginManager pluginMgr = storeMgr.getOMFContext().getPluginManager();
        RDBMSMappingManager mapMgr = (RDBMSMappingManager)this.getMappingManager();
        mapMgr.loadDatastoreMapping(pluginMgr, clr, this.getVendorID());
        handler.getSchemaData(mconn.getConnection(), "types", null);
    }

    @Override
    public void removeUnsupportedMappings(StoreSchemaHandler handler, ManagedConnection mconn) {
        RDBMSMappingManager mapMgr = (RDBMSMappingManager)this.getMappingManager();
        RDBMSTypesInfo types = (RDBMSTypesInfo)handler.getSchemaData(mconn.getConnection(), "types", null);
        int[] jdbcTypes = JDBCUtils.getJDBCTypes();
        for (int i = 0; i < jdbcTypes.length; ++i) {
            if (types.getChild("" + jdbcTypes[i]) != null) continue;
            mapMgr.deregisterDatastoreMappingsForJDBCType(JDBCUtils.getNameForJDBCType(jdbcTypes[i]));
        }
    }

    protected void addSQLTypeForJDBCType(StoreSchemaHandler handler, ManagedConnection mconn, short jdbcTypeNumber, SQLTypeInfo sqlType, boolean addIfNotPresent) {
        String key;
        RDBMSTypesInfo types = (RDBMSTypesInfo)handler.getSchemaData(mconn.getConnection(), "types", null);
        JDBCTypeInfo jdbcType = (JDBCTypeInfo)types.getChild(key = "" + jdbcTypeNumber);
        if (jdbcType != null && !addIfNotPresent) {
            return;
        }
        if (jdbcType == null) {
            jdbcType = new JDBCTypeInfo(jdbcTypeNumber);
            types.addChild((StoreSchemaData)jdbcType);
            jdbcType.addChild(sqlType);
        } else {
            jdbcType.addChild(sqlType);
        }
    }

    @Override
    public void logConfiguration() {
        NucleusLogger.DATASTORE.debug((Object)("Datastore Adapter : " + this.getClass().getName()));
        NucleusLogger.DATASTORE.debug((Object)("Datastore Details : name=\"" + this.datastoreProductName + "\" version=\"" + this.datastoreProductVersion + "\" (major=" + this.datastoreMajorVersion + ", minor=" + this.datastoreMinorVersion + ", revision=" + this.datastoreRevisionVersion + ")"));
        NucleusLogger.DATASTORE.debug((Object)("Datastore Driver : name=\"" + this.driverName + "\" version=\"" + this.driverVersion + "\" (major=" + this.driverMajorVersion + ", minor=" + this.driverMinorVersion + ")"));
        NucleusLogger.DATASTORE.debug((Object)("Supported Identifier Cases : " + (this.supportsOption("LowerCaseIdentifiers") ? "lowercase " : "") + (this.supportsOption("LowerCaseQuotedIdentifiers") ? "\"lowercase\" " : "") + (this.supportsOption("MixedCaseIdentifiers") ? "MixedCase " : "") + (this.supportsOption("MixedCaseQuotedIdentifiers") ? "\"MixedCase\" " : "") + (this.supportsOption("UpperCaseIdentifiers") ? "UPPERCASE " : "") + (this.supportsOption("UpperCaseQuotedIdentifiers") ? "\"UPPERCASE\" " : "") + (this.supportsOption("MixedCaseSensitiveIdentifiers") ? "MixedCase-Sensitive " : "") + (this.supportsOption("MixedCaseQuotedSensitiveIdentifiers") ? "\"MixedCase-Sensitive\" " : "")));
        NucleusLogger.DATASTORE.debug((Object)("Supported Identifier Lengths (max) : Table=" + this.getMaxTableNameLength() + " Column=" + this.getMaxColumnNameLength() + " Constraint=" + this.getMaxConstraintNameLength() + " Index=" + this.getMaxIndexNameLength() + " Delimiter=" + this.getIdentifierQuoteString()));
        NucleusLogger.DATASTORE.debug((Object)("Support for Identifiers in DDL : catalog=" + this.supportsOption("CatalogInTableDefinition") + " schema=" + this.supportsOption("SchemaInTableDefinition")));
        NucleusLogger.DATASTORE.debug((Object)("Support Statement Batching : " + (this.supportedOptions.contains("StatementBatching") ? "yes" : "no")));
    }

    @Override
    public Collection<String> getSupportedOptions() {
        return this.supportedOptions;
    }

    @Override
    public boolean supportsOption(String option) {
        return this.supportedOptions.contains(option);
    }

    @Override
    public MappingManager getMappingManager() {
        if (this.mappingManager == null) {
            this.mappingManager = this.getNewMappingManager();
        }
        return this.mappingManager;
    }

    @Override
    public JavaTypeMapping getMapping(Class c, MappedStoreManager storeMgr) {
        return this.getMapping(c, storeMgr, false, false, null);
    }

    @Override
    public JavaTypeMapping getMapping(Class c, MappedStoreManager storeMgr, boolean serialised, boolean embedded, String fieldName) {
        return this.getMappingManager().getMapping(c, serialised, embedded, storeMgr, fieldName);
    }

    @Override
    public JavaTypeMapping getMapping(Class c, MappedStoreManager storeMgr, ClassLoaderResolver clr) {
        return this.getMapping(c, storeMgr, clr, false, false);
    }

    @Override
    public JavaTypeMapping getMapping(Class c, MappedStoreManager storeMgr, ClassLoaderResolver clr, boolean serialised, boolean embedded) {
        return this.getMappingManager().getMapping(c, serialised, embedded, storeMgr, clr);
    }

    protected final JavaTypeMapping getMapping(Class c, ScalarExpression expr) {
        return this.getMappingManager().getMapping(c, false, false, expr.getQueryExpression().getStoreManager(), expr.getQueryExpression().getClassLoaderResolver());
    }

    @Override
    public long getAdapterTime(Timestamp time) {
        long timestamp = this.getTime(time.getTime(), time.getNanos());
        int ms = this.getMiliseconds(time.getNanos());
        return timestamp + (long)ms;
    }

    protected long getTime(long time, long nanos) {
        if (nanos < 0L) {
            return (time / 1000L - 1L) * 1000L;
        }
        return time / 1000L * 1000L;
    }

    protected int getMiliseconds(long nanos) {
        return (int)(nanos / 1000000L);
    }

    @Override
    public int getDatastoreMajorVersion() {
        return this.datastoreMajorVersion;
    }

    @Override
    public int getDatastoreMinorVersion() {
        return this.datastoreMinorVersion;
    }

    @Override
    public boolean supportsQueryFetchSize(int size) {
        return true;
    }

    @Override
    public String getVendorID() {
        return null;
    }

    @Override
    public boolean isReservedKeyword(String word) {
        return this.reservedKeywords.contains(word);
    }

    @Override
    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    @Override
    public int getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    @Override
    public int getMaxForeignKeys() {
        return 9999;
    }

    @Override
    public int getMaxIndexes() {
        return 9999;
    }

    @Override
    public int getMaxConstraintNameLength() {
        return this.maxConstraintNameLength;
    }

    @Override
    public int getMaxIndexNameLength() {
        return this.maxIndexNameLength;
    }

    @Override
    public int getMaxColumnNameLength() {
        return this.maxColumnNameLength;
    }

    @Override
    public Iterator iteratorReservedWords() {
        return this.reservedKeywords.iterator();
    }

    @Override
    public RDBMSColumnInfo newRDBMSColumnInfo(ResultSet rs) {
        return new RDBMSColumnInfo(rs);
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new SQLTypeInfo(rs);
    }

    @Override
    public ForeignKeyInfo newFKInfo(ResultSet rs) {
        return new ForeignKeyInfo(rs);
    }

    protected Set parseKeywordList(String list) {
        StringTokenizer tokens = new StringTokenizer(list, ",");
        HashSet<String> words = new HashSet<String>();
        while (tokens.hasMoreTokens()) {
            words.add(tokens.nextToken().trim().toUpperCase());
        }
        return words;
    }

    @Override
    public boolean isSQLKeyword(String word) {
        return this.isReservedKeyword(word.toUpperCase());
    }

    @Override
    public int getUnlimitedLengthPrecisionValue(SQLTypeInfo typeInfo) {
        if (typeInfo.getCreateParams() != null && typeInfo.getCreateParams().length() > 0) {
            return typeInfo.getPrecision();
        }
        return -1;
    }

    @Override
    public boolean isValidPrimaryKeyType(int datatype) {
        return datatype != 2004 && datatype != 2005 && datatype != -4;
    }

    @Override
    public String getSurrogateForEmptyStrings() {
        return null;
    }

    protected MappingManager getNewMappingManager() {
        return new RDBMSMappingManager();
    }

    @Override
    public int getTransactionIsolationForSchemaCreation() {
        return 8;
    }

    @Override
    public int getRequiredTransactionIsolationLevel() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(ConnectionProvider connProvider, DataSource[] ds, int isolationLevel) throws SQLException {
        int reqdIsolationLevel = isolationLevel;
        if (this.getRequiredTransactionIsolationLevel() >= 0) {
            reqdIsolationLevel = this.getRequiredTransactionIsolationLevel();
        }
        Connection conn = connProvider.getConnection(ds);
        boolean succeeded = false;
        try {
            if (reqdIsolationLevel == 0) {
                if (!conn.getAutoCommit()) {
                    conn.setAutoCommit(true);
                }
            } else {
                if (conn.getAutoCommit()) {
                    conn.setAutoCommit(false);
                }
                if (RDBMSStoreHelper.supportsTransactionIsolation(this, reqdIsolationLevel)) {
                    int currentIsolationLevel = conn.getTransactionIsolation();
                    if (currentIsolationLevel != reqdIsolationLevel) {
                        conn.setTransactionIsolation(reqdIsolationLevel);
                    }
                } else {
                    NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("051008", (long)reqdIsolationLevel));
                }
            }
            succeeded = true;
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("052002", (Object)conn.toString(), (Object)TransactionUtils.getNameForTransactionIsolationLevel((int)reqdIsolationLevel)));
            }
            if (reqdIsolationLevel != isolationLevel && isolationLevel == 0 && !conn.getAutoCommit()) {
                conn.setAutoCommit(true);
            }
        }
        finally {
            if (!succeeded) {
                conn.close();
            }
        }
        return conn;
    }

    @Override
    public String getCatalogName(Connection conn) throws SQLException {
        throw new UnsupportedOperationException(LOCALISER.msg("051015", (Object)this.datastoreProductName, (Object)this.datastoreProductVersion));
    }

    @Override
    public String getSchemaName(Connection conn) throws SQLException {
        throw new UnsupportedOperationException(LOCALISER.msg("051016", (Object)this.datastoreProductName, (Object)this.datastoreProductVersion));
    }

    @Override
    public String getCatalogSeparator() {
        return this.catalogSeparator;
    }

    @Override
    public String getSelectWithLockOption() {
        return null;
    }

    @Override
    public String getSelectNewUUIDStmt() {
        return null;
    }

    public String getNewUUIDFunction() {
        return null;
    }

    @Override
    public String getNonAnsiInnerJoinWhereClause(String col1, String col2) {
        return null;
    }

    @Override
    public String getNonAnsiLeftOuterJoinWhereClause(String col1, String col2) {
        return null;
    }

    public String getNonAnsiRightOuterJoinWhereClause(String col1, String col2) {
        return null;
    }

    @Override
    public String getAutoIncrementStmt(Table table, String columnName) {
        throw new UnsupportedOperationException(LOCALISER.msg("051019"));
    }

    @Override
    public String getAutoIncrementKeyword() {
        throw new UnsupportedOperationException(LOCALISER.msg("051019"));
    }

    @Override
    public boolean isIdentityFieldDataType(String typeName) {
        throw new UnsupportedOperationException(LOCALISER.msg("051019"));
    }

    @Override
    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " () VALUES ()";
    }

    @Override
    public String getSequenceCreateStmt(String sequence_name, String min, String max, String start, String increment, String cache_size) {
        throw new UnsupportedOperationException(LOCALISER.msg("051020"));
    }

    @Override
    public String getSequenceNextStmt(String sequence_name) {
        throw new UnsupportedOperationException(LOCALISER.msg("051020"));
    }

    @Override
    public ResultSet getExistingIndexes(Connection conn, String catalog, String schema, String table) throws SQLException {
        return null;
    }

    @Override
    public String getCreateTableStatement(TableImpl table, Column[] columns, Properties props) {
        int i;
        PrimaryKey pk;
        StringBuffer createStmt = new StringBuffer();
        createStmt.append("CREATE TABLE ").append(table.toString()).append(this.getContinuationString()).append("(").append(this.getContinuationString());
        for (int i2 = 0; i2 < columns.length; ++i2) {
            if (i2 > 0) {
                createStmt.append(",").append(this.getContinuationString());
            }
            createStmt.append("    ").append(columns[i2].getSQLDefinition());
        }
        if (this.supportsOption("PrimaryKeyInCreateStatements") && (pk = table.getPrimaryKey()) != null && pk.size() > 0) {
            createStmt.append(",").append(this.getContinuationString());
            createStmt.append("    ").append(pk.toString());
        }
        if (this.supportsOption("UniqueInEndCreateStatements")) {
            StringBuffer uniqueConstraintStmt = new StringBuffer();
            for (i = 0; i < columns.length; ++i) {
                if (!columns[i].isUnique()) continue;
                if (uniqueConstraintStmt.length() < 1) {
                    uniqueConstraintStmt.append(",").append(this.getContinuationString());
                    uniqueConstraintStmt.append(" UNIQUE (");
                } else {
                    uniqueConstraintStmt.append(",");
                }
                uniqueConstraintStmt.append(((Object)columns[i].getIdentifier()).toString());
            }
            if (uniqueConstraintStmt.length() > 1) {
                uniqueConstraintStmt.append(")");
                createStmt.append(uniqueConstraintStmt.toString());
            }
        }
        if (this.supportsOption("CheckInEndCreateStatements")) {
            StringBuffer checkConstraintStmt = new StringBuffer();
            for (i = 0; i < columns.length; ++i) {
                if (columns[i].getConstraints() == null) continue;
                checkConstraintStmt.append(",").append(this.getContinuationString());
                checkConstraintStmt.append(columns[i].getConstraints());
            }
            if (checkConstraintStmt.length() > 1) {
                createStmt.append(checkConstraintStmt.toString());
            }
        }
        createStmt.append(this.getContinuationString()).append(")");
        return createStmt.toString();
    }

    @Override
    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        if (pk.getName() != null) {
            String identifier = factory.getIdentifierInAdapterCase(pk.getName());
            return "ALTER TABLE " + pk.getDatastoreContainerObject().toString() + " ADD CONSTRAINT " + identifier + ' ' + pk;
        }
        return "ALTER TABLE " + pk.getDatastoreContainerObject().toString() + " ADD " + pk;
    }

    @Override
    public String getAddCandidateKeyStatement(CandidateKey ck, IdentifierFactory factory) {
        if (ck.getName() != null) {
            String identifier = factory.getIdentifierInAdapterCase(ck.getName());
            return "ALTER TABLE " + ck.getDatastoreContainerObject().toString() + " ADD CONSTRAINT " + identifier + ' ' + ck;
        }
        return "ALTER TABLE " + ck.getDatastoreContainerObject().toString() + " ADD " + ck;
    }

    @Override
    public String getAddForeignKeyStatement(ForeignKey fk, IdentifierFactory factory) {
        if (fk.getName() != null) {
            String identifier = factory.getIdentifierInAdapterCase(fk.getName());
            return "ALTER TABLE " + fk.getDatastoreContainerObject().toString() + " ADD CONSTRAINT " + identifier + ' ' + fk;
        }
        return "ALTER TABLE " + fk.getDatastoreContainerObject().toString() + " ADD " + fk;
    }

    @Override
    public String getAddColumnStatement(DatastoreContainerObject table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD " + col.getSQLDefinition();
    }

    @Override
    public String getCreateIndexStatement(Index idx, IdentifierFactory factory) {
        String indexIdentifier = factory.getIdentifierInAdapterCase(idx.getName());
        return "CREATE " + (idx.getUnique() ? "UNIQUE " : "") + "INDEX " + indexIdentifier + " ON " + idx.getDatastoreContainerObject().toString() + ' ' + idx + (idx.getExtendedIndexSettings() == null ? "" : " " + idx.getExtendedIndexSettings());
    }

    @Override
    public String getCheckConstraintForValues(DatastoreIdentifier identifier, ScalarExpression[] values, boolean nullable) {
        StringBuffer constraints = new StringBuffer("CHECK (");
        constraints.append(identifier);
        constraints.append(" IN (");
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                constraints.append(",");
            }
            constraints.append(values[i].toStatementText(ScalarExpression.PROJECTION));
        }
        constraints.append(")");
        if (nullable) {
            constraints.append(" OR " + identifier + " IS NULL");
        }
        constraints.append(")");
        return constraints.toString();
    }

    @Override
    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString() + " CASCADE";
    }

    @Override
    public String getDropViewStatement(ViewImpl view) {
        return "DROP VIEW " + view.toString();
    }

    @Override
    public String getRangeByLimitSelectClause(long offset, long count) {
        return "";
    }

    @Override
    public String getRangeByLimitWhereClause(long offset, long count) {
        return "";
    }

    @Override
    public String getRangeByRowNumberColumn() {
        return "";
    }

    @Override
    public ResultSet getColumns(Connection conn, String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        return dmd.getColumns(catalog, schema, table, columnNamePattern);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("================ DatabaseAdapter ==================");
        sb.append("\n");
        sb.append("Adapter : " + this.getClass().getName());
        sb.append("\n");
        sb.append("Datastore : name=\"" + this.datastoreProductName + "\" version=\"" + this.datastoreProductVersion + "\" (major=" + this.datastoreMajorVersion + ", minor=" + this.datastoreMinorVersion + ", revision=" + this.datastoreRevisionVersion + ")");
        sb.append("\n");
        sb.append("Driver : name=\"" + this.driverName + "\" version=\"" + this.driverVersion + "\" (major=" + this.driverMajorVersion + ", minor=" + this.driverMinorVersion + ")");
        sb.append("\n");
        sb.append("===================================================");
        return sb.toString();
    }

    @Override
    public String getDatastoreDateStatement() {
        return "SELECT CURRENT_TIMESTAMP";
    }

    @Override
    public ScalarExpression getCurrentDateMethod(QueryExpression qs) {
        return new SqlTemporalExpression("CURRENT_DATE", qs);
    }

    @Override
    public ScalarExpression getCurrentTimeMethod(QueryExpression qs) {
        return new SqlTemporalExpression("CURRENT_TIME", qs);
    }

    @Override
    public ScalarExpression getCurrentTimestampMethod(QueryExpression qs) {
        return new SqlTemporalExpression("CURRENT_TIMESTAMP", qs);
    }

    @Override
    public NumericExpression modOperator(ScalarExpression operand1, ScalarExpression operand2) {
        return new NumericExpression(operand1, ScalarExpression.OP_MOD, operand2);
    }

    @Override
    public ScalarExpression getEscapedPatternExpression(ScalarExpression patternExpression) {
        if (patternExpression instanceof StringLiteral) {
            String value = (String)((StringLiteral)patternExpression).getValue();
            value = StringUtils.replaceAll((String)value, (String)"\\", (String)"\\\\");
            value = StringUtils.replaceAll((String)value, (String)"%", (String)"\\%");
            value = StringUtils.replaceAll((String)value, (String)"_", (String)"\\_");
            JavaTypeMapping m = this.getMapping(String.class, patternExpression);
            return m.newLiteral(patternExpression.getQueryExpression(), value);
        }
        return patternExpression;
    }

    @Override
    public String getPatternExpressionAnyCharacter() {
        return "_";
    }

    @Override
    public String getPatternExpressionZeroMoreCharacters() {
        return "%";
    }

    @Override
    public String getEscapePatternExpression() {
        return "ESCAPE '\\'";
    }

    @Override
    public String getEscapeCharacter() {
        return "\\";
    }

    public String getContinuationString() {
        return "\n";
    }

    @Override
    public String cartersianProduct(LogicSetExpression Y) {
        StringBuffer sb = new StringBuffer();
        sb.append(" , ");
        sb.append(Y.toString());
        return sb.toString();
    }

    @Override
    public QueryExpression newQueryStatement(DatastoreContainerObject table, DatastoreIdentifier rangeVar, ClassLoaderResolver clr) {
        return new QueryStatement(table, rangeVar, clr);
    }

    @Override
    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        return new TableExprAsJoins(qs, table, rangeVar);
    }

    public String getNumericConversionFunction() {
        return "ASCII";
    }

    @Override
    public NumericExpression toNumericExpression(CharacterExpression expr) {
        if (expr instanceof CharacterLiteral) {
            char c = ((Character)((CharacterLiteral)expr).getValue()).charValue();
            BigInteger value = new BigInteger("" + c);
            return (NumericExpression)this.getMapping(value.getClass(), expr).newLiteral(expr.getQueryExpression(), value);
        }
        if (expr instanceof Literal) {
            BigInteger value = new BigInteger((String)((Literal)((Object)expr)).getValue());
            return (NumericExpression)this.getMapping(value.getClass(), expr).newLiteral(expr.getQueryExpression(), value);
        }
        ArrayList<CharacterExpression> args = new ArrayList<CharacterExpression>();
        args.add(expr);
        return new NumericExpression("ASCII", args);
    }

    @Override
    public StringExpression translateMethod(ScalarExpression expr, ScalarExpression toExpr, ScalarExpression fromExpr) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        args.add(fromExpr);
        args.add(toExpr);
        return new StringExpression("TRANSLATE", args);
    }

    @Override
    public NumericExpression getNumericExpressionForMethod(String method, ScalarExpression expr) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        if (method.equalsIgnoreCase("abs")) {
            return new NumericExpression("ABS", args);
        }
        if (method.equalsIgnoreCase("sqrt")) {
            return new NumericExpression("SQRT", args);
        }
        if (method.equalsIgnoreCase("cos")) {
            return new NumericExpression("COS", args);
        }
        if (method.equalsIgnoreCase("sin")) {
            return new NumericExpression("SIN", args);
        }
        if (method.equalsIgnoreCase("tan")) {
            return new NumericExpression("TAN", args);
        }
        if (method.equalsIgnoreCase("acos")) {
            return new NumericExpression("ACOS", args);
        }
        if (method.equalsIgnoreCase("asin")) {
            return new NumericExpression("ASIN", args);
        }
        if (method.equalsIgnoreCase("atan")) {
            return new NumericExpression("ATAN", args);
        }
        if (method.equalsIgnoreCase("exp")) {
            return new NumericExpression("EXP", args);
        }
        if (method.equalsIgnoreCase("log")) {
            return new NumericExpression("LOG", args);
        }
        if (method.equalsIgnoreCase("floor")) {
            return new NumericExpression("FLOOR", args);
        }
        if (method.equalsIgnoreCase("ceil")) {
            return new NumericExpression("CEIL", args);
        }
        if (method.equalsIgnoreCase("length")) {
            return new NumericExpression("CHAR_LENGTH", args);
        }
        if (method.equalsIgnoreCase("year")) {
            return new NumericExpression("YEAR", args);
        }
        if (method.equalsIgnoreCase("month")) {
            JavaTypeMapping m = this.getMapping(BigInteger.class, expr);
            ScalarExpression integerLiteral = m.newLiteral(expr.getQueryExpression(), BigInteger.ONE);
            NumericExpression numExpr = new NumericExpression(new NumericExpression("MONTH", args), ScalarExpression.OP_SUB, integerLiteral);
            numExpr.encloseWithInParentheses();
            return numExpr;
        }
        if (method.equalsIgnoreCase("day")) {
            return new NumericExpression("DAY", args);
        }
        if (method.equalsIgnoreCase("hour")) {
            return new NumericExpression("HOUR", args);
        }
        if (method.equalsIgnoreCase("minute")) {
            return new NumericExpression("MINUTE", args);
        }
        if (method.equalsIgnoreCase("second")) {
            return new NumericExpression("SECOND", args);
        }
        throw new NucleusUserException("Attempt to get numeric expression for " + method + " yet this is not supported");
    }

    @Override
    public BooleanExpression endsWithMethod(ScalarExpression leftOperand, ScalarExpression rightOperand) {
        if (!(rightOperand instanceof StringExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(rightOperand);
        }
        StringLiteral pct = new StringLiteral(leftOperand.getQueryExpression(), leftOperand.getMapping(), '%');
        return new BooleanExpression(leftOperand, ScalarExpression.OP_LIKE, pct.add(leftOperand.getQueryExpression().getStoreManager().getDatastoreAdapter().getEscapedPatternExpression(rightOperand)));
    }

    @Override
    public BooleanExpression matchesMethod(StringExpression text, StringExpression pattern) {
        return new BooleanExpression(text, ScalarExpression.OP_LIKE, pattern);
    }

    @Override
    public StringExpression toStringExpression(NumericExpression expr) {
        if (expr instanceof Literal) {
            JavaTypeMapping m = this.getMapping(String.class, expr);
            return new StringLiteral(expr.getQueryExpression(), m, ((Literal)((Object)expr)).getValue().toString());
        }
        ArrayList<NumericExpression> args = new ArrayList<NumericExpression>();
        args.add(expr);
        ArrayList<String> types = new ArrayList<String>();
        types.add("VARCHAR(4000)");
        return new StringExpression("CAST", args, types);
    }

    @Override
    public StringExpression toStringExpression(StringLiteral expr) {
        return expr;
    }

    @Override
    public StringExpression substringMethod(StringExpression str, NumericExpression begin) {
        return new SubstringExpression(str, begin);
    }

    @Override
    public StringExpression lowerMethod(StringExpression str) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        return new StringExpression("LOWER", args);
    }

    @Override
    public StringExpression upperMethod(StringExpression str) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        return new StringExpression("UPPER", args);
    }

    @Override
    public StringExpression trimMethod(StringExpression str, boolean leading, boolean trailing) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        if (leading && trailing) {
            return new StringExpression("TRIM", args);
        }
        if (leading) {
            return new StringExpression("LTRIM", args);
        }
        if (trailing) {
            return new StringExpression("RTRIM", args);
        }
        return str;
    }

    @Override
    public StringExpression substringMethod(StringExpression str, NumericExpression begin, NumericExpression end) {
        return new SubstringExpression(str, begin, end);
    }

    @Override
    public BooleanExpression startsWithMethod(ScalarExpression source, ScalarExpression str) {
        ScalarExpression pct = this.getMapping(String.class, source).newLiteral(source.getQueryExpression(), "%");
        return new BooleanExpression(source, ScalarExpression.OP_LIKE, this.getEscapedPatternExpression(str).add(pct));
    }

    @Override
    public NumericExpression indexOfMethod(ScalarExpression source, ScalarExpression str, NumericExpression from) {
        JavaTypeMapping m = this.getMapping(BigInteger.class, source);
        ScalarExpression integerLiteral = m.newLiteral(source.getQueryExpression(), BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(source);
        if (from != null) {
            args.add(from.add(integerLiteral));
        }
        NumericExpression locateExpr = new NumericExpression("LOCATE", args);
        return new NumericExpression(locateExpr, ScalarExpression.OP_SUB, integerLiteral);
    }

    @Override
    public String getOperatorConcat() {
        return "||";
    }

    @Override
    public ScalarExpression concatOperator(ScalarExpression operand1, ScalarExpression operand2) {
        return new ConcatOperatorExpression(operand1, operand2);
    }
}

