/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ConnectionFactory;
import org.datanucleus.ConnectionFactoryRegistry;
import org.datanucleus.ManagedConnection;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.sco.IncompatibleFieldTypeException;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.Extent;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.NucleusSequence;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.exceptions.NoExtentException;
import org.datanucleus.store.exceptions.UnsupportedDataTypeException;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.FetchStatement;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementExpressionIndex;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.StatementText;
import org.datanucleus.store.mapped.mapping.ArrayMapping;
import org.datanucleus.store.mapped.mapping.CollectionMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MapMapping;
import org.datanucleus.store.rdbms.AbstractSchemaTransaction;
import org.datanucleus.store.rdbms.ConnectionFactoryImpl;
import org.datanucleus.store.rdbms.ConnectionProvider;
import org.datanucleus.store.rdbms.DeleteTablesSchemaTransaction;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.JDOConnectionImpl;
import org.datanucleus.store.rdbms.NucleusSequenceImpl;
import org.datanucleus.store.rdbms.RDBMSFetchStatement;
import org.datanucleus.store.rdbms.RDBMSPersistenceHandler;
import org.datanucleus.store.rdbms.RDBMSStoreData;
import org.datanucleus.store.rdbms.RDBMSStoreHelper;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.ValidateTableSchemaTransaction;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapterFactory;
import org.datanucleus.store.rdbms.extent.ClassTableExtent;
import org.datanucleus.store.rdbms.extent.ClassViewExtent;
import org.datanucleus.store.rdbms.fieldmanager.ResultSetGetter;
import org.datanucleus.store.rdbms.schema.JDBCTypeInfo;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.RDBMSSchemaHandler;
import org.datanucleus.store.rdbms.schema.RDBMSSchemaInfo;
import org.datanucleus.store.rdbms.schema.RDBMSTableInfo;
import org.datanucleus.store.rdbms.schema.RDBMSTypesInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.scostore.AbstractArrayStore;
import org.datanucleus.store.rdbms.scostore.AbstractCollectionStore;
import org.datanucleus.store.rdbms.scostore.AbstractMapStore;
import org.datanucleus.store.rdbms.scostore.FKArrayStore;
import org.datanucleus.store.rdbms.scostore.FKListStore;
import org.datanucleus.store.rdbms.scostore.FKMapStore;
import org.datanucleus.store.rdbms.scostore.FKSetStore;
import org.datanucleus.store.rdbms.scostore.JoinArrayStore;
import org.datanucleus.store.rdbms.scostore.JoinListStore;
import org.datanucleus.store.rdbms.scostore.JoinMapStore;
import org.datanucleus.store.rdbms.scostore.JoinSetStore;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sqlidentifier.SQLIdentifier;
import org.datanucleus.store.rdbms.table.AbstractTable;
import org.datanucleus.store.rdbms.table.ArrayTable;
import org.datanucleus.store.rdbms.table.ClassTable;
import org.datanucleus.store.rdbms.table.ClassView;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.rdbms.table.ProbeTable;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.store.rdbms.table.ViewImpl;
import org.datanucleus.store.scostore.ArrayStore;
import org.datanucleus.store.scostore.CollectionStore;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.store.valuegenerator.AbstractDatastoreGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationConnectionProvider;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.MacroString;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class RDBMSManager
extends MappedStoreManager {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    private String catalogName = null;
    private String schemaName = null;
    private ConnectionProvider connProvider;
    private SQLController sqlController = null;
    protected final boolean checkExistTablesOrViews;
    protected SQLExpressionFactory expressionFactory;
    private ClassAdder classAdder = null;
    private final Object CLASSADDER_MUTEX = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RDBMSManager(ClassLoaderResolver clr, OMFContext omfContext) {
        super("rdbms", clr, omfContext);
        PersistenceConfiguration conf = omfContext.getPersistenceConfiguration();
        this.checkExistTablesOrViews = conf.getBooleanProperty("datanucleus.rdbms.checkExistTablesOrViews");
        try {
            this.connProvider = (ConnectionProvider)omfContext.getPluginManager().createExecutableExtension("org.datanucleus.store_connectionprovider", "name", conf.getStringProperty("datanucleus.rdbms.connectionProviderName"), "class-name", null, null);
            if (this.connProvider == null) {
                throw new NucleusException(LOCALISER_RDBMS.msg("050000", (Object)conf.getStringProperty("datanucleus.rdbms.connectionProviderName"))).setFatal();
            }
            this.connProvider.setFailOnError(conf.getBooleanProperty("datanucleus.rdbms.connectionProviderFailOnError"));
        }
        catch (Exception e) {
            throw new NucleusException(LOCALISER.msg("050001", (Object)conf.getStringProperty("datanucleus.rdbms.connectionProviderName"), (Object)e.getMessage()), (Throwable)e).setFatal();
        }
        this.persistenceHandler = new RDBMSPersistenceHandler((StoreManager)this);
        this.schemaHandler = new RDBMSSchemaHandler(this);
        this.expressionFactory = new SQLExpressionFactory(this);
        try {
            ManagedConnection mc = this.getConnection(-1);
            Connection conn = (Connection)mc.getConnection();
            if (conn == null) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("050007"));
            }
            try {
                String validCatalogName;
                String validSchemaName;
                this.dba = RDBMSAdapterFactory.getInstance().getDatastoreAdapter(clr, conn, conf.getStringProperty("datanucleus.rdbms.datastoreAdapterClassName"), omfContext.getPluginManager());
                this.dba.initialiseTypes(this.schemaHandler, mc);
                this.dba.removeUnsupportedMappings(this.schemaHandler, mc);
                if (conf.hasProperty("datanucleus.mapping.Catalog")) {
                    if (!((RDBMSAdapter)this.dba).supportsOption("CatalogInTableDefinition")) {
                        NucleusLogger.DATASTORE.warn((Object)LOCALISER_RDBMS.msg("050002", (Object)conf.getStringProperty("datanucleus.mapping.Catalog")));
                    } else {
                        this.catalogName = conf.getStringProperty("datanucleus.mapping.Catalog");
                    }
                }
                if (conf.hasProperty("datanucleus.mapping.Schema")) {
                    if (!((RDBMSAdapter)this.dba).supportsOption("SchemaInTableDefinition")) {
                        NucleusLogger.DATASTORE.warn((Object)LOCALISER_RDBMS.msg("050002", (Object)conf.getStringProperty("datanucleus.mapping.Schema")));
                    } else {
                        this.schemaName = conf.getStringProperty("datanucleus.mapping.Schema");
                    }
                }
                this.initialiseIdentifierFactory(omfContext);
                if (this.schemaName != null && !(validSchemaName = this.identifierFactory.getIdentifierInAdapterCase(this.schemaName)).equals(this.schemaName)) {
                    NucleusLogger.JDO.warn((Object)LOCALISER_RDBMS.msg("020192", (Object)"schema", (Object)this.schemaName, (Object)validSchemaName));
                    this.schemaName = validSchemaName;
                }
                if (this.catalogName != null && !(validCatalogName = this.identifierFactory.getIdentifierInAdapterCase(this.catalogName)).equals(this.catalogName)) {
                    NucleusLogger.JDO.warn((Object)LOCALISER_RDBMS.msg("020192", (Object)"catalog", (Object)this.catalogName, (Object)validCatalogName));
                    this.catalogName = validCatalogName;
                }
                this.sqlController = new SQLController(((RDBMSAdapter)this.dba).supportsOption("StatementBatching"), conf.getIntProperty("datanucleus.rdbms.statementBatchLimit"), conf.getIntProperty("datanucleus.query.timeout"));
                this.initialiseSchema(conn, clr);
            }
            finally {
                mc.close();
            }
        }
        catch (NucleusException jpex) {
            NucleusLogger.DATASTORE_SCHEMA.error((Object)LOCALISER_RDBMS.msg("050004"), (Throwable)jpex);
            throw jpex.setFatal();
        }
        catch (Exception e1) {
            String msg = LOCALISER_RDBMS.msg("050004") + ' ' + LOCALISER_RDBMS.msg("050006") + ' ' + LOCALISER_RDBMS.msg("048000", (Object)e1);
            NucleusLogger.DATASTORE_SCHEMA.error((Object)msg, (Throwable)e1);
            throw new NucleusUserException(msg, (Throwable)e1).setFatal();
        }
        finally {
            this.logConfiguration();
        }
    }

    protected void logConfiguration() {
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            PersistenceConfiguration conf = this.getOMFContext().getPersistenceConfiguration();
            String classNames = conf.getStringProperty("datanucleus.autoStartClassNames");
            NucleusLogger.DATASTORE.debug((Object)"======================= Datastore =========================");
            NucleusLogger.DATASTORE.debug((Object)("StoreManager : \"" + this.storeManagerKey + "\" (" + ((Object)((Object)this)).getClass().getName() + ")"));
            NucleusLogger.DATASTORE.debug((Object)("AutoStart : mechanism=" + this.autoStartMechanism + ", mode=" + conf.getStringProperty("datanucleus.autoStartMechanismMode") + (classNames != null ? ", classes=" + classNames : "")));
            ConnectionFactoryRegistry registry = this.getOMFContext().getConnectionFactoryRegistry();
            ConnectionFactoryImpl connFactory = (ConnectionFactoryImpl)registry.lookupConnectionFactory(this.nontxConnectionFactoryName);
            String poolingType = connFactory.getPoolingType();
            NucleusLogger.DATASTORE.debug((Object)("Connection Pooling : " + (poolingType.equals("default") ? "None" : poolingType)));
            if (this.identifierFactory != null) {
                NucleusLogger.DATASTORE.debug((Object)("Datastore Identifiers : factory=\"" + conf.getStringProperty("datanucleus.identifierFactory") + "\"" + " case=" + this.identifierFactory.getNameOfIdentifierCase() + (this.catalogName != null ? " catalog=" + this.catalogName : "") + (this.schemaName != null ? " schema=" + this.schemaName : "")));
            }
            NucleusLogger.DATASTORE.debug((Object)("Datastore : " + (this.readOnlyDatastore ? "read-only" : "read-write") + (this.fixedDatastore ? ", fixed" : "") + (conf.getBooleanProperty("datanucleus.rdbms.useUpdateLock") ? ", useUpdateLock" : "") + (conf.getBooleanProperty("datanucleus.rdbms.checkExistTablesOrViews") ? ", checkTableViewExistence" : "") + ", rdbmsConstraintCreateMode=" + conf.getStringProperty("datanucleus.rdbms.constraintCreateMode") + ", initialiseColumnInfo=" + conf.getStringProperty("datanucleus.rdbms.initializeColumnInfo")));
            StringBuffer autoCreateOptions = null;
            if (this.autoCreateTables || this.autoCreateColumns || this.autoCreateConstraints) {
                autoCreateOptions = new StringBuffer();
                boolean first = true;
                if (this.autoCreateTables) {
                    if (!first) {
                        autoCreateOptions.append(",");
                    }
                    autoCreateOptions.append("Tables");
                    first = false;
                }
                if (this.autoCreateColumns) {
                    if (!first) {
                        autoCreateOptions.append(",");
                    }
                    autoCreateOptions.append("Columns");
                    first = false;
                }
                if (this.autoCreateConstraints) {
                    if (!first) {
                        autoCreateOptions.append(",");
                    }
                    autoCreateOptions.append("Constraints");
                    first = false;
                }
            }
            StringBuffer validateOptions = null;
            if (this.validateTables || this.validateColumns || this.validateConstraints) {
                validateOptions = new StringBuffer();
                boolean first = true;
                if (this.validateTables) {
                    validateOptions.append("Tables");
                    first = false;
                }
                if (this.validateColumns) {
                    if (!first) {
                        validateOptions.append(",");
                    }
                    validateOptions.append("Columns");
                    first = false;
                }
                if (this.validateConstraints) {
                    if (!first) {
                        validateOptions.append(",");
                    }
                    validateOptions.append("Constraints");
                    first = false;
                }
            }
            NucleusLogger.DATASTORE.debug((Object)("Schema Control : AutoCreate(" + (autoCreateOptions != null ? autoCreateOptions.toString() : "None") + ")" + ", Validate(" + (validateOptions != null ? validateOptions.toString() : "None") + ")"));
            int batchLimit = conf.getIntProperty("datanucleus.rdbms.statementBatchLimit");
            NucleusLogger.DATASTORE.debug((Object)("Statement Batching : max-batch-size=" + (batchLimit == -1 ? "UNLIMITED" : "" + batchLimit)));
            Object[] queryLanguages = this.getOMFContext().getPluginManager().getAttributeValuesForExtension("org.datanucleus.store_query_query", "datastore", this.storeManagerKey, "name");
            NucleusLogger.DATASTORE.debug((Object)("Query Languages : " + StringUtils.objectArrayToString((Object[])queryLanguages)));
            NucleusLogger.DATASTORE.debug((Object)("Queries : Timeout=" + conf.getIntProperty("datanucleus.query.timeout")));
            NucleusLogger.DATASTORE.debug((Object)("Queries : Results direction=" + conf.getStringProperty("datanucleus.rdbms.query.fetchDirection") + ", type=" + conf.getStringProperty("datanucleus.rdbms.query.resultSetType") + ", concurrency=" + conf.getStringProperty("datanucleus.rdbms.query.resultSetConcurrency")));
            NucleusLogger.DATASTORE.debug((Object)("Java-Types : string-default-length=" + conf.getIntProperty("datanucleus.rdbms.stringDefaultLength")));
            RDBMSTypesInfo typesInfo = (RDBMSTypesInfo)this.schemaHandler.getSchemaData(null, "types", null);
            if (typesInfo != null && typesInfo.getNumberOfChildren() > 0) {
                StringBuffer typeStr = new StringBuffer();
                Iterator jdbcTypesIter = typesInfo.getChildren().keySet().iterator();
                while (jdbcTypesIter.hasNext()) {
                    String jdbcTypeStr = (String)jdbcTypesIter.next();
                    int jdbcTypeNumber = 0;
                    try {
                        jdbcTypeNumber = new Short(jdbcTypeStr).shortValue();
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    typeStr.append(JDBCUtils.getNameForJDBCType(jdbcTypeNumber));
                    if (!jdbcTypesIter.hasNext()) continue;
                    typeStr.append(", ");
                }
                NucleusLogger.DATASTORE.debug((Object)("JDBC-Types : " + typeStr));
            }
            if (this.dba != null) {
                ((RDBMSAdapter)this.dba).logConfiguration();
            }
            NucleusLogger.DATASTORE.debug((Object)"===========================================================");
        }
    }

    protected void initialiseIdentifierFactory(OMFContext omfContext) {
        PersistenceConfiguration conf = omfContext.getPersistenceConfiguration();
        String idFactoryName = conf.getStringProperty("datanucleus.identifierFactory");
        String idFactoryClassName = omfContext.getPluginManager().getAttributeValueForExtension("org.datanucleus.store_identifierfactory", "name", idFactoryName, "class-name");
        if (idFactoryClassName == null) {
            throw new NucleusUserException(LOCALISER_RDBMS.msg("039003", (Object)idFactoryName)).setFatal();
        }
        try {
            Class<?> cls = Class.forName(idFactoryClassName);
            Class[] argTypes = new Class[]{DatastoreAdapter.class, String.class, String.class, String.class, String.class, String.class, String.class};
            Object[] args = new Object[]{this.dba, this.catalogName, this.schemaName, conf.getStringProperty("datanucleus.identifier.case"), conf.getStringProperty("datanucleus.identifier.wordSeparator"), conf.getStringProperty("datanucleus.identifier.tablePrefix"), conf.getStringProperty("datanucleus.identifier.tableSuffix")};
            this.identifierFactory = (IdentifierFactory)ClassUtils.newInstance(cls, (Class[])argTypes, (Object[])args);
        }
        catch (ClassNotFoundException cnfe) {
            throw new NucleusUserException(LOCALISER_RDBMS.msg("039004", (Object)idFactoryName, (Object)idFactoryClassName), (Throwable)cnfe).setFatal();
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error((Object)e);
            throw new NucleusException(LOCALISER_RDBMS.msg("039005", (Object)idFactoryClassName), (Throwable)e).setFatal();
        }
    }

    public void close() {
        super.close();
        this.classAdder = null;
    }

    public NucleusSequence getNucleusSequence(ObjectManager om, SequenceMetaData seqmd) {
        return new NucleusSequenceImpl(om, this, seqmd);
    }

    public NucleusConnection getNucleusConnection(ObjectManager om) {
        final boolean enlisted = om.getTransaction().isActive();
        ConnectionFactory cf = null;
        cf = enlisted ? this.getOMFContext().getConnectionFactoryRegistry().lookupConnectionFactory(this.txConnectionFactoryName) : this.getOMFContext().getConnectionFactoryRegistry().lookupConnectionFactory(this.nontxConnectionFactoryName);
        final ManagedConnection mc = cf.getConnection((ObjectManager)(enlisted ? om : null), null);
        mc.lock();
        return new JDOConnectionImpl(mc.getConnection(), new Runnable(){

            public void run() {
                mc.unlock();
                if (!enlisted) {
                    try {
                        ((Connection)mc.getConnection()).close();
                    }
                    catch (SQLException sqle) {
                        throw new NucleusDataStoreException(sqle.getMessage());
                    }
                }
            }
        });
    }

    public SQLController getSQLController() {
        return this.sqlController;
    }

    public SQLExpressionFactory getSQLExpressionFactory() {
        return this.expressionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseSchema(Connection conn, ClassLoaderResolver clr) throws Exception {
        block18: {
            RDBMSAdapter rdba = (RDBMSAdapter)this.dba;
            if (this.schemaName == null && this.catalogName == null) {
                try {
                    try {
                        this.catalogName = rdba.getCatalogName(conn);
                        this.schemaName = rdba.getSchemaName(conn);
                    }
                    catch (UnsupportedOperationException e) {
                        if (this.readOnlyDatastore || this.fixedDatastore) break block18;
                        ProbeTable pt = new ProbeTable(this);
                        pt.initialize(clr);
                        pt.create(conn);
                        try {
                            String[] schema_details = pt.findSchemaDetails(conn);
                            if (schema_details != null) {
                                this.catalogName = schema_details[0];
                                this.schemaName = schema_details[1];
                            }
                        }
                        finally {
                            pt.drop(conn);
                        }
                    }
                }
                catch (SQLException e) {
                    String msg = LOCALISER_RDBMS.msg("050005", (Object)e.getMessage()) + ' ' + LOCALISER_RDBMS.msg("050006");
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)msg);
                }
            }
        }
        if (!this.readOnlyDatastore) {
            this.dba.initialiseDatastore(conn);
        }
        if (this.autoStartMechanism == null) {
            this.autoStartMechanism = "SchemaTable";
        }
        if ((this.readOnlyDatastore || this.fixedDatastore) && this.autoStartMechanism.equals("SchemaTable")) {
            this.autoStartMechanism = "None";
        }
        if (NucleusLogger.DATASTORE_SCHEMA.isInfoEnabled()) {
            NucleusLogger.DATASTORE_SCHEMA.info((Object)LOCALISER_RDBMS.msg("050008", (Object)this.catalogName, (Object)this.schemaName, (Object)this.autoStartMechanism));
        }
        this.initialiseAutoStart(clr);
        if (NucleusLogger.DATASTORE_SCHEMA.isInfoEnabled()) {
            if (this.readOnlyDatastore) {
                NucleusLogger.DATASTORE_SCHEMA.info((Object)LOCALISER_RDBMS.msg("050010", (Object)this.catalogName, (Object)this.schemaName, (Object)("" + this.storeDataMgr.size())));
            } else if (this.fixedDatastore) {
                NucleusLogger.DATASTORE_SCHEMA.info((Object)LOCALISER_RDBMS.msg("050011", (Object)this.catalogName, (Object)this.schemaName, (Object)("" + this.storeDataMgr.size())));
            } else {
                NucleusLogger.DATASTORE_SCHEMA.info((Object)LOCALISER_RDBMS.msg("050009", (Object)this.catalogName, (Object)this.schemaName, (Object)("" + this.storeDataMgr.size())));
            }
        }
    }

    private void clearSchemaData() {
        this.deregisterAllStoreData();
        this.schemaHandler.clear();
        ((RDBMSPersistenceHandler)this.persistenceHandler).removeAllRequests();
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connProvider;
    }

    public Date getDatastoreDate() {
        Date serverDate;
        block14: {
            serverDate = null;
            String dateStmt = ((RDBMSAdapter)this.dba).getDatastoreDateStatement();
            ManagedConnection mconn = null;
            try {
                mconn = this.getConnection(0);
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    ps = this.getSQLController().getStatementForQuery(mconn, dateStmt);
                    rs = this.getSQLController().executeStatementQuery(mconn, dateStmt, ps);
                    if (rs.next()) {
                        Timestamp time = rs.getTimestamp(1, this.getOMFContext().getPersistenceConfiguration().getCalendarForDateTimezone());
                        serverDate = new Date(time.getTime());
                        break block14;
                    }
                    Date time = null;
                    return time;
                }
                catch (SQLException sqle) {
                    String msg = LOCALISER_RDBMS.msg("050052", (Object)sqle.getMessage());
                    NucleusLogger.DATASTORE.warn((Object)msg, (Throwable)sqle);
                    throw new NucleusUserException(msg, (Throwable)sqle).setFatal();
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        this.getSQLController().closeStatement(mconn, ps);
                    }
                }
            }
            catch (SQLException sqle) {
                String msg = LOCALISER_RDBMS.msg("050052", (Object)sqle.getMessage());
                NucleusLogger.DATASTORE.warn((Object)msg, (Throwable)sqle);
                throw new NucleusException(msg, (Throwable)sqle).setFatal();
            }
            finally {
                mconn.close();
            }
        }
        return serverDate;
    }

    public void addClasses(String[] classNames, ClassLoaderResolver clr) {
        this.addClasses(classNames, clr, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClasses(String[] classNames, ClassLoaderResolver clr, Writer writer, boolean completeDdl) {
        if (writer != null) {
            AbstractTable.setDdlWriter(writer);
        }
        AbstractTable.setCompleteDdl(completeDdl);
        Object object = this.CLASSADDER_MUTEX;
        synchronized (object) {
            if (this.classAdder != null) {
                this.classAdder.addClasses(classNames, clr);
                return;
            }
        }
        if (classNames != null && classNames.length > 0) {
            new ClassAdder(classNames, writer).execute(clr);
        }
    }

    public void removeAllClasses(ClassLoaderResolver clr) {
        DeleteTablesSchemaTransaction deleteTablesTxn = new DeleteTablesSchemaTransaction(this, 2, this.storeDataMgr);
        boolean success = true;
        try {
            deleteTablesTxn.execute(clr);
        }
        catch (NucleusException ne) {
            success = false;
            throw ne;
        }
        finally {
            if (success) {
                this.clearSchemaData();
            }
        }
    }

    public void validateTable(TableImpl table, ClassLoaderResolver clr) {
        ValidateTableSchemaTransaction validateTblTxn = new ValidateTableSchemaTransaction(this, 2, table);
        validateTblTxn.execute(clr);
    }

    public FetchStatement getFetchStatement(DatastoreContainerObject table) {
        return new RDBMSFetchStatement(table);
    }

    public Store getBackingStoreForField(ClassLoaderResolver clr, AbstractMemberMetaData fmd, Class type) {
        if (fmd != null && fmd.isSerialized()) {
            return null;
        }
        if (fmd.getMap() != null) {
            this.assertCompatibleFieldType(fmd, clr, type, MapMapping.class);
            return this.getBackingStoreForMap(fmd, clr, type);
        }
        if (fmd.getArray() != null) {
            this.assertCompatibleFieldType(fmd, clr, type, ArrayMapping.class);
            return this.getBackingStoreForArray(fmd, clr, type);
        }
        this.assertCompatibleFieldType(fmd, clr, type, CollectionMapping.class);
        return this.getBackingStoreForCollection(fmd, clr, type);
    }

    private void assertCompatibleFieldType(AbstractMemberMetaData fmd, ClassLoaderResolver clr, Class type, Class expectedMappingType) {
        JavaTypeMapping m;
        AbstractClassMetaData fieldTypeCmd;
        AbstractClassMetaData[] tableOwnerCmds;
        DatastoreClass ownerTable = this.getDatastoreClass(fmd.getClassName(), clr);
        if (ownerTable == null && (tableOwnerCmds = this.getClassesManagingTableForClass(fieldTypeCmd = this.getMetaDataManager().getMetaDataForClass(fmd.getClassName(), clr), clr)) != null && tableOwnerCmds.length == 1) {
            ownerTable = this.getDatastoreClass(tableOwnerCmds[0].getFullClassName(), clr);
        }
        if (ownerTable != null && !expectedMappingType.isAssignableFrom((m = ownerTable.getFieldMapping(fmd)).getClass())) {
            throw new IncompatibleFieldTypeException(fmd.getFullFieldName(), type.getName(), fmd.getTypeName());
        }
    }

    private CollectionStore getBackingStoreForCollection(AbstractMemberMetaData fmd, ClassLoaderResolver clr, Class type) {
        AbstractCollectionStore store = null;
        DatastoreContainerObject datastoreTable = this.getDatastoreContainerObject(fmd);
        store = type == null ? (datastoreTable == null ? (List.class.isAssignableFrom(fmd.getType()) ? new FKListStore(fmd, this, clr) : new FKSetStore(fmd, this, clr)) : (List.class.isAssignableFrom(fmd.getType()) ? new JoinListStore(fmd, (CollectionTable)datastoreTable, clr) : new JoinSetStore(fmd, (CollectionTable)datastoreTable, clr))) : (datastoreTable == null ? (SCOUtils.isListBased((Class)type) ? new FKListStore(fmd, this, clr) : new FKSetStore(fmd, this, clr)) : (SCOUtils.isListBased((Class)type) ? new JoinListStore(fmd, (CollectionTable)datastoreTable, clr) : new JoinSetStore(fmd, (CollectionTable)datastoreTable, clr)));
        return store;
    }

    private MapStore getBackingStoreForMap(AbstractMemberMetaData fmd, ClassLoaderResolver clr, Class type) {
        AbstractMapStore store = null;
        DatastoreContainerObject datastoreTable = this.getDatastoreContainerObject(fmd);
        store = datastoreTable == null ? new FKMapStore(fmd, this, clr) : new JoinMapStore((MapTable)datastoreTable, clr);
        return store;
    }

    private ArrayStore getBackingStoreForArray(AbstractMemberMetaData fmd, ClassLoaderResolver clr, Class type) {
        AbstractArrayStore store = null;
        DatastoreContainerObject datastoreTable = this.getDatastoreContainerObject(fmd);
        store = datastoreTable != null ? new JoinArrayStore((ArrayTable)datastoreTable, clr) : new FKArrayStore(fmd, this, clr);
        return store;
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ObjectManager om) {
        RDBMSStoreData data;
        AbstractCollection subclasses;
        if (id instanceof SCOID) {
            return ((SCOID)id).getSCOClass();
        }
        ArrayList<StoreData> classTree = new ArrayList<StoreData>();
        String targetClassName = null;
        AbstractClassMetaData cmd = null;
        ApiAdapter api = this.getApiAdapter();
        if (id instanceof OID) {
            OID oid = (OID)id;
            cmd = this.getMetaDataManager().getMetaDataForClass(oid.getPcClass(), clr);
            if (!cmd.hasDiscriminatorStrategy()) {
                subclasses = new ArrayList(this.getSubClassesForClass(oid.getPcClass(), true, clr));
                if (subclasses.size() < 1) {
                    NucleusLogger.PERSISTENCE.debug((Object)("1) Id \"" + id + "\" has been determined to be the id of class " + oid.getPcClass()));
                    return oid.getPcClass();
                }
                targetClassName = oid.getPcClass();
            }
        } else if (api.isSingleFieldIdentity(id)) {
            targetClassName = api.getTargetClassNameForSingleFieldIdentity(id);
            cmd = this.getMetaDataManager().getMetaDataForClass(targetClassName, clr);
            if (cmd.getIdentityType() != IdentityType.APPLICATION || !cmd.getObjectidClass().equals(id.getClass().getName())) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("050022", id, (Object)cmd.getFullClassName()));
            }
            if (cmd.hasDiscriminatorStrategy()) {
                targetClassName = null;
            }
        } else {
            Collection c = this.storeDataMgr.getByPrimaryKeyClass(id.getClass().getName());
            if (c != null) {
                for (RDBMSStoreData store_data : c) {
                    if (!store_data.hasTable()) continue;
                    classTree.add(store_data);
                }
            }
        }
        if (targetClassName != null && (data = (RDBMSStoreData)this.storeDataMgr.get(targetClassName)) != null) {
            if (data.hasTable()) {
                classTree.add(data);
            }
            subclasses = this.getSubClassesForClass(targetClassName, true, clr);
            for (String subclassName : subclasses) {
                RDBMSStoreData subclassData = (RDBMSStoreData)this.storeDataMgr.get(subclassName);
                if (!subclassData.hasTable()) continue;
                classTree.add(subclassData);
            }
        }
        if (!(classTree.size() != 0 || cmd != null && cmd.hasDiscriminatorStrategy())) {
            NucleusLogger.PERSISTENCE.debug((Object)("2) Object id of \"" + id + "\" doesnt define a known persistable class in this persistence factory." + " Make sure that the class is registered (e.g pm.getExtent)"));
            return null;
        }
        if (!(classTree.size() != 1 || (cmd = this.getMetaDataManager().getMetaDataForClass(((RDBMSStoreData)((Object)classTree.get(0))).getName(), clr)) != null && cmd.hasDiscriminatorStrategy())) {
            NucleusLogger.PERSISTENCE.debug((Object)("3) Id \"" + id + "\" has been determined to be the id of class " + ((RDBMSStoreData)((Object)classTree.get(0))).getName()));
            return ((RDBMSStoreData)((Object)classTree.get(0))).getName();
        }
        if (om != null) {
            String className = null;
            if (cmd != null && cmd.hasDiscriminatorStrategy()) {
                DatastoreClass primaryTable = this.getDatastoreClass(cmd.getFullClassName(), om.getClassLoaderResolver());
                if (primaryTable != null) {
                    classTree.add(this.storeDataMgr.get(cmd.getFullClassName()));
                    HashSet subclasses2 = this.getSubClassesForClass(cmd.getFullClassName(), true, clr);
                    for (String subclassName : subclasses2) {
                        RDBMSStoreData subclassData = (RDBMSStoreData)this.storeDataMgr.get(subclassName);
                        if (!subclassData.hasTable()) continue;
                        classTree.add(subclassData);
                    }
                    className = RDBMSStoreHelper.getClassNameForIdKeyUsingDiscriminator(om, this, id, classTree);
                    if (className != null) {
                        NucleusLogger.PERSISTENCE.debug((Object)("4) Id \"" + id + "\" has been determined to be the id of class " + className));
                        return className;
                    }
                    return null;
                }
            } else {
                className = RDBMSStoreHelper.getClassNameForIdKeyUsingUnion(om, this, id, classTree);
            }
            if (className != null) {
                NucleusLogger.PERSISTENCE.debug((Object)("6) Id \"" + id + "\" has been determined to be the id of class " + className));
                return className;
            }
            if (id instanceof OID) {
                NucleusLogger.PERSISTENCE.debug((Object)("7) Id \"" + id + "\" has been determined to be the id of class " + ((OID)id).getPcClass()));
                return ((OID)id).getPcClass();
            }
        } else {
            NucleusLogger.PERSISTENCE.debug((Object)("8) Id \"" + id + "\" has been determined to be the id of class " + ((RDBMSStoreData)((Object)classTree.get(0))).getName()));
            return ((RDBMSStoreData)((Object)classTree.get(0))).getName();
        }
        return null;
    }

    public FieldManager getFieldManagerForResultProcessing(StateManager sm, Object resultSet, StatementExpressionIndex[] stmtExprIndex) {
        return new ResultSetGetter(sm, (ResultSet)resultSet, stmtExprIndex);
    }

    public Object getResultValueAtPosition(Object resultSet, JavaTypeMapping mapping, int position) {
        try {
            return ((ResultSet)resultSet).getObject(position);
        }
        catch (SQLException sqle) {
            throw new NucleusDataStoreException(sqle.getMessage(), (Throwable)sqle);
        }
    }

    public Extent getExtent(ObjectManager om, Class c, boolean subclasses) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(c, om.getClassLoaderResolver());
        if (!cmd.isRequiresExtent()) {
            throw new NoExtentException(c.getName());
        }
        DatastoreClass t = this.getDatastoreClass(cmd.getFullClassName(), om.getClassLoaderResolver());
        if (cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.COMPLETE_TABLE) {
            HashSet subclassNames;
            HashSet<DatastoreClass> candidateTables = new HashSet<DatastoreClass>();
            if (t != null) {
                candidateTables.add(t);
            }
            if (subclasses && (subclassNames = this.getSubClassesForClass(cmd.getFullClassName(), subclasses, om.getClassLoaderResolver())) != null) {
                for (String subclassName : subclassNames) {
                    DatastoreClass tbl = this.getDatastoreClass(subclassName, om.getClassLoaderResolver());
                    if (tbl == null) continue;
                    candidateTables.add(tbl);
                }
            }
            return new ClassTableExtent(om, candidateTables.toArray(new DatastoreClass[candidateTables.size()]), c, subclasses, cmd);
        }
        if (t instanceof ClassView) {
            return new ClassViewExtent(om, t, c, subclasses, cmd);
        }
        if (t instanceof ClassTable) {
            return new ClassTableExtent(om, t, c, subclasses, cmd);
        }
        AbstractClassMetaData[] cmds = this.getClassesManagingTableForClass(cmd, om.getClassLoaderResolver());
        if (cmds != null) {
            DatastoreClass[] tables = new DatastoreClass[cmds.length];
            for (int i = 0; i < cmds.length; ++i) {
                tables[i] = this.getDatastoreClass(cmds[i].getFullClassName(), om.getClassLoaderResolver());
            }
            return new ClassTableExtent(om, tables, c, subclasses, cmd);
        }
        throw new NucleusUserException("Attempt to create an Extent for class " + c.getName() + " which has MetaData, yet no table was found! This should be impossible");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement getStatementForQuery(QueryExpression qs, ObjectManager om, ManagedConnection conn, boolean updateLock, String resultSetType, String resultSetConcurrency) throws SQLException {
        StatementText text = qs.toStatementText(updateLock);
        SQLController sqlControl = this.getSQLController();
        PreparedStatement ps = sqlControl.getStatementForQuery(conn, text.toString(), resultSetType, resultSetConcurrency);
        boolean done = false;
        try {
            text.applyParametersToStatement(om, ps);
            done = true;
        }
        finally {
            if (!done) {
                sqlControl.closeStatement(conn, ps);
            }
        }
        return ps;
    }

    public String getStatementTextForQuery(QueryExpression qs, boolean updateLock) {
        return qs.toStatementText(updateLock).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getStrategyValueForGenerator(ValueGenerator generator, final ObjectManager om) {
        Object oid = null;
        ValueGenerator valueGenerator = generator;
        synchronized (valueGenerator) {
            if (generator instanceof AbstractDatastoreGenerator) {
                final RDBMSManager thisStoreMgr = this;
                ValueGenerationConnectionProvider connProvider = new ValueGenerationConnectionProvider(){
                    ManagedConnection mconn;

                    public ManagedConnection retrieveConnection() {
                        PersistenceConfiguration conf = om.getOMFContext().getPersistenceConfiguration();
                        if (conf.getStringProperty("datanucleus.valuegeneration.transactionAttribute").equalsIgnoreCase("UsePM")) {
                            this.mconn = thisStoreMgr.getConnection(om);
                        } else {
                            int isolationLevel = TransactionUtils.getTransactionIsolationLevelForName((String)conf.getStringProperty("datanucleus.valuegeneration.transactionIsolation"));
                            this.mconn = thisStoreMgr.getConnection(isolationLevel);
                        }
                        return this.mconn;
                    }

                    public void releaseConnection() {
                        try {
                            PersistenceConfiguration conf = om.getOMFContext().getPersistenceConfiguration();
                            if (conf.getStringProperty("datanucleus.valuegeneration.transactionAttribute").equalsIgnoreCase("UsePM")) {
                                this.mconn.release();
                            } else {
                                this.mconn.close();
                            }
                            this.mconn = null;
                        }
                        catch (NucleusException e) {
                            String msg = LOCALISER_RDBMS.msg("050025", (Object)e);
                            NucleusLogger.VALUEGENERATION.error((Object)msg);
                            throw new NucleusDataStoreException(msg, (Throwable)e);
                        }
                    }
                };
                ((AbstractDatastoreGenerator)generator).setConnectionProvider(connProvider);
            }
            oid = generator.next();
        }
        return oid;
    }

    protected Properties getPropertiesForGenerator(AbstractClassMetaData cmd, int absoluteFieldNumber, ObjectManager om, SequenceMetaData seqmd, TableGeneratorMetaData tablegenmd) {
        AbstractMemberMetaData mmd = null;
        IdentityStrategy strategy = null;
        String sequence = null;
        ExtensionMetaData[] extensions = null;
        if (absoluteFieldNumber >= 0) {
            mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
            strategy = mmd.getValueStrategy();
            sequence = mmd.getSequence();
            extensions = mmd.getExtensions();
        } else {
            IdentityMetaData idmd = cmd.getBaseIdentityMetaData();
            strategy = idmd.getValueStrategy();
            sequence = idmd.getSequence();
            extensions = idmd.getExtensions();
        }
        DatastoreClass tbl = this.getDatastoreClass(cmd.getBaseAbstractClassMetaData().getFullClassName(), om.getClassLoaderResolver());
        if (tbl == null) {
            tbl = this.getTableForStrategy(cmd, absoluteFieldNumber, om.getClassLoaderResolver());
        }
        JavaTypeMapping m = null;
        if (mmd != null) {
            m = tbl.getFieldMapping(mmd);
            if (m == null) {
                tbl = this.getTableForStrategy(cmd, absoluteFieldNumber, om.getClassLoaderResolver());
                m = tbl.getFieldMapping(mmd);
            }
        } else {
            m = tbl.getIDMapping();
        }
        StringBuffer columnsName = new StringBuffer();
        for (int i = 0; i < m.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                columnsName.append(",");
            }
            columnsName.append(((Object)m.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
        }
        Properties properties = new Properties();
        properties.setProperty("class-name", cmd.getFullClassName());
        properties.put("root-class-name", cmd.getBaseAbstractClassMetaData().getFullClassName());
        if (mmd != null) {
            properties.setProperty("field-name", mmd.getFullFieldName());
        }
        if (cmd.getCatalog() != null) {
            properties.setProperty("catalog-name", cmd.getCatalog());
        }
        if (cmd.getSchema() != null) {
            properties.setProperty("schema-name", cmd.getSchema());
        }
        properties.setProperty("table-name", ((Object)tbl.getIdentifier()).toString());
        properties.setProperty("column-name", columnsName.toString());
        if (sequence != null) {
            properties.setProperty("sequence-name", sequence);
        }
        if (extensions != null) {
            for (int i = 0; i < extensions.length; ++i) {
                properties.put(extensions[i].getKey(), extensions[i].getValue());
            }
        }
        if (strategy == IdentityStrategy.INCREMENT && tablegenmd != null) {
            properties.put("key-initial-value", "" + tablegenmd.getInitialValue());
            properties.put("key-cache-size", "" + tablegenmd.getAllocationSize());
            if (tablegenmd.getTableName() != null) {
                properties.put("sequence-table-name", tablegenmd.getTableName());
            }
            if (tablegenmd.getCatalogName() != null) {
                properties.put("sequence-catalog-name", tablegenmd.getCatalogName());
            }
            if (tablegenmd.getSchemaName() != null) {
                properties.put("sequence-schema-name", tablegenmd.getSchemaName());
            }
            if (tablegenmd.getPKColumnName() != null) {
                properties.put("sequence-name-column-name", tablegenmd.getPKColumnName());
            }
            if (tablegenmd.getPKColumnName() != null) {
                properties.put("sequence-nextval-column-name", tablegenmd.getValueColumnName());
            }
            if (tablegenmd.getPKColumnValue() != null) {
                properties.put("sequence-name", tablegenmd.getPKColumnValue());
            }
            properties.remove("table-name");
            properties.remove("column-name");
        } else if (strategy == IdentityStrategy.SEQUENCE && seqmd != null && seqmd.getDatastoreSequence() != null) {
            if (seqmd.getInitialValue() >= 0L) {
                properties.put("key-initial-value", "" + seqmd.getInitialValue());
            }
            if (seqmd.getAllocationSize() > 0L) {
                properties.put("key-cache-size", "" + seqmd.getAllocationSize());
            }
            properties.put("sequence-name", "" + seqmd.getDatastoreSequence());
            ExtensionMetaData[] seqExtensions = seqmd.getExtensions();
            if (seqExtensions != null) {
                for (int i = 0; i < seqExtensions.length; ++i) {
                    properties.put(seqExtensions[i].getKey(), seqExtensions[i].getValue());
                }
            }
        }
        return properties;
    }

    private DatastoreClass getTableForStrategy(AbstractClassMetaData cmd, int fieldNumber, ClassLoaderResolver clr) {
        DatastoreClass t = this.getDatastoreClass(cmd.getFullClassName(), clr);
        if (t == null && cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
            throw new NucleusUserException(LOCALISER.msg("032013", (Object)cmd.getFullClassName()));
        }
        if (fieldNumber >= 0) {
            AbstractMemberMetaData fmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            t = t.getBaseDatastoreClassWithField(fmd);
        } else if (t != null) {
            boolean has_superclass = true;
            while (has_superclass) {
                DatastoreClass supert = t.getSuperDatastoreClass();
                if (supert != null) {
                    t = supert;
                    continue;
                }
                has_superclass = false;
            }
        }
        return t;
    }

    protected String getStrategyForNative(String sequence) {
        if (this.dba.supportsOption("Sequences") && sequence != null) {
            return "sequence";
        }
        return "table-sequence";
    }

    public SQLTypeInfo getSQLTypeInfoForJDBCType(int jdbcType) throws UnsupportedDataTypeException {
        RDBMSTypesInfo typesInfo = (RDBMSTypesInfo)this.schemaHandler.getSchemaData(null, "types", null);
        JDBCTypeInfo jdbcTypeInfo = (JDBCTypeInfo)typesInfo.getChild("" + jdbcType);
        if (jdbcTypeInfo.getNumberOfChildren() == 0) {
            throw new UnsupportedDataTypeException(LOCALISER.msg("051005", (Object)JDBCUtils.getNameForJDBCType(jdbcType)));
        }
        return (SQLTypeInfo)jdbcTypeInfo.getChild("DEFAULT");
    }

    public RDBMSColumnInfo getColumnInfoForColumnName(Table table, Connection conn, DatastoreIdentifier column) throws SQLException {
        RDBMSColumnInfo colInfo = (RDBMSColumnInfo)this.schemaHandler.getSchemaData((Object)conn, "column", new Object[]{table, column.getIdentifier()});
        return colInfo;
    }

    public List getColumnInfoForTable(Table table, Connection conn) throws SQLException {
        RDBMSTableInfo tableInfo = (RDBMSTableInfo)this.schemaHandler.getSchemaData((Object)conn, "columns", new Object[]{table});
        if (tableInfo == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList cols = new ArrayList(tableInfo.getNumberOfChildren());
        cols.addAll(tableInfo.getChildren());
        return cols;
    }

    public void invalidateColumnInfoForTable(Table table) {
        RDBMSSchemaInfo schemaInfo = (RDBMSSchemaInfo)this.schemaHandler.getSchemaData(null, "tables", null);
        if (schemaInfo != null && schemaInfo.getNumberOfChildren() > 0) {
            schemaInfo.getChildren().remove(table.getIdentifier().getFullyQualifiedName(true));
        }
    }

    public Collection getManagedTables(String catalog, String schema) {
        if (this.storeDataMgr == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<DatastoreContainerObject> tables = new HashSet<DatastoreContainerObject>();
        for (RDBMSStoreData sd : this.storeDataMgr.getManagedStoreData()) {
            if (sd.getDatastoreContainerObject() == null) continue;
            SQLIdentifier identifier = (SQLIdentifier)sd.getDatastoreContainerObject().getIdentifier();
            boolean catalogMatches = true;
            boolean schemaMatches = true;
            if (catalog != null && identifier.getCatalogName() != null && !catalog.equals(identifier.getCatalogName())) {
                catalogMatches = false;
            }
            if (schema != null && identifier.getSchemaName() != null && !schema.equals(identifier.getSchemaName())) {
                schemaMatches = false;
            }
            if (!catalogMatches || !schemaMatches) continue;
            tables.add(sd.getDatastoreContainerObject());
        }
        return tables;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resolveIdentifierMacro(MacroString.IdentifierMacro im, ClassLoaderResolver clr) {
        JavaTypeMapping m;
        DatastoreClass ct = this.getDatastoreClass(im.className, clr);
        if (im.fieldName == null) {
            im.value = ((Object)ct.getIdentifier()).toString();
            return;
        }
        if (im.fieldName.equals("this")) {
            if (!(ct instanceof ClassTable)) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("050034", (Object)im.className));
            }
            if (im.subfieldName != null) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("050035", (Object)im.className, (Object)im.fieldName, (Object)im.subfieldName));
            }
            m = ct.getIDMapping();
        } else {
            AbstractMemberMetaData fmd = this.getMetaDataManager().getMetaDataForMember(im.className, im.fieldName, clr);
            m = ct.getFieldMapping(fmd);
            DatastoreContainerObject t = this.getDatastoreContainerObject(fmd);
            if (im.subfieldName == null) {
                if (t != null) {
                    im.value = ((Object)t.getIdentifier()).toString();
                    return;
                }
            } else if (t instanceof CollectionTable) {
                CollectionTable collTable = (CollectionTable)t;
                if (im.subfieldName.equals("owner")) {
                    m = collTable.getOwnerMapping();
                } else if (im.subfieldName.equals("element")) {
                    m = collTable.getElementMapping();
                } else {
                    if (!im.subfieldName.equals("index")) throw new NucleusUserException(LOCALISER_RDBMS.msg("050036", (Object)im.subfieldName, (Object)im));
                    m = collTable.getOrderMapping();
                }
            } else {
                if (!(t instanceof MapTable)) throw new NucleusUserException(LOCALISER_RDBMS.msg("050035", (Object)im.className, (Object)im.fieldName, (Object)im.subfieldName));
                MapTable mt = (MapTable)t;
                if (im.subfieldName.equals("owner")) {
                    m = mt.getOwnerMapping();
                } else if (im.subfieldName.equals("key")) {
                    m = mt.getKeyMapping();
                } else {
                    if (!im.subfieldName.equals("value")) throw new NucleusUserException(LOCALISER_RDBMS.msg("050037", (Object)im.subfieldName, (Object)im));
                    m = mt.getValueMapping();
                }
            }
        }
        im.value = ((Object)((Column)m.getDataStoreMapping(0).getDatastoreField()).getIdentifier()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printInformation(String category, PrintStream ps) throws Exception {
        RDBMSAdapter dba = (RDBMSAdapter)this.getDatastoreAdapter();
        super.printInformation(category, ps);
        if (category.equalsIgnoreCase("DATASTORE")) {
            String msg = dba.toString();
            NucleusLogger.SCHEMATOOL.info((Object)msg);
            ps.println(msg);
            ps.println();
            msg = "Database TypeInfo";
            NucleusLogger.SCHEMATOOL.info((Object)msg);
            ps.println(msg);
            RDBMSTypesInfo typesInfo = (RDBMSTypesInfo)this.schemaHandler.getSchemaData(null, "types", null);
            if (typesInfo != null) {
                for (String jdbcTypeStr : typesInfo.getChildren().keySet()) {
                    short jdbcTypeNumber = 0;
                    try {
                        jdbcTypeNumber = new Short(jdbcTypeStr);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    JDBCTypeInfo jdbcType = (JDBCTypeInfo)typesInfo.getChild(jdbcTypeStr);
                    Set sqlTypeNames = jdbcType.getChildren().keySet();
                    String typeStr = "JDBC Type=" + JDBCUtils.getNameForJDBCType(jdbcTypeNumber) + " sqlTypes=" + StringUtils.collectionToString(sqlTypeNames);
                    NucleusLogger.SCHEMATOOL.info((Object)typeStr);
                    ps.println(typeStr);
                    SQLTypeInfo sqlType = (SQLTypeInfo)jdbcType.getChild("DEFAULT");
                    NucleusLogger.SCHEMATOOL.info((Object)sqlType);
                    ps.println(sqlType);
                }
            }
            ps.println("");
            msg = "Database Keywords";
            NucleusLogger.SCHEMATOOL.info((Object)msg);
            ps.println(msg);
            Iterator reservedWordsIter = dba.iteratorReservedWords();
            while (reservedWordsIter.hasNext()) {
                Object words = reservedWordsIter.next();
                NucleusLogger.SCHEMATOOL.info(words);
                ps.println(words);
            }
            ps.println("");
        } else if (category.equalsIgnoreCase("SCHEMA")) {
            String msg = dba.toString();
            NucleusLogger.SCHEMATOOL.info((Object)msg);
            ps.println(msg);
            ps.println();
            NucleusLogger.SCHEMATOOL.info((Object)"TABLES");
            ManagedConnection mc = this.getConnection(-1);
            try {
                Connection conn = (Connection)mc.getConnection();
                RDBMSSchemaInfo schemaInfo = (RDBMSSchemaInfo)this.schemaHandler.getSchemaData((Object)conn, "tables", new Object[]{this.catalogName, this.schemaName});
                if (schemaInfo != null) {
                    for (RDBMSTableInfo tableInfo : schemaInfo.getChildren().values()) {
                        NucleusLogger.SCHEMATOOL.info((Object)tableInfo);
                        ps.println(tableInfo);
                        for (RDBMSColumnInfo colInfo : tableInfo.getChildren()) {
                            NucleusLogger.SCHEMATOOL.info((Object)colInfo);
                            ps.println(colInfo);
                        }
                    }
                }
            }
            finally {
                if (mc != null) {
                    mc.close();
                }
            }
            ps.println("");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized DatastoreContainerObject newJoinDatastoreContainerObject(AbstractMemberMetaData fmd, ClassLoaderResolver clr) {
        AbstractMemberMetaData[] relatedMmds;
        if (fmd.getJoinMetaData() == null && ((relatedMmds = fmd.getRelatedMemberMetaData(clr)) == null || relatedMmds[0].getJoinMetaData() == null)) {
            Class element_class;
            if (fmd.hasCollection()) {
                element_class = clr.classForName(fmd.getCollection().getElementType());
            } else if (fmd.hasMap()) {
                MapMetaData mmd = (MapMetaData)fmd.getContainer();
                if (fmd.getValueMetaData() != null && fmd.getValueMetaData().getMappedBy() != null) {
                    element_class = clr.classForName(mmd.getKeyType());
                } else {
                    if (fmd.getKeyMetaData() == null || fmd.getKeyMetaData().getMappedBy() == null) throw new NucleusUserException(LOCALISER_RDBMS.msg("050050", (Object)fmd.getFullFieldName()));
                    element_class = clr.classForName(mmd.getValueType());
                }
            } else {
                if (!fmd.hasArray()) return null;
                element_class = clr.classForName(fmd.getTypeName()).getComponentType();
            }
            if (this.getMetaDataManager().getMetaDataForClass(element_class, clr) != null) {
                return null;
            }
            if (!ClassUtils.isReferenceType(element_class)) throw new NucleusUserException(LOCALISER_RDBMS.msg("050049", (Object)fmd.getFullFieldName(), (Object)fmd.toString()));
            return null;
        }
        DatastoreContainerObject joinTable = this.getDatastoreContainerObject(fmd);
        if (joinTable != null) {
            return joinTable;
        }
        if (this.classAdder == null) {
            throw new IllegalStateException(LOCALISER_RDBMS.msg("050016"));
        }
        if (fmd.getType().isArray()) {
            return this.classAdder.addJoinTableForContainer(fmd, clr, 3);
        }
        if (!Map.class.isAssignableFrom(fmd.getType())) return this.classAdder.addJoinTableForContainer(fmd, clr, 1);
        return this.classAdder.addJoinTableForContainer(fmd, clr, 2);
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ORM");
        set.add("BackedSCO");
        set.add("DatastoreIdentity");
        set.add("ApplicationIdentity");
        set.add("OptimisticTransaction");
        if (this.dba.supportsOption("TxIsolationReadCommitted")) {
            set.add("TransactionIsolationLevel.read-committed");
        }
        if (this.dba.supportsOption("TxIsolationReadUncommitted")) {
            set.add("TransactionIsolationLevel.read-uncommitted");
        }
        if (this.dba.supportsOption("TxIsolationReadRepeatableRead")) {
            set.add("TransactionIsolationLevel.repeatable-read");
        }
        if (this.dba.supportsOption("TxIsolationSerializable")) {
            set.add("TransactionIsolationLevel.serializable");
        }
        return set;
    }

    private class ClassAdder
    extends AbstractSchemaTransaction {
        public static final int JOIN_TABLE_COLLECTION = 1;
        public static final int JOIN_TABLE_MAP = 2;
        public static final int JOIN_TABLE_ARRAY = 3;
        private Writer ddlWriter;
        private HashSet<RDBMSStoreData> schemaDataAdded;
        private final String[] classNames;
        private int addClassTablesRecursionCounter;

        private ClassAdder(String[] classNames, Writer writer) {
            super(RDBMSManager.this, ((RDBMSAdapter)RDBMSManager.this.dba).getTransactionIsolationForSchemaCreation());
            this.ddlWriter = null;
            this.schemaDataAdded = new HashSet();
            this.addClassTablesRecursionCounter = 0;
            this.ddlWriter = writer;
            this.classNames = RDBMSManager.this.getOMFContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        }

        public String toString() {
            return LOCALISER_RDBMS.msg("050038", (Object)RDBMSManager.this.catalogName, (Object)RDBMSManager.this.schemaName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void run(ClassLoaderResolver clr) throws SQLException {
            if (this.classNames.length == 0) {
                return;
            }
            Object object = RDBMSManager.this.CLASSADDER_MUTEX;
            synchronized (object) {
                RDBMSManager.this.classAdder = this;
                try {
                    this.addClassTablesAndValidate(this.classNames, clr);
                }
                finally {
                    RDBMSManager.this.classAdder = null;
                }
            }
        }

        private void addClasses(String[] classNames, ClassLoaderResolver clr) {
            classNames = RDBMSManager.this.getOMFContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
            if (classNames.length == 0) {
                return;
            }
            try {
                if (this.getCurrentConnection() == null) {
                    throw new IllegalStateException(LOCALISER_RDBMS.msg("050039"));
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException("SQL exception: " + this, (Throwable)e);
            }
            this.addClassTables(classNames, clr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addClassTables(String[] classNames, ClassLoaderResolver clr) {
            ++this.addClassTablesRecursionCounter;
            try {
                Iterator iter = RDBMSManager.this.getMetaDataManager().getReferencedClasses(classNames, clr).iterator();
                try {
                    if (RDBMSManager.this.starter != null && RDBMSManager.this.starterInitialised && !RDBMSManager.this.starter.isOpen()) {
                        RDBMSManager.this.starter.open();
                    }
                    while (iter.hasNext()) {
                        ClassMetaData cmd = (ClassMetaData)iter.next();
                        this.addClassTable(cmd, clr);
                    }
                    for (RDBMSStoreData data : new HashSet<RDBMSStoreData>(this.schemaDataAdded)) {
                        AbstractClassMetaData cmd;
                        InheritanceMetaData imd;
                        if (data.getDatastoreContainerObject() != null || !data.isFCO() || (imd = (cmd = (AbstractClassMetaData)data.getMetaData()).getInheritanceMetaData()).getStrategyValue() != InheritanceStrategy.SUPERCLASS_TABLE) continue;
                        AbstractClassMetaData[] managingCmds = RDBMSManager.this.getClassesManagingTableForClass(cmd, clr);
                        DatastoreClass superTable = null;
                        if (managingCmds == null || managingCmds.length != 1) continue;
                        RDBMSStoreData superData = (RDBMSStoreData)RDBMSManager.this.storeDataMgr.get(managingCmds[0].getFullClassName());
                        if (superData == null) {
                            this.addClassTables(new String[]{managingCmds[0].getFullClassName()}, clr);
                            superData = (RDBMSStoreData)RDBMSManager.this.storeDataMgr.get(managingCmds[0].getFullClassName());
                        }
                        if (superData == null) {
                            String msg = LOCALISER_RDBMS.msg("050013", (Object)cmd.getFullClassName());
                            NucleusLogger.PERSISTENCE.error((Object)msg);
                            throw new NucleusUserException(msg);
                        }
                        superTable = (DatastoreClass)superData.getDatastoreContainerObject();
                        data.setDatastoreContainerObject(superTable);
                    }
                }
                finally {
                    if (RDBMSManager.this.starter != null && RDBMSManager.this.starterInitialised && RDBMSManager.this.starter.isOpen() && this.addClassTablesRecursionCounter <= 1) {
                        RDBMSManager.this.starter.close();
                    }
                }
            }
            finally {
                --this.addClassTablesRecursionCounter;
            }
        }

        private void addClassTable(ClassMetaData cmd, ClassLoaderResolver clr) {
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                return;
            }
            if (cmd.getIdentityType() == IdentityType.NONDURABLE && cmd.hasExtension("requires-table") && cmd.getValueForExtension("requires-table") != null && cmd.getValueForExtension("requires-table").equalsIgnoreCase("false")) {
                return;
            }
            RDBMSStoreData sd = (RDBMSStoreData)RDBMSManager.this.storeDataMgr.get(cmd.getFullClassName());
            if (sd == null) {
                if (cmd.getIdentityType() == IdentityType.APPLICATION && !cmd.usesSingleFieldIdentityClass()) {
                    String baseClassWithMetaData = cmd.getBaseAbstractClassMetaData().getFullClassName();
                    Collection c = RDBMSManager.this.storeDataMgr.getByPrimaryKeyClass(cmd.getObjectidClass());
                    if (c != null && c.size() > 0) {
                        boolean in_same_tree = false;
                        String sample_class_in_other_tree = null;
                        for (RDBMSStoreData id_sd : c) {
                            String otherClassBaseClass = ((AbstractClassMetaData)id_sd.getMetaData()).getBaseAbstractClassMetaData().getFullClassName();
                            if (otherClassBaseClass.equals(baseClassWithMetaData)) {
                                in_same_tree = true;
                                break;
                            }
                            sample_class_in_other_tree = id_sd.getName();
                        }
                        if (!in_same_tree) {
                            String error_msg = LOCALISER_RDBMS.msg("050021", (Object)cmd.getFullClassName(), (Object)cmd.getObjectidClass(), sample_class_in_other_tree);
                            NucleusLogger.DATASTORE.error((Object)error_msg);
                            throw new NucleusUserException(error_msg);
                        }
                    }
                }
                if (cmd.isEmbeddedOnly()) {
                    NucleusLogger.DATASTORE.info((Object)LOCALISER.msg("032012", (Object)cmd.getFullClassName()));
                } else {
                    InheritanceMetaData imd = cmd.getInheritanceMetaData();
                    RDBMSStoreData sdNew = null;
                    if (imd.getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                        sdNew = new RDBMSStoreData(cmd, null, false);
                        RDBMSManager.this.registerStoreData(sdNew);
                    } else if (imd.getStrategyValue() == InheritanceStrategy.COMPLETE_TABLE && cmd.isAbstractPersistenceCapable()) {
                        sdNew = new RDBMSStoreData(cmd, null, false);
                        RDBMSManager.this.registerStoreData(sdNew);
                    } else if (imd.getStrategyValue() == InheritanceStrategy.NEW_TABLE || imd.getStrategyValue() == InheritanceStrategy.COMPLETE_TABLE) {
                        DatastoreIdentifier tableName = null;
                        RDBMSStoreData tmpData = (RDBMSStoreData)RDBMSManager.this.storeDataMgr.get(cmd.getFullClassName());
                        tableName = tmpData != null && tmpData.getDatastoreIdentifier() != null ? tmpData.getDatastoreIdentifier() : RDBMSManager.this.identifierFactory.newDatastoreContainerIdentifier(clr, (AbstractClassMetaData)cmd);
                        StoreData[] existingStoreData = RDBMSManager.this.getStoreDataForDatastoreContainerObject(tableName);
                        if (existingStoreData != null) {
                            String existingClass = null;
                            for (int j = 0; j < existingStoreData.length; ++j) {
                                if (existingStoreData[j].getName().equals(cmd.getFullClassName())) continue;
                                existingClass = existingStoreData[j].getName();
                                break;
                            }
                            if (existingClass != null) {
                                String msg = LOCALISER_RDBMS.msg("050015", (Object)cmd.getFullClassName(), (Object)tableName.getIdentifier(), existingClass);
                                NucleusLogger.DATASTORE.warn((Object)msg);
                            }
                        }
                        AbstractTable t = null;
                        boolean hasViewDef = false;
                        if (RDBMSManager.this.dba.getVendorID() != null) {
                            hasViewDef = cmd.hasExtension("view-definition-" + RDBMSManager.this.dba.getVendorID());
                        }
                        if (!hasViewDef) {
                            hasViewDef = cmd.hasExtension("view-definition");
                        }
                        t = hasViewDef ? new ClassView(tableName, RDBMSManager.this, cmd) : new ClassTable(tableName, RDBMSManager.this, cmd);
                        sdNew = new RDBMSStoreData(cmd, t, true);
                        RDBMSManager.this.registerStoreData(sdNew);
                        ((Table)t).preInitialize(clr);
                    } else if (imd.getStrategyValue() == InheritanceStrategy.SUPERCLASS_TABLE) {
                        AbstractClassMetaData[] managingCmds = RDBMSManager.this.getClassesManagingTableForClass((AbstractClassMetaData)cmd, clr);
                        DatastoreContainerObject superTable = null;
                        if (managingCmds != null && managingCmds.length == 1) {
                            RDBMSStoreData superData = (RDBMSStoreData)RDBMSManager.this.storeDataMgr.get(managingCmds[0].getFullClassName());
                            if (superData != null) {
                                superTable = superData.getDatastoreContainerObject();
                            }
                            sdNew = new RDBMSStoreData(cmd, superTable, false);
                            RDBMSManager.this.registerStoreData(sdNew);
                        } else {
                            String msg = LOCALISER_RDBMS.msg("050013", (Object)cmd.getFullClassName());
                            NucleusLogger.PERSISTENCE.error((Object)msg);
                            throw new NucleusUserException(msg);
                        }
                    }
                    this.schemaDataAdded.add(sdNew);
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addClassTablesAndValidate(String[] classNames, ClassLoaderResolver clr) {
            block11: {
                block10: {
                    RDBMSManager.this.storeDataMgr.begin();
                    boolean completed = false;
                    List tablesCreated = null;
                    List tableConstraintsCreated = null;
                    List viewsCreated = null;
                    try {
                        List[] result;
                        List autoCreateErrors = new ArrayList();
                        this.addClassTables(classNames, clr);
                        List[] toValidate = this.initializeClassTables(classNames, clr);
                        if (toValidate[0] != null && toValidate[0].size() > 0) {
                            result = this.performTablesValidation(toValidate[0], clr);
                            tablesCreated = result[0];
                            tableConstraintsCreated = result[1];
                            autoCreateErrors = result[2];
                        }
                        if (toValidate[1] != null && toValidate[1].size() > 0) {
                            result = this.performViewsValidation(toValidate[1]);
                            viewsCreated = result[0];
                            autoCreateErrors.addAll(result[1]);
                        }
                        this.verifyErrors(autoCreateErrors);
                        completed = true;
                        if (completed) break block10;
                    }
                    catch (SQLException sqle) {
                        try {
                            String msg = LOCALISER_RDBMS.msg("050044", (Object)sqle);
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
                            throw new NucleusDataStoreException(msg, (Throwable)sqle);
                            catch (Exception e) {
                                if (NucleusException.class.isAssignableFrom(e.getClass())) {
                                    throw (NucleusException)((Object)e);
                                }
                                NucleusLogger.DATASTORE_SCHEMA.error((Object)LOCALISER_RDBMS.msg("050044", (Object)e));
                                throw new NucleusException(e.toString(), (Throwable)e).setFatal();
                            }
                        }
                        catch (Throwable throwable) {
                            if (!completed) {
                                RDBMSManager.this.storeDataMgr.rollback();
                                this.rollbackSchemaCreation(viewsCreated, tableConstraintsCreated, tablesCreated);
                            } else {
                                RDBMSManager.this.storeDataMgr.commit();
                            }
                            this.schemaDataAdded.clear();
                            throw throwable;
                        }
                    }
                    RDBMSManager.this.storeDataMgr.rollback();
                    this.rollbackSchemaCreation(viewsCreated, tableConstraintsCreated, tablesCreated);
                    break block11;
                }
                RDBMSManager.this.storeDataMgr.commit();
            }
            this.schemaDataAdded.clear();
        }

        private List[] initializeClassTables(String[] classNames, ClassLoaderResolver clr) {
            boolean someNeededInitialization;
            ArrayList<Table> tablesToValidate = new ArrayList<Table>();
            ArrayList<Table> viewsToValidate = new ArrayList<Table>();
            ArrayList<Table> recentlyInitilized = new ArrayList<Table>();
            do {
                someNeededInitialization = false;
                RDBMSStoreData[] rdbmsStoreData = RDBMSManager.this.storeDataMgr.getManagedStoreData().toArray(new RDBMSStoreData[RDBMSManager.this.storeDataMgr.size()]);
                for (int i = 0; i < rdbmsStoreData.length; ++i) {
                    if (!rdbmsStoreData[i].hasTable()) continue;
                    Table t = (Table)rdbmsStoreData[i].getDatastoreContainerObject();
                    if (t instanceof DatastoreClass) {
                        ((RDBMSPersistenceHandler)RDBMSManager.this.persistenceHandler).removeRequestsForTable((DatastoreClass)((Object)t));
                    }
                    if (!t.isInitialized()) {
                        t.initialize(clr);
                        recentlyInitilized.add(t);
                        if (t instanceof ViewImpl) {
                            viewsToValidate.add(t);
                        } else {
                            tablesToValidate.add(t);
                        }
                        someNeededInitialization = true;
                    }
                    if (rdbmsStoreData[i].isTableOwner() || ((ClassTable)t).managesClass(rdbmsStoreData[i].getName())) continue;
                    ((ClassTable)t).manageClass((AbstractClassMetaData)((ClassMetaData)rdbmsStoreData[i].getMetaData()), clr);
                    if (!tablesToValidate.contains(t)) {
                        tablesToValidate.add(t);
                    }
                    someNeededInitialization = true;
                }
            } while (someNeededInitialization);
            for (int j = 0; j < recentlyInitilized.size(); ++j) {
                ((Table)recentlyInitilized.get(j)).postInitialize(clr);
            }
            return new List[]{tablesToValidate, viewsToValidate};
        }

        private List[] performTablesValidation(List tablesToValidate, ClassLoaderResolver clr) throws SQLException {
            ArrayList autoCreateErrors = new ArrayList();
            ArrayList<TableImpl> tableConstraintsCreated = new ArrayList<TableImpl>();
            ArrayList<TableImpl> tablesCreated = new ArrayList<TableImpl>();
            if (this.ddlWriter != null) {
                tablesToValidate = this.removeDuplicateTablesFromList(tablesToValidate);
            }
            for (TableImpl t : tablesToValidate) {
                boolean columnsValidated = false;
                if (RDBMSManager.this.checkExistTablesOrViews) {
                    if (this.ddlWriter != null) {
                        try {
                            if (t instanceof ClassTable) {
                                this.ddlWriter.write("-- Table " + t.toString() + " for classes " + StringUtils.objectArrayToString((Object[])((ClassTable)t).getManagedClasses()) + "\n");
                            } else if (t instanceof JoinTable) {
                                this.ddlWriter.write("-- Table " + t.toString() + " for join relationship\n");
                            }
                        }
                        catch (IOException ioe) {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)"error writing DDL into file", (Throwable)ioe);
                        }
                    }
                    if (!tablesCreated.contains(t) && t.exists(this.getCurrentConnection(), RDBMSManager.this.autoCreateTables)) {
                        tablesCreated.add(t);
                        columnsValidated = true;
                    } else if (t.isInitializedModified() || RDBMSManager.this.autoCreateColumns) {
                        t.validateColumns(this.getCurrentConnection(), false, RDBMSManager.this.autoCreateColumns, autoCreateErrors);
                        columnsValidated = true;
                    }
                }
                if (RDBMSManager.this.validateTables && !columnsValidated) {
                    t.validate(this.getCurrentConnection(), RDBMSManager.this.validateColumns, false, autoCreateErrors);
                } else if (!columnsValidated) {
                    String initInfo = RDBMSManager.this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.rdbms.initializeColumnInfo");
                    if (initInfo.equalsIgnoreCase("PK")) {
                        t.initializeColumnInfoForPrimaryKeyColumns(this.getCurrentConnection());
                    } else if (initInfo.equalsIgnoreCase("ALL")) {
                        t.initializeColumnInfoFromDatastore(this.getCurrentConnection());
                    }
                }
                RDBMSManager.this.invalidateColumnInfoForTable(t);
            }
            for (TableImpl t : tablesToValidate) {
                if (!RDBMSManager.this.validateConstraints && !RDBMSManager.this.autoCreateConstraints) continue;
                if (this.ddlWriter != null) {
                    try {
                        if (t instanceof ClassTable) {
                            this.ddlWriter.write("-- Constraints for table " + t.toString() + " for class(es) " + StringUtils.objectArrayToString((Object[])((ClassTable)t).getManagedClasses()) + "\n");
                        } else {
                            this.ddlWriter.write("-- Constraints for table " + t.toString() + "\n");
                        }
                    }
                    catch (IOException ioe) {
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)"error writing DDL into file", (Throwable)ioe);
                    }
                }
                if (tablesCreated.contains(t) && !this.hasDuplicateTablesFromList(tablesToValidate)) {
                    if (t.createConstraints(this.getCurrentConnection(), autoCreateErrors, clr)) {
                        tableConstraintsCreated.add(t);
                    }
                } else if (t.validateConstraints(this.getCurrentConnection(), RDBMSManager.this.autoCreateConstraints, autoCreateErrors, clr)) {
                    tableConstraintsCreated.add(t);
                }
                if (this.ddlWriter == null) continue;
                try {
                    this.ddlWriter.write("\n");
                }
                catch (IOException ioe) {
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)"error writing DDL into file", (Throwable)ioe);
                }
            }
            return new List[]{tablesCreated, tableConstraintsCreated, autoCreateErrors};
        }

        private List removeDuplicateTablesFromList(List newTables) {
            ArrayList result = new ArrayList();
            TreeSet uniqueTables = new TreeSet(new Comparator(){

                public int compare(Object o1, Object o2) {
                    DatastoreContainerObject t1 = (DatastoreContainerObject)o1;
                    DatastoreContainerObject t2 = (DatastoreContainerObject)o2;
                    return StringUtils.toJVMIDString((Object)t1).compareTo(StringUtils.toJVMIDString((Object)t2));
                }
            });
            uniqueTables.addAll(newTables);
            result.addAll(uniqueTables);
            return result;
        }

        private boolean hasDuplicateTablesFromList(List newTables) {
            HashMap<String, DatastoreContainerObject> map = new HashMap<String, DatastoreContainerObject>();
            for (int i = 0; i < newTables.size(); ++i) {
                DatastoreContainerObject t1 = (DatastoreContainerObject)newTables.get(i);
                if (map.containsKey(t1.getIdentifier().getIdentifier())) {
                    return true;
                }
                map.put(t1.getIdentifier().getIdentifier(), t1);
            }
            return false;
        }

        private List[] performViewsValidation(List viewsToValidate) throws SQLException {
            ArrayList<ViewImpl> viewsCreated = new ArrayList<ViewImpl>();
            ArrayList autoCreateErrors = new ArrayList();
            for (ViewImpl v : viewsToValidate) {
                if (RDBMSManager.this.checkExistTablesOrViews && v.exists(this.getCurrentConnection(), RDBMSManager.this.autoCreateTables)) {
                    viewsCreated.add(v);
                }
                if (RDBMSManager.this.validateTables) {
                    v.validate(this.getCurrentConnection(), true, false, autoCreateErrors);
                }
                RDBMSManager.this.invalidateColumnInfoForTable(v);
            }
            return new List[]{viewsCreated, autoCreateErrors};
        }

        private void verifyErrors(List autoCreateErrors) {
            if (autoCreateErrors.size() > 0) {
                for (Throwable exc : autoCreateErrors) {
                    if (RDBMSManager.this.autoCreateWarnOnError) {
                        NucleusLogger.DATASTORE.warn((Object)LOCALISER_RDBMS.msg("050044", (Object)exc));
                        continue;
                    }
                    NucleusLogger.DATASTORE.error((Object)LOCALISER_RDBMS.msg("050044", (Object)exc));
                }
                if (!RDBMSManager.this.autoCreateWarnOnError) {
                    throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("050043"), autoCreateErrors.toArray(new Throwable[autoCreateErrors.size()]));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rollbackSchemaCreation(List viewsCreated, List tableConstraintsCreated, List tablesCreated) {
            if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_RDBMS.msg("050040"));
            }
            try {
                ListIterator li;
                if (viewsCreated != null) {
                    li = viewsCreated.listIterator(viewsCreated.size());
                    while (li.hasPrevious()) {
                        ((ViewImpl)li.previous()).drop(this.getCurrentConnection());
                    }
                }
                if (tableConstraintsCreated != null) {
                    li = tableConstraintsCreated.listIterator(tableConstraintsCreated.size());
                    while (li.hasPrevious()) {
                        ((TableImpl)li.previous()).dropConstraints(this.getCurrentConnection());
                    }
                }
                if (tablesCreated != null) {
                    li = tablesCreated.listIterator(tablesCreated.size());
                    while (li.hasPrevious()) {
                        ((TableImpl)li.previous()).drop(this.getCurrentConnection());
                    }
                }
            }
            catch (Exception e) {
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER_RDBMS.msg("050041", (Object)e));
            }
            if (RDBMSManager.this.starter != null && RDBMSManager.this.starterInitialised) {
                try {
                    if (!RDBMSManager.this.starter.isOpen()) {
                        RDBMSManager.this.starter.open();
                    }
                    for (RDBMSStoreData sd : this.schemaDataAdded) {
                        RDBMSManager.this.starter.deleteClass(sd.getName());
                    }
                }
                finally {
                    if (RDBMSManager.this.starter.isOpen()) {
                        RDBMSManager.this.starter.close();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DatastoreContainerObject addJoinTableForContainer(AbstractMemberMetaData fmd, ClassLoaderResolver clr, int type) {
            RDBMSStoreData data;
            DatastoreIdentifier tableName = null;
            RDBMSStoreData sd = (RDBMSStoreData)RDBMSManager.this.storeDataMgr.get(fmd);
            tableName = sd != null && sd.getDatastoreIdentifier() != null ? sd.getDatastoreIdentifier() : RDBMSManager.this.identifierFactory.newDatastoreContainerIdentifier(clr, fmd);
            JoinTable join = null;
            if (type == 1) {
                join = new CollectionTable(tableName, fmd, RDBMSManager.this);
            } else if (type == 2) {
                join = new MapTable(tableName, fmd, RDBMSManager.this);
            } else if (type == 3) {
                join = new ArrayTable(tableName, fmd, RDBMSManager.this);
            }
            try {
                if (RDBMSManager.this.starter != null && RDBMSManager.this.starterInitialised && !RDBMSManager.this.starter.isOpen()) {
                    RDBMSManager.this.starter.open();
                }
                data = new RDBMSStoreData(fmd, join);
                RDBMSManager.this.registerStoreData(data);
            }
            finally {
                if (RDBMSManager.this.starter != null && RDBMSManager.this.starterInitialised && RDBMSManager.this.starter.isOpen()) {
                    RDBMSManager.this.starter.close();
                }
            }
            this.schemaDataAdded.add(data);
            return join;
        }
    }
}

