/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StatementText;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

public class UnboundVariable
extends ScalarExpression {
    private final String name;
    private Class type;
    private final VariableBinder binder;
    ScalarExpression exprToBind = null;

    public UnboundVariable(QueryExpression qs, String name, Class type, VariableBinder binder) {
        super(qs);
        this.name = name;
        this.type = type;
        this.binder = binder;
        this.getExpressionToBindToThis();
    }

    public String getVariableName() {
        return this.name;
    }

    public LogicSetExpression getLogicSetExpression() {
        if (this.te == null) {
            ScalarExpression boundExpr = this.getExpressionToBindToThis();
            if (boundExpr == null) {
                return null;
            }
            return boundExpr.getLogicSetExpression();
        }
        return this.te;
    }

    public Class getVariableType() {
        return this.type;
    }

    public void setVariableType(Class type) {
        this.type = type;
        this.getExpressionToBindToThis();
    }

    public void bindTo(ScalarExpression qsc) {
        this.binder.bindVariable(this.name, qsc);
    }

    public StatementText toStatementText(int mode) {
        ScalarExpression exprToBind = this.getExpressionToBindToThis();
        if (exprToBind == null) {
            throw new NucleusUserException("Unconstrained variable referenced: " + this.name);
        }
        if (!this.qs.hasCrossJoin(exprToBind.te)) {
            this.qs.crossJoin(exprToBind.te, true);
        }
        return exprToBind.toStatementText(mode);
    }

    public ScalarExpression.ExpressionList getExpressionList() {
        ScalarExpression exprToBind = this.getExpressionToBindToThis();
        if (exprToBind == null) {
            throw new NucleusUserException("Unconstrained variable referenced: " + this.name);
        }
        if (!this.qs.hasCrossJoin(exprToBind.te)) {
            this.qs.crossJoin(exprToBind.te, true);
        }
        return exprToBind.getExpressionList();
    }

    public StatementText toStatementText() {
        throw new NucleusUserException("Unconstrained variable referenced: " + this.name);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        ScalarExpression boundExpr = this.getExpressionToBindToThis();
        this.bindTo(boundExpr);
        if (this.qs.hasCrossJoin(boundExpr.te)) {
            this.qs.andCondition(expr.eq(boundExpr));
        } else {
            this.qs.innerJoin(expr, boundExpr, boundExpr.te, true, true);
        }
        return expr.eq(boundExpr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        ScalarExpression boundExpr = this.getExpressionToBindToThis();
        this.bindTo(boundExpr);
        if (!this.qs.hasCrossJoin(boundExpr.te)) {
            this.qs.innerJoin(expr, boundExpr, boundExpr.te, false, true);
        }
        return expr.noteq(boundExpr);
    }

    public ScalarExpression accessField(String fieldName, boolean innerJoin) {
        ScalarExpression exprToBind = this.getExpressionToBindToThis();
        this.bindTo(exprToBind);
        this.qs.crossJoin(exprToBind.getLogicSetExpression(), true);
        return exprToBind.accessField(fieldName, innerJoin);
    }

    private ScalarExpression getExpressionToBindToThis() {
        if (this.exprToBind != null) {
            return this.exprToBind;
        }
        if (this.type == null) {
            return null;
        }
        ApiAdapter api = this.qs.getStoreManager().getApiAdapter();
        if (!api.isPersistable(this.type)) {
            return null;
        }
        AbstractClassMetaData typeCmd = this.qs.getStoreManager().getOMFContext().getMetaDataManager().getMetaDataForClass(this.type, this.qs.getClassLoaderResolver());
        if (typeCmd.isEmbeddedOnly()) {
            return null;
        }
        String jtJavaName = "UNBOUND." + this.getVariableName();
        DatastoreClass cbt = this.qs.getStoreManager().getDatastoreClass(this.type.getName(), this.qs.getClassLoaderResolver());
        DatastoreIdentifier jtRangeVar = this.qs.getStoreManager().getIdentifierFactory().newIdentifier(0, jtJavaName);
        LogicSetExpression jtExpr = this.qs.getTableExpression(jtRangeVar);
        if (jtExpr == null) {
            jtExpr = this.qs.newTableExpression(cbt, jtRangeVar);
        }
        JavaTypeMapping mb = cbt.getIDMapping();
        ScalarExpression exprBindTo = mb.newScalarExpression(this.qs, jtExpr);
        this.mapping = mb;
        this.exprToBind = exprBindTo;
        return exprBindTo;
    }

    public static interface VariableBinder {
        public void bindVariable(String var1, ScalarExpression var2);
    }
}

