/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringExpression;
import org.datanucleus.store.mapped.expression.TableExprAsJoins;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Table;

public class SybaseAdapter
extends DatabaseAdapter {
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$math$BigInteger;

    public SybaseAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("BooleanExpression");
        this.supportedOptions.remove("LockWithSelectForUpdate");
        this.supportedOptions.remove("AutoIncrementNullSpecification");
    }

    public String getVendorID() {
        return "sybase";
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        SQLTypeInfo info = new SQLTypeInfo(rs);
        if (info.getTypeName().toLowerCase().startsWith("tinyint")) {
            return null;
        }
        if (info.getTypeName().toLowerCase().startsWith("longsysname")) {
            return null;
        }
        return info;
    }

    public RDBMSColumnInfo newRDBMSColumnInfo(ResultSet rs) {
        RDBMSColumnInfo info = new RDBMSColumnInfo(rs);
        short dataType = info.getDataType();
        switch (dataType) {
            case 91: 
            case 92: 
            case 93: {
                info.setDecimalDigits(0);
                break;
            }
        }
        return info;
    }

    public String getAutoIncrementStmt(Table table, String columnName) {
        return "SELECT @@IDENTITY";
    }

    public String getAutoIncrementKeyword() {
        return "IDENTITY";
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        return new TableExprAsJoins(qs, table, rangeVar);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$lang$Integer == null ? (class$java$lang$Integer = SybaseAdapter.class$("java.lang.Integer")) : class$java$lang$Integer, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        args.add(this.getNumericExpressionForMethod("length", str).sub(begin));
        return new StringExpression("SUBSTRING", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin, NumericExpression end) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = SybaseAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        args.add(end.sub(begin));
        return new StringExpression("SUBSTRING", args);
    }

    public NumericExpression indexOfMethod(ScalarExpression source, ScalarExpression str, NumericExpression from) {
        ScalarExpression integerLiteral = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = SybaseAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, source).newLiteral(source.getQueryExpression(), BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(source);
        if (from != null) {
            args.add(new NumericExpression(from, ScalarExpression.OP_ADD, integerLiteral));
        }
        NumericExpression locateExpr = new NumericExpression("CHARINDEX", args);
        return new NumericExpression(locateExpr, ScalarExpression.OP_SUB, integerLiteral);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

