/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringExpression;
import org.datanucleus.store.mapped.expression.TableExprAsJoins;
import org.datanucleus.store.rdbms.ConnectionProvider;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.schema.McKoiTypeInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;

public class McKoiAdapter
extends DatabaseAdapter {
    private static final String MCKOI_RESERVED_WORDS = "ACCOUNT,ACTION,ADD,AFTER,ALL,ALTER,AND,ANY,AS,ASC,AUTO,BEFORE,BETWEEN,BIGINT,BINARY,BIT,BLOB,BOOLEAN,BOTH,BY,CACHE,CALL,CALLBACK,CANONICAL_DECOMPOSITION,CASCADE,CAST,CHAR,CHARACTER,CHECK,CLOB,COLLATE,COLUMN,COMMIT,COMMITTED,COMPACT,CONSTRAINT,COUNT,CREATE,CROSS,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CYCLE,DATE,DECIMAL,DEFAULT,DEFERRABLE,DEFERRED,DELETE,DESC,DESCRIBE,DISTINCT,DOUBLE,DROP,EACH,EXCEPT,EXECUTE,EXISTS,EXPLAIN,FLOAT,FOR,FOREIGN,FROM,FULL_DECOMPOSITION,FUNCTION,GRANT,GROUP,GROUPS,HAVING,IDENTICAL_STRENGTH,IF,IGNORE,IMMEDIATE,IN,INCREMENT,INDEX,INDEX_BLIST,INDEX_NONE,INITIALLY,INNER,INSERT,INT,INTEGER,INTERSECT,INTO,IS,ISOLATION,JAVA,JAVA_OBJECT,JOIN,KEY,LANGUAGE,LEADING,LEFT,LEVEL,LIKE,LIMIT,LOCK,LONG,LONGVARBINARY,LONGVARCHAR,MAX,MAXVALUE,MINVALUE,NAME,NATURAL,NEW,NO,NO_DECOMPOSITION,NOT,NUMERIC,OLD,ON,OPTIMIZE,OPTION,OR,ORDER,OUTER,PASSWORD,PRIMARY,PRIMARY_STRENGTH,PRIVILEGES,PROCEDURE,PUBLIC,READ,REAL,REFERENCES,REGEX,REPEATABLE,RESTRICT,RETURN,RETURNS,REVOKE,RIGHT,ROLLBACK,ROW,SCHEMA,SECONDARY_STRENGTH,SELECT,SEQUENCE,SERIALIZABLE,SET,SHOW,SHUTDOWN,SMALLINT,SOME,START,STRING,TABLE,TEMPORARY,TERTIARY_STRENGTH,TEXT,TIME,TIMESTAMP,TINYINT,TO,TRAILING,TRANSACTION,TRIGGER,TRIM,UNCOMMITTED,UNION,UNIQUE,UNLOCK,UPDATE,USAGE,USE,USER,USING,VALUES,VARBINARY,VARCHAR,VARYING,VIEW,WHERE,WITH";
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$math$BigInteger;

    public McKoiAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.reservedKeywords.addAll(this.parseKeywordList(MCKOI_RESERVED_WORDS));
        this.supportedOptions.add("Sequences");
        this.supportedOptions.add("UseUnionAll");
        this.supportedOptions.remove("EscapeExpressionInLikePredicate");
    }

    public String getVendorID() {
        return "mckoi";
    }

    public boolean isSQLKeyword(String word) {
        return true;
    }

    public int getMaxTableNameLength() {
        return 128;
    }

    public int getMaxConstraintNameLength() {
        return 128;
    }

    public int getMaxIndexNameLength() {
        return 128;
    }

    public int getMaxColumnNameLength() {
        return 128;
    }

    public String getAddColumnStatement(DatastoreContainerObject table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD COLUMN " + col.getSQLDefinition();
    }

    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new McKoiTypeInfo(rs);
    }

    public boolean supportsTransactionIsolationLevel(int isolationLevel) {
        return isolationLevel == 8;
    }

    public int getRequiredTransactionIsolationLevel() {
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(ConnectionProvider connProvider, DataSource[] ds, int isolationLevel) throws SQLException {
        Connection conn = connProvider.getConnection(ds);
        boolean succeeded = false;
        try {
            conn.setAutoCommit(true);
            conn.setTransactionIsolation(8);
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                conn.close();
            }
        }
        return conn;
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        return new TableExprAsJoins(qs, table, rangeVar);
    }

    public NumericExpression getNumericExpressionForMethod(String method, ScalarExpression expr) {
        if (method.equalsIgnoreCase("length")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            args.add(expr);
            return new NumericExpression("LENGTH", args);
        }
        return super.getNumericExpressionForMethod(method, expr);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$lang$Integer == null ? (class$java$lang$Integer = McKoiAdapter.class$("java.lang.Integer")) : class$java$lang$Integer, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        args.add(this.getNumericExpressionForMethod("length", str).sub(begin));
        return new StringExpression("SUBSTRING", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin, NumericExpression end) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = McKoiAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        args.add(end.sub(begin));
        return new StringExpression("SUBSTRING", args);
    }

    public String getSequenceCreateStmt(String sequence_name, String min, String max, String start, String increment, String cache_size) {
        if (sequence_name == null) {
            throw new UnsupportedOperationException("Adapter.SequenceNameNullNotSupported");
        }
        StringBuffer stmt = new StringBuffer("CREATE SEQUENCE ");
        stmt.append(sequence_name);
        if (increment != null && increment.length() > 0) {
            stmt.append(" INCREMENT " + increment);
        }
        if (min != null && min.length() > 0) {
            stmt.append(" MINVALUE " + min);
        }
        if (max != null && max.length() > 0) {
            stmt.append(" MAXVALUE " + max);
        }
        if (start != null && start.length() > 0) {
            stmt.append(" START " + start);
        }
        if (cache_size != null && cache_size.length() > 0) {
            stmt.append(" CACHE " + cache_size);
        }
        return stmt.toString();
    }

    public String getSequenceNextStmt(String sequence_name) {
        if (sequence_name == null) {
            throw new UnsupportedOperationException("Adapter.SequenceNameNullNotSupported");
        }
        StringBuffer stmt = new StringBuffer("SELECT ");
        stmt.append(" NEXTVAL('" + sequence_name + "') ");
        return stmt.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

