/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ManagedConnectionResourceListener;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementExpressionIndex;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.query.AbstractSQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.store.rdbms.query.ForwardQueryResult;
import org.datanucleus.store.rdbms.query.PersistentIDROF;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.query.ResultMetaDataROF;
import org.datanucleus.store.rdbms.query.SQLEvaluator;
import org.datanucleus.store.rdbms.query.SQLQueryCompiler;
import org.datanucleus.store.rdbms.query.ScrollableQueryResult;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public final class SQLQuery
extends AbstractSQLQuery {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)(class$org$datanucleus$store$rdbms$RDBMSManager == null ? (class$org$datanucleus$store$rdbms$RDBMSManager = SQLQuery.class$("org.datanucleus.store.rdbms.RDBMSManager")) : class$org$datanucleus$store$rdbms$RDBMSManager).getClassLoader());
    protected transient boolean isCompiled = false;
    static /* synthetic */ Class class$org$datanucleus$store$rdbms$RDBMSManager;

    public SQLQuery(ObjectManager om, SQLQuery query) {
        super(om, (AbstractSQLQuery)query);
    }

    public SQLQuery(ObjectManager om) {
        super(om, (String)null);
    }

    public SQLQuery(ObjectManager om, String queryString) {
        super(om, queryString);
        String firstToken = new StringTokenizer(queryString, " ").nextToken();
        if (firstToken.equalsIgnoreCase("DELETE")) {
            ((Query)this).type = (short)2;
            ((Query)this).unique = true;
        } else if (firstToken.equalsIgnoreCase("INSERT") || firstToken.equalsIgnoreCase("UPDATE") || firstToken.equalsIgnoreCase("MERGE")) {
            ((Query)this).type = 1;
            ((Query)this).unique = true;
        }
        if (om.getApiAdapter().getName().equalsIgnoreCase("JDO") && !om.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.rdbms.sql.allowAllSQLStatements") && !firstToken.equals("SELECT") && !firstToken.startsWith("select")) {
            throw new NucleusUserException(Query.LOCALISER.msg("059002", (Object)this.inputSQL));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SQLQuery) || !super.equals(obj)) {
            return false;
        }
        return this.inputSQL.equals(((SQLQuery)((Object)obj)).inputSQL);
    }

    protected void discardCompiled() {
        this.isCompiled = false;
        super.discardCompiled();
    }

    protected boolean isCompiled() {
        return this.isCompiled;
    }

    public void compileInternal(boolean forExecute, Map parameterValues) {
        if (this.isCompiled) {
            return;
        }
        if (forExecute) {
            SQLQueryCompiler c = new SQLQueryCompiler(this, this.getParsedImports(), parameterValues);
            this.compiledSQL = (String)c.compile(4);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Query.LOCALISER.msg("059012", (Object)this.compiledSQL));
            }
        } else {
            SQLQueryCompiler c = new SQLQueryCompiler(this, this.getParsedImports(), parameterValues);
            this.compiledSQL = (String)c.compile(3);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Query.LOCALISER.msg("059012", (Object)this.compiledSQL));
            }
        }
        this.isCompiled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected Object performExecute(Map parameters) {
        if (parameters.size() != (((Query)this).parameterNames != null ? ((Query)this).parameterNames.length : 0)) {
            throw new NucleusUserException(LOCALISER_RDBMS.msg("059019", (Object)("" + ((Query)this).parameterNames.length), (Object)("" + parameters.size())));
        }
        if (((Query)this).type == 0) {
            SQLQueryEvaluator eval = new SQLQueryEvaluator((Query)this, parameters);
            QueryResult qr = (QueryResult)((SQLEvaluator)eval).evaluate(null);
            ((Query)this).queryResults.add(qr);
            return qr;
        }
        try {
            RDBMSManager storeMgr = (RDBMSManager)((Query)this).om.getStoreManager();
            ManagedConnection mconn = storeMgr.getConnection(((Query)this).om);
            SQLController sqlControl = storeMgr.getSQLController();
            try {
                Long l;
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.compiledSQL, false);
                try {
                    if (parameters != null) {
                        for (int i = 0; i < parameters.size(); ++i) {
                            Object obj = parameters.get(new Integer(i + 1));
                            ps.setObject(i + 1, obj);
                        }
                    }
                    int[] rcs = sqlControl.executeStatementUpdate(mconn, this.compiledSQL, ps, true);
                    l = new Long(rcs[0]);
                }
                catch (Throwable throwable) {
                    sqlControl.closeStatement(mconn, ps);
                    throw throwable;
                }
                sqlControl.closeStatement(mconn, ps);
                return l;
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Query.LOCALISER.msg("059025", (Object)this.compiledSQL), (Throwable)e);
        }
    }

    public static boolean columnNamesAreTheSame(DatastoreAdapter dba, String name1, String name2) {
        return name1.equalsIgnoreCase(name2) || name1.equalsIgnoreCase(dba.getIdentifierQuoteString() + name2 + dba.getIdentifierQuoteString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SQLQueryEvaluator
    extends SQLEvaluator {
        Map parameters;
        StatementExpressionIndex[] statementExpressionIndex;

        public SQLQueryEvaluator(Query query, Map parameters) {
            super(query, null, null);
            this.parameters = parameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object evaluate(QueryExpression queryStmt) {
            AbstractRDBMSQueryResult qr = null;
            try {
                RDBMSManager storeMgr = (RDBMSManager)this.om.getStoreManager();
                ManagedConnection mconn = storeMgr.getConnection(this.om);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = RDBMSQueryUtils.getPreparedStatementForQuery(mconn, SQLQuery.this.compiledSQL, this.query);
                    try {
                        if (this.parameters != null) {
                            for (int i = 0; i < this.parameters.size(); ++i) {
                                Object obj = this.parameters.get(new Integer(i + 1));
                                ps.setObject(i + 1, obj);
                            }
                        }
                        RDBMSQueryUtils.prepareStatementForExecution(ps, this.query);
                        ResultSet rs = sqlControl.executeStatementQuery(mconn, SQLQuery.this.compiledSQL, ps);
                        try {
                            this.rof = SQLQuery.this.resultMetaData != null ? new ResultMetaDataROF(SQLQuery.this.resultMetaData) : (((Query)SQLQuery.this).resultClass != null || ((Query)SQLQuery.this).candidateClass == null ? this.getResultObjectFactoryForNoCandidateClass(rs, ((Query)SQLQuery.this).resultClass) : this.getResultObjectFactoryForCandidateClass(rs));
                            String resultSetType = RDBMSQueryUtils.getResultSetTypeForQuery(this.query);
                            qr = resultSetType.equals("scroll-insensitive") || resultSetType.equals("scroll-sensitive") ? new ScrollableQueryResult(null, this.query, this.rof, rs, null) : new ForwardQueryResult(null, this.query, this.rof, rs, null);
                            final ScrollableQueryResult qr1 = qr;
                            final ManagedConnection mconn1 = mconn;
                            mconn.addListener(new ManagedConnectionResourceListener(){

                                public void managedConnectionFlushed() {
                                    qr1.disconnect();
                                }

                                public void managedConnectionPreClose() {
                                }

                                public void managedConnectionPostClose() {
                                }

                                public void resourcePostClose() {
                                    mconn1.removeListener((ManagedConnectionResourceListener)this);
                                }
                            });
                        }
                        finally {
                            if (qr == null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (qr == null) {
                            sqlControl.closeStatement(mconn, ps);
                        }
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(SQLEvaluator.LOCALISER.msg("059025", (Object)SQLQuery.this.compiledSQL), (Throwable)e);
            }
            return qr;
        }

        private ResultObjectFactory getResultObjectFactoryForCandidateClass(ResultSet rs) throws SQLException {
            int i;
            ClassLoaderResolver clr = this.om.getClassLoaderResolver();
            MappedStoreManager storeMgr = (MappedStoreManager)this.om.getStoreManager();
            DatastoreAdapter dba = storeMgr.getDatastoreAdapter();
            AbstractClassMetaData candidateCmd = this.om.getMetaDataManager().getMetaDataForClass(((Query)SQLQuery.this).candidateClass, clr);
            int fieldCount = candidateCmd.getNoOfManagedMembers() + candidateCmd.getNoOfInheritedManagedMembers();
            HashMap<String, Integer> columnFieldNumberMap = new HashMap<String, Integer>();
            this.statementExpressionIndex = new StatementExpressionIndex[fieldCount];
            DatastoreClass tbl = storeMgr.getDatastoreClass(((Query)SQLQuery.this).candidateClass.getName(), clr);
            for (int fieldNumber = 0; fieldNumber < fieldCount; ++fieldNumber) {
                this.statementExpressionIndex[fieldNumber] = new StatementExpressionIndex();
                AbstractMemberMetaData fmd = candidateCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                String fieldName = fmd.getName();
                Class fieldType = fmd.getType();
                if (fmd.getPersistenceModifier() == FieldPersistenceModifier.NONE) continue;
                JavaTypeMapping m = null;
                m = tbl != null ? tbl.getFieldMapping(fmd) : dba.getMapping(fieldType, storeMgr, clr);
                if (!m.includeInFetchStatement()) continue;
                this.statementExpressionIndex[fieldNumber].setMapping(m);
                String columnName = null;
                if (fmd.getColumnMetaData() != null && fmd.getColumnMetaData().length > 0) {
                    for (int colNum = 0; colNum < fmd.getColumnMetaData().length; ++colNum) {
                        columnName = fmd.getColumnMetaData()[colNum].getName();
                        columnFieldNumberMap.put(columnName, new Integer(fieldNumber));
                    }
                    continue;
                }
                columnName = storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(fieldName, this.om.getOMFContext().getTypeManager().isDefaultEmbeddedType(fieldType), 0).getIdentifier();
                columnFieldNumberMap.put(columnName, new Integer(fieldNumber));
            }
            if (columnFieldNumberMap.size() == 0) {
                throw new NucleusUserException("SQL query class has no persistent fields in the SELECT : " + ((Query)SQLQuery.this).candidateClass.getName()).setFatal();
            }
            DatastoreClass table = storeMgr.getDatastoreClass(((Query)SQLQuery.this).candidateClass.getName(), clr);
            PersistenceCapableMapping idMapping = (PersistenceCapableMapping)table.getIDMapping();
            String[] idColNames = new String[idMapping.getNumberOfDatastoreFields()];
            boolean[] idColMissing = new boolean[idMapping.getNumberOfDatastoreFields()];
            for (int i2 = 0; i2 < idMapping.getNumberOfDatastoreFields(); ++i2) {
                DatastoreMapping m = idMapping.getDataStoreMapping(i2);
                idColNames[i2] = ((Object)m.getDatastoreField().getIdentifier()).toString();
                idColMissing[i2] = true;
            }
            String discriminatorColName = table.getDiscriminatorMapping(false) != null ? ((Object)table.getDiscriminatorMapping(false).getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString() : null;
            String versionColName = table.getVersionMapping(false) != null ? ((Object)table.getVersionMapping(false).getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString() : null;
            boolean discrimMissing = discriminatorColName != null;
            boolean versionMissing = true;
            if (versionColName == null) {
                versionMissing = false;
            }
            ResultSetMetaData rsmd = rs.getMetaData();
            HashSet remainingColumnNames = new HashSet(columnFieldNumberMap.size());
            int colCount = rsmd.getColumnCount();
            int[] datastoreIndex = null;
            int[] versionIndex = null;
            int[] matchedFieldNumbers = new int[colCount];
            int fieldNumberPosition = 0;
            for (int colNum = 1; colNum <= colCount; ++colNum) {
                String colName = rsmd.getColumnName(colNum);
                int fieldNumber = -1;
                Integer fieldNum = (Integer)columnFieldNumberMap.get(colName);
                if (fieldNum != null) {
                    fieldNumber = fieldNum;
                }
                if (fieldNumber >= 0) {
                    int[] exprIndices = null;
                    if (this.statementExpressionIndex[fieldNumber].getExpressionIndex() != null) {
                        exprIndices = new int[this.statementExpressionIndex[fieldNumber].getExpressionIndex().length + 1];
                        for (int i3 = 0; i3 < this.statementExpressionIndex[fieldNumber].getExpressionIndex().length; ++i3) {
                            exprIndices[i3] = this.statementExpressionIndex[fieldNumber].getExpressionIndex()[i3];
                        }
                        exprIndices[exprIndices.length - 1] = colNum;
                    } else {
                        exprIndices = new int[]{colNum};
                    }
                    this.statementExpressionIndex[fieldNumber].setExpressionIndex(exprIndices);
                    remainingColumnNames.remove(colName);
                    matchedFieldNumbers[fieldNumberPosition++] = fieldNumber;
                }
                if (versionColName != null && colName.equals(versionColName)) {
                    versionIndex = new int[]{colNum};
                    versionMissing = false;
                }
                if (candidateCmd.getIdentityType() == IdentityType.DATASTORE) {
                    if (SQLQuery.columnNamesAreTheSame(dba, idColNames[0], colName)) {
                        datastoreIndex = new int[]{colNum};
                        idColMissing[0] = false;
                    }
                } else if (candidateCmd.getIdentityType() == IdentityType.APPLICATION) {
                    for (int j = 0; j < idColNames.length; ++j) {
                        if (!SQLQuery.columnNamesAreTheSame(dba, idColNames[j], colName)) continue;
                        idColMissing[j] = false;
                    }
                }
                if (discrimMissing && SQLQuery.columnNamesAreTheSame(dba, discriminatorColName, colName)) {
                    discrimMissing = false;
                    continue;
                }
                if (!versionMissing || !SQLQuery.columnNamesAreTheSame(dba, versionColName, colName)) continue;
                versionMissing = false;
            }
            int[] fieldNumbers = new int[fieldNumberPosition];
            for (i = 0; i < fieldNumberPosition; ++i) {
                fieldNumbers[i] = matchedFieldNumbers[i];
            }
            if (discrimMissing) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("059014", (Object)SQLQuery.this.inputSQL, (Object)((Query)SQLQuery.this).candidateClass.getName(), (Object)discriminatorColName));
            }
            if (versionMissing) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("059015", (Object)SQLQuery.this.inputSQL, (Object)((Query)SQLQuery.this).candidateClass.getName(), (Object)versionColName));
            }
            for (i = 0; i < idColMissing.length; ++i) {
                if (!idColMissing[i]) continue;
                throw new NucleusUserException(LOCALISER_RDBMS.msg("059013", (Object)SQLQuery.this.inputSQL, (Object)((Query)SQLQuery.this).candidateClass.getName(), (Object)idColNames[i]));
            }
            return new PersistentIDROF(table, fieldNumbers, candidateCmd, this.statementExpressionIndex, datastoreIndex, versionIndex, ((Query)SQLQuery.this).ignoreCache, false, false, SQLQuery.this.getFetchPlan(), this.query.getCandidateClass());
        }
    }
}

