/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.oracle;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.BitSet;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.mapped.mapping.BitSetMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.datatype.BlobImpl;
import org.datanucleus.store.rdbms.mapping.oracle.OracleBlobRDBMSMapping;
import org.datanucleus.util.TypeConversionHelper;

public class OracleBitSetMapping
extends BitSetMapping
implements MappingCallbacks {
    public void postInsert(StateManager sm) {
        Object value = sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        byte[] bytes = new byte[]{};
        try {
            if (this.fmd.isSerialized()) {
                if (!(value instanceof Serializable)) {
                    throw new NucleusDataStoreException(JavaTypeMapping.LOCALISER.msg("055005", (Object)value.getClass().getName()));
                }
                BlobImpl b = new BlobImpl(value);
                bytes = b.getBytes(0L, (int)b.length());
            } else if (value instanceof BitSet) {
                bytes = TypeConversionHelper.getByteArrayFromBooleanArray((Object)TypeConversionHelper.getBooleanArrayFromBitSet((BitSet)((BitSet)value)));
            } else {
                if (!(value instanceof Serializable)) {
                    throw new NucleusDataStoreException(JavaTypeMapping.LOCALISER.msg("055005", (Object)value.getClass().getName()));
                }
                BlobImpl b = new BlobImpl(value);
                bytes = b.getBytes(0L, (int)b.length());
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(JavaTypeMapping.LOCALISER.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.fmd, (Object)e.getMessage()), (Throwable)e);
        }
        catch (IOException e1) {
            // empty catch block
        }
        OracleBlobRDBMSMapping.updateBlobColumn(sm, this.getDatastoreContainer(), this.getDataStoreMapping(0), bytes);
    }

    public void postUpdate(StateManager sm) {
        this.postInsert(sm);
    }

    public void deleteDependent(StateManager sm) {
    }

    public void postFetch(StateManager sm) {
    }

    public void preDelete(StateManager sm) {
    }
}

