/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.datanucleus.ManagedConnection;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringExpression;
import org.datanucleus.store.mapped.expression.StringLiteral;
import org.datanucleus.store.mapped.expression.TableExprAsJoins;
import org.datanucleus.store.mapped.expression.TableExprAsSubquery;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.schema.DB2TypeInfo;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;

public class DB2Adapter
extends DatabaseAdapter {
    public static final String DB2_RESERVED_WORDS = "ACCESS,ALIAS,ALLOW,ASUTIME,AUDIT,AUX,AUXILIARY,BUFFERPOOL,CAPTURE,CCSID,CLUSTER,COLLECTION,COLLID,COMMENT,CONCAT,CONTAINS,COUNT_BIG,CURRENT_LC_PATH,CURRENT_SERVER,CURRENT_TIMEZONE,DATABASE,DAYS,DB2GENERAL,DB2SQL,DBA,DBINFO,DBSPACE,DISALLOW,DSSIZE,EDITPROC,ERASE,EXCLUSIVE,EXPLAIN,FENCED,FIELDPROC,FILE,FINAL,GENERATED,GRAPHIC,HOURS,IDENTIFIED,INDEX,INTEGRITY,ISOBID,JAVA,LABEL,LC_CTYPE,LINKTYPE,LOCALE,LOCATORS,LOCK,LOCKSIZE,LONG,MICROSECOND,MICROSECONDS,MINUTES,MODE,MONTHS,NAME,NAMED,NHEADER,NODENAME,NODENUMBER,NULLS,NUMPARTS,OBID,OPTIMIZATION,OPTIMIZE,PACKAGE,PAGE,PAGES,PART,PCTFREE,PCTINDEX,PIECESIZE,PLAN,PRIQTY,PRIVATE,PROGRAM,PSID,QYERYNO,RECOVERY,RENAME,RESET,RESOURCE,RRN,RUN,SCHEDULE,SCRATCHPAD,SECONDS,SECQTY,SECURITY,SHARE,SIMPLE,SOURCE,STANDARD,STATISTICS,STAY,STOGROUP,STORES,STORPOOL,STYLE,SUBPAGES,SYNONYM,TABLESPACE,TYPE,VALIDPROC,VARIABLE,VARIANT,VCAT,VOLUMES,WLM,YEARS";
    static /* synthetic */ Class class$java$math$BigInteger;

    public DB2Adapter(DatabaseMetaData metadata) {
        super(metadata);
        this.reservedKeywords.addAll(this.parseKeywordList(DB2_RESERVED_WORDS));
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.remove("BooleanExpression");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("NullsInCandidateKeys");
        this.supportedOptions.remove("ColumnOptions_NullsKeyword");
    }

    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        DB2TypeInfo sqlType = new DB2TypeInfo("FLOAT", 6, 53, null, null, null, 1, false, 2, false, false, false, null, 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)6, sqlType, true);
        sqlType = new DB2TypeInfo("NUMERIC", 2, 31, null, null, "PRECISION,SCALE", 1, false, 2, false, false, false, null, 0, 31, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2, sqlType, true);
        sqlType = new DB2TypeInfo("BIGINT", -5, 20, null, null, null, 1, false, 2, false, true, false, null, 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-5, sqlType, true);
    }

    public String getVendorID() {
        return "db2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSchemaName(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        try {
            String string;
            String stmtText = "VALUES (CURRENT SCHEMA)";
            ResultSet rs = stmt.executeQuery(stmtText);
            try {
                if (!rs.next()) {
                    throw new NucleusDataStoreException("No result returned from " + stmtText).setFatal();
                }
                string = rs.getString(1).trim();
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return string;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Connection conn) throws SQLException {
        try {
            conn.rollback();
        }
        catch (Exception exception) {
        }
        finally {
            conn.close();
        }
    }

    public int getMaxConstraintNameLength() {
        return 18;
    }

    public int getMaxIndexNameLength() {
        return 18;
    }

    public boolean supportsForeignKeyUpdateAction(ForeignKey.FKAction action) {
        return action.equals(ForeignKey.RESTRICT_ACTION);
    }

    public boolean supportsForeignKeyDeleteAction(ForeignKey.FKAction action) {
        return action.equals(ForeignKey.CASCADE_ACTION) || action.equals(ForeignKey.RESTRICT_ACTION) || action.equals(ForeignKey.NULL_ACTION);
    }

    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new DB2TypeInfo(rs);
    }

    public RDBMSColumnInfo newRDBMSColumnInfo(ResultSet rs) {
        RDBMSColumnInfo info = new RDBMSColumnInfo(rs);
        short dataType = info.getDataType();
        switch (dataType) {
            case 91: 
            case 92: 
            case 93: {
                info.setDecimalDigits(0);
                break;
            }
        }
        return info;
    }

    public int getUnlimitedLengthPrecisionValue(SQLTypeInfo typeInfo) {
        if (typeInfo.getDataType() == 2004 || typeInfo.getDataType() == 2005) {
            return 0x40000000;
        }
        return super.getUnlimitedLengthPrecisionValue(typeInfo);
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public String getAutoIncrementStmt(Table table, String columnName) {
        return "VALUES IDENTITY_VAL_LOCAL()";
    }

    public String getAutoIncrementKeyword() {
        return "generated always as identity (start with 1)";
    }

    public String getContinuationString() {
        return " ";
    }

    public String getSequenceCreateStmt(String sequence_name, String min, String max, String start, String increment, String cache_size) {
        if (sequence_name == null) {
            throw new NucleusUserException(DatabaseAdapter.LOCALISER.msg("Adapter.SequenceNameNullNotSupported"));
        }
        StringBuffer stmt = new StringBuffer("CREATE SEQUENCE ");
        stmt.append(sequence_name);
        stmt.append(" AS INTEGER ");
        if (start != null && start.length() > 0) {
            stmt.append(" START WITH " + start);
        }
        if (increment != null && increment.length() > 0) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (min != null && min.length() > 0) {
            stmt.append(" MINVALUE " + min);
        }
        if (max != null && max.length() > 0) {
            stmt.append(" MAXVALUE " + max);
        }
        if (cache_size != null && cache_size.length() > 0) {
            stmt.append(" CACHE " + cache_size);
        } else {
            stmt.append(" NOCACHE");
        }
        return stmt.toString();
    }

    public String getSequenceNextStmt(String sequence_name) {
        if (sequence_name == null) {
            throw new NucleusUserException(DatabaseAdapter.LOCALISER.msg("Adapter.SequenceNameNullNotSupported"));
        }
        StringBuffer stmt = new StringBuffer("VALUES NEXTVAL FOR ");
        stmt.append(sequence_name);
        return stmt.toString();
    }

    public StringExpression toStringExpression(StringLiteral expr) {
        ArrayList<StringLiteral> args = new ArrayList<StringLiteral>();
        args.add(expr);
        ArrayList<String> types = new ArrayList<String>();
        types.add("VARCHAR(32672)");
        return new StringExpression("CAST", args, types);
    }

    public StringExpression translateMethod(ScalarExpression expr, ScalarExpression toExpr, ScalarExpression fromExpr) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        args.add(toExpr);
        args.add(fromExpr);
        return new StringExpression("TRANSLATE", args);
    }

    public BooleanExpression startsWithMethod(ScalarExpression source, ScalarExpression str) {
        ScalarExpression integerLiteral = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DB2Adapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, source).newLiteral(source.getQueryExpression(), BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        if (str instanceof StringLiteral) {
            args.add(this.toStringExpression((StringLiteral)str));
        } else {
            args.add(str);
        }
        if (source instanceof StringLiteral) {
            args.add(this.toStringExpression((StringLiteral)source));
        } else {
            args.add(source);
        }
        return new BooleanExpression(new StringExpression("LOCATE", args), ScalarExpression.OP_EQ, integerLiteral);
    }

    public ScalarExpression concatOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<String> types = new ArrayList<String>();
        types.add("VARCHAR(4000)");
        ArrayList<ScalarExpression> argsOp1 = new ArrayList<ScalarExpression>();
        argsOp1.add(operand1);
        ArrayList<ScalarExpression> argsOp2 = new ArrayList<ScalarExpression>();
        argsOp2.add(operand2);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(super.concatOperator(new StringExpression("CAST", argsOp1, types), new StringExpression("CAST", argsOp2, types)));
        return new StringExpression("CAST", args, types);
    }

    public BooleanExpression endsWithMethod(ScalarExpression leftOperand, ScalarExpression rightOperand) {
        if (!(rightOperand instanceof StringExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(rightOperand);
        }
        ArrayList<String> types = new ArrayList<String>();
        types.add("VARCHAR(4000)");
        ArrayList<ScalarExpression> argsOp1 = new ArrayList<ScalarExpression>();
        argsOp1.add(leftOperand);
        StringLiteral pct = new StringLiteral(leftOperand.getQueryExpression(), leftOperand.getMapping(), '%');
        return new BooleanExpression(new StringExpression("CAST", argsOp1, types), ScalarExpression.OP_LIKE, pct.add(leftOperand.getQueryExpression().getStoreManager().getDatastoreAdapter().getEscapedPatternExpression(rightOperand)));
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        if (this.datastoreMajorVersion >= 8) {
            return new TableExprAsJoins(qs, table, rangeVar);
        }
        return new TableExprAsSubquery(qs, table, rangeVar);
    }

    public NumericExpression modOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<NumericExpression> args = new ArrayList<NumericExpression>();
        ArrayList<String> types = new ArrayList<String>();
        types.add("BIGINT");
        ArrayList<ScalarExpression> argsOp1 = new ArrayList<ScalarExpression>();
        argsOp1.add(operand1);
        args.add(new NumericExpression("CAST", argsOp1, types));
        ArrayList<ScalarExpression> argsOp2 = new ArrayList<ScalarExpression>();
        argsOp2.add(operand2);
        args.add(new NumericExpression("CAST", argsOp2, types));
        return new NumericExpression("MOD", args);
    }

    public NumericExpression getNumericExpressionForMethod(String method, ScalarExpression expr) {
        if (method.equalsIgnoreCase("length")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            args.add(expr);
            return new NumericExpression("LENGTH", args);
        }
        return super.getNumericExpressionForMethod(method, expr);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        if (str instanceof StringLiteral) {
            args.add(this.toStringExpression((StringLiteral)str));
        } else {
            args.add(str);
        }
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DB2Adapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        return new StringExpression("SUBSTR", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin, NumericExpression end) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        if (str instanceof StringLiteral) {
            args.add(this.toStringExpression((StringLiteral)str));
        } else {
            args.add(str);
        }
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DB2Adapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        args.add(end.sub(begin));
        return new StringExpression("SUBSTR", args);
    }

    public StringExpression trimMethod(StringExpression str, boolean leading, boolean trailing) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        if (leading && trailing) {
            StringExpression strExpr = new StringExpression("RTRIM", args);
            args.clear();
            args.add(strExpr);
            return new StringExpression("LTRIM", args);
        }
        if (leading) {
            return new StringExpression("LTRIM", args);
        }
        if (trailing) {
            return new StringExpression("RTRIM", args);
        }
        return str;
    }

    public NumericExpression indexOfMethod(ScalarExpression source, ScalarExpression str, NumericExpression from) {
        ScalarExpression integerLiteral = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DB2Adapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, source).newLiteral(source.getQueryExpression(), BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(source);
        ArrayList<ScalarExpression> argsOp0 = new ArrayList<ScalarExpression>();
        argsOp0.add(str);
        ArrayList<String> types = new ArrayList<String>();
        types.add("VARCHAR(4000)");
        args.add(new StringExpression("CAST", argsOp0, types));
        if (from != null) {
            types = new ArrayList();
            types.add("BIGINT");
            ArrayList<NumericExpression> argsOp1 = new ArrayList<NumericExpression>();
            argsOp1.add(new NumericExpression(from, ScalarExpression.OP_ADD, integerLiteral));
            args.add(new NumericExpression("CAST", argsOp1, types));
        }
        NumericExpression locateExpr = new NumericExpression("LOCATE", args);
        return new NumericExpression(locateExpr, ScalarExpression.OP_SUB, integerLiteral);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

