/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.query.IncompatibleQueryElementTypeException;
import org.datanucleus.store.rdbms.query.UnionIteratorStatement;
import org.datanucleus.store.rdbms.scostore.AbstractArrayStore;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class FKArrayStore
extends AbstractArrayStore {
    private String updateFkStmt;
    private String clearNullifyStmt;

    public FKArrayStore(AbstractMemberMetaData fmd, RDBMSManager storeMgr, ClassLoaderResolver clr) {
        super((StoreManager)storeMgr, clr);
        this.setOwnerMemberMetaData(fmd);
        ArrayMetaData arrmd = fmd.getArray();
        if (arrmd == null) {
            throw new NucleusUserException(BaseContainerStore.LOCALISER.msg("056000", (Object)fmd.getFullFieldName()));
        }
        this.elementType = fmd.getType().getComponentType().getName();
        Class element_class = clr.classForName(this.elementType);
        if (ClassUtils.isReferenceType((Class)element_class)) {
            this.emd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr);
            if (this.emd != null) {
                this.elementType = this.emd.getFullClassName();
            }
        } else {
            this.emd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
        }
        if (this.emd == null) {
            throw new NucleusUserException(BaseContainerStore.LOCALISER.msg("056003", (Object)element_class.getName(), (Object)fmd.getFullFieldName()));
        }
        this.elementInfo = this.getElementInformationForClass();
        if (this.elementInfo != null && this.elementInfo.length > 1) {
            throw new NucleusUserException(BaseContainerStore.LOCALISER.msg("056045", (Object)this.ownerMemberMetaData.getFullFieldName()));
        }
        this.elementMapping = this.elementInfo[0].getDatastoreClass().getIDMapping();
        this.elementsAreEmbedded = false;
        this.elementsAreSerialised = false;
        String mappedByFieldName = fmd.getMappedBy();
        if (mappedByFieldName != null) {
            AbstractMemberMetaData eofmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForMember(element_class, clr, mappedByFieldName);
            if (eofmd == null) {
                throw new NucleusUserException(BaseContainerStore.LOCALISER.msg("056024", (Object)fmd.getFullFieldName(), (Object)mappedByFieldName, (Object)element_class.getName()));
            }
            if (!clr.isAssignableFrom(eofmd.getType(), fmd.getAbstractClassMetaData().getFullClassName())) {
                throw new NucleusUserException(BaseContainerStore.LOCALISER.msg("056025", (Object)fmd.getFullFieldName(), (Object)eofmd.getFullFieldName(), (Object)eofmd.getTypeName(), (Object)fmd.getAbstractClassMetaData().getFullClassName()));
            }
            String ownerFieldName = eofmd.getName();
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getFieldMapping(eofmd);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(BaseContainerStore.LOCALISER.msg("056046", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.elementType, (Object)ownerFieldName));
            }
            if (this.isEmbeddedMapping(this.ownerMapping)) {
                throw new NucleusUserException(BaseContainerStore.LOCALISER.msg("056026", (Object)ownerFieldName, (Object)this.elementType, (Object)eofmd.getTypeName(), (Object)fmd.getClassName()));
            }
        } else {
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 5);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(BaseContainerStore.LOCALISER.msg("056047", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.elementType));
            }
        }
        this.orderMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 4);
        if (this.orderMapping == null) {
            throw new NucleusUserException(BaseContainerStore.LOCALISER.msg("056048", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.elementType));
        }
        this.relationDiscriminatorMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 6);
        if (this.relationDiscriminatorMapping != null) {
            this.relationDiscriminatorValue = fmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = fmd.getFullFieldName();
            }
        }
        this.containerTable = this.elementInfo[0].getDatastoreClass();
        if (fmd.getMappedBy() != null && this.ownerMapping.getDatastoreContainer() != this.containerTable) {
            this.containerTable = this.ownerMapping.getDatastoreContainer();
        }
    }

    protected String getClearNullifyStmt() {
        if (this.clearNullifyStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (this.elementInfo.length > 1) {
                stmt.append("?");
            } else {
                stmt.append(((Object)this.elementInfo[0].getDatastoreClass()).toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(", ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + " = NULL");
            }
            for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(", ");
                stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + " = NULL");
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(", ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + " = NULL");
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.clearNullifyStmt = stmt.toString();
        }
        return this.clearNullifyStmt;
    }

    private String getUpdateFkStmt() {
        if (this.updateFkStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (this.elementInfo.length > 1) {
                stmt.append("?");
            } else {
                stmt.append(((Object)this.elementInfo[0].getDatastoreClass()).toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            this.updateFkStmt = stmt.toString();
        }
        return this.updateFkStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateElementFk(StateManager sm, Object element, Object owner, int index) {
        boolean retval;
        if (element == null) {
            return false;
        }
        ObjectManager om = sm.getObjectManager();
        String updateFkStmt = this.getUpdateFkStmt();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (this.elementInfo.length > 1) {
                        DatastoreClass table = this.storeMgr.getDatastoreClass(element.getClass().getName(), this.clr);
                        if (table != null) {
                            ps.setString(jdbcPosition++, ((Object)table).toString());
                        } else {
                            NucleusLogger.PERSISTENCE.info((Object)(">> InverseArrayStore.updateElementFK : need to set table in statement but dont know table where to store " + element));
                        }
                    }
                    if (owner == null) {
                        this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.ownerMapping), null);
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreFields();
                    } else {
                        jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    }
                    jdbcPosition = this.populateOrderInStatement(om, ps, index, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                    sqlControl.executeStatementUpdate(mconn, updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(BaseContainerStore.LOCALISER.msg("056027", (Object)updateFkStmt), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(StateManager ownerSM) {
        boolean deleteElements = false;
        if (this.ownerMemberMetaData.getArray().isDependentElement()) {
            NucleusLogger.DATASTORE.debug((Object)BaseContainerStore.LOCALISER.msg("056034"));
            deleteElements = true;
        } else if (this.ownerMapping.isNullable() && this.orderMapping.isNullable()) {
            NucleusLogger.DATASTORE.debug((Object)BaseContainerStore.LOCALISER.msg("056036"));
            deleteElements = false;
        } else {
            NucleusLogger.DATASTORE.debug((Object)BaseContainerStore.LOCALISER.msg("056035"));
            deleteElements = true;
        }
        if (deleteElements) {
            ownerSM.getObjectManager().getApiAdapter().isLoaded(ownerSM, this.ownerMemberMetaData.getAbsoluteFieldNumber());
            Object[] value = (Object[])ownerSM.provideField(this.ownerMemberMetaData.getAbsoluteFieldNumber());
            if (value != null && value.length > 0) {
                ownerSM.getObjectManager().deleteObjects(value);
            }
        } else {
            String clearNullifyStmt = this.getClearNullifyStmt();
            try {
                ObjectManager om = ownerSM.getObjectManager();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearNullifyStmt, false);
                    try {
                        int jdbcPosition = 1;
                        jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition);
                        if (this.relationDiscriminatorMapping != null) {
                            jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                        }
                        sqlControl.executeStatementUpdate(mconn, clearNullifyStmt, ps, true);
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(BaseContainerStore.LOCALISER.msg("056013", (Object)clearNullifyStmt), (Throwable)e);
            }
        }
    }

    public boolean set(StateManager ownerSM, Object array) {
        if (array == null) {
            return true;
        }
        for (int i = 0; i < Array.getLength(array); ++i) {
            this.validateElementForWriting(ownerSM, Array.get(array, i), null);
        }
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object obj = Array.get(array, i);
            this.updateElementFk(ownerSM, obj, ownerSM.getObject(), i);
        }
        return true;
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM) {
        if (this.elementInfo == null) {
            return null;
        }
        ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        QueryExpression stmt = null;
        for (int i = 0; i < this.elementInfo.length; ++i) {
            int elementNo = i;
            Class elementCls = clr.classForName(this.elementType);
            QueryExpression subStmt = new UnionIteratorStatement(clr, elementCls, true, (StoreManager)this.storeMgr, elementCls, this.elementMapping, this.elementInfo[elementNo].getDatastoreClass(), false, null, true, false).getQueryStatement(null);
            if (stmt == null) {
                stmt = subStmt;
                continue;
            }
            stmt.union(subStmt);
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.relationDiscriminatorMapping != null) {
            ScalarExpression distinguisherExpr = this.relationDiscriminatorMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
            ScalarExpression distinguisherVal = this.relationDiscriminatorMapping.newLiteral(stmt, this.relationDiscriminatorValue);
            stmt.andCondition(distinguisherExpr.eq(distinguisherVal), true);
        }
        ScalarExpression[] exprIndex = new ScalarExpression[this.orderMapping.getNumberOfDatastoreFields()];
        boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreFields()];
        exprIndex = this.orderMapping.newScalarExpression(stmt, stmt.getMainTableExpression()).getExpressionList().toArray();
        stmt.setOrdering(exprIndex, descendingOrder);
        return stmt;
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier listTableAlias, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementTableAlias) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        DatastoreClass filteredElementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), stmt.getClassLoaderResolver());
        stmt.newTableExpression(filteredElementTable, elementTableAlias);
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        DatastoreIdentifier containerRangeVar = listTableAlias;
        if (stmt.getTableExpression(containerRangeVar) == null) {
            containerRangeVar = elementTableAlias;
        }
        ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
        stmt.newTableExpression(this.containerTable, containerRangeVar);
        stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        JavaTypeMapping elementTableID = filteredElementTable.getIDMapping();
        return elementTableID.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
    }
}

