/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringExpression;
import org.datanucleus.store.mapped.expression.TableExprAsJoins;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.query.SAPDBQueryStatement;

public class SAPDBAdapter
extends DatabaseAdapter {
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Integer;

    public SAPDBAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.add("BooleanExpression");
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.remove("AlterTableDropConstraint_Syntax");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.add("BitIsReallyBoolean");
    }

    public String getVendorID() {
        return "sapdb";
    }

    public String getSelectWithLockOption() {
        return "EXCLUSIVE LOCK";
    }

    public boolean supportsForeignKeyUpdateAction(ForeignKey.FKAction action) {
        return false;
    }

    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return "ALTER TABLE " + pk.getDatastoreContainerObject().toString() + " ADD " + pk;
    }

    public String getAddCandidateKeyStatement(CandidateKey ck, IdentifierFactory factory) {
        Index idx = new Index(ck);
        idx.setName(ck.getName());
        return this.getCreateIndexStatement(idx, factory);
    }

    public String getAddForeignKeyStatement(ForeignKey fk, IdentifierFactory factory) {
        return "ALTER TABLE " + fk.getDatastoreContainerObject().toString() + " ADD " + fk;
    }

    public String getSequenceCreateStmt(String sequence_name, String min, String max, String start, String increment, String cache_size) {
        if (sequence_name == null) {
            throw new NucleusUserException(DatabaseAdapter.LOCALISER.msg("Adapter.SequenceNameNullNotSupported"));
        }
        StringBuffer stmt = new StringBuffer("CREATE SEQUENCE ");
        stmt.append(sequence_name);
        if (min != null && min.length() > 0) {
            stmt.append(" MINVALUE " + min);
        }
        if (max != null && max.length() > 0) {
            stmt.append(" MAXVALUE " + max);
        }
        if (start != null && start.length() > 0) {
            stmt.append(" START WITH " + start);
        }
        if (increment != null && increment.length() > 0) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (cache_size != null && cache_size.length() > 0) {
            stmt.append(" CACHE " + cache_size);
        } else {
            stmt.append(" NOCACHE");
        }
        return stmt.toString();
    }

    public String getSequenceNextStmt(String sequence_name) {
        if (sequence_name == null) {
            throw new NucleusUserException(DatabaseAdapter.LOCALISER.msg("Adapter.SequenceNameNullNotSupported"));
        }
        StringBuffer stmt = new StringBuffer("SELECT ");
        stmt.append(sequence_name);
        stmt.append(".nextval FROM dual");
        return stmt.toString();
    }

    public QueryExpression newQueryStatement(DatastoreContainerObject table, DatastoreIdentifier rangeVar, ClassLoaderResolver clr) {
        return new SAPDBQueryStatement(table, rangeVar, clr);
    }

    public QueryExpression newQueryStatement(DatastoreContainerObject table, ClassLoaderResolver clr) {
        return new SAPDBQueryStatement(table, clr);
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        return new TableExprAsJoins(qs, table, rangeVar);
    }

    public NumericExpression getNumericExpressionForMethod(String method, ScalarExpression expr) {
        if (method.equalsIgnoreCase("length")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            args.add(expr);
            return new NumericExpression("LENGTH", args);
        }
        return super.getNumericExpressionForMethod(method, expr);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = SAPDBAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        return new StringExpression("SUBSTR", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin, NumericExpression end) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$lang$Integer == null ? (class$java$lang$Integer = SAPDBAdapter.class$("java.lang.Integer")) : class$java$lang$Integer, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        args.add(end.sub(begin));
        return new StringExpression("SUBSTR", args);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

