/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBStoreManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.FetchFieldManager;
import org.datanucleus.store.mongodb.fieldmanager.StoreFieldManager;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class MongoDBPersistenceHandler
extends AbstractPersistenceHandler {
    public static final String OP_DB_OBJECT = "DB_OBJECT";

    public MongoDBPersistenceHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertObjects(ObjectProvider ... ops) {
        if (ops.length == 1) {
            this.insertObject(ops[0]);
            return;
        }
        for (ObjectProvider op : ops) {
            AbstractClassMetaData cmd = op.getClassMetaData();
            if (!cmd.pkIsDatastoreAttributed(this.storeMgr)) continue;
            this.insertObject(op);
        }
        ExecutionContext ec = ops[0].getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            DB db = (DB)mconn.getConnection();
            HashMap<String, HashSet<ObjectProvider>> opsByTable = new HashMap<String, HashSet<ObjectProvider>>();
            for (ObjectProvider op : ops) {
                Table table;
                String tableName;
                HashSet<ObjectProvider> opsForTable;
                AbstractClassMetaData cmd = op.getClassMetaData();
                if (cmd.pkIsDatastoreAttributed(this.storeMgr)) continue;
                StoreData sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                if (sd == null) {
                    ((MongoDBStoreManager)this.storeMgr).manageClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), db);
                    sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                }
                if ((opsForTable = (HashSet<ObjectProvider>)opsByTable.get(tableName = (table = sd.getTable()).getName())) == null) {
                    opsForTable = new HashSet<ObjectProvider>();
                    opsByTable.put(tableName, opsForTable);
                }
                opsForTable.add(op);
            }
            for (Map.Entry entry : opsByTable.entrySet()) {
                String tableName = (String)entry.getKey();
                Set opsForTable = (Set)entry.getValue();
                try {
                    long startTime = System.currentTimeMillis();
                    DBCollection collection = db.getCollection(tableName);
                    Object[] dbObjects = new DBObject[opsForTable.size()];
                    int i = 0;
                    for (ObjectProvider op : opsForTable) {
                        this.assertReadOnlyForUpdateOfObject(op);
                        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                            NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.Insert.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
                        }
                        dbObjects[i] = this.getDBObjectForObjectProviderToInsert(op, true);
                        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                            NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.Insert.ObjectPersisted", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
                        }
                        ++i;
                    }
                    if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_NATIVE.debug((Object)("Persisting objects using collection.insert(" + StringUtils.objectArrayToString((Object[])dbObjects) + ") into table " + tableName));
                    }
                    collection.insert((DBObject[])dbObjects, new WriteConcern(1));
                    if (ec.getStatistics() != null) {
                        ec.getStatistics().incrementNumWrites();
                        for (int j = 0; j < dbObjects.length; ++j) {
                            ec.getStatistics().incrementInsertCount();
                        }
                    }
                    if (!NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) continue;
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
                }
                catch (MongoException me) {
                    NucleusLogger.PERSISTENCE.error((Object)"Exception inserting objects", (Throwable)me);
                    throw new NucleusDataStoreException("Exception inserting objects", (Throwable)me);
                    return;
                }
            }
        }
        finally {
            mconn.release();
        }
    }

    public void insertObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            DB db = (DB)mconn.getConnection();
            AbstractClassMetaData cmd = op.getClassMetaData();
            StoreData sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            if (sd == null) {
                ((MongoDBStoreManager)this.storeMgr).manageClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), db);
                sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            }
            Table table = sd.getTable();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.Insert.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
            DBCollection collection = db.getCollection(table.getName());
            DBObject dbObject = this.getDBObjectForObjectProviderToInsert(op, !cmd.pkIsDatastoreAttributed(this.storeMgr));
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Persisting object " + op + " using collection.insert(" + dbObject + ") into table=" + table.getName()));
            collection.insert(dbObject, new WriteConcern(1));
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
            }
            if (cmd.pkIsDatastoreAttributed(this.storeMgr)) {
                if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                    ObjectId idKey = (ObjectId)dbObject.get("_id");
                    op.setPostStoreNewObjectId((Object)idKey.toString());
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.Insert.ObjectPersistedWithIdentity", (Object[])new Object[]{op.getObjectAsPrintable(), idKey}));
                    }
                } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    int[] pkFieldNumbers = cmd.getPKMemberPositions();
                    for (int i = 0; i < pkFieldNumbers.length; ++i) {
                        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
                        if (!this.storeMgr.isValueGenerationStrategyDatastoreAttributed(cmd, pkFieldNumbers[i])) continue;
                        if (mmd.getType() != String.class) {
                            throw new NucleusUserException("Any field using IDENTITY value generation with MongoDB should be of type String");
                        }
                        ObjectId idKey = (ObjectId)dbObject.get("_id");
                        op.replaceField(mmd.getAbsoluteFieldNumber(), (Object)idKey.toString());
                        op.setPostStoreNewObjectId((Object)idKey);
                        if (!NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) continue;
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.Insert.ObjectPersistedWithIdentity", (Object[])new Object[]{op.getObjectAsPrintable(), idKey}));
                    }
                }
                StoreFieldManager fieldManager = new StoreFieldManager(op, dbObject, true, table);
                int[] fieldNumbers = cmd.getRelationMemberPositions(ec.getClassLoaderResolver());
                if (fieldNumbers != null && fieldNumbers.length > 0) {
                    op.provideFields(fieldNumbers, (FieldManager)fieldManager);
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Saving object " + op + " as " + dbObject));
                    collection.save(dbObject);
                    if (ec.getStatistics() != null) {
                        ec.getStatistics().incrementNumWrites();
                    }
                }
            } else if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.Insert.ObjectPersisted", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementInsertCount();
            }
        }
        catch (MongoException me) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception inserting object " + op), (Throwable)me);
            throw new NucleusDataStoreException("Exception inserting object for " + op, (Throwable)me);
        }
        finally {
            mconn.release();
        }
    }

    private DBObject getDBObjectForObjectProviderToInsert(ObjectProvider op, boolean includeRelationFields) {
        VersionMetaData vermd;
        BasicDBObject dbObject = new BasicDBObject();
        AbstractClassMetaData cmd = op.getClassMetaData();
        Table table = this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
        ExecutionContext ec = op.getExecutionContext();
        if (cmd.getIdentityType() == IdentityType.DATASTORE && !this.storeMgr.isValueGenerationStrategyDatastoreAttributed(cmd, -1)) {
            String fieldName = table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID).getName();
            Object key = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)op.getInternalObjectId());
            dbObject.put(fieldName, key);
        }
        if (cmd.hasDiscriminatorStrategy()) {
            dbObject.put(table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR).getName(), cmd.getDiscriminatorValue());
        }
        if (ec.getNucleusContext().isClassMultiTenant(cmd)) {
            dbObject.put(table.getSurrogateColumn(SurrogateColumnType.MULTITENANCY).getName(), (Object)ec.getNucleusContext().getMultiTenancyId(ec));
        }
        if (table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE) != null) {
            dbObject.put(table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE).getName(), (Object)Boolean.FALSE);
        }
        if ((vermd = cmd.getVersionMetaDataForClass()) != null) {
            Object versionValue = ec.getLockManager().getNextVersion(vermd, null);
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                Number verFieldValue = (long)((Long)versionValue);
                if (verMmd.getType() == Integer.TYPE || verMmd.getType() == Integer.class) {
                    verFieldValue = ((Long)versionValue).intValue();
                }
                op.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)verFieldValue);
            } else {
                String fieldName = table.getSurrogateColumn(SurrogateColumnType.VERSION).getName();
                dbObject.put(fieldName, versionValue);
            }
            op.setTransactionalVersion(versionValue);
        }
        StoreFieldManager fieldManager = new StoreFieldManager(op, (DBObject)dbObject, true, table);
        int[] fieldNumbers = cmd.getAllMemberPositions();
        if (!includeRelationFields) {
            fieldNumbers = cmd.getNonRelationMemberPositions(ec.getClassLoaderResolver());
        }
        op.provideFields(fieldNumbers, (FieldManager)fieldManager);
        return dbObject;
    }

    public void updateObject(ObjectProvider op, int[] fieldNumbers) {
        this.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            DBCollection collection;
            DBObject dbObject;
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            AbstractClassMetaData cmd = op.getClassMetaData();
            StoreData sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            if (sd == null) {
                ((MongoDBStoreManager)this.storeMgr).manageClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), db);
                sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            }
            Table table = sd.getTable();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                StringBuilder fieldStr = new StringBuilder();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.Update.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId(), fieldStr.toString()}));
            }
            if ((dbObject = MongoDBUtils.getObjectForObjectProvider(collection = db.getCollection(table.getName()), op, true, true)) == null) {
                if (cmd.isVersioned()) {
                    throw new NucleusOptimisticException("Object with id " + op.getInternalObjectId() + " and version " + op.getTransactionalVersion() + " no longer present");
                }
                throw new NucleusDataStoreException("Could not find object with id " + op.getInternalObjectId());
            }
            int[] updatedFieldNums = fieldNumbers;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd != null) {
                Object currentVersion = op.getTransactionalVersion();
                Object nextVersion = ec.getLockManager().getNextVersion(vermd, currentVersion);
                op.setTransactionalVersion(nextVersion);
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    op.replaceField(verMmd.getAbsoluteFieldNumber(), nextVersion);
                    boolean updatingVerField = false;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (fieldNumbers[i] != verMmd.getAbsoluteFieldNumber()) continue;
                        updatingVerField = true;
                    }
                    if (!updatingVerField) {
                        updatedFieldNums = new int[fieldNumbers.length + 1];
                        System.arraycopy(fieldNumbers, 0, updatedFieldNums, 0, fieldNumbers.length);
                        updatedFieldNums[fieldNumbers.length] = verMmd.getAbsoluteFieldNumber();
                    }
                } else {
                    String fieldName = table.getSurrogateColumn(SurrogateColumnType.VERSION).getName();
                    dbObject.put(fieldName, nextVersion);
                }
            }
            StoreFieldManager fieldManager = new StoreFieldManager(op, dbObject, false, table);
            op.provideFields(updatedFieldNums, (FieldManager)fieldManager);
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("Updating object " + op + " using collection.save(" + dbObject + ") into table=" + table.getName()));
            }
            collection.save(dbObject);
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementUpdateCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        catch (MongoException me) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception updating object " + op), (Throwable)me);
            throw new NucleusDataStoreException("Exception updating object for " + op, (Throwable)me);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObjects(ObjectProvider ... ops) {
        super.deleteObjects(ops);
    }

    public void deleteObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        AbstractClassMetaData cmd = op.getClassMetaData();
        Table table = this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            DBCollection collection;
            DBObject dbObject;
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.Delete.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
            if ((dbObject = MongoDBUtils.getObjectForObjectProvider(collection = db.getCollection(table.getName()), op, true, false)) == null) {
                if (cmd.isVersioned()) {
                    throw new NucleusOptimisticException("Object with id " + op.getInternalObjectId() + " and version " + op.getTransactionalVersion() + " no longer present");
                }
                throw new NucleusDataStoreException("Could not find object with id " + op.getInternalObjectId());
            }
            op.setAssociatedValue((Object)OP_DB_OBJECT, (Object)dbObject);
            op.loadUnloadedFields();
            op.provideFields(cmd.getAllMemberPositions(), (FieldManager)new DeleteFieldManager(op, true));
            op.removeAssociatedValue((Object)OP_DB_OBJECT);
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("Removing object " + op + " using collection.remove(" + dbObject + ") from table=" + table.getName()));
            }
            collection.remove(dbObject);
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementDeleteCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        catch (MongoException me) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception deleting object " + op), (Throwable)me);
            throw new NucleusDataStoreException("Exception deleting object for " + op, (Throwable)me);
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchObject(ObjectProvider op, int[] fieldNumbers) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            DBCollection collection;
            DB db = (DB)mconn.getConnection();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                StringBuilder str = new StringBuilder("Fetching object \"");
                str.append(op.getObjectAsPrintable()).append("\" (id=");
                str.append(op.getInternalObjectId()).append(")").append(" fields [");
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                str.append("]");
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)str.toString());
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"MongoDB.Fetch.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
            Table table = this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
            DBObject dbObject = (DBObject)op.getAssociatedValue((Object)OP_DB_OBJECT);
            if (dbObject == null && (dbObject = MongoDBUtils.getObjectForObjectProvider(collection = db.getCollection(table.getName()), op, false, false)) == null) {
                throw new NucleusObjectNotFoundException("Could not find object with id " + op.getInternalObjectId() + " op=" + op);
            }
            HashSet<Integer> nonpersistableFields = null;
            for (int i = 0; i < fieldNumbers.length; ++i) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                if (mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) continue;
                if (nonpersistableFields == null) {
                    nonpersistableFields = new HashSet<Integer>();
                }
                nonpersistableFields.add(fieldNumbers[i]);
            }
            if (nonpersistableFields != null) {
                for (Integer fieldNum : nonpersistableFields) {
                    op.replaceField(fieldNum.intValue(), op.provideField(fieldNum.intValue()));
                }
            }
            if (nonpersistableFields == null || nonpersistableFields.size() != fieldNumbers.length) {
                if (nonpersistableFields != null) {
                    int[] persistableFieldNums = new int[fieldNumbers.length - nonpersistableFields.size()];
                    int pos = 0;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (nonpersistableFields.contains(fieldNumbers[i])) continue;
                        persistableFieldNums[pos++] = fieldNumbers[i];
                    }
                    fieldNumbers = persistableFieldNums;
                }
                FetchFieldManager fieldManager = new FetchFieldManager(op, dbObject, table);
                op.replaceFields(fieldNumbers, (FieldManager)fieldManager);
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                if (vermd != null && op.getTransactionalVersion() == null) {
                    if (vermd.getFieldName() != null) {
                        Object datastoreVersion = op.provideField(cmd.getAbsolutePositionOfMember(vermd.getFieldName()));
                        op.setVersion(datastoreVersion);
                    } else {
                        String fieldName = table.getSurrogateColumn(SurrogateColumnType.VERSION).getName();
                        Object datastoreVersion = dbObject.get(fieldName);
                        op.setVersion(datastoreVersion);
                    }
                }
            }
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"MongoDB.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementFetchCount();
            }
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ExecutionContext om, Object id) {
        return null;
    }

    public void locateObjects(ObjectProvider[] ops) {
        super.locateObjects(ops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locateObject(ObjectProvider op) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            ExecutionContext ec = op.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            try {
                Table table;
                DBCollection collection;
                DBObject dbObject;
                DB db = (DB)mconn.getConnection();
                StoreData sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                if (sd == null) {
                    ((MongoDBStoreManager)this.storeMgr).manageClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), db);
                    sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                }
                if ((dbObject = MongoDBUtils.getObjectForObjectProvider(collection = db.getCollection((table = sd.getTable()).getName()), op, false, false)) == null) {
                    throw new NucleusObjectNotFoundException();
                }
            }
            finally {
                mconn.release();
            }
        }
    }
}

