/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.query;

import com.mongodb.BasicDBObject;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.AbstractExpressionEvaluator;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.query.MongoDBResult;
import org.datanucleus.store.mongodb.query.expression.MongoBooleanExpression;
import org.datanucleus.store.mongodb.query.expression.MongoExpression;
import org.datanucleus.store.mongodb.query.expression.MongoFieldExpression;
import org.datanucleus.store.mongodb.query.expression.MongoLiteral;
import org.datanucleus.store.mongodb.query.expression.MongoOperator;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class QueryToMongoDBMapper
extends AbstractExpressionEvaluator {
    final ExecutionContext ec;
    final String candidateAlias;
    final AbstractClassMetaData candidateCmd;
    final Query query;
    final QueryCompilation compilation;
    final Map parameters;
    int positionalParamNumber = -1;
    CompilationComponent compileComponent;
    boolean filterComplete = true;
    MongoBooleanExpression filterExpr;
    boolean orderComplete = true;
    BasicDBObject orderingObject;
    boolean resultComplete = true;
    MongoDBResult resultObject;
    boolean precompilable = true;
    Deque<MongoExpression> stack = new ArrayDeque<MongoExpression>();

    public QueryToMongoDBMapper(QueryCompilation compilation, Map parameters, AbstractClassMetaData cmd, ExecutionContext ec, Query q) {
        this.ec = ec;
        this.query = q;
        this.compilation = compilation;
        this.parameters = parameters;
        this.candidateCmd = cmd;
        this.candidateAlias = compilation.getCandidateAlias();
    }

    public boolean isFilterComplete() {
        return this.filterComplete;
    }

    public boolean isOrderComplete() {
        return this.orderComplete;
    }

    public boolean isResultComplete() {
        return this.resultComplete;
    }

    public boolean isPrecompilable() {
        return this.precompilable;
    }

    public MongoBooleanExpression getFilterExpression() {
        return this.filterExpr;
    }

    public MongoDBResult getResultObject() {
        return this.resultObject;
    }

    public BasicDBObject getOrderingObject() {
        return this.orderingObject;
    }

    public void compile() {
        Expression[] fromExpr;
        if (this.compilation.getExprFrom() != null && (fromExpr = this.compilation.getExprFrom()) != null) {
            if (fromExpr.length > 1) {
                NucleusLogger.QUERY.warn((Object)"FROM clause will be ignored. Not supported for this datastore (MongoDB doesn't do 'joins')");
            } else if (fromExpr.length == 1 && fromExpr[0].getRight() != null) {
                NucleusLogger.QUERY.warn((Object)"FROM clause will be ignored. Not supported for this datastore (MongoDB doesn't do 'joins')");
            }
        }
        this.compileFilter();
        this.compileResult();
        if (this.compilation.getExprGrouping() != null) {
            NucleusLogger.QUERY.warn((Object)"GROUPING clause will be ignored. Not supported for this datastore");
        }
        if (this.compilation.getExprHaving() != null) {
            NucleusLogger.QUERY.warn((Object)"HAVING clause will be ignored. Not supported for this datastore");
        }
        this.compileOrdering();
    }

    protected void compileFilter() {
        if (this.compilation.getExprFilter() != null) {
            this.compileComponent = CompilationComponent.FILTER;
            try {
                this.compilation.getExprFilter().evaluate((ExpressionEvaluator)this);
                MongoExpression mongoExpr = this.stack.pop();
                if (!(mongoExpr instanceof MongoBooleanExpression)) {
                    NucleusLogger.QUERY.error((Object)("Invalid compilation : filter compiled to " + mongoExpr));
                    this.filterComplete = false;
                } else {
                    this.filterExpr = (MongoBooleanExpression)mongoExpr;
                }
            }
            catch (Exception e) {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)("Compilation of filter to be evaluated completely in-datastore was impossible : " + e.getMessage()));
                }
                this.filterComplete = false;
            }
            this.compileComponent = null;
        }
    }

    protected void compileResult() {
        if (this.compilation.getExprResult() != null) {
            Expression[] resultExprs;
            this.compileComponent = CompilationComponent.RESULT;
            this.resultObject = new MongoDBResult();
            for (Expression expr : resultExprs = this.compilation.getExprResult()) {
                if (expr instanceof InvokeExpression) {
                    if ("count".equalsIgnoreCase(((InvokeExpression)expr).getOperation()) && resultExprs.length == 1) {
                        this.resultObject.setCountOnly(true);
                        continue;
                    }
                    this.resultComplete = false;
                    continue;
                }
                this.resultComplete = false;
            }
        }
        this.compileComponent = null;
    }

    protected void compileOrdering() {
        if (this.compilation.getExprOrdering() != null) {
            this.compileComponent = CompilationComponent.ORDERING;
            this.orderingObject = new BasicDBObject();
            for (Expression expr : this.compilation.getExprOrdering()) {
                OrderExpression orderExpr = (OrderExpression)expr;
                MongoFieldExpression orderMongoExpr = (MongoFieldExpression)orderExpr.getLeft().evaluate((ExpressionEvaluator)this);
                String orderDir = orderExpr.getSortOrder();
                int direction = orderDir == null || orderDir.equals("ascending") ? 1 : -1;
                this.orderingObject.put((Object)orderMongoExpr.getPropertyName(), (Object)direction);
            }
            this.compileComponent = null;
        }
    }

    protected Object processAndExpression(Expression expr) {
        MongoBooleanExpression right = (MongoBooleanExpression)this.stack.pop();
        MongoBooleanExpression left = (MongoBooleanExpression)this.stack.pop();
        MongoBooleanExpression andExpr = new MongoBooleanExpression(left, right, MongoOperator.OP_AND);
        this.stack.push(andExpr);
        return andExpr;
    }

    protected Object processOrExpression(Expression expr) {
        MongoBooleanExpression right = (MongoBooleanExpression)this.stack.pop();
        MongoBooleanExpression left = (MongoBooleanExpression)this.stack.pop();
        MongoBooleanExpression andExpr = new MongoBooleanExpression(left, right, MongoOperator.OP_OR);
        this.stack.push(andExpr);
        return andExpr;
    }

    protected Object processEqExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)right, (MongoLiteral)left, MongoOperator.OP_EQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)left, (MongoLiteral)right, MongoOperator.OP_EQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        return super.processEqExpression(expr);
    }

    protected Object processNoteqExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)right, (MongoLiteral)left, MongoOperator.OP_NOTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)left, (MongoLiteral)right, MongoOperator.OP_NOTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        return super.processNoteqExpression(expr);
    }

    protected Object processGtExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)right, (MongoLiteral)left, MongoOperator.OP_LTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)left, (MongoLiteral)right, MongoOperator.OP_GT);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        return super.processGtExpression(expr);
    }

    protected Object processLtExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)right, (MongoLiteral)left, MongoOperator.OP_GTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)left, (MongoLiteral)right, MongoOperator.OP_LT);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        return super.processLtExpression(expr);
    }

    protected Object processGteqExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)right, (MongoLiteral)left, MongoOperator.OP_LT);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)left, (MongoLiteral)right, MongoOperator.OP_GTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        return super.processGteqExpression(expr);
    }

    protected Object processLteqExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)right, (MongoLiteral)left, MongoOperator.OP_GT);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)left, (MongoLiteral)right, MongoOperator.OP_LTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        return super.processLteqExpression(expr);
    }

    protected Object processInExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            MongoLiteral lit = (MongoLiteral)right;
            Object litValue = lit.getValue();
            if (litValue instanceof Collection) {
                MongoBooleanExpression inExpr = null;
                for (Object litElemValue : (Collection)litValue) {
                    MongoLiteral elemLit = this.getMongoLiteralForValue(litElemValue);
                    if (elemLit == null) continue;
                    MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)left, elemLit, MongoOperator.OP_EQ);
                    if (inExpr == null) {
                        inExpr = mongoExpr;
                        continue;
                    }
                    inExpr = new MongoBooleanExpression(inExpr, mongoExpr, MongoOperator.OP_OR);
                }
                if (inExpr != null) {
                    this.stack.push(inExpr);
                    return inExpr;
                }
            } else {
                MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)left, lit, MongoOperator.OP_EQ);
                this.stack.push(mongoExpr);
                return mongoExpr;
            }
        }
        return super.processInExpression(expr);
    }

    protected Object processNotInExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            MongoLiteral lit = (MongoLiteral)right;
            Object litValue = lit.getValue();
            if (litValue instanceof Collection) {
                MongoBooleanExpression inExpr = null;
                for (Object litElemValue : (Collection)litValue) {
                    MongoLiteral elemLit = this.getMongoLiteralForValue(litElemValue);
                    if (elemLit == null) continue;
                    MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)left, elemLit, MongoOperator.OP_NOTEQ);
                    if (inExpr == null) {
                        inExpr = mongoExpr;
                        continue;
                    }
                    inExpr = new MongoBooleanExpression(inExpr, mongoExpr, MongoOperator.OP_AND);
                }
                if (inExpr != null) {
                    this.stack.push(inExpr);
                    return inExpr;
                }
            } else {
                MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)left, lit, MongoOperator.OP_NOTEQ);
                this.stack.push(mongoExpr);
                return mongoExpr;
            }
        }
        return super.processNotInExpression(expr);
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        Expression left = expr.getLeft();
        if (left == null) {
            MongoFieldExpression fieldExpr = this.getFieldNameForPrimary(expr);
            if (fieldExpr == null) {
                if (this.compileComponent == CompilationComponent.FILTER) {
                    this.filterComplete = false;
                } else if (this.compileComponent == CompilationComponent.ORDERING) {
                    this.orderComplete = false;
                } else if (this.compileComponent == CompilationComponent.RESULT) {
                    this.resultComplete = false;
                }
                NucleusLogger.QUERY.warn((Object)("Primary " + expr + " is not stored in this document, so unexecutable in datastore"));
            } else {
                this.stack.push(fieldExpr);
                return fieldExpr;
            }
        }
        return super.processPrimaryExpression(expr);
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        Object paramValue = null;
        boolean paramValueSet = false;
        if (this.parameters != null && !this.parameters.isEmpty()) {
            if (this.parameters.containsKey(expr.getId())) {
                paramValue = this.parameters.get(expr.getId());
                paramValueSet = true;
            } else if (this.parameters.containsKey(expr.getId())) {
                paramValue = this.parameters.get(expr.getId());
                paramValueSet = true;
            } else {
                int position = this.positionalParamNumber;
                if (this.positionalParamNumber < 0) {
                    position = 0;
                }
                if (this.parameters.containsKey(position)) {
                    paramValue = this.parameters.get(position);
                    paramValueSet = true;
                    this.positionalParamNumber = position + 1;
                }
            }
        }
        if (paramValueSet) {
            if (paramValue == null) {
                MongoLiteral lit = new MongoLiteral(null);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if ((paramValue = MongoDBUtils.getAcceptableDatastoreValue(paramValue)) instanceof Number || paramValue instanceof String || paramValue instanceof Character || paramValue instanceof Boolean || paramValue instanceof Enum || paramValue instanceof Date || paramValue instanceof Collection || paramValue instanceof Calendar) {
                MongoLiteral lit = new MongoLiteral(paramValue);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (this.ec.getApiAdapter().isPersistable(paramValue)) {
                MongoLiteral lit = new MongoLiteral(String.valueOf(this.ec.getApiAdapter().getIdForObject(paramValue)));
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
        } else {
            this.precompilable = false;
            throw new NucleusException("Parameter " + expr + " is not currently set, so cannot complete the compilation");
        }
        NucleusLogger.QUERY.warn((Object)("Dont currently support parameter values of type " + paramValue.getClass().getName()));
        return super.processParameterExpression(expr);
    }

    protected Object processLiteral(Literal expr) {
        Object litValue = expr.getLiteral();
        MongoLiteral lit = this.getMongoLiteralForValue(litValue);
        if (lit != null) {
            this.stack.push(lit);
            return lit;
        }
        return super.processLiteral(expr);
    }

    protected MongoLiteral getMongoLiteralForValue(Object value) {
        if (value instanceof BigDecimal) {
            return new MongoLiteral(((BigDecimal)value).doubleValue());
        }
        if (value instanceof Number) {
            return new MongoLiteral(value);
        }
        if (value instanceof String) {
            return new MongoLiteral(value);
        }
        if (value instanceof Character) {
            return new MongoLiteral("" + value);
        }
        if (value instanceof Boolean) {
            return new MongoLiteral(value);
        }
        if (value == null) {
            return new MongoLiteral(null);
        }
        if (value instanceof Collection) {
            return new MongoLiteral(value);
        }
        return null;
    }

    protected Object processInvokeExpression(InvokeExpression expr) {
        MongoExpression mongoExprArg0;
        boolean supported = true;
        Expression invokedExpr = expr.getLeft();
        String operation = expr.getOperation();
        List args = expr.getArguments();
        MongoExpression invokedMongoExpr = null;
        if (invokedExpr != null) {
            if (invokedExpr instanceof PrimaryExpression) {
                this.processPrimaryExpression((PrimaryExpression)invokedExpr);
                invokedMongoExpr = this.stack.pop();
            } else if (invokedExpr instanceof ParameterExpression) {
                this.processParameterExpression((ParameterExpression)invokedExpr);
                invokedMongoExpr = this.stack.pop();
            } else {
                supported = false;
            }
        }
        ArrayList<MongoExpression> mongoExprArgs = null;
        if (supported && args != null) {
            mongoExprArgs = new ArrayList<MongoExpression>();
            for (Expression argExpr : args) {
                if (argExpr instanceof PrimaryExpression) {
                    this.processPrimaryExpression((PrimaryExpression)argExpr);
                    mongoExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof ParameterExpression) {
                    this.processParameterExpression((ParameterExpression)argExpr);
                    mongoExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof InvokeExpression) {
                    this.processInvokeExpression((InvokeExpression)argExpr);
                    mongoExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof Literal) {
                    this.processLiteral((Literal)argExpr);
                    mongoExprArgs.add(this.stack.pop());
                    continue;
                }
                supported = false;
                break;
            }
        }
        MongoBooleanExpression mongoExpr = null;
        MongoExpression mongoExpression = mongoExprArg0 = mongoExprArgs != null && mongoExprArgs.size() == 1 ? (MongoExpression)mongoExprArgs.get(0) : null;
        if (supported) {
            if (invokedMongoExpr instanceof MongoFieldExpression && mongoExprArg0 instanceof MongoLiteral) {
                MongoFieldExpression invokedFieldExpr = (MongoFieldExpression)invokedMongoExpr;
                MongoLiteral invokedExprArg = (MongoLiteral)mongoExprArg0;
                if (invokedFieldExpr.getMemberMetaData().getType() == String.class) {
                    if ("equals".equals(operation)) {
                        mongoExpr = new MongoBooleanExpression(invokedFieldExpr, invokedExprArg, MongoOperator.OP_EQ);
                    } else if ("matches".equals(operation)) {
                        mongoExpr = new MongoBooleanExpression(invokedFieldExpr, invokedExprArg, MongoOperator.REGEX);
                    } else if ("startsWith".equals(operation)) {
                        mongoExpr = new MongoBooleanExpression(invokedFieldExpr, new MongoLiteral("^" + Pattern.quote(invokedExprArg.getValue().toString())), MongoOperator.REGEX);
                    } else if ("endsWith".equals(operation)) {
                        mongoExpr = new MongoBooleanExpression(invokedFieldExpr, new MongoLiteral(Pattern.quote(invokedExprArg.getValue().toString()) + "$"), MongoOperator.REGEX);
                    }
                } else if (invokedFieldExpr.getMemberMetaData().hasCollection() && "contains".equals(operation)) {
                    mongoExpr = new MongoBooleanExpression(invokedFieldExpr, invokedExprArg, MongoOperator.OP_EQ);
                }
            } else if (invokedMongoExpr instanceof MongoLiteral && mongoExprArg0 instanceof MongoFieldExpression) {
                MongoLiteral invokedLiteralExpr = (MongoLiteral)invokedMongoExpr;
                MongoFieldExpression invokedExprArg = (MongoFieldExpression)mongoExprArg0;
                if (invokedLiteralExpr.getValue() instanceof Collection && "contains".equals(operation)) {
                    mongoExpr = new MongoBooleanExpression(invokedExprArg, invokedLiteralExpr, MongoOperator.IN);
                }
            }
        }
        if (mongoExpr != null) {
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        NucleusLogger.QUERY.warn((Object)("Dont currently support method invocation in MongoDB datastore queries : method=" + operation + " args=" + StringUtils.collectionToString((Collection)args)));
        return super.processInvokeExpression(expr);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected MongoFieldExpression getFieldNameForPrimary(PrimaryExpression expr) {
        List tuples = expr.getTuples();
        if (tuples == null || tuples.isEmpty()) {
            return null;
        }
        AbstractClassMetaData cmd = this.candidateCmd;
        Table table = this.ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName()).getTable();
        AbstractMemberMetaData embMmd = null;
        boolean embeddedFlat = false;
        String embeddedNestedField = null;
        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
        boolean firstTuple = true;
        Iterator iter = tuples.iterator();
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        while (true) {
            block21: {
                RelationType relationType;
                AbstractMemberMetaData mmd;
                block19: {
                    block20: {
                        if (!iter.hasNext()) {
                            return null;
                        }
                        String name = (String)iter.next();
                        if (firstTuple && name.equals(this.candidateAlias)) {
                            cmd = this.candidateCmd;
                            continue;
                        }
                        mmd = cmd.getMetaDataForMember(name);
                        if (mmd == null) {
                            NucleusLogger.QUERY.warn((Object)("Attempt to locate PrimaryExpression " + expr + " gave no result! Maybe an unsupported feature?"));
                            return null;
                        }
                        relationType = mmd.getRelationType(clr);
                        if (relationType == RelationType.NONE) {
                            if (iter.hasNext()) {
                                throw new NucleusUserException("Query has reference to " + StringUtils.collectionToString((Collection)tuples) + " yet " + name + " is a non-relation field!");
                            }
                            if (embMmd == null) {
                                MemberColumnMapping mapping = table.getMemberColumnMappingForMember(mmd);
                                return new MongoFieldExpression(mapping.getColumn(0).getName(), mmd, mapping);
                            }
                            if (embeddedFlat) {
                                embMmds.add(mmd);
                                MemberColumnMapping mapping = table.getMemberColumnMappingForEmbeddedMember(embMmds);
                                return new MongoFieldExpression(mapping.getColumn(0).getName(), mmd, mapping);
                            }
                            embMmds.add(mmd);
                            MemberColumnMapping mapping = table.getMemberColumnMappingForEmbeddedMember(embMmds);
                            return new MongoFieldExpression(embeddedNestedField + "." + table.getMemberColumnMappingForEmbeddedMember(embMmds).getColumn(0).getName(), mmd, mapping);
                        }
                        if (!RelationType.isRelationSingleValued((RelationType)relationType)) break block19;
                        boolean embedded = MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, embMmds.isEmpty() ? null : (AbstractMemberMetaData)embMmds.get(embMmds.size() - 1));
                        if (!embedded) break block20;
                        boolean nested = MongoDBUtils.isMemberNested(mmd);
                        cmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), this.ec.getClassLoaderResolver());
                        embMmd = mmd;
                        embMmds.add(embMmd);
                        if (nested) {
                            embeddedNestedField = embeddedNestedField == null ? table.getMemberColumnMappingForMember(mmd).getColumn(0).getName() : embeddedNestedField + "." + table.getMemberColumnMappingForEmbeddedMember(embMmds).getColumn(0).getName();
                            break block21;
                        } else if (!embeddedFlat) {
                            embeddedFlat = true;
                        }
                        break block21;
                    }
                    if (embMmds.isEmpty() && !iter.hasNext()) {
                        MemberColumnMapping mapping = table.getMemberColumnMappingForMember(mmd);
                        String fieldName = mapping.getColumn(0).getName();
                        return new MongoFieldExpression(fieldName, mmd, mapping);
                    }
                    embMmds.clear();
                    if (this.compileComponent == CompilationComponent.FILTER) {
                        this.filterComplete = false;
                    } else if (this.compileComponent == CompilationComponent.ORDERING) {
                        this.orderComplete = false;
                    } else if (this.compileComponent == CompilationComponent.RESULT) {
                        this.resultComplete = false;
                    }
                    NucleusLogger.QUERY.warn((Object)("Query has reference to " + StringUtils.collectionToString((Collection)tuples) + " and " + mmd.getFullFieldName() + " is not persisted into this document, so unexecutable in the datastore"));
                    return null;
                }
                if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                    throw new NucleusUserException("Dont currently support querying of multi-valued fields at " + mmd.getFullFieldName());
                }
            }
            firstTuple = false;
        }
    }
}

