/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.store.fieldmanager.AbstractStoreFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.StoreEmbeddedFieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class StoreFieldManager
extends AbstractStoreFieldManager {
    protected Table table;
    protected DBObject dbObject;
    protected AbstractMemberMetaData ownerMmd = null;

    public StoreFieldManager(ObjectProvider op, DBObject dbObject, boolean insert, Table table) {
        super(op, insert);
        this.table = table;
        this.dbObject = dbObject;
    }

    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        return this.table.getMemberColumnMappingForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        this.dbObject.put(mapping.getColumn(0).getName(), (Object)value);
    }

    public void storeCharField(int fieldNumber, char value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        this.dbObject.put(mapping.getColumn(0).getName(), (Object)("" + value));
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        this.dbObject.put(mapping.getColumn(0).getName(), (Object)value);
    }

    public void storeShortField(int fieldNumber, short value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        this.dbObject.put(mapping.getColumn(0).getName(), (Object)value);
    }

    public void storeIntField(int fieldNumber, int value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        this.dbObject.put(mapping.getColumn(0).getName(), (Object)value);
    }

    public void storeLongField(int fieldNumber, long value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        this.dbObject.put(mapping.getColumn(0).getName(), (Object)value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        this.dbObject.put(mapping.getColumn(0).getName(), (Object)Float.valueOf(value));
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        this.dbObject.put(mapping.getColumn(0).getName(), (Object)value);
    }

    public void storeStringField(int fieldNumber, String value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        if (mmd.getValueStrategy() == IdentityStrategy.IDENTITY) {
            return;
        }
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        String fieldName = mapping.getColumn(0).getName();
        if (value == null) {
            this.dbObject.removeField(fieldName);
            return;
        }
        this.dbObject.put(fieldName, (Object)value);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        ExecutionContext ec = this.op.getExecutionContext();
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        StoreManager storeMgr = ec.getStoreManager();
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(ec.getMetaDataManager(), clr, mmd, relationType, this.ownerMmd)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                if ((this.insert && !mmd.isCascadePersist() || !this.insert && !mmd.isCascadeUpdate()) && !ec.getApiAdapter().isDetached(value) && !ec.getApiAdapter().isPersistent(value)) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
                    }
                    throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), value);
                }
                boolean nested = MongoDBUtils.isMemberNested(mmd);
                if (nested && this.ownerMmd != null && (RelationType.isBidirectional((RelationType)relationType) ? this.ownerMmd.getMappedBy() != null && mmd.getName().equals(this.ownerMmd.getMappedBy()) || mmd.getMappedBy() != null && this.ownerMmd.getName().equals(mmd.getMappedBy()) : (this.ownerMmd.hasCollection() ? this.ownerMmd.getElementMetaData().getEmbeddedMetaData() != null && this.ownerMmd.getElementMetaData().getEmbeddedMetaData().getOwnerMember() != null && this.ownerMmd.getElementMetaData().getEmbeddedMetaData().getOwnerMember().equals(mmd.getName()) : this.ownerMmd.getEmbeddedMetaData() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember().equals(mmd.getName())))) {
                    return;
                }
                if (value == null) {
                    if (nested) {
                        for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                            this.dbObject.removeField(mapping.getColumn(i).getName());
                        }
                        return;
                    }
                    return;
                }
                AbstractClassMetaData embcmd = ec.getMetaDataManager().getMetaDataForClass(value.getClass(), clr);
                if (embcmd == null) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " specified as embedded but metadata not found for the class of type " + mmd.getTypeName());
                }
                ObjectProvider embOP = ec.findObjectProviderForEmbedded(value, this.op, mmd);
                DBObject embeddedObject = this.dbObject;
                if (nested) {
                    embeddedObject = new BasicDBObject();
                }
                if (embcmd.hasDiscriminatorStrategy()) {
                    String discPropName = null;
                    discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : storeMgr.getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                    DiscriminatorMetaData discmd = embcmd.getDiscriminatorMetaData();
                    String discVal = null;
                    discVal = embcmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? embcmd.getFullClassName() : discmd.getValue();
                    embeddedObject.put(discPropName, (Object)discVal);
                }
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embOP, embeddedObject, this.insert, embMmds, this.table);
                embOP.provideFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                if (nested) {
                    this.dbObject.put(mapping.getColumn(0).getName(), (Object)embeddedObject);
                }
                return;
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                if (value == null) {
                    for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                        this.dbObject.removeField(mapping.getColumn(i).getName());
                    }
                    return;
                }
                if (mmd.hasCollection()) {
                    AbstractClassMetaData embcmd = mmd.getCollection().getElementClassMetaData(clr, ec.getMetaDataManager());
                    ArrayList<BasicDBObject> coll = new ArrayList<BasicDBObject>();
                    Collection valueColl = (Collection)value;
                    for (Object element : valueColl) {
                        if (!element.getClass().getName().equals(embcmd.getFullClassName())) {
                            embcmd = ec.getMetaDataManager().getMetaDataForClass(element.getClass(), clr);
                        }
                        BasicDBObject embeddedObject = new BasicDBObject();
                        if (embcmd.hasDiscriminatorStrategy()) {
                            String discPropName = null;
                            discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : storeMgr.getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                            DiscriminatorMetaData discmd = embcmd.getDiscriminatorMetaData();
                            String discVal = null;
                            discVal = embcmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? embcmd.getFullClassName() : discmd.getValue();
                            embeddedObject.put((Object)discPropName, (Object)discVal);
                        }
                        ObjectProvider embOP = ec.findObjectProviderForEmbedded(element, this.op, mmd);
                        embOP.setPcObjectType((short)2);
                        String embClassName = embOP.getClassMetaData().getFullClassName();
                        if (!storeMgr.managesClass(embClassName)) {
                            storeMgr.manageClasses(clr, new String[]{embClassName});
                        }
                        Table elemTable = storeMgr.getStoreDataForClass(embClassName).getTable();
                        StoreFieldManager sfm = new StoreFieldManager(embOP, (DBObject)embeddedObject, this.insert, elemTable);
                        sfm.ownerMmd = mmd;
                        embOP.provideFields(embcmd.getAllMemberPositions(), (FieldManager)sfm);
                        coll.add(embeddedObject);
                    }
                    this.dbObject.put(mapping.getColumn(0).getName(), coll);
                    return;
                }
                if (mmd.hasArray()) {
                    AbstractClassMetaData embcmd = mmd.getArray().getElementClassMetaData(clr, ec.getMetaDataManager());
                    Object[] array = new Object[Array.getLength(value)];
                    for (int i = 0; i < array.length; ++i) {
                        Object element = Array.get(value, i);
                        if (!element.getClass().getName().equals(embcmd.getFullClassName())) {
                            embcmd = ec.getMetaDataManager().getMetaDataForClass(element.getClass(), clr);
                        }
                        BasicDBObject embeddedObject = new BasicDBObject();
                        if (embcmd.hasDiscriminatorStrategy()) {
                            String discPropName = null;
                            discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : storeMgr.getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                            DiscriminatorMetaData discmd = embcmd.getDiscriminatorMetaData();
                            String discVal = null;
                            discVal = embcmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? embcmd.getFullClassName() : discmd.getValue();
                            embeddedObject.put((Object)discPropName, (Object)discVal);
                        }
                        ObjectProvider embOP = ec.findObjectProviderForEmbedded(element, this.op, mmd);
                        embOP.setPcObjectType((short)2);
                        String embClassName = embOP.getClassMetaData().getFullClassName();
                        if (!storeMgr.managesClass(embClassName)) {
                            storeMgr.manageClasses(clr, new String[]{embClassName});
                        }
                        Table elemTable = this.op.getStoreManager().getStoreDataForClass(embClassName).getTable();
                        StoreFieldManager sfm = new StoreFieldManager(embOP, (DBObject)embeddedObject, this.insert, elemTable);
                        sfm.ownerMmd = mmd;
                        embOP.provideFields(embcmd.getAllMemberPositions(), (FieldManager)sfm);
                        array[i] = embeddedObject;
                    }
                    this.dbObject.put(mapping.getColumn(0).getName(), (Object)array);
                    return;
                }
                AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, ec.getMetaDataManager());
                AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr, ec.getMetaDataManager());
                ArrayList<BasicDBObject> entryList = new ArrayList<BasicDBObject>();
                Map valueMap = (Map)value;
                for (Map.Entry entry : valueMap.entrySet()) {
                    StoreFieldManager sfm;
                    ObjectProvider embOP;
                    BasicDBObject entryObj = new BasicDBObject();
                    if (keyCmd == null) {
                        this.processContainerNonRelationField("key", ec, entry.getKey(), (DBObject)entryObj, mmd, FieldRole.ROLE_MAP_KEY);
                    } else {
                        embOP = ec.findObjectProviderForEmbedded(entry.getKey(), this.op, mmd);
                        embOP.setPcObjectType((short)3);
                        BasicDBObject embeddedKey = new BasicDBObject();
                        String keyClassName = embOP.getClassMetaData().getFullClassName();
                        if (!storeMgr.managesClass(keyClassName)) {
                            storeMgr.manageClasses(clr, new String[]{keyClassName});
                        }
                        Table keyTable = this.op.getStoreManager().getStoreDataForClass(keyClassName).getTable();
                        sfm = new StoreFieldManager(embOP, (DBObject)embeddedKey, this.insert, keyTable);
                        sfm.ownerMmd = mmd;
                        embOP.provideFields(keyCmd.getAllMemberPositions(), (FieldManager)sfm);
                        entryObj.append("key", (Object)embeddedKey);
                    }
                    if (valCmd == null) {
                        this.processContainerNonRelationField("value", ec, entry.getValue(), (DBObject)entryObj, mmd, FieldRole.ROLE_MAP_VALUE);
                    } else {
                        embOP = ec.findObjectProviderForEmbedded(entry.getValue(), this.op, mmd);
                        embOP.setPcObjectType((short)4);
                        BasicDBObject embeddedVal = new BasicDBObject();
                        String valClassName = embOP.getClassMetaData().getFullClassName();
                        if (!storeMgr.managesClass(valClassName)) {
                            storeMgr.manageClasses(clr, new String[]{valClassName});
                        }
                        Table valTable = this.op.getStoreManager().getStoreDataForClass(valClassName).getTable();
                        sfm = new StoreFieldManager(embOP, (DBObject)embeddedVal, this.insert, valTable);
                        sfm.ownerMmd = mmd;
                        embOP.provideFields(valCmd.getAllMemberPositions(), (FieldManager)sfm);
                        entryObj.append("value", (Object)embeddedVal);
                    }
                    entryList.add(entryObj);
                }
                this.dbObject.put(mapping.getColumn(0).getName(), entryList);
                return;
            }
        }
        this.storeNonEmbeddedObjectField(mmd, relationType, clr, value);
    }

    protected void storeNonEmbeddedObjectField(AbstractMemberMetaData mmd, RelationType relationType, ClassLoaderResolver clr, Object value) {
        int fieldNumber = mmd.getAbsoluteFieldNumber();
        ExecutionContext ec = this.op.getExecutionContext();
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        if (value == null) {
            for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                String colName = mapping.getColumn(i).getName();
                if (!this.dbObject.containsField(colName)) continue;
                this.dbObject.removeField(colName);
            }
            return;
        }
        if (mmd.isSerialized()) {
            byte[] bytes = MongoDBUtils.getStoredValueForJavaSerialisedField(mmd, value);
            this.dbObject.put(mapping.getColumn(0).getName(), (Object)bytes);
            SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, (Object)value, (boolean)true);
        } else if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            if ((this.insert && !mmd.isCascadePersist() || !this.insert && !mmd.isCascadeUpdate()) && !ec.getApiAdapter().isDetached(value) && !ec.getApiAdapter().isPersistent(value)) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
                }
                throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), value);
            }
            this.processSingleRelationField(value, ec, mapping.getColumn(0).getName());
        } else if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            this.processContainerRelationField(mmd, value, ec, mapping.getColumn(0).getName());
            SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, (Object)value, (boolean)true);
        } else {
            if (mapping.getTypeConverter() != null) {
                Object datastoreValue = mapping.getTypeConverter().toDatastoreType(value);
                if (mapping.getNumberOfColumns() > 1) {
                    for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                        Object colValue = Array.get(datastoreValue, i);
                        this.dbObject.put(mapping.getColumn(i).getName(), colValue);
                    }
                } else {
                    this.dbObject.put(mapping.getColumn(0).getName(), datastoreValue);
                }
            } else {
                this.processContainerNonRelationField(mapping.getColumn(0).getName(), ec, value, this.dbObject, mmd, FieldRole.ROLE_FIELD);
            }
            SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, (Object)value, (boolean)true);
        }
    }

    protected void processSingleRelationField(Object value, ExecutionContext ec, String fieldName) {
        Object valuePC = this.op.getExecutionContext().persistObjectInternal(value, null, -1, -1);
        Object valueId = ec.getApiAdapter().getIdForObject(valuePC);
        this.dbObject.put(fieldName, (Object)IdentityUtils.getPersistableIdentityForId((Object)valueId));
    }

    protected void processContainerRelationField(AbstractMemberMetaData mmd, Object value, ExecutionContext ec, String fieldName) {
        if (mmd.hasCollection()) {
            Collection coll = (Collection)value;
            if (this.insert && !mmd.isCascadePersist() || !this.insert && !mmd.isCascadeUpdate()) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
                }
                for (Object element : coll) {
                    if (ec.getApiAdapter().isDetached(element) || ec.getApiAdapter().isPersistent(element)) continue;
                    throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), element);
                }
            }
            ArrayList<String> collIds = new ArrayList<String>();
            Iterator collIter = coll.iterator();
            while (collIter.hasNext()) {
                if (mmd.getCollection().isSerializedElement()) {
                    throw new NucleusUserException("Don't currently support serialised collection elements at " + mmd.getFullFieldName() + " . Serialise the whole field");
                }
                Object element = collIter.next();
                if (element != null) {
                    Object elementPC = ec.persistObjectInternal(element, null, -1, -1);
                    Object elementID = ec.getApiAdapter().getIdForObject(elementPC);
                    collIds.add(IdentityUtils.getPersistableIdentityForId((Object)elementID));
                    continue;
                }
                collIds.add("NULL");
            }
            this.dbObject.put(fieldName, collIds);
        } else if (mmd.hasMap()) {
            HashSet<BasicDBObject> collEntries = new HashSet<BasicDBObject>();
            Map map = (Map)value;
            Iterator mapIter = map.entrySet().iterator();
            while (mapIter.hasNext()) {
                Object pc;
                if (mmd.getMap().isSerializedKey() || mmd.getMap().isSerializedValue()) {
                    throw new NucleusUserException("Don't currently support serialised map keys/values at " + mmd.getFullFieldName() + " . Serialise the whole field");
                }
                Map.Entry entry = mapIter.next();
                Object mapKey = entry.getKey();
                Object mapValue = entry.getValue();
                BasicDBObject entryObj = new BasicDBObject();
                if (ec.getApiAdapter().isPersistable(mapKey)) {
                    pc = ec.persistObjectInternal(mapKey, null, -1, -1);
                    Object keyID = ec.getApiAdapter().getIdForObject(pc);
                    entryObj.append("key", (Object)IdentityUtils.getPersistableIdentityForId((Object)keyID));
                } else {
                    this.processContainerNonRelationField("key", ec, mapKey, (DBObject)entryObj, mmd, FieldRole.ROLE_MAP_KEY);
                }
                if (ec.getApiAdapter().isPersistable(mapValue)) {
                    pc = ec.persistObjectInternal(mapValue, null, -1, -1);
                    Object valueID = ec.getApiAdapter().getIdForObject(pc);
                    entryObj.append("value", (Object)IdentityUtils.getPersistableIdentityForId((Object)valueID));
                } else {
                    this.processContainerNonRelationField("value", ec, mapValue, (DBObject)entryObj, mmd, FieldRole.ROLE_MAP_VALUE);
                }
                collEntries.add(entryObj);
            }
            this.dbObject.put(fieldName, collEntries);
        } else if (mmd.hasArray()) {
            ArrayList<String> collIds = new ArrayList<String>();
            for (int i = 0; i < Array.getLength(value); ++i) {
                if (mmd.getArray().isSerializedElement()) {
                    throw new NucleusUserException("Don't currently support serialised array elements at " + mmd.getFullFieldName() + " . Serialise the whole field");
                }
                Object element = Array.get(value, i);
                if (element != null) {
                    Object elementPC = ec.persistObjectInternal(element, null, -1, -1);
                    Object elementID = ec.getApiAdapter().getIdForObject(elementPC);
                    collIds.add(IdentityUtils.getPersistableIdentityForId((Object)elementID));
                    continue;
                }
                collIds.add("NULL");
            }
            this.dbObject.put(fieldName, collIds);
        }
    }

    protected void processContainerNonRelationField(String fieldName, ExecutionContext ec, Object value, DBObject dbObject, AbstractMemberMetaData mmd, FieldRole fieldRole) {
        Object storeValue = MongoDBUtils.getStoredValueForField(ec, mmd, value, fieldRole);
        dbObject.put(fieldName, storeValue);
    }
}

