/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.Relation;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractStoreFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.fieldmanager.StoreEmbeddedFieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.TypeConverter;

public class StoreFieldManager
extends AbstractStoreFieldManager {
    protected DBObject dbObject;
    protected AbstractMemberMetaData ownerMmd = null;

    public StoreFieldManager(ObjectProvider op, DBObject dbObject, boolean insert) {
        super(op, insert);
        this.dbObject = dbObject;
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        this.dbObject.put(fieldName, (Object)value);
    }

    public void storeCharField(int fieldNumber, char value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        this.dbObject.put(fieldName, (Object)Character.valueOf(value));
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        this.dbObject.put(fieldName, (Object)value);
    }

    public void storeShortField(int fieldNumber, short value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        this.dbObject.put(fieldName, (Object)value);
    }

    public void storeIntField(int fieldNumber, int value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        this.dbObject.put(fieldName, (Object)value);
    }

    public void storeLongField(int fieldNumber, long value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        this.dbObject.put(fieldName, (Object)value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        this.dbObject.put(fieldName, (Object)Float.valueOf(value));
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        this.dbObject.put(fieldName, (Object)value);
    }

    public void storeStringField(int fieldNumber, String value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        if (mmd.getValueStrategy() == IdentityStrategy.IDENTITY) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        if (value == null) {
            this.dbObject.removeField(fieldName);
            return;
        }
        this.dbObject.put(fieldName, (Object)value);
    }

    protected String getFieldName(int fieldNumber) {
        return this.op.getExecutionContext().getStoreManager().getNamingFactory().getColumnName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), ColumnType.COLUMN);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        ExecutionContext ec = this.op.getExecutionContext();
        String fieldName = ec.getStoreManager().getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        int relationType = mmd.getRelationType(clr);
        boolean embedded = false;
        if (this.op.getEmbeddedOwners() != null) {
            embedded = true;
        } else if (relationType != 0) {
            if (mmd.isEmbedded()) {
                embedded = true;
            } else if (mmd.getEmbeddedMetaData() != null) {
                embedded = true;
            } else if (Relation.isRelationMultiValued((int)relationType)) {
                if (mmd.hasCollection() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                    embedded = true;
                } else if (mmd.hasArray() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                    embedded = true;
                } else if (mmd.hasMap() && (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getEmbeddedMetaData() != null || mmd.getValueMetaData() != null && mmd.getValueMetaData().getEmbeddedMetaData() != null)) {
                    embedded = true;
                }
            }
        }
        if (embedded) {
            if (Relation.isRelationSingleValued((int)relationType)) {
                boolean nested = true;
                String nestedStr = mmd.getValueForExtension("nested");
                if (nestedStr != null && nestedStr.equalsIgnoreCase("false")) {
                    nested = false;
                }
                if (nested && this.ownerMmd != null && Relation.isBidirectional((int)relationType) && (this.ownerMmd.getMappedBy() != null && mmd.getName().equals(this.ownerMmd.getMappedBy()) || mmd.getMappedBy() != null && this.ownerMmd.getName().equals(mmd.getMappedBy()))) {
                    return;
                }
                if (value == null) {
                    if (nested) {
                        this.dbObject.removeField(fieldName);
                        return;
                    }
                    return;
                }
                AbstractClassMetaData embcmd = ec.getMetaDataManager().getMetaDataForClass(value.getClass(), clr);
                if (embcmd == null) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " specified as embedded but metadata not found for the class of type " + mmd.getTypeName());
                }
                ObjectProvider embSM = ec.findObjectProviderForEmbedded(value, this.op, mmd);
                if (nested) {
                    BasicDBObject embeddedObject = new BasicDBObject();
                    if (embcmd.hasDiscriminatorStrategy()) {
                        String discPropName = null;
                        discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : ec.getStoreManager().getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                        DiscriminatorMetaData discmd = embcmd.getDiscriminatorMetaData();
                        String discVal = null;
                        discVal = embcmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? embcmd.getFullClassName() : discmd.getValue();
                        embeddedObject.put(discPropName, (Object)discVal);
                    }
                    StoreFieldManager sfm = new StoreFieldManager(embSM, (DBObject)embeddedObject, this.insert);
                    sfm.ownerMmd = mmd;
                    embSM.provideFields(embcmd.getAllMemberPositions(), (FieldManager)sfm);
                    this.dbObject.put(fieldName, (Object)embeddedObject);
                    return;
                }
                if (embcmd.hasDiscriminatorStrategy()) {
                    String discPropName = null;
                    discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : ec.getStoreManager().getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                    DiscriminatorMetaData discmd = embcmd.getDiscriminatorMetaData();
                    String discVal = null;
                    discVal = embcmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? embcmd.getFullClassName() : discmd.getValue();
                    this.dbObject.put(discPropName, (Object)discVal);
                }
                StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embSM, this.dbObject, mmd, this.insert);
                embSM.provideFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                return;
            }
            if (Relation.isRelationMultiValued((int)relationType)) {
                if (value == null) {
                    this.dbObject.removeField(fieldName);
                    return;
                }
                if (this.ownerMmd != null && Relation.isBidirectional((int)relationType) && (this.ownerMmd.getMappedBy() != null && mmd.getName().equals(this.ownerMmd.getMappedBy()) || mmd.getMappedBy() != null && this.ownerMmd.getName().equals(mmd.getMappedBy()))) {
                    return;
                }
                if (mmd.hasCollection()) {
                    AbstractClassMetaData embcmd = mmd.getCollection().getElementClassMetaData(clr, ec.getMetaDataManager());
                    ArrayList<BasicDBObject> coll = new ArrayList<BasicDBObject>();
                    Collection valueColl = (Collection)value;
                    for (Object element : valueColl) {
                        if (!element.getClass().getName().equals(embcmd.getFullClassName())) {
                            embcmd = ec.getMetaDataManager().getMetaDataForClass(element.getClass(), clr);
                        }
                        BasicDBObject embeddedObject = new BasicDBObject();
                        if (embcmd.hasDiscriminatorStrategy()) {
                            String discPropName = null;
                            discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : ec.getStoreManager().getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                            DiscriminatorMetaData discmd = embcmd.getDiscriminatorMetaData();
                            String discVal = null;
                            discVal = embcmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? embcmd.getFullClassName() : discmd.getValue();
                            embeddedObject.put(discPropName, (Object)discVal);
                        }
                        ObjectProvider embSM = ec.findObjectProviderForEmbedded(element, this.op, mmd);
                        embSM.setPcObjectType((short)2);
                        StoreFieldManager sfm = new StoreFieldManager(embSM, (DBObject)embeddedObject, this.insert);
                        sfm.ownerMmd = mmd;
                        embSM.provideFields(embcmd.getAllMemberPositions(), (FieldManager)sfm);
                        coll.add(embeddedObject);
                    }
                    this.dbObject.put(fieldName, coll);
                    return;
                }
                if (mmd.hasArray()) {
                    AbstractClassMetaData embcmd = mmd.getArray().getElementClassMetaData(clr, ec.getMetaDataManager());
                    Object[] array = new Object[Array.getLength(value)];
                    for (int i = 0; i < array.length; ++i) {
                        Object element = Array.get(value, i);
                        if (!element.getClass().getName().equals(embcmd.getFullClassName())) {
                            embcmd = ec.getMetaDataManager().getMetaDataForClass(element.getClass(), clr);
                        }
                        BasicDBObject embeddedObject = new BasicDBObject();
                        if (embcmd.hasDiscriminatorStrategy()) {
                            String discPropName = null;
                            discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : ec.getStoreManager().getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                            DiscriminatorMetaData discmd = embcmd.getDiscriminatorMetaData();
                            String discVal = null;
                            discVal = embcmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? embcmd.getFullClassName() : discmd.getValue();
                            embeddedObject.put(discPropName, (Object)discVal);
                        }
                        ObjectProvider embSM = ec.findObjectProviderForEmbedded(element, this.op, mmd);
                        embSM.setPcObjectType((short)2);
                        StoreFieldManager sfm = new StoreFieldManager(embSM, (DBObject)embeddedObject, this.insert);
                        sfm.ownerMmd = mmd;
                        embSM.provideFields(embcmd.getAllMemberPositions(), (FieldManager)sfm);
                        array[i] = embeddedObject;
                    }
                    this.dbObject.put(fieldName, (Object)array);
                    return;
                }
                AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, ec.getMetaDataManager());
                AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr, ec.getMetaDataManager());
                ArrayList<BasicDBObject> entryList = new ArrayList<BasicDBObject>();
                Map valueMap = (Map)value;
                for (Map.Entry entry : valueMap.entrySet()) {
                    StoreFieldManager sfm;
                    ObjectProvider embSM;
                    BasicDBObject entryObj = new BasicDBObject();
                    if (keyCmd == null) {
                        this.processContainerNonRelationField("key", ec, entry.getKey(), (DBObject)entryObj, null);
                    } else {
                        embSM = ec.findObjectProviderForEmbedded(entry.getKey(), this.op, mmd);
                        embSM.setPcObjectType((short)3);
                        BasicDBObject embeddedKey = new BasicDBObject();
                        sfm = new StoreFieldManager(embSM, (DBObject)embeddedKey, this.insert);
                        sfm.ownerMmd = mmd;
                        embSM.provideFields(keyCmd.getAllMemberPositions(), (FieldManager)sfm);
                        entryObj.append("key", (Object)embeddedKey);
                    }
                    if (valCmd == null) {
                        this.processContainerNonRelationField("value", ec, entry.getValue(), (DBObject)entryObj, null);
                    } else {
                        embSM = ec.findObjectProviderForEmbedded(entry.getValue(), this.op, mmd);
                        embSM.setPcObjectType((short)4);
                        BasicDBObject embeddedVal = new BasicDBObject();
                        sfm = new StoreFieldManager(embSM, (DBObject)embeddedVal, this.insert);
                        sfm.ownerMmd = mmd;
                        embSM.provideFields(valCmd.getAllMemberPositions(), (FieldManager)sfm);
                        entryObj.append("value", (Object)embeddedVal);
                    }
                    entryList.add(entryObj);
                }
                this.dbObject.put(fieldName, entryList);
                return;
            }
        }
        if (value == null) {
            if (this.dbObject.containsField(fieldName)) {
                this.dbObject.removeField(fieldName);
            }
            return;
        }
        if (mmd.isSerialized()) {
            this.processSerialisedField(fieldName, value, this.dbObject);
            this.op.wrapSCOField(fieldNumber, value, false, false, true);
        } else if (Relation.isRelationSingleValued((int)relationType)) {
            this.processSingleRelationField(value, ec, fieldName);
        } else if (Relation.isRelationMultiValued((int)relationType)) {
            this.processContainerRelationField(mmd, value, ec, fieldName);
            this.op.wrapSCOField(fieldNumber, value, false, false, true);
        } else {
            if (mmd.getTypeConverterName() != null) {
                TypeManager typeMgr = this.op.getExecutionContext().getNucleusContext().getTypeManager();
                TypeConverter conv = typeMgr.getTypeConverterForName(mmd.getTypeConverterName());
                this.dbObject.put(fieldName, conv.toDatastoreType(value));
            } else {
                ColumnMetaData colmd = null;
                if (mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                    colmd = mmd.getColumnMetaData()[0];
                }
                this.processContainerNonRelationField(fieldName, ec, value, this.dbObject, colmd);
            }
            this.op.wrapSCOField(fieldNumber, value, false, false, true);
        }
    }

    protected void processSingleRelationField(Object value, ExecutionContext ec, String fieldName) {
        Object valuePC = this.op.getExecutionContext().persistObjectInternal(value, null, -1, -1);
        Object valueId = ec.getApiAdapter().getIdForObject(valuePC);
        this.dbObject.put(fieldName, (Object)valueId.toString());
    }

    protected void processContainerRelationField(AbstractMemberMetaData mmd, Object value, ExecutionContext ec, String fieldName) {
        if (mmd.hasCollection()) {
            ArrayList<String> collIds = new ArrayList<String>();
            Collection coll = (Collection)value;
            for (Object element : coll) {
                Object elementPC = ec.persistObjectInternal(element, null, -1, -1);
                Object elementID = ec.getApiAdapter().getIdForObject(elementPC);
                collIds.add(elementID.toString());
            }
            this.dbObject.put(fieldName, collIds);
        } else if (mmd.hasMap()) {
            HashSet<BasicDBObject> collEntries = new HashSet<BasicDBObject>();
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                Object pc;
                Object mapKey = entry.getKey();
                Object mapValue = entry.getValue();
                BasicDBObject entryObj = new BasicDBObject();
                if (ec.getApiAdapter().isPersistable(mapKey)) {
                    pc = ec.persistObjectInternal(mapKey, null, -1, -1);
                    Object keyID = ec.getApiAdapter().getIdForObject(pc);
                    entryObj.append("key", (Object)keyID.toString());
                } else {
                    this.processContainerNonRelationField("key", ec, mapKey, (DBObject)entryObj, null);
                }
                if (ec.getApiAdapter().isPersistable(mapValue)) {
                    pc = ec.persistObjectInternal(mapValue, null, -1, -1);
                    Object valueID = ec.getApiAdapter().getIdForObject(pc);
                    entryObj.append("value", (Object)valueID.toString());
                } else {
                    this.processContainerNonRelationField("value", ec, mapValue, (DBObject)entryObj, null);
                }
                collEntries.add(entryObj);
            }
            this.dbObject.put(fieldName, collEntries);
        } else if (mmd.hasArray()) {
            ArrayList<String> collIds = new ArrayList<String>();
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object element = Array.get(value, i);
                Object elementPC = ec.persistObjectInternal(element, null, -1, -1);
                Object elementID = ec.getApiAdapter().getIdForObject(elementPC);
                collIds.add(elementID.toString());
            }
            this.dbObject.put(fieldName, collIds);
        }
    }

    protected void processSerialisedField(String fieldName, Object value, DBObject dbObject) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            dbObject.put(fieldName, (Object)bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException("Exception thrown serialising value for field " + fieldName, (Throwable)e);
        }
    }

    protected void processContainerNonRelationField(String fieldName, ExecutionContext ec, Object value, DBObject dbObject, ColumnMetaData colmd) {
        if (Enum.class.isAssignableFrom(value.getClass())) {
            boolean useLong = MetaDataUtils.persistColumnAsNumeric((ColumnMetaData)colmd);
            dbObject.put(fieldName, useLong ? Integer.valueOf(((Enum)value).ordinal()) : ((Enum)value).name());
            return;
        }
        if (Date.class.isAssignableFrom(value.getClass())) {
            dbObject.put(fieldName, (Object)((Date)value));
            return;
        }
        if (Calendar.class.isAssignableFrom(value.getClass())) {
            Date dateValue = ((Calendar)value).getTime();
            dbObject.put(fieldName, (Object)dateValue);
            return;
        }
        TypeConverter strConv = ec.getTypeManager().getTypeConverterForType(value.getClass(), String.class);
        TypeConverter longConv = ec.getTypeManager().getTypeConverterForType(value.getClass(), Long.class);
        if (strConv != null) {
            String strValue = (String)strConv.toDatastoreType(value);
            dbObject.put(fieldName, (Object)strValue);
        } else if (longConv != null) {
            Long longValue = (Long)longConv.toDatastoreType(value);
            dbObject.put(fieldName, (Object)longValue);
        } else {
            dbObject.put(fieldName, value);
        }
    }
}

