/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.ldap.LDAPUtils;

public class RelationByDnMetaData {
    private AbstractMemberMetaData mmd;
    private AbstractMemberMetaData otherMmd;
    private String emptyValue;
    private boolean hasColumn;

    public RelationByDnMetaData(AbstractMemberMetaData mmd, MetaDataManager mmgr) {
        this.mmd = mmd;
        AbstractClassMetaData otherClassMetaData = LDAPUtils.getEffectiveClassMetaData(mmd, mmgr);
        boolean bl = this.hasColumn = mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0;
        if (mmd.getMappedBy() != null) {
            this.otherMmd = otherClassMetaData.getMetaDataForMember(mmd.getMappedBy());
        } else if (mmd.getElementMetaData() != null && !this.hasColumn) {
            this.otherMmd = null;
        }
        this.emptyValue = mmd.getMappedBy() != null ? LDAPUtils.getEmptyValue(this.otherMmd) : LDAPUtils.getEmptyValue(mmd);
    }

    public AbstractMemberMetaData getOwnerMMD() {
        if (this.mmd.getMappedBy() != null) {
            return this.otherMmd;
        }
        if (this.mmd.getElementMetaData() != null && !this.hasColumn) {
            return null;
        }
        return this.mmd;
    }

    public String getEmptyValue() {
        return this.emptyValue;
    }

    public String getOwnerAttributeName() {
        if (this.mmd.getMappedBy() != null) {
            return LDAPUtils.getAttributeNameForField(this.otherMmd);
        }
        if (this.mmd.getElementMetaData() != null && !this.hasColumn) {
            return this.mmd.getElementMetaData().getColumnName();
        }
        return LDAPUtils.getAttributeNameForField(this.mmd);
    }

    public AbstractMemberMetaData getNonOwnerMMD() {
        if (this.mmd.getMappedBy() != null) {
            return this.mmd;
        }
        if (this.mmd.getElementMetaData() != null && !this.hasColumn) {
            return this.mmd;
        }
        return this.otherMmd;
    }

    public static boolean isRelationByDn(AbstractMemberMetaData mmd, MetaDataManager mmgr) {
        LDAPUtils.LocationInfo locationInfo;
        AbstractClassMetaData effectiveClassMetaData;
        String mappingStrategy;
        if (mmd.hasExtension("mapping-strategy") && (mappingStrategy = mmd.getValueForExtension("mapping-strategy")) != null) {
            if (mappingStrategy.equalsIgnoreCase("attribute")) {
                return false;
            }
            if (mappingStrategy.equalsIgnoreCase("dn")) {
                return true;
            }
        }
        RelationByDnMetaData md = new RelationByDnMetaData(mmd, mmgr);
        if (md.mmd != null) {
            if (md.mmd.getJoinMetaData() != null) {
                return false;
            }
            effectiveClassMetaData = LDAPUtils.getEffectiveClassMetaData(md.mmd, mmgr);
            if (effectiveClassMetaData == null || effectiveClassMetaData.isEmbeddedOnly()) {
                return false;
            }
            locationInfo = LDAPUtils.getLocationInfo(effectiveClassMetaData);
            if (locationInfo.parentFieldName != null) {
                return false;
            }
        }
        if (md.otherMmd != null) {
            if (md.otherMmd.getJoinMetaData() != null) {
                return false;
            }
            effectiveClassMetaData = LDAPUtils.getEffectiveClassMetaData(md.otherMmd, mmgr);
            if (effectiveClassMetaData == null || effectiveClassMetaData.isEmbeddedOnly()) {
                return false;
            }
            locationInfo = LDAPUtils.getLocationInfo(effectiveClassMetaData);
            if (locationInfo.parentFieldName != null) {
                return false;
            }
        }
        return true;
    }
}

