/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.flush.FlushOrdered;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.ldap.LDAPMetaDataListener;
import org.datanucleus.store.ldap.LDAPPersistenceHandler;
import org.datanucleus.util.Localiser;

public class LDAPStoreManager
extends AbstractStoreManager {
    MetaDataListener metadataListener = new LDAPMetaDataListener();

    public LDAPStoreManager(ClassLoaderResolver clr, PersistenceNucleusContext ctx, Map<String, Object> props) {
        super("ldap", clr, ctx, props);
        ctx.getMetaDataManager().registerListener(this.metadataListener);
        this.persistenceHandler = new LDAPPersistenceHandler((StoreManager)this);
        this.flushProcess = new FlushOrdered();
        this.logConfiguration();
    }

    public void close() {
        this.nucleusContext.getMetaDataManager().deregisterListener(this.metadataListener);
        super.close();
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationId");
        set.add("TransactionIsolationLevel.read-committed");
        set.add("ORM");
        set.add("ORM.EmbeddedPC");
        return set;
    }

    static {
        Localiser.registerBundle((String)"org.datanucleus.store.ldap.Localisation", (ClassLoader)LDAPStoreManager.class.getClassLoader());
    }
}

