/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.ContextNotEmptyException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.ldap.LDAPStoreManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.FetchFieldManager;
import org.datanucleus.store.ldap.fieldmanager.RelationByAttributeMetaData;
import org.datanucleus.store.ldap.fieldmanager.RelationByDnMetaData;
import org.datanucleus.store.ldap.fieldmanager.StoreFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class LDAPPersistenceHandler
extends AbstractPersistenceHandler {
    protected static final Localiser LOCALISER_LDAP = Localiser.getInstance((String)"org.datanucleus.store.ldap.Localisation", (ClassLoader)LDAPStoreManager.class.getClassLoader());

    public LDAPPersistenceHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void close() {
    }

    public void insertObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (LDAPUtils.isHierarchicalMappedAtChild(op)) {
            LDAPUtils.LocationInfo locationInfo = LDAPUtils.getLocationInfo(cmd);
            AbstractMemberMetaData parentFieldMmd = cmd.getMetaDataForMember(locationInfo.parentFieldName);
            Object parentFieldValue = op.provideField(parentFieldMmd.getAbsoluteFieldNumber());
            if (parentFieldValue != null) {
                LDAPUtils.getObjectProviderForObject(parentFieldValue, op.getExecutionContext(), true);
            } else if (locationInfo.dn == null) {
                throw new NucleusUserException(LOCALISER_LDAP.msg("LDAP.Insert.MissingParentReference", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
        }
        if (cmd.getIdentityType() != IdentityType.APPLICATION && cmd.getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusUserException(LOCALISER_LDAP.msg("LDAP.DatastoreID"));
        }
        Set<String> objectClasses = LDAPUtils.getObjectClassesForClass(op.getClassMetaData());
        if (objectClasses == null) {
            throw new NucleusDataStoreException("Missing 'objectClass' extension or 'schema' attribute for class " + cmd.getName());
        }
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_LDAP.msg("LDAP.Insert.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
            DirContext ctx = (DirContext)mconn.getConnection();
            BasicAttributes attrs = new BasicAttributes();
            List<AbstractMemberMetaData> nonEmbeddedMmds = LDAPUtils.getAllMemberMetaData(cmd);
            ArrayList<AbstractMemberMetaData> embeddedMmds = new ArrayList<AbstractMemberMetaData>();
            Iterator<AbstractMemberMetaData> it = nonEmbeddedMmds.iterator();
            while (it.hasNext()) {
                AbstractMemberMetaData mmd = it.next();
                if (!LDAPUtils.isEmbeddedField(mmd)) continue;
                embeddedMmds.add(mmd);
                it.remove();
            }
            int[] nonEmbeddedFieldNumbers = new int[nonEmbeddedMmds.size()];
            for (int i = 0; i < nonEmbeddedFieldNumbers.length; ++i) {
                nonEmbeddedFieldNumbers[i] = nonEmbeddedMmds.get(i).getAbsoluteFieldNumber();
            }
            int[] embeddedFieldNumbers = new int[embeddedMmds.size()];
            for (int i = 0; i < embeddedFieldNumbers.length; ++i) {
                embeddedFieldNumbers[i] = ((AbstractMemberMetaData)embeddedMmds.get(i)).getAbsoluteFieldNumber();
            }
            op.provideFields(nonEmbeddedFieldNumbers, (FieldManager)new StoreFieldManager(this.storeMgr, op, attrs, true));
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, op, false);
            BasicAttribute objectClass = new BasicAttribute("objectClass");
            for (String oc : objectClasses) {
                objectClass.add(oc);
            }
            attrs.put(objectClass);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_LDAP.msg("LDAP.JNDI.createSubcontext", (Object)dn, (Object)attrs));
            }
            ctx.bind(dn, null, (Attributes)attrs);
            attrs = new BasicAttributes();
            op.provideFields(embeddedFieldNumbers, (FieldManager)new StoreFieldManager(this.storeMgr, op, attrs, true));
            if (attrs.size() > 0) {
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_LDAP.msg("LDAP.JNDI.modifyAttributes", (Object)dn, (Object)"REPLACE", (Object)attrs));
                }
                ctx.modifyAttributes(dn, 2, (Attributes)attrs);
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_LDAP.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementInsertCount();
            }
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)LOCALISER_LDAP.msg("LDAP.Insert.ObjectPersisted", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
        }
        catch (NameAlreadyBoundException e) {
            throw new NucleusUserException(LOCALISER_LDAP.msg("LDAP.Insert.ObjectWithIdAlreadyExists", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()), (Throwable)e);
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void updateObject(ObjectProvider op, int[] fieldNumbers) {
        this.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                AbstractClassMetaData cmd = op.getClassMetaData();
                StringBuffer fieldStr = new StringBuffer();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_LDAP.msg("LDAP.Update.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId(), (Object)fieldStr.toString()));
            }
            DirContext ctx = (DirContext)mconn.getConnection();
            AbstractClassMetaData cmd = op.getClassMetaData();
            if (LDAPUtils.isHierarchicalMappedAtChild(op)) {
                LDAPUtils.LocationInfo locationInfo = LDAPUtils.getLocationInfo(cmd);
                AbstractMemberMetaData parentFieldMmd = cmd.getMetaDataForMember(locationInfo.parentFieldName);
                int absoluteFieldNumber = parentFieldMmd.getAbsoluteFieldNumber();
                for (int i : fieldNumbers) {
                    if (i != absoluteFieldNumber) continue;
                    LdapName oldDn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, op, true);
                    op.setAssociatedValue((Object)"dn", null);
                    LdapName newDn = null;
                    Object parentFieldValue = op.provideField(absoluteFieldNumber);
                    if (parentFieldValue != null) {
                        newDn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, op, false);
                    } else if (locationInfo.dn != null) {
                        newDn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, op, false);
                    }
                    if (newDn == null || oldDn.equals(newDn)) break;
                    LDAPUtils.markForRename(this.storeMgr, op.getObject(), ec, oldDn, newDn);
                    LDAPUtils.unmarkForDeletion(op.getObject(), ec);
                    break;
                }
            }
            BasicAttributes attrs = new BasicAttributes();
            op.provideFields(fieldNumbers, (FieldManager)new StoreFieldManager(this.storeMgr, op, attrs, false));
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, op, true);
            if (attrs.size() > 0) {
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)LOCALISER_LDAP.msg("LDAP.JNDI.modifyAttributes", (Object)dn, (Object)"REPLACE", (Object)attrs));
                }
                ctx.modifyAttributes(dn, 2, (Attributes)attrs);
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_LDAP.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementUpdateCount();
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        op.loadUnloadedFields();
        op.provideFields(op.getClassMetaData().getAllMemberPositions(), (FieldManager)new DeleteFieldManager(op));
        this.deleteDnReferences(op);
        this.deleteAttributeReferences(op);
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        DirContext ctx = (DirContext)mconn.getConnection();
        long startTime = System.currentTimeMillis();
        try {
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_LDAP.msg("LDAP.Delete.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, op, true);
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)LOCALISER_LDAP.msg("LDAP.JNDI.destroySubcontext", (Object)dn));
            }
            ctx.unbind(dn);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_LDAP.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementDeleteCount();
            }
        }
        catch (ContextNotEmptyException cnee) {
            try {
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_LDAP.msg("LDAP.DeleteRecursive.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
                }
                LDAPUtils.deleteRecursive(LDAPUtils.getDistinguishedNameForObject(this.storeMgr, op, true), ctx);
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_LDAP.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
                }
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    private void deleteDnReferences(ObjectProvider op) {
        int[] fieldNumbers;
        for (int fieldNumber : fieldNumbers = op.getClassMetaData().getAllMemberPositions()) {
            ElementMetaData elementMetaData;
            AbstractMemberMetaData mmd = op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            if (!RelationByDnMetaData.isRelationByDn(mmd, op.getExecutionContext().getMetaDataManager()) || (elementMetaData = mmd.getElementMetaData()) == null) continue;
            AbstractClassMetaData otherCmd = LDAPUtils.getEffectiveClassMetaData(mmd, op.getExecutionContext().getMetaDataManager());
            Class c = op.getExecutionContext().getClassLoaderResolver().classForName(otherCmd.getFullClassName());
            if (c.isInterface() || Modifier.isAbstract(c.getModifiers())) continue;
            String name = elementMetaData.getColumnName() != null ? elementMetaData.getColumnName() : elementMetaData.getColumnMetaData()[0].getName();
            String emptyValue = LDAPUtils.getEmptyValue(mmd);
            this.deleteDnReference(otherCmd, name, op, emptyValue);
        }
        ClassLoaderResolver clr = op.getExecutionContext().getClassLoaderResolver();
        MetaDataManager mdm = op.getExecutionContext().getMetaDataManager();
        Collection classesWithMetaData = mdm.getClassesWithMetaData();
        for (String className : classesWithMetaData) {
            Class c;
            AbstractClassMetaData otherCmd = mdm.getMetaDataForClass(className, clr);
            if (otherCmd.isEmbeddedOnly() || (c = op.getExecutionContext().getClassLoaderResolver().classForName(className)).isInterface() || Modifier.isAbstract(c.getModifiers())) continue;
            for (int fieldNumber : fieldNumbers = otherCmd.getAllMemberPositions()) {
                String[] subclassNames;
                AbstractMemberMetaData mmd = otherCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                if (!RelationByDnMetaData.isRelationByDn(mmd, op.getExecutionContext().getMetaDataManager())) continue;
                AbstractClassMetaData effectiveCmd = LDAPUtils.getEffectiveClassMetaData(mmd, op.getExecutionContext().getMetaDataManager());
                String[] stringArray = subclassNames = effectiveCmd != null ? op.getExecutionContext().getMetaDataManager().getSubclassesForClass(effectiveCmd.getFullClassName(), true) : null;
                if (effectiveCmd != op.getClassMetaData() && (subclassNames == null || !Arrays.asList(subclassNames).contains(op.getClassMetaData().getFullClassName()))) continue;
                String name = LDAPUtils.getAttributeNameForField(mmd);
                String emptyValue = LDAPUtils.getEmptyValue(mmd);
                this.deleteDnReference(otherCmd, name, op, emptyValue);
            }
        }
    }

    private void deleteDnReference(AbstractClassMetaData cmd, String name, ObjectProvider op, Object emptyValue) {
        LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, op, true);
        ExecutionContext om = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(om);
        try {
            LdapName base = LDAPUtils.getSearchBase(cmd, op.getExecutionContext().getMetaDataManager());
            String ocFilter = LDAPUtils.getSearchFilter(cmd);
            String dnFilter = "(" + name + "=" + dn.toString() + ")";
            String filter = ocFilter != null ? "(&" + ocFilter + dnFilter + ")" : dnFilter;
            SearchControls searchControls = LDAPUtils.getSearchControls(cmd);
            searchControls.setReturningAttributes(new String[]{name});
            DirContext ctx = (DirContext)mconn.getConnection();
            NamingEnumeration<SearchResult> enumeration = ctx.search((Name)base, filter, searchControls);
            while (enumeration.hasMoreElements()) {
                boolean removed;
                SearchResult sr = (SearchResult)enumeration.nextElement();
                String srName = sr.getNameInNamespace();
                Attributes attrs = sr.getAttributes();
                Attribute attr = sr.getAttributes().get(name);
                if (attr == null || !(removed = attr.remove(dn.toString()))) continue;
                if (attr.size() == 0 && emptyValue != null) {
                    attr.add(emptyValue);
                }
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_LDAP.msg("LDAP.JNDI.DeleteDnReference", (Object)srName, (Object)dn));
                }
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)LOCALISER_LDAP.msg("LDAP.JNDI.modifyAttributes", (Object)srName, (Object)"REPLACE", (Object)attrs));
                }
                ctx.modifyAttributes(srName, 2, attrs);
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    private void deleteAttributeReferences(ObjectProvider op) {
        int[] fieldNumbers;
        for (int fieldNumber : fieldNumbers = op.getClassMetaData().getAllMemberPositions()) {
            RelationByAttributeMetaData mappingMetaData;
            ElementMetaData elementMetaData;
            AbstractMemberMetaData mmd = op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            if (!RelationByAttributeMetaData.isRelationByAttribute(mmd, op.getExecutionContext().getMetaDataManager()) || (elementMetaData = mmd.getElementMetaData()) == null || (mappingMetaData = new RelationByAttributeMetaData(mmd, op.getExecutionContext().getMetaDataManager())).getNonOwnerMMD() != mmd) continue;
            String ownerAttributeName = mappingMetaData.getOwnerAttributeName();
            String joinAttributeName = mappingMetaData.getJoinAttributeName();
            Object joinAttributeValue = LDAPUtils.getAttributeValue(this.storeMgr, op, joinAttributeName);
            String emptyValue = LDAPUtils.getEmptyValue(mmd);
            AbstractClassMetaData otherCmd = LDAPUtils.getEffectiveClassMetaData(mmd, op.getExecutionContext().getMetaDataManager());
            this.deleteAttributeReference(otherCmd, ownerAttributeName, joinAttributeValue, op, emptyValue);
        }
        ClassLoaderResolver clr = op.getExecutionContext().getClassLoaderResolver();
        MetaDataManager mdm = op.getExecutionContext().getMetaDataManager();
        Collection classesWithMetaData = mdm.getClassesWithMetaData();
        for (String className : classesWithMetaData) {
            Class c;
            AbstractClassMetaData otherCmd = mdm.getMetaDataForClass(className, clr);
            if (otherCmd.isEmbeddedOnly() || (c = op.getExecutionContext().getClassLoaderResolver().classForName(className)).isInterface() || Modifier.isAbstract(c.getModifiers())) continue;
            for (int fieldNumber : fieldNumbers = otherCmd.getAllMemberPositions()) {
                RelationByAttributeMetaData mappingMetaData;
                String[] subclassNames;
                AbstractMemberMetaData mmd = otherCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                if (!RelationByAttributeMetaData.isRelationByAttribute(mmd, op.getExecutionContext().getMetaDataManager())) continue;
                AbstractClassMetaData effectiveCmd = LDAPUtils.getEffectiveClassMetaData(mmd, op.getExecutionContext().getMetaDataManager());
                String[] stringArray = subclassNames = effectiveCmd != null ? op.getExecutionContext().getMetaDataManager().getSubclassesForClass(effectiveCmd.getFullClassName(), true) : null;
                if (effectiveCmd != op.getClassMetaData() && (subclassNames == null || !Arrays.asList(subclassNames).contains(op.getClassMetaData().getFullClassName())) || (mappingMetaData = new RelationByAttributeMetaData(mmd, op.getExecutionContext().getMetaDataManager())).getOwnerMMD() != mmd) continue;
                String ownerAttributeName = mappingMetaData.getOwnerAttributeName();
                String joinAttributeName = mappingMetaData.getJoinAttributeName();
                Object joinAttributeValue = LDAPUtils.getAttributeValue(this.storeMgr, op, joinAttributeName);
                String emptyValue = LDAPUtils.getEmptyValue(mmd);
                this.deleteAttributeReference(otherCmd, ownerAttributeName, joinAttributeValue, op, emptyValue);
            }
        }
    }

    private void deleteAttributeReference(AbstractClassMetaData cmd, String attributeName, Object attributeValue, ObjectProvider op, Object emptyValue) {
        ExecutionContext om = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(om);
        try {
            LdapName base = LDAPUtils.getSearchBase(cmd, op.getExecutionContext().getMetaDataManager());
            String ocFilter = LDAPUtils.getSearchFilter(cmd);
            String dnFilter = "(" + attributeName + "=" + attributeValue + ")";
            String filter = ocFilter != null ? "(&" + ocFilter + dnFilter + ")" : dnFilter;
            SearchControls searchControls = LDAPUtils.getSearchControls(cmd);
            searchControls.setReturningAttributes(new String[]{attributeName});
            DirContext ctx = (DirContext)mconn.getConnection();
            NamingEnumeration<SearchResult> enumeration = ctx.search((Name)base, filter, searchControls);
            while (enumeration.hasMoreElements()) {
                boolean removed;
                SearchResult sr = (SearchResult)enumeration.nextElement();
                String srName = sr.getNameInNamespace();
                Attributes attrs = sr.getAttributes();
                Attribute attr = sr.getAttributes().get(attributeName);
                if (attr == null || !(removed = attr.remove(attributeValue))) continue;
                if (attr.size() == 0 && emptyValue != null) {
                    attr.add(emptyValue);
                }
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_LDAP.msg("LDAP.JNDI.DeleteAttributeReference", (Object)attributeName, attributeValue, (Object)srName));
                }
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)LOCALISER_LDAP.msg("LDAP.JNDI.modifyAttributes", (Object)srName, (Object)"REPLACE", (Object)attrs));
                }
                ctx.modifyAttributes(srName, 2, attrs);
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void fetchObject(ObjectProvider op, int[] fieldNumbers) {
        int i;
        if (op.getLifecycleState().isDeleted()) {
            return;
        }
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            StringBuffer str = new StringBuffer("Fetching object \"");
            str.append(op.getObjectAsPrintable()).append("\" (id=");
            str.append(op.getInternalObjectId()).append(")").append(" fields [");
            for (i = 0; i < fieldNumbers.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
            }
            str.append("]");
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)str.toString());
        }
        ArrayList<String> attributeNameList = new ArrayList<String>();
        for (i = 0; i < fieldNumbers.length; ++i) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(this.storeMgr, op, mmd, new BasicAttributes());
            List<String> attributeNames = ms.getAttributeNames();
            attributeNameList.addAll(attributeNames);
        }
        String[] attributeNames = attributeNameList.toArray(new String[0]);
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER_LDAP.msg("LDAP.Fetch.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
            DirContext ctx = (DirContext)mconn.getConnection();
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, op, true);
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)LOCALISER_LDAP.msg("LDAP.JNDI.getAttributes", (Object)dn, attributeNameList, (Object)""));
            }
            Attributes result = ctx.getAttributes(dn, attributeNames);
            op.replaceFields(fieldNumbers, (FieldManager)new FetchFieldManager(this.storeMgr, op, result));
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER_LDAP.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumReads();
                ec.getStatistics().incrementFetchCount();
            }
        }
        catch (NameNotFoundException e) {
            throw new NucleusObjectNotFoundException("Object not found", op.getInternalObjectId());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ExecutionContext ec, Object id) {
        return null;
    }

    public void locateObject(ObjectProvider op) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            ExecutionContext ec = op.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                long startTime = System.currentTimeMillis();
                if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER_LDAP.msg("LDAP.Locate.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
                }
                DirContext ctx = (DirContext)mconn.getConnection();
                LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, op, true);
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)LOCALISER_LDAP.msg("LDAP.JNDI.getAttributes", (Object)dn, (Object)"none", (Object)""));
                }
                ctx.getAttributes(dn, LDAPUtils.NO_ATTRIBUTES);
                if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER_LDAP.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
                }
                if (ec.getStatistics() != null) {
                    ec.getStatistics().incrementNumReads();
                }
                return;
            }
            catch (NameNotFoundException e) {
                throw new NucleusObjectNotFoundException("Object not found", op.getInternalObjectId());
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusUserException(LOCALISER_LDAP.msg("LDAP.DatastoreID"));
        }
    }
}

