/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.transaction.xa.XAResource;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.ldap.LDAPUtils;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    public ConnectionFactoryImpl(StoreManager storeMgr, String resourceType) {
        super(storeMgr, resourceType);
    }

    public ManagedConnection createManagedConnection(Object poolKey, Map transactionOptions) {
        return new ManagedConnectionImpl(transactionOptions);
    }

    public class ManagedConnectionImpl
    extends AbstractManagedConnection {
        Map options;
        LdapContext mainContext;
        List<LdapContext> subContexts;

        public ManagedConnectionImpl(Map options) {
            this.options = options;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.mainContext == null) {
                return;
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            try {
                try {
                    for (LdapContext subContext : this.subContexts) {
                        subContext.close();
                    }
                    this.mainContext.close();
                }
                catch (Exception e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.subContexts = null;
                this.mainContext = null;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
                }
            }
        }

        public Object getConnection() {
            if (this.mainContext == null) {
                try {
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    env.put("java.naming.factory.initial", ConnectionFactoryImpl.this.storeMgr.getConnectionDriverName());
                    env.put("java.naming.provider.url", ConnectionFactoryImpl.this.storeMgr.getConnectionURL());
                    env.put("java.naming.security.principal", ConnectionFactoryImpl.this.storeMgr.getConnectionUserName());
                    env.put("java.naming.security.credentials", ConnectionFactoryImpl.this.storeMgr.getConnectionPassword());
                    if ("JNDI".equals(ConnectionFactoryImpl.this.storeMgr.getStringProperty("datanucleus.connectionPoolingType"))) {
                        int size;
                        env.put("com.sun.jndi.ldap.connect.pool", "true");
                        if (ConnectionFactoryImpl.this.storeMgr.hasProperty("datanucleus.connectionPool.maxPoolSize") && (size = ConnectionFactoryImpl.this.storeMgr.getIntProperty("datanucleus.connectionPool.maxPoolSize")) >= 0) {
                            System.setProperty("com.sun.jndi.ldap.connect.pool.maxsize", "" + size);
                        }
                        if (ConnectionFactoryImpl.this.storeMgr.hasProperty("datanucleus.connectionPool.initialPoolSize") && (size = ConnectionFactoryImpl.this.storeMgr.getIntProperty("datanucleus.connectionPool.initialPoolSize")) >= 0) {
                            System.setProperty("com.sun.jndi.ldap.connect.pool.initsize", "" + size);
                        }
                    }
                    MetaDataManager mdm = ConnectionFactoryImpl.this.storeMgr.getNucleusContext().getMetaDataManager();
                    Collection classesWithMetaData = mdm.getClassesWithMetaData();
                    StringBuilder sb = new StringBuilder();
                    for (String className : classesWithMetaData) {
                        AbstractClassMetaData cmd = mdm.getMetaDataForClass(className, ConnectionFactoryImpl.this.storeMgr.getNucleusContext().getClassLoaderResolver(null));
                        List<AbstractMemberMetaData> mmds = LDAPUtils.getAllMemberMetaData(cmd);
                        for (AbstractMemberMetaData mmd : mmds) {
                            if (mmd.getJoinMetaData() != null || !mmd.getType().isArray()) continue;
                            String attributeNameForField = LDAPUtils.getAttributeNameForField(mmd);
                            sb.append(attributeNameForField).append(' ');
                        }
                    }
                    if (sb.length() > 0) {
                        env.put("java.naming.ldap.attributes.binary", sb.toString());
                    }
                    this.mainContext = new InitialLdapContext(env, null);
                    this.subContexts = new ArrayList<LdapContext>();
                }
                catch (NamingException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            try {
                LdapContext subContext = this.mainContext.newInstance(null);
                this.subContexts.add(subContext);
                return subContext;
            }
            catch (NamingException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        }

        public XAResource getXAResource() {
            return null;
        }
    }
}

