/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Calendar;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.types.ObjectStringConverter;
import org.datanucleus.util.ClassUtils;

public class CalendarToGeneralizedTimeStringConverter
implements ObjectStringConverter {
    public Object toObject(String str) {
        if (str == null) {
            return null;
        }
        try {
            Class<?> cls = Class.forName("org.apache.directory.shared.ldap.util.GeneralizedTime");
            Constructor constr = ClassUtils.getConstructorWithArguments(cls, (Class[])new Class[]{String.class});
            Object instance = constr.newInstance(str);
            Method method = ClassUtils.getMethodForClass(cls, (String)"getCalendar", null);
            Calendar calendar = (Calendar)method.invoke(instance, (Object[])null);
            calendar.setLenient(true);
            calendar.set(14, 0);
            return calendar;
        }
        catch (Throwable e) {
            throw new NucleusException("Type java.util.Calendar is not supported without Apache Directory shared-ldap library.");
        }
    }

    public String toString(Object obj) {
        String str;
        if (obj instanceof Calendar) {
            Calendar calendar = (Calendar)obj;
            calendar.set(14, 0);
            try {
                Class<?> cls = Class.forName("org.apache.directory.shared.ldap.util.GeneralizedTime");
                Constructor constr = ClassUtils.getConstructorWithArguments(cls, (Class[])new Class[]{Calendar.class});
                Object instance = constr.newInstance(obj);
                Method method = ClassUtils.getMethodForClass(cls, (String)"toGeneralizedTime", null);
                str = (String)method.invoke(instance, (Object[])null);
            }
            catch (Throwable e) {
                throw new NucleusException("Type java.util.Calendar is not supported without Apache Directory shared-ldap library.");
            }
        } else {
            str = (String)obj;
        }
        return str;
    }
}

