/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.transaction.xa.XAResource;
import org.datanucleus.ConnectionFactory;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ManagedConnectionResourceListener;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;

public class ConnectionFactoryImpl
implements ConnectionFactory {
    OMFContext omfContext;

    public ConnectionFactoryImpl(OMFContext omfContext, String resourceType) {
        this.omfContext = omfContext;
    }

    public ManagedConnection getConnection(ObjectManager om, Map options) {
        HashMap addedOptions = new HashMap();
        if (options != null) {
            addedOptions.putAll(options);
        }
        return this.omfContext.getConnectionManager().allocateConnection((ConnectionFactory)this, om, addedOptions);
    }

    public ManagedConnection createManagedConnection(ObjectManager om, Map transactionOptions) {
        return new ManagedConnectionImpl(om.getOMFContext(), transactionOptions);
    }

    public static class ManagedConnectionImpl
    implements ManagedConnection {
        OMFContext omf;
        Map options;
        LdapContext mainContext;
        List<LdapContext> subContexts;
        boolean locked = false;
        List<ManagedConnectionResourceListener> listeners = new ArrayList<ManagedConnectionResourceListener>();

        public ManagedConnectionImpl(OMFContext omf, Map options) {
            this.omf = omf;
            this.options = options;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.mainContext == null) {
                return;
            }
            for (ManagedConnectionResourceListener listener : this.listeners) {
                listener.managedConnectionPreClose();
            }
            try {
                try {
                    for (LdapContext subContext : this.subContexts) {
                        subContext.close();
                    }
                    this.mainContext.close();
                }
                catch (Exception e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
                this.subContexts = null;
                this.mainContext = null;
            }
            catch (Throwable throwable) {
                this.subContexts = null;
                this.mainContext = null;
                for (ManagedConnectionResourceListener listener : this.listeners) {
                    listener.managedConnectionPostClose();
                }
                throw throwable;
            }
            for (ManagedConnectionResourceListener listener : this.listeners) {
                listener.managedConnectionPostClose();
            }
        }

        public void flush() {
            for (ManagedConnectionResourceListener listener : this.listeners) {
                listener.managedConnectionFlushed();
            }
        }

        public Object getConnection() {
            if (this.mainContext == null) {
                try {
                    PersistenceConfiguration conf = this.omf.getPersistenceConfiguration();
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    env.put("java.naming.factory.initial", conf.getStringProperty("datanucleus.ConnectionDriverName"));
                    env.put("java.naming.provider.url", conf.getStringProperty("datanucleus.ConnectionURL"));
                    env.put("java.naming.security.principal", conf.getStringProperty("datanucleus.ConnectionUserName"));
                    env.put("java.naming.security.credentials", conf.getStringProperty("datanucleus.ConnectionPassword"));
                    if ("JNDI".equals(conf.getStringProperty("datanucleus.connectionPoolingType"))) {
                        int size;
                        env.put("com.sun.jndi.ldap.connect.pool", "true");
                        if (conf.hasProperty("datanucleus.connectionPool.maxPoolSize") && (size = conf.getIntProperty("datanucleus.connectionPool.maxPoolSize")) >= 0) {
                            System.setProperty("com.sun.jndi.ldap.connect.pool.maxsize", "" + size);
                        }
                        if (conf.hasProperty("datanucleus.connectionPool.initialPoolSize") && (size = conf.getIntProperty("datanucleus.connectionPool.initialPoolSize")) >= 0) {
                            System.setProperty("com.sun.jndi.ldap.connect.pool.initsize", "" + size);
                        }
                    }
                    this.mainContext = new InitialLdapContext(env, null);
                    this.subContexts = new ArrayList<LdapContext>();
                }
                catch (NamingException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            try {
                LdapContext subContext = this.mainContext.newInstance(null);
                this.subContexts.add(subContext);
                return subContext;
            }
            catch (NamingException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        }

        public XAResource getXAResource() {
            return null;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void lock() {
            this.locked = true;
        }

        public void unlock() {
            this.locked = false;
        }

        public void release() {
        }

        public void addListener(ManagedConnectionResourceListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(ManagedConnectionResourceListener listener) {
            this.listeners.remove(listener);
        }

        public void setManagedResource() {
        }
    }
}

