/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.googlestorage;

import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.json.googlestorage.GoogleStoragePersistenceHandler;
import org.datanucleus.store.json.query.JDOQLQuery;
import org.datanucleus.store.json.query.JPQLQuery;
import org.datanucleus.store.query.Query;

public class GoogleStorageStoreManager
extends AbstractStoreManager {
    public GoogleStorageStoreManager(ClassLoaderResolver clr, PersistenceNucleusContext ctx, Map<String, Object> props) {
        super("googlestorage", clr, ctx, props);
        this.persistenceHandler = new GoogleStoragePersistenceHandler((StoreManager)this);
        this.connectionMgr.disableConnectionCaching();
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        this.logConfiguration();
    }

    public Query newQuery(String language, ExecutionContext ec) {
        if (language.equalsIgnoreCase("JDOQL")) {
            return new JDOQLQuery((StoreManager)this, ec);
        }
        if (language.equalsIgnoreCase("JPQL")) {
            return new JPQLQuery((StoreManager)this, ec);
        }
        throw new NucleusException("Error creating query for language " + language);
    }

    public Query newQuery(String language, ExecutionContext ec, String queryString) {
        if (language.equalsIgnoreCase("JDOQL")) {
            return new JDOQLQuery((StoreManager)this, ec, queryString);
        }
        if (language.equalsIgnoreCase("JPQL")) {
            return new JPQLQuery((StoreManager)this, ec, queryString);
        }
        throw new NucleusException("Error creating query for language " + language);
    }

    public Query newQuery(String language, ExecutionContext ec, Query q) {
        if (language.equalsIgnoreCase("JDOQL")) {
            return new JDOQLQuery((StoreManager)this, ec, (JDOQLQuery)q);
        }
        if (language.equalsIgnoreCase("JPQL")) {
            return new JPQLQuery((StoreManager)this, ec, (JPQLQuery)q);
        }
        throw new NucleusException("Error creating query for language " + language);
    }

    public NucleusConnection getNucleusConnection(ExecutionContext ec) {
        throw new UnsupportedOperationException();
    }
}

