/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.json.JsonPersistenceHandler;
import org.datanucleus.store.json.SchemaVerifierImpl;
import org.datanucleus.store.schema.table.CompleteClassTable;
import org.datanucleus.store.schema.table.SchemaVerifier;

public class JsonStoreManager
extends AbstractStoreManager {
    public JsonStoreManager(ClassLoaderResolver clr, PersistenceNucleusContext ctx, Map<String, Object> props) {
        super("json", clr, ctx, props);
        this.persistenceHandler = new JsonPersistenceHandler((StoreManager)this);
        this.connectionMgr.disableConnectionPool();
        this.logConfiguration();
    }

    public NucleusConnection getNucleusConnection(ExecutionContext ec) {
        throw new UnsupportedOperationException();
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationId");
        set.add("ApplicationCompositeId");
        set.add("DatastoreId");
        set.add("TransactionIsolationLevel.read-committed");
        set.add("ORM");
        set.add("ORM.EmbeddedPC.Nested");
        return set;
    }

    public void manageClasses(ClassLoaderResolver clr, String ... classNames) {
        if (classNames == null) {
            return;
        }
        String[] filteredClassNames = this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        for (ClassMetaData cmd : this.getMetaDataManager().getReferencedClasses(filteredClassNames, clr)) {
            StoreData sd;
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd.isEmbeddedOnly() || cmd.isAbstract() || this.storeDataMgr.managesClass(cmd.getFullClassName()) || (sd = this.storeDataMgr.get(cmd.getFullClassName())) != null) continue;
            CompleteClassTable table = new CompleteClassTable((StoreManager)this, (AbstractClassMetaData)cmd, (SchemaVerifier)new SchemaVerifierImpl((StoreManager)this, (AbstractClassMetaData)cmd, clr));
            sd = this.newStoreData(cmd, clr);
            sd.addProperty("tableObject", (Object)table);
            this.registerStoreData(sd);
        }
    }
}

