/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.json.CloudStorageUtils;
import org.datanucleus.store.json.JSONUtils;
import org.datanucleus.store.json.JsonPersistenceHandler;
import org.datanucleus.store.json.fieldmanager.FetchFieldManager;
import org.datanucleus.store.json.fieldmanager.StoreFieldManager;
import org.datanucleus.util.NucleusLogger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CloudStoragePersistenceHandler
extends JsonPersistenceHandler {
    CloudStoragePersistenceHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    @Override
    public void insertObject(ObjectProvider op) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(op);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.datanucleus.store.json.url", "/");
        ManagedConnection mconn = this.storeMgr.getConnection(op.getExecutionContext(), options);
        URLConnection conn = (URLConnection)mconn.getConnection();
        this.createBucket(conn, this.getHeaderForBucket());
        options.put("org.datanucleus.store.json.url", this.getURLPath(op));
        options.put("Content-Type", "application/json");
        mconn = this.storeMgr.getConnection(op.getExecutionContext(), options);
        conn = (URLConnection)mconn.getConnection();
        JSONObject jsonobj = new JSONObject();
        op.provideFields(op.getClassMetaData().getAllMemberPositions(), (FieldManager)new StoreFieldManager(op, jsonobj, true));
        this.write("PUT", conn.getURL().getPath(), conn, jsonobj, this.getHeaders("PUT", options));
    }

    protected void createBucket(URLConnection conn, Map headers) {
        try {
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)"Creating bucket. ");
            }
            HttpURLConnection http = (HttpURLConnection)conn;
            for (String key : headers.keySet()) {
                String value = (String)headers.get(key);
                http.setRequestProperty(key, value);
            }
            http.setRequestProperty("Content-Length", "0");
            http.setDoOutput(true);
            http.setRequestMethod("PUT");
            http.setReadTimeout(10000);
            http.setConnectTimeout(10000);
            http.connect();
            int code = http.getResponseCode();
            if (code != 409) {
                if (code >= 400) {
                    int r;
                    StringBuffer sb = new StringBuffer();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((r = http.getErrorStream().read(buffer)) != -1) {
                        baos.write(buffer, 0, r);
                    }
                    sb.append(new String(baos.toByteArray()));
                    http.getErrorStream().close();
                    throw new NucleusDataStoreException("HTTP Error code: " + code + " " + http.getResponseMessage() + " error: " + sb.toString());
                }
                if (code >= 300) {
                    throw new NucleusDataStoreException("Redirect not supported. HTTP Error code: " + code + " " + http.getResponseMessage());
                }
            }
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected Map<String, String> getHeaders(String httpVerb, Map<String, String> options) {
        Map<String, String> headers = super.getHeaders(httpVerb, options);
        String contentMD5 = "";
        String contentType = "";
        if (options.containsKey("Content-Type")) {
            contentType = options.get("Content-Type");
        }
        String urlStr = this.storeMgr.getConnectionURL();
        String authenticationKey = this.storeMgr.getConnectionUserName();
        String authenticationSecretKey = this.storeMgr.getConnectionPassword();
        try {
            urlStr = urlStr.substring(urlStr.indexOf(this.storeMgr.getStoreManagerKey() + ":") + this.storeMgr.getStoreManagerKey().length() + 1);
            headers.put("Host", this.getBucket() + "." + new URL(urlStr).getHost());
            String path = "/" + this.getBucket();
            if (options.containsKey("org.datanucleus.store.json.url")) {
                if (!options.get("org.datanucleus.store.json.url").toString().startsWith("/")) {
                    path = path + "/";
                }
                path = options.get("org.datanucleus.store.json.url").toString().indexOf("?") > -1 ? path + options.get("org.datanucleus.store.json.url").toString().substring(0, options.get("org.datanucleus.store.json.url").toString().indexOf("?")) : path + options.get("org.datanucleus.store.json.url").toString();
            } else {
                path = path + new URL(urlStr).getPath();
            }
            String stringToSign = httpVerb + "\n" + contentMD5 + "\n" + contentType + "\n" + headers.get("Date") + "\n" + path;
            headers.put("Authorization", this.getRealmName() + " " + authenticationKey + ":" + CloudStorageUtils.hmac(authenticationSecretKey, stringToSign));
        }
        catch (MalformedURLException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return headers;
    }

    protected abstract String getRealmName();

    protected Map getHeaderForBucket() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Date", CloudStorageUtils.getHTTPDate());
        String contentMD5 = "";
        String contentType = "";
        String httpVerb = "PUT";
        String urlStr = this.storeMgr.getConnectionURL();
        String awsKey = this.storeMgr.getConnectionUserName();
        String awsSecretKey = this.storeMgr.getConnectionPassword();
        try {
            urlStr = urlStr.substring(urlStr.indexOf(this.storeMgr.getStoreManagerKey() + ":") + this.storeMgr.getStoreManagerKey().length() + 1);
            headers.put("Host", this.getBucket() + "." + new URL(urlStr).getHost());
            String stringToSign = httpVerb + "\n" + contentMD5 + "\n" + contentType + "\n" + headers.get("Date") + "\n" + "/" + this.getBucket() + "/";
            headers.put("Authorization", "AWS " + awsKey + ":" + CloudStorageUtils.hmac(awsSecretKey, stringToSign));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return headers;
    }

    @Override
    public List getObjectsOfCandidateType(final ExecutionContext ec, ManagedConnection mconn, Class candidateClass, boolean subclasses, boolean ignoreCache, Map options) {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            JSONArray jsonarray;
            URLConnection conn = (URLConnection)mconn.getConnection();
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            final AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(candidateClass, clr);
            try {
                HttpURLConnection http = (HttpURLConnection)conn;
                Map<String, String> headers = this.getHeaders("GET", options);
                for (String key : headers.keySet()) {
                    String value = headers.get(key);
                    http.setRequestProperty(key, value);
                }
                http.setDoInput(true);
                http.setRequestMethod("GET");
                http.setReadTimeout(10000);
                http.setConnectTimeout(10000);
                http.connect();
                int code = http.getResponseCode();
                if (code == 404) {
                    return Collections.EMPTY_LIST;
                }
                this.handleHTTPErrorCode(http);
                StringBuffer sb = new StringBuffer();
                if (http.getContentLength() > 0) {
                    for (int i = 0; i < http.getContentLength(); ++i) {
                        sb.append((char)http.getInputStream().read());
                    }
                } else {
                    int r;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((r = http.getInputStream().read(buffer)) != -1) {
                        baos.write(buffer, 0, r);
                    }
                    sb.append(new String(baos.toByteArray()));
                }
                http.getInputStream().close();
                String contentType = http.getHeaderField("content-type");
                if (contentType != null && (contentType.split(";")[0].equalsIgnoreCase("application/xml") || contentType.split(";")[0].equalsIgnoreCase("text/xml"))) {
                    Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(sb.toString().getBytes()));
                    NodeList list = doc.getElementsByTagName("Contents");
                    HashSet<JSONObject> set = new HashSet<JSONObject>();
                    for (int i = 0; i < list.getLength(); ++i) {
                        String key;
                        Element el = (Element)list.item(i);
                        JSONObject object = new JSONObject();
                        String keyText = el.getElementsByTagName("Key").item(0).getTextContent();
                        if (keyText.indexOf("/") < 1 || (key = keyText.substring(keyText.indexOf("/", 1) + 1)).length() < 1) continue;
                        String className = keyText.substring(0, keyText.indexOf("/"));
                        object.put("class", className);
                        object.put(cmd.getPrimaryKeyMemberNames()[0], key);
                        set.add(object);
                    }
                    jsonarray = new JSONArray(set);
                } else {
                    jsonarray = new JSONArray(sb.toString());
                }
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            catch (JSONException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            catch (SAXException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            for (int i = 0; i < jsonarray.length(); ++i) {
                final JSONObject json = jsonarray.getJSONObject(i);
                OID id = null;
                if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                    String memberName = JSONUtils.getMemberNameForDatastoreIdentity(cmd);
                    Object key = json.get(memberName);
                    id = key instanceof String ? OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)((String)key)) : OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (long)((Long)key));
                } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)true, (FieldManager)new FetchFieldManager(ec, cmd, json));
                }
                results.add(ec.findObject((Object)id, new FieldValues(){

                    public FetchPlan getFetchPlanForLoading() {
                        return null;
                    }

                    public void fetchNonLoadedFields(ObjectProvider sm) {
                        sm.replaceNonLoadedFields(cmd.getPKMemberPositions(), (FieldManager)new FetchFieldManager(ec, cmd, json));
                    }

                    public void fetchFields(ObjectProvider sm) {
                        sm.replaceFields(cmd.getPKMemberPositions(), (FieldManager)new FetchFieldManager(ec, cmd, json));
                    }
                }, null, ignoreCache));
            }
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
        return results;
    }

    @Override
    public String getURLPathForQuery(AbstractClassMetaData acmd) {
        String url = acmd.getValueForExtension("url");
        if (url == null) {
            url = acmd.getFullClassName();
        }
        url = "?prefix=" + url;
        return url;
    }

    private String getBucket() {
        PersistenceConfiguration conf = this.storeMgr.getNucleusContext().getPersistenceConfiguration();
        return conf.getStringProperty("datanucleus.cloud.storage.bucket");
    }
}

