/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.fieldmanager;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.json.JSONException;
import org.json.JSONObject;

public class InsertFieldManager
implements FieldManager {
    StateManager sm;
    JSONObject jsonobj;

    public InsertFieldManager(StateManager sm, JSONObject jsonobj) {
        this.sm = sm;
        this.jsonobj = jsonobj;
        try {
            jsonobj.put("class", sm.getClassMetaData().getFullClassName());
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public String fetchStringField(int fieldNumber) {
        return null;
    }

    public short fetchShortField(int fieldNumber) {
        return 0;
    }

    public Object fetchObjectField(int fieldNumber) {
        return null;
    }

    public long fetchLongField(int fieldNumber) {
        return 0L;
    }

    public int fetchIntField(int fieldNumber) {
        return 0;
    }

    public float fetchFloatField(int fieldNumber) {
        return 0.0f;
    }

    public double fetchDoubleField(int fieldNumber) {
        return 0.0;
    }

    public char fetchCharField(int fieldNumber) {
        return '\u0000';
    }

    public byte fetchByteField(int fieldNumber) {
        return 0;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        return false;
    }

    public void storeStringField(int fieldNumber, String value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = mmd.getName();
        if (mmd.hasExtension("member-name")) {
            name = mmd.getValueForExtension("member-name");
        }
        try {
            if (value == null) {
                this.jsonobj.put(name, JSONObject.NULL);
            } else {
                this.jsonobj.put(name, value);
            }
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeShortField(int fieldNumber, short value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = mmd.getName();
        if (mmd.hasExtension("member-name")) {
            name = mmd.getValueForExtension("member-name");
        }
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = mmd.getName();
        if (mmd.hasExtension("member-name")) {
            name = mmd.getValueForExtension("member-name");
        }
        try {
            if (value == null) {
                this.jsonobj.put(name, JSONObject.NULL);
            } else if (value instanceof Date) {
                this.jsonobj.put(name, ((Date)value).getTime());
            } else if (value instanceof Calendar) {
                this.jsonobj.put(name, ((Calendar)value).getTimeInMillis());
            } else if (value instanceof BigDecimal) {
                this.jsonobj.put(name, value);
            } else if (value instanceof BigInteger) {
                this.jsonobj.put(name, value);
            } else {
                JSONObject jsonobjfield = new JSONObject(value);
                jsonobjfield.put("class", value.getClass().getName());
                this.jsonobj.put(name, jsonobjfield);
            }
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeLongField(int fieldNumber, long value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = mmd.getName();
        if (mmd.hasExtension("member-name")) {
            name = mmd.getValueForExtension("member-name");
        }
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeIntField(int fieldNumber, int value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = mmd.getName();
        if (mmd.hasExtension("member-name")) {
            name = mmd.getValueForExtension("member-name");
        }
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeFloatField(int fieldNumber, float value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = mmd.getName();
        if (mmd.hasExtension("member-name")) {
            name = mmd.getValueForExtension("member-name");
        }
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = mmd.getName();
        if (mmd.hasExtension("member-name")) {
            name = mmd.getValueForExtension("member-name");
        }
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeCharField(int fieldNumber, char value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = mmd.getName();
        if (mmd.hasExtension("member-name")) {
            name = mmd.getValueForExtension("member-name");
        }
        try {
            this.jsonobj.put(name, new Character(value));
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeByteField(int fieldNumber, byte value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = mmd.getName();
        if (mmd.hasExtension("member-name")) {
            name = mmd.getValueForExtension("member-name");
        }
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = mmd.getName();
        if (mmd.hasExtension("member-name")) {
            name = mmd.getValueForExtension("member-name");
        }
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }
}

