/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.hbase.HBaseManagedConnection;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.metadata.MetaDataExtensionParser;
import org.datanucleus.store.schema.AbstractStoreSchemaHandler;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.CompleteClassTable;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class HBaseSchemaHandler
extends AbstractStoreSchemaHandler {
    public HBaseSchemaHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void createSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        if (this.isAutoCreateTables() || this.isAutoCreateColumns()) {
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                String className = classIter.next();
                AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                this.createSchemaForClass((HBaseStoreManager)this.storeMgr, cmd, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchemaForClass(HBaseStoreManager storeMgr, AbstractClassMetaData cmd, boolean validateOnly) {
        if (cmd.isEmbeddedOnly()) {
            return;
        }
        StoreData storeData = storeMgr.getStoreDataForClass(cmd.getFullClassName());
        Object t = null;
        t = storeData != null ? storeData.getTable() : new CompleteClassTable((StoreManager)storeMgr, cmd, null);
        Table table = t;
        String tableNameString = table.getName();
        TableName tableName = TableName.valueOf((String)tableNameString);
        HBaseManagedConnection mconn = (HBaseManagedConnection)storeMgr.getConnectionManager().getConnection(-1);
        try {
            HTableDescriptor hTable;
            Admin hBaseAdmin;
            block22: {
                block21: {
                    Connection conn = (Connection)mconn.getConnection();
                    hBaseAdmin = conn.getAdmin();
                    hTable = null;
                    try {
                        hTable = hBaseAdmin.getTableDescriptor(tableName);
                    }
                    catch (TableNotFoundException tnfe) {
                        if (validateOnly) {
                            NucleusLogger.DATASTORE_SCHEMA.info((Object)Localiser.msg((String)"HBase.SchemaValidate.Class", (Object[])new Object[]{cmd.getFullClassName(), tableNameString}));
                        }
                        if (!storeMgr.getSchemaHandler().isAutoCreateTables()) break block21;
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"HBase.SchemaCreate.Class", (Object[])new Object[]{cmd.getFullClassName(), tableNameString}));
                        hTable = new HTableDescriptor(tableName);
                        HashSet<String> familyNames = new HashSet<String>();
                        for (Column col : table.getColumns()) {
                            String familyName = HBaseUtils.getFamilyNameForColumn(col);
                            if (!familyNames.add(familyName)) continue;
                            HColumnDescriptor familyNameCd = new HColumnDescriptor(familyName);
                            hTable.addFamily(familyNameCd);
                        }
                        hBaseAdmin.createTable(hTable);
                    }
                }
                if (hTable != null) break block22;
                return;
            }
            try {
                boolean changed;
                boolean modified = false;
                List cols = table.getColumns();
                HashSet<String> familyNames = new HashSet<String>();
                for (Column col : cols) {
                    boolean changed2 = this.addColumnFamilyForColumn(col, hTable, tableNameString, familyNames, validateOnly);
                    if (!changed2) continue;
                    modified = true;
                }
                if (table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID) != null && (changed = this.addColumnFamilyForColumn(table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID), hTable, tableNameString, familyNames, validateOnly))) {
                    modified = true;
                }
                if (table.getSurrogateColumn(SurrogateColumnType.VERSION) != null && (changed = this.addColumnFamilyForColumn(table.getSurrogateColumn(SurrogateColumnType.VERSION), hTable, tableNameString, familyNames, validateOnly))) {
                    modified = true;
                }
                if (table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR) != null && (changed = this.addColumnFamilyForColumn(table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR), hTable, tableNameString, familyNames, validateOnly))) {
                    modified = true;
                }
                if (table.getSurrogateColumn(SurrogateColumnType.MULTITENANCY) != null && (changed = this.addColumnFamilyForColumn(table.getSurrogateColumn(SurrogateColumnType.MULTITENANCY), hTable, tableNameString, familyNames, validateOnly))) {
                    modified = true;
                }
                if (table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE) != null && (changed = this.addColumnFamilyForColumn(table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE), hTable, tableNameString, familyNames, validateOnly))) {
                    modified = true;
                }
                MetaDataExtensionParser ep = new MetaDataExtensionParser(cmd);
                if (!validateOnly && ep.hasExtensions()) {
                    for (String familyName : familyNames) {
                        modified |= ep.applyExtensions(hTable, familyName);
                    }
                }
                if (modified) {
                    hBaseAdmin.disableTable(tableName);
                    hBaseAdmin.modifyTable(tableName, hTable);
                    hBaseAdmin.enableTable(tableName);
                }
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(e.getMessage(), e.getCause());
            }
        }
        finally {
            mconn.release();
        }
    }

    protected boolean addColumnFamilyForColumn(Column col, HTableDescriptor htable, String tableName, Set<String> familyNames, boolean validateOnly) {
        boolean modified = false;
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        if (!familyNames.contains(familyName)) {
            familyNames.add(familyName);
            if (!htable.hasFamily(familyName.getBytes())) {
                if (validateOnly) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"HBase.SchemaValidate.Class.Family", (Object[])new Object[]{tableName, familyName}));
                } else if (this.storeMgr.getSchemaHandler().isAutoCreateColumns()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"HBase.SchemaCreate.Class.Family", (Object[])new Object[]{tableName, familyName}));
                    HColumnDescriptor hColumn = new HColumnDescriptor(familyName);
                    htable.addFamily(hColumn);
                    modified = true;
                }
            }
        }
        return modified;
    }

    public void deleteSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        Iterator<String> classIter = classNames.iterator();
        ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
        while (classIter.hasNext()) {
            String className = classIter.next();
            AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
            if (cmd == null) continue;
            this.deleteSchemaForClass(cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteSchemaForClass(AbstractClassMetaData cmd) {
        if (cmd.isEmbeddedOnly()) {
            return;
        }
        StoreData storeData = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
        Object table = null;
        table = storeData != null ? storeData.getTable() : new CompleteClassTable(this.storeMgr, cmd, null);
        String tableNameString = table.getName();
        TableName tableName = TableName.valueOf((String)tableNameString);
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnectionManager().getConnection(-1);
        try {
            Connection conn = (Connection)mconn.getConnection();
            try {
                Admin hBaseAdmin = conn.getAdmin();
                HTableDescriptor hTable = null;
                try {
                    hTable = hBaseAdmin.getTableDescriptor(tableName);
                }
                catch (TableNotFoundException tnfe) {
                    hTable = new HTableDescriptor(tableName);
                    hBaseAdmin.createTable(hTable);
                }
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"HBase.SchemaDelete.Class", (Object[])new Object[]{cmd.getFullClassName(), hTable.getNameAsString()}));
                hBaseAdmin.disableTable(tableName);
                hBaseAdmin.deleteTable(tableName);
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(e.getMessage(), e.getCause());
            }
        }
        finally {
            mconn.release();
        }
    }

    public void validateSchema(Set<String> classNames, Properties props, Object connection) {
        if (this.isValidateTables() || this.isValidateColumns()) {
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                String className = classIter.next();
                AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                this.createSchemaForClass((HBaseStoreManager)this.storeMgr, cmd, true);
            }
        }
    }
}

