/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.query;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.AbstractExpressionEvaluator;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.query.expression.HBaseBooleanExpression;
import org.datanucleus.store.hbase.query.expression.HBaseExpression;
import org.datanucleus.store.hbase.query.expression.HBaseFieldExpression;
import org.datanucleus.store.hbase.query.expression.HBaseLiteral;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.TypeConversionHelper;

public class QueryToHBaseMapper
extends AbstractExpressionEvaluator {
    final ExecutionContext ec;
    final String candidateAlias;
    final AbstractClassMetaData candidateCmd;
    final Query query;
    final QueryCompilation compilation;
    final Map parameters;
    Map<String, Object> parameterValueByName = null;
    Map<Integer, String> paramNameByPosition = null;
    int positionalParamNumber = -1;
    CompilationComponent compileComponent;
    boolean filterComplete = true;
    HBaseBooleanExpression filterExpr = null;
    boolean precompilable = true;
    Deque<HBaseExpression> stack = new ArrayDeque<HBaseExpression>();

    public QueryToHBaseMapper(QueryCompilation compilation, Map parameters, AbstractClassMetaData cmd, ExecutionContext ec, Query q) {
        this.ec = ec;
        this.query = q;
        this.compilation = compilation;
        this.parameters = parameters;
        this.candidateCmd = cmd;
        this.candidateAlias = compilation.getCandidateAlias();
    }

    public boolean isFilterComplete() {
        return this.filterComplete;
    }

    public HBaseBooleanExpression getFilterExpression() {
        return this.filterExpr;
    }

    public void compile() {
        this.compileFilter();
    }

    public boolean isPrecompilable() {
        return this.precompilable;
    }

    protected void compileFilter() {
        if (this.compilation.getExprFilter() != null) {
            this.compileComponent = CompilationComponent.FILTER;
            try {
                this.compilation.getExprFilter().evaluate((ExpressionEvaluator)this);
                HBaseExpression filterExpr = this.stack.pop();
                if (filterExpr instanceof HBaseBooleanExpression) {
                    this.filterExpr = (HBaseBooleanExpression)filterExpr;
                } else {
                    NucleusLogger.QUERY.error((Object)(">> invalid compilation : filter compiled to " + filterExpr));
                    this.filterComplete = false;
                }
            }
            catch (Exception e) {
                this.filterComplete = false;
                NucleusLogger.QUERY.debug((Object)">> compileFilter caught exception ", (Throwable)e);
            }
            this.compileComponent = null;
        }
    }

    protected Object processOrExpression(Expression expr) {
        HBaseBooleanExpression right = (HBaseBooleanExpression)this.stack.pop();
        HBaseBooleanExpression left = (HBaseBooleanExpression)this.stack.pop();
        HBaseBooleanExpression orExpr = new HBaseBooleanExpression(left, right, (Expression.Operator)Expression.OP_OR);
        this.stack.push(orExpr);
        return orExpr;
    }

    protected Object processAndExpression(Expression expr) {
        HBaseBooleanExpression right = (HBaseBooleanExpression)this.stack.pop();
        HBaseBooleanExpression left = (HBaseBooleanExpression)this.stack.pop();
        HBaseBooleanExpression andExpr = new HBaseBooleanExpression(left, right, (Expression.Operator)Expression.OP_AND);
        this.stack.push(andExpr);
        return andExpr;
    }

    protected Object processEqExpression(Expression expr) {
        HBaseExpression right = this.stack.pop();
        HBaseExpression left = this.stack.pop();
        if (left instanceof HBaseLiteral && right instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)right;
            HBaseLiteral litExpr = (HBaseLiteral)left;
            Object litVal = TypeConversionHelper.convertTo((Object)litExpr.getValue(), (Class)fieldExpr.getType());
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litVal, (Expression.Operator)Expression.OP_EQ);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        if (right instanceof HBaseLiteral && left instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)left;
            HBaseLiteral litExpr = (HBaseLiteral)right;
            Object litVal = TypeConversionHelper.convertTo((Object)litExpr.getValue(), (Class)fieldExpr.getType());
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litVal, (Expression.Operator)Expression.OP_EQ);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        return super.processEqExpression(expr);
    }

    protected Object processNoteqExpression(Expression expr) {
        HBaseExpression right = this.stack.pop();
        HBaseExpression left = this.stack.pop();
        if (left instanceof HBaseLiteral && right instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)right;
            HBaseLiteral litExpr = (HBaseLiteral)left;
            Object litVal = TypeConversionHelper.convertTo((Object)litExpr.getValue(), (Class)fieldExpr.getType());
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litVal, (Expression.Operator)Expression.OP_NOTEQ);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        if (right instanceof HBaseLiteral && left instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)left;
            HBaseLiteral litExpr = (HBaseLiteral)right;
            Object litVal = TypeConversionHelper.convertTo((Object)litExpr.getValue(), (Class)fieldExpr.getType());
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litVal, (Expression.Operator)Expression.OP_NOTEQ);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        return super.processNoteqExpression(expr);
    }

    protected Object processGtExpression(Expression expr) {
        HBaseExpression right = this.stack.pop();
        HBaseExpression left = this.stack.pop();
        if (left instanceof HBaseLiteral && right instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)right;
            HBaseLiteral litExpr = (HBaseLiteral)left;
            Object litVal = TypeConversionHelper.convertTo((Object)litExpr.getValue(), (Class)fieldExpr.getType());
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litVal, (Expression.Operator)Expression.OP_LTEQ);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        if (right instanceof HBaseLiteral && left instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)left;
            HBaseLiteral litExpr = (HBaseLiteral)right;
            Object litVal = TypeConversionHelper.convertTo((Object)litExpr.getValue(), (Class)fieldExpr.getType());
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litVal, (Expression.Operator)Expression.OP_GT);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        return super.processGtExpression(expr);
    }

    protected Object processLtExpression(Expression expr) {
        HBaseExpression right = this.stack.pop();
        HBaseExpression left = this.stack.pop();
        if (left instanceof HBaseLiteral && right instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)right;
            HBaseLiteral litExpr = (HBaseLiteral)left;
            Object litVal = TypeConversionHelper.convertTo((Object)litExpr.getValue(), (Class)fieldExpr.getType());
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litVal, (Expression.Operator)Expression.OP_GTEQ);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        if (right instanceof HBaseLiteral && left instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)left;
            HBaseLiteral litExpr = (HBaseLiteral)right;
            Object litVal = TypeConversionHelper.convertTo((Object)litExpr.getValue(), (Class)fieldExpr.getType());
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litVal, (Expression.Operator)Expression.OP_LT);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        return super.processLtExpression(expr);
    }

    protected Object processGteqExpression(Expression expr) {
        HBaseExpression right = this.stack.pop();
        HBaseExpression left = this.stack.pop();
        if (left instanceof HBaseLiteral && right instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)right;
            HBaseLiteral litExpr = (HBaseLiteral)left;
            Object litVal = TypeConversionHelper.convertTo((Object)litExpr.getValue(), (Class)fieldExpr.getType());
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litVal, (Expression.Operator)Expression.OP_LT);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        if (right instanceof HBaseLiteral && left instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)left;
            HBaseLiteral litExpr = (HBaseLiteral)right;
            Object litVal = TypeConversionHelper.convertTo((Object)litExpr.getValue(), (Class)fieldExpr.getType());
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litVal, (Expression.Operator)Expression.OP_GTEQ);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        return super.processGteqExpression(expr);
    }

    protected Object processLteqExpression(Expression expr) {
        HBaseExpression right = this.stack.pop();
        HBaseExpression left = this.stack.pop();
        if (left instanceof HBaseLiteral && right instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)right;
            HBaseLiteral litExpr = (HBaseLiteral)left;
            Object litVal = TypeConversionHelper.convertTo((Object)litExpr.getValue(), (Class)fieldExpr.getType());
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litVal, (Expression.Operator)Expression.OP_GT);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        if (right instanceof HBaseLiteral && left instanceof HBaseFieldExpression) {
            HBaseFieldExpression fieldExpr = (HBaseFieldExpression)left;
            HBaseLiteral litExpr = (HBaseLiteral)right;
            Object litVal = TypeConversionHelper.convertTo((Object)litExpr.getValue(), (Class)fieldExpr.getType());
            HBaseBooleanExpression hbaseExpr = new HBaseBooleanExpression(fieldExpr.getFamilyName(), fieldExpr.getColumnName(), litVal, (Expression.Operator)Expression.OP_LTEQ);
            this.stack.push(hbaseExpr);
            return hbaseExpr;
        }
        return super.processLteqExpression(expr);
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        Expression left = expr.getLeft();
        if (left == null) {
            List tuples = expr.getTuples();
            PrimaryDetails primDetails = this.getFamilyColumnNameForPrimary(tuples);
            if (primDetails == null) {
                if (this.compileComponent == CompilationComponent.FILTER) {
                    this.filterComplete = false;
                }
                NucleusLogger.QUERY.debug((Object)(">> Primary " + expr + " is not stored in this document, so unexecutable in datastore"));
            } else {
                HBaseFieldExpression fieldExpr = new HBaseFieldExpression(primDetails.type, primDetails.family, primDetails.column);
                this.stack.push(fieldExpr);
                return fieldExpr;
            }
        }
        return super.processPrimaryExpression(expr);
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        if (expr.getPosition() >= 0) {
            if (this.paramNameByPosition == null) {
                this.paramNameByPosition = new HashMap<Integer, String>();
            }
            this.paramNameByPosition.put(expr.getPosition(), expr.getId());
        }
        Object paramValue = null;
        boolean paramValueSet = false;
        if (this.parameters != null && !this.parameters.isEmpty()) {
            if (this.parameters.containsKey(expr.getId())) {
                paramValue = this.parameters.get(expr.getId());
                paramValueSet = true;
            } else if (this.parameterValueByName != null && this.parameterValueByName.containsKey(expr.getId())) {
                paramValue = this.parameterValueByName.get(expr.getId());
                paramValueSet = true;
            } else {
                int position = this.positionalParamNumber;
                if (this.positionalParamNumber < 0) {
                    position = 0;
                }
                if (this.parameters.containsKey(position)) {
                    paramValue = this.parameters.get(position);
                    paramValueSet = true;
                    this.positionalParamNumber = position + 1;
                    if (this.parameterValueByName == null) {
                        this.parameterValueByName = new HashMap<String, Object>();
                    }
                    this.parameterValueByName.put(expr.getId(), paramValue);
                }
            }
        }
        if (paramValueSet && (paramValue instanceof Number || paramValue instanceof String)) {
            HBaseLiteral paramLit = new HBaseLiteral(paramValue);
            this.precompilable = false;
            this.stack.push(paramLit);
            return paramLit;
        }
        return super.processParameterExpression(expr);
    }

    protected Object processLiteral(Literal expr) {
        Object litValue = expr.getLiteral();
        if (litValue instanceof Number) {
            HBaseLiteral lit = new HBaseLiteral(litValue);
            this.stack.push(lit);
            return lit;
        }
        if (litValue instanceof String) {
            HBaseLiteral lit = new HBaseLiteral(litValue);
            this.stack.push(lit);
            return lit;
        }
        return super.processLiteral(expr);
    }

    protected PrimaryDetails getFamilyColumnNameForPrimary(List<String> tuples) {
        if (tuples == null || tuples.isEmpty()) {
            return null;
        }
        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
        AbstractMemberMetaData embMmd = null;
        boolean firstTuple = true;
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractClassMetaData cmd = this.candidateCmd;
        Table table = this.ec.getStoreManager().getStoreDataForClass(this.candidateCmd.getFullClassName()).getTable();
        Iterator<String> iter = tuples.iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            if (firstTuple && name.equals(this.candidateAlias)) {
                cmd = this.candidateCmd;
            } else {
                AbstractMemberMetaData mmd = cmd.getMetaDataForMember(name);
                RelationType relationType = mmd.getRelationType(this.ec.getClassLoaderResolver());
                if (relationType == RelationType.NONE) {
                    if (iter.hasNext()) {
                        throw new NucleusUserException("Query has reference to " + StringUtils.collectionToString(tuples) + " yet " + name + " is a non-relation field!");
                    }
                    Column col = null;
                    if (embMmd != null) {
                        embMmds.add(mmd);
                        col = table.getMemberColumnMappingForEmbeddedMember(embMmds).getColumn(0);
                    } else {
                        col = table.getMemberColumnMappingForMember(mmd).getColumn(0);
                    }
                    String familyName = HBaseUtils.getFamilyNameForColumn(col);
                    String qualifName = HBaseUtils.getQualifierNameForColumn(col);
                    return new PrimaryDetails(mmd.getType(), familyName, qualifName);
                }
                boolean embedded = MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, embMmds.isEmpty() ? null : (AbstractMemberMetaData)embMmds.get(embMmds.size() - 1));
                if (embedded) {
                    if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                        cmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), this.ec.getClassLoaderResolver());
                        embMmd = embMmd != null ? embMmd.getEmbeddedMetaData().getMemberMetaData()[mmd.getAbsoluteFieldNumber()] : mmd;
                        embMmds.add(embMmd);
                    } else if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                        throw new NucleusUserException("Do not support the querying of embedded collection/map/array fields : " + mmd.getFullFieldName());
                    }
                } else {
                    embMmds.clear();
                    if (this.compileComponent == CompilationComponent.FILTER) {
                        this.filterComplete = false;
                    }
                    NucleusLogger.QUERY.debug((Object)("Query has reference to " + StringUtils.collectionToString(tuples) + " and " + mmd.getFullFieldName() + " is not persisted into this document, so unexecutable in the datastore"));
                    return null;
                }
            }
            firstTuple = false;
        }
        return null;
    }

    static class PrimaryDetails {
        String family;
        String column;
        Class type;

        public PrimaryDetails(Class type, String fam, String col) {
            this.type = type;
            this.family = fam;
            this.column = col;
        }
    }
}

