/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.connection.AbstractManagedConnection;

public class HBaseManagedConnection
extends AbstractManagedConnection {
    private HConnection hconn;
    private Map<String, HTableInterface> tables;
    private int idleTimeoutMills = 30000;
    private long expirationTime;
    private boolean isDisposed = false;

    public HBaseManagedConnection(HConnection hconn) {
        this.hconn = hconn;
        this.tables = new HashMap<String, HTableInterface>();
        this.disableExpirationTime();
    }

    public Object getConnection() {
        throw new NucleusDataStoreException("Unsupported Exception #getConnection() for " + ((Object)((Object)this)).getClass().getName());
    }

    public HTableInterface getHTable(String tableName) {
        HTableInterface table = this.tables.get(tableName);
        if (table == null) {
            try {
                table = this.hconn.getTable(tableName);
                this.tables.put(tableName, table);
            }
            catch (Exception e) {
                throw new NucleusDataStoreException("Exception obtaining HTableInterface from HConnection for table=" + tableName, (Throwable)e);
            }
        }
        return table;
    }

    public XAResource getXAResource() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        for (Object listener : this.listeners) {
            listener.managedConnectionPreClose();
        }
        try {
            Map<String, HTableInterface> oldtables = this.tables;
            this.tables = new HashMap<String, HTableInterface>();
            try {
                for (HTableInterface table : oldtables.values()) {
                    table.close();
                }
                this.dispose();
            }
            catch (IOException e) {
                throw new NucleusDataStoreException("Exception thrown while closing HTable(s) for transaction and associated HConnection", (Throwable)e);
            }
        }
        finally {
            for (Object listener : this.listeners) {
                listener.managedConnectionPostClose();
            }
        }
    }

    protected void incrementUseCount() {
        super.incrementUseCount();
        this.disableExpirationTime();
    }

    public void release() {
        super.release();
        if (this.useCount == 0) {
            this.enableExpirationTime();
        }
    }

    private void enableExpirationTime() {
        this.expirationTime = System.currentTimeMillis() + (long)this.idleTimeoutMills;
    }

    private void disableExpirationTime() {
        this.expirationTime = -1L;
    }

    public void setIdleTimeoutMills(int mills) {
        this.idleTimeoutMills = mills;
    }

    public boolean isExpired() {
        return this.expirationTime > 0L && this.expirationTime > System.currentTimeMillis();
    }

    public void dispose() {
        this.isDisposed = true;
        if (!this.hconn.isClosed()) {
            try {
                this.hconn.close();
            }
            catch (IOException e) {
                throw new NucleusDataStoreException("Exception thrown closing HConnection", (Throwable)e);
            }
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }
}

