/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.fieldmanager;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.StoreFieldManager;
import org.datanucleus.store.types.converters.TypeConverter;

public class StoreEmbeddedFieldManager
extends StoreFieldManager {
    private final AbstractMemberMetaData ownerMmd;

    public StoreEmbeddedFieldManager(ObjectProvider sm, Put put, Delete delete, AbstractMemberMetaData mmd, String tableName, boolean insert) {
        super(sm, put, delete, insert, tableName);
        this.ownerMmd = mmd;
    }

    protected String getFamilyName(int fieldNumber) {
        return HBaseUtils.getFamilyName(this.ownerMmd, fieldNumber, this.tableName);
    }

    protected String getQualifierName(int fieldNumber) {
        return HBaseUtils.getQualifierName(this.ownerMmd, fieldNumber);
    }

    protected AbstractMemberMetaData getMemberMetaData(int fieldNumber) {
        return this.ownerMmd.getEmbeddedMetaData().getMemberMetaData()[fieldNumber];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeObjectField(int fieldNumber, Object value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        if (value == null) {
            this.delete.deleteColumn(familyName.getBytes(), columnName.getBytes());
            return;
        }
        ExecutionContext ec = this.op.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractMemberMetaData embMmd = this.ownerMmd.getEmbeddedMetaData().getMemberMetaData()[fieldNumber];
        RelationType relationType = embMmd.getRelationType(clr);
        if ((relationType == RelationType.ONE_TO_ONE_BI || relationType == RelationType.ONE_TO_ONE_UNI) && embMmd.isEmbedded()) {
            Class embcls = embMmd.getType();
            AbstractClassMetaData embcmd = ec.getMetaDataManager().getMetaDataForClass(embcls, clr);
            if (embcmd == null) throw new NucleusUserException("Field " + embMmd.getFullFieldName() + " specified as embedded but metadata not found for the class of type " + embMmd.getTypeName());
            ObjectProvider embSM = ec.findObjectProviderForEmbedded(value, this.op, embMmd);
            StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embSM, this.put, this.delete, embMmd, this.tableName, this.insert);
            embSM.provideFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
            return;
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            Object valuePC = this.op.getExecutionContext().persistObjectInternal(value, this.op, fieldNumber, -1);
            if (embMmd.isSerialized()) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(value);
                    this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                    oos.close();
                    bos.close();
                    return;
                }
                catch (IOException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            } else {
                Object valueId = ec.getApiAdapter().getIdForObject(valuePC);
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(valueId);
                    this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                    oos.close();
                    bos.close();
                    return;
                }
                catch (IOException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            if (embMmd.hasCollection()) {
                ObjectOutputStream oos;
                ByteArrayOutputStream bos;
                ArrayList<Object> collIds = new ArrayList<Object>();
                Collection coll = (Collection)value;
                for (Object element : coll) {
                    Object elementPC = this.op.getExecutionContext().persistObjectInternal(element, this.op, fieldNumber, -1);
                    Object elementID = this.op.getExecutionContext().getApiAdapter().getIdForObject(elementPC);
                    collIds.add(elementID);
                }
                if (embMmd.isSerialized()) {
                    try {
                        bos = new ByteArrayOutputStream();
                        oos = new ObjectOutputStream(bos);
                        oos.writeObject(value);
                        this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                        oos.close();
                        bos.close();
                        return;
                    }
                    catch (IOException e) {
                        throw new NucleusException(e.getMessage(), (Throwable)e);
                    }
                } else {
                    try {
                        bos = new ByteArrayOutputStream();
                        oos = new ObjectOutputStream(bos);
                        oos.writeObject(collIds);
                        this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                        oos.close();
                        bos.close();
                        return;
                    }
                    catch (IOException e) {
                        throw new NucleusException(e.getMessage(), (Throwable)e);
                    }
                }
            } else if (embMmd.hasMap()) {
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    Object mapKey = entry.getKey();
                    Object mapValue = entry.getValue();
                    if (ec.getApiAdapter().isPersistable(mapKey)) {
                        ec.persistObjectInternal(mapKey, this.op, fieldNumber, -1);
                    }
                    if (!ec.getApiAdapter().isPersistable(mapValue)) continue;
                    ec.persistObjectInternal(mapValue, this.op, fieldNumber, -1);
                }
                if (!embMmd.isSerialized()) throw new NucleusException("Only currently support maps serialised with HBase. Mark the field as serialized");
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(value);
                    this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                    oos.close();
                    bos.close();
                    return;
                }
                catch (IOException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            } else {
                ObjectOutputStream oos;
                if (!embMmd.hasArray()) return;
                ArrayList<Object> arrIds = new ArrayList<Object>();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object element = Array.get(value, i);
                    Object elementPC = ec.persistObjectInternal(element, this.op, fieldNumber, -1);
                    Object elementID = ec.getApiAdapter().getIdForObject(elementPC);
                    arrIds.add(elementID);
                }
                if (embMmd.isSerialized()) {
                    try {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        oos = new ObjectOutputStream(bos);
                        oos.writeObject(value);
                        this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                        oos.close();
                        bos.close();
                        return;
                    }
                    catch (IOException e) {
                        throw new NucleusException(e.getMessage(), (Throwable)e);
                    }
                } else {
                    try {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        oos = new ObjectOutputStream(bos);
                        oos.writeObject(arrIds);
                        this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                        oos.close();
                        bos.close();
                        return;
                    }
                    catch (IOException e) {
                        throw new NucleusException(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        if (Enum.class.isAssignableFrom(value.getClass()) && !embMmd.isSerialized()) {
            this.put.add(familyName.getBytes(), columnName.getBytes(), ((Enum)value).name().getBytes());
        }
        TypeConverter strConv = this.op.getExecutionContext().getTypeManager().getTypeConverterForType(embMmd.getType(), String.class);
        if (!embMmd.isSerialized() && strConv != null) {
            String strValue = (String)strConv.toDatastoreType(value);
            this.put.add(familyName.getBytes(), columnName.getBytes(), strValue.getBytes());
            return;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
            return;
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }
}

