/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.query;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.Relation;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseManagedConnection;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.FetchFieldManager;
import org.datanucleus.util.NucleusLogger;

class HBaseQueryUtils {
    HBaseQueryUtils() {
    }

    static List getObjectsOfCandidateType(ExecutionContext ec, HBaseManagedConnection mconn, Class candidateClass, boolean subclasses, boolean ignoreCache, FetchPlan fetchPlan, Filter filter) {
        List cmds = MetaDataUtils.getMetaDataForCandidates((Class)candidateClass, (boolean)subclasses, (ExecutionContext)ec);
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving objects for candidate=" + candidateClass.getName() + (subclasses ? " and subclasses" : "") + (filter != null ? " with filter=" + filter : "")));
        }
        Iterator cmdIter = cmds.iterator();
        ArrayList results = new ArrayList();
        while (cmdIter.hasNext()) {
            AbstractClassMetaData acmd = (AbstractClassMetaData)cmdIter.next();
            results.addAll(HBaseQueryUtils.getObjectsOfType(ec, mconn, acmd, ignoreCache, fetchPlan, filter));
        }
        return results;
    }

    private static List getObjectsOfType(final ExecutionContext ec, final HBaseManagedConnection mconn, final AbstractClassMetaData cmd, boolean ignoreCache, FetchPlan fp, final Filter filter) {
        ArrayList<Object> results = new ArrayList<Object>();
        fp.manageFetchPlanForClass(cmd);
        final int[] fpMembers = fp.getFetchPlanForClass(cmd).getMemberNumbers();
        try {
            final ClassLoaderResolver clr = ec.getClassLoaderResolver();
            Iterator it = (Iterator)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    byte[] familyName;
                    Scan scan = new Scan();
                    if (filter != null) {
                        scan.setFilter(filter);
                    }
                    for (int i = 0; i < fpMembers.length; ++i) {
                        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fpMembers[i]);
                        int relationType = mmd.getRelationType(clr);
                        if (Relation.isRelationSingleValued((int)relationType) && mmd.isEmbedded()) {
                            HBaseQueryUtils.addColumnsToScanForEmbeddedMember(scan, mmd, HBaseUtils.getTableName(cmd), ec);
                            continue;
                        }
                        byte[] familyName2 = HBaseUtils.getFamilyName(cmd, fpMembers[i]).getBytes();
                        byte[] columnName = HBaseUtils.getQualifierName(cmd, fpMembers[i]).getBytes();
                        scan.addColumn(familyName2, columnName);
                    }
                    VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                    if (cmd.isVersioned() && vermd.getFieldName() == null) {
                        familyName = HBaseUtils.getFamilyName(vermd).getBytes();
                        byte[] columnName = HBaseUtils.getQualifierName(vermd).getBytes();
                        scan.addColumn(familyName, columnName);
                    }
                    if (cmd.hasDiscriminatorStrategy()) {
                        familyName = HBaseUtils.getFamilyName(cmd.getDiscriminatorMetaData()).getBytes();
                        byte[] columnName = HBaseUtils.getQualifierName(cmd.getDiscriminatorMetaData()).getBytes();
                        scan.addColumn(familyName, columnName);
                    }
                    if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                        familyName = HBaseUtils.getFamilyName(cmd.getIdentityMetaData()).getBytes();
                        byte[] columnName = HBaseUtils.getQualifierName(cmd.getIdentityMetaData()).getBytes();
                        scan.addColumn(familyName, columnName);
                    }
                    HTable table = mconn.getHTable(HBaseUtils.getTableName(cmd));
                    ResultScanner scanner = table.getScanner(scan);
                    Iterator it = scanner.iterator();
                    return it;
                }
            });
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                while (it.hasNext()) {
                    Result result = (Result)it.next();
                    Object obj = HBaseQueryUtils.getObjectUsingApplicationIdForResult(result, cmd, ec, ignoreCache, fpMembers);
                    if (obj == null) continue;
                    results.add(obj);
                }
            } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                while (it.hasNext()) {
                    Result result = (Result)it.next();
                    Object obj = HBaseQueryUtils.getObjectUsingDatastoreIdForResult(result, cmd, ec, ignoreCache, fpMembers);
                    if (obj == null) continue;
                    results.add(obj);
                }
            } else {
                while (it.hasNext()) {
                    Result result = (Result)it.next();
                    Object obj = HBaseQueryUtils.getObjectUsingNondurableIdForResult(result, cmd, ec, ignoreCache, fpMembers);
                    if (obj == null) continue;
                    results.add(obj);
                }
            }
        }
        catch (PrivilegedActionException e) {
            throw new NucleusDataStoreException(e.getMessage(), e.getCause());
        }
        return results;
    }

    protected static Object getObjectUsingApplicationIdForResult(final Result result, final AbstractClassMetaData cmd, final ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        if (cmd.hasDiscriminatorStrategy()) {
            Object discValue = HBaseUtils.getDiscriminatorForObject(cmd, result);
            if (cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? !cmd.getFullClassName().equals(discValue) : cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.VALUE_MAP && !cmd.getDiscriminatorValue().equals(discValue)) {
                return null;
            }
        }
        Object id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)false, (FieldManager)new FetchFieldManager(ec, cmd, result));
        Object pc = ec.findObject(id, new FieldValues(){

            public void fetchFields(ObjectProvider sm) {
                sm.replaceFields(fpMembers, (FieldManager)new FetchFieldManager(ec, cmd, result));
            }

            public void fetchNonLoadedFields(ObjectProvider sm) {
                sm.replaceNonLoadedFields(fpMembers, (FieldManager)new FetchFieldManager(ec, cmd, result));
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, null, ignoreCache);
        if (cmd.isVersioned()) {
            ObjectProvider sm = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = sm.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = HBaseUtils.getSurrogateVersionForObject(cmd, result);
            }
            sm.setVersion(version);
        }
        return pc;
    }

    protected static Object getObjectUsingDatastoreIdForResult(final Result result, final AbstractClassMetaData cmd, final ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        if (cmd.hasDiscriminatorStrategy()) {
            Object discValue = HBaseUtils.getDiscriminatorForObject(cmd, result);
            if (cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? !cmd.getFullClassName().equals(discValue) : cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.VALUE_MAP && !cmd.getDiscriminatorValue().equals(discValue)) {
                return null;
            }
        }
        String dsidFamilyName = HBaseUtils.getFamilyName(cmd.getIdentityMetaData());
        String dsidColumnName = HBaseUtils.getQualifierName(cmd.getIdentityMetaData());
        OID id = null;
        try {
            byte[] bytes = result.getValue(dsidFamilyName.getBytes(), dsidColumnName.getBytes());
            if (bytes == null) {
                throw new NucleusException("Retrieved identity for family=" + dsidFamilyName + " column=" + dsidColumnName + " IS NULL");
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object key = ois.readObject();
            id = OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)cmd.getFullClassName(), (Object)key);
            ois.close();
            bis.close();
        }
        catch (Exception e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        Object pc = ec.findObject((Object)id, new FieldValues(){

            public void fetchFields(ObjectProvider sm) {
                sm.replaceFields(fpMembers, (FieldManager)new FetchFieldManager(ec, cmd, result));
            }

            public void fetchNonLoadedFields(ObjectProvider sm) {
                sm.replaceNonLoadedFields(fpMembers, (FieldManager)new FetchFieldManager(ec, cmd, result));
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, null, ignoreCache);
        if (cmd.isVersioned()) {
            ObjectProvider sm = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = sm.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = HBaseUtils.getSurrogateVersionForObject(cmd, result);
            }
            sm.setVersion(version);
        }
        return pc;
    }

    protected static Object getObjectUsingNondurableIdForResult(final Result result, final AbstractClassMetaData cmd, final ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        if (cmd.hasDiscriminatorStrategy()) {
            Object discValue = HBaseUtils.getDiscriminatorForObject(cmd, result);
            if (cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? !cmd.getFullClassName().equals(discValue) : cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.VALUE_MAP && !cmd.getDiscriminatorValue().equals(discValue)) {
                return null;
            }
        }
        SCOID id = new SCOID(cmd.getFullClassName());
        Object pc = ec.findObject((Object)id, new FieldValues(){

            public void fetchFields(ObjectProvider sm) {
                sm.replaceFields(fpMembers, (FieldManager)new FetchFieldManager(ec, cmd, result));
            }

            public void fetchNonLoadedFields(ObjectProvider sm) {
                sm.replaceNonLoadedFields(fpMembers, (FieldManager)new FetchFieldManager(ec, cmd, result));
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, null, ignoreCache);
        if (cmd.isVersioned()) {
            ObjectProvider sm = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = sm.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = HBaseUtils.getSurrogateVersionForObject(cmd, result);
            }
            sm.setVersion(version);
        }
        return pc;
    }

    private static void addColumnsToScanForEmbeddedMember(Scan scan, AbstractMemberMetaData mmd, String tableName, ExecutionContext ec) {
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
        for (int i = 0; i < embmmds.length; ++i) {
            AbstractMemberMetaData embMmd = embmmds[i];
            int relationType = embMmd.getRelationType(clr);
            if ((relationType == 2 || relationType == 1) && embMmd.isEmbedded()) {
                HBaseQueryUtils.addColumnsToScanForEmbeddedMember(scan, embMmd, tableName, ec);
                continue;
            }
            byte[] familyName = HBaseUtils.getFamilyName(mmd, i, tableName).getBytes();
            byte[] columnName = HBaseUtils.getQualifierName(mmd, i).getBytes();
            scan.addColumn(familyName, columnName);
        }
    }
}

