/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.valuegenerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.util.Bytes;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.store.valuegenerator.AbstractDatastoreGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.util.NucleusLogger;

public class IncrementGenerator
extends AbstractDatastoreGenerator
implements ValueGenerator {
    static final String INCREMENT_COL_NAME = "increment";
    private String key;
    private HTable table;
    private String tableName = null;

    public IncrementGenerator(String name, Properties props) {
        super(name, props);
        this.key = this.properties.getProperty("field-name", name);
        this.tableName = this.properties.getProperty("sequence-table-name");
        if (this.tableName == null) {
            this.tableName = "IncrementTable";
        }
        this.allocationSize = this.properties.containsKey("key-cache-size") ? Integer.valueOf(this.properties.getProperty("key-cache-size")) : 1;
    }

    private synchronized void initialiseTable() {
        if (this.table == null) {
            try {
                HBaseStoreManager hbaseMgr = (HBaseStoreManager)this.storeMgr;
                Configuration config = hbaseMgr.getHbaseConfig();
                HBaseAdmin admin = new HBaseAdmin(config);
                if (!admin.tableExists(this.tableName)) {
                    if (!this.storeMgr.isAutoCreateTables()) {
                        throw new NucleusUserException(LOCALISER.msg("040011", (Object)this.tableName));
                    }
                    NucleusLogger.VALUEGENERATION.debug((Object)("IncrementGenerator: Creating Table '" + this.tableName + "'"));
                    HTableDescriptor ht = new HTableDescriptor(this.tableName);
                    HColumnDescriptor hcd = new HColumnDescriptor(INCREMENT_COL_NAME);
                    hcd.setCompressionType(Compression.Algorithm.NONE);
                    hcd.setMaxVersions(1);
                    ht.addFamily(hcd);
                    admin.createTable(ht);
                }
                this.table = new HTable(config, this.tableName);
                if (!this.table.exists(new Get(Bytes.toBytes((String)this.key)))) {
                    long initialValue = 0L;
                    if (this.properties.containsKey("key-initial-value")) {
                        initialValue = Long.valueOf(this.properties.getProperty("key-initial-value")) - 1L;
                    }
                    this.table.put(new Put(Bytes.toBytes((String)this.key)).add(Bytes.toBytes((String)INCREMENT_COL_NAME), Bytes.toBytes((String)INCREMENT_COL_NAME), Bytes.toBytes((long)initialValue)));
                }
            }
            catch (IOException ex) {
                NucleusLogger.VALUEGENERATION.fatal((Object)"Error instantiating IncrementGenerator", (Throwable)ex);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    protected ValueGenerationBlock reserveBlock(long size) {
        if (size < 1L) {
            return null;
        }
        if (this.table == null) {
            this.initialiseTable();
        }
        ArrayList<Long> oids = new ArrayList<Long>();
        try {
            long number = this.table.incrementColumnValue(Bytes.toBytes((String)this.key), Bytes.toBytes((String)INCREMENT_COL_NAME), Bytes.toBytes((String)INCREMENT_COL_NAME), size);
            long nextNumber = number - size + 1L;
            int i = 0;
            while ((long)i < size) {
                oids.add(nextNumber++);
                ++i;
            }
        }
        catch (IOException ex) {
            NucleusLogger.VALUEGENERATION.error((Object)"IncrementGenerator: Error incrementing generated value", (Throwable)ex);
            throw new NucleusDataStoreException("Error incrementing generated value.", (Throwable)ex);
        }
        return new ValueGenerationBlock(oids);
    }
}

